<?php
/**
 * The template for displaying image attachments.
 *
 * @package Ef Practical
 */

get_header(); ?>

<div id="content" class="site-content cf">
    
    <?php
        $title_bar = get_post_meta( $post->ID, 'practical-title-bar', true );
        if ( ! $title_bar) { $title_bar = 'default'; }
        if ( $title_bar == 'default' ) :
            if ( '' != get_the_archive_title() && 1 == get_theme_mod( 'practical_header_title_bar', 1 ) ) :
                get_template_part( '/template-parts/title-bar' );
            endif;
        elseif ( $title_bar == 'show' ) :
            get_template_part( '/template-parts/title-bar' );
        endif;
    ?>
    
    <div class="ef-container">
        <div class="row">
            
            <div id="primary" class="content-area col-md-9 order-md-2">
                <main id="main" class="site-main" role="main">
                    
                    <?php while ( have_posts() ) : the_post(); ?>
                    
                        <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                            
                            <div class="entry-content">
                                
                                <div class="entry-attachment">
                                    
                                    <?php $imageArray = wp_get_attachment_image_src($post->ID, 'full', false); ?>
                                    <a href="<?php echo esc_url( $imageArray[0] ); ?>" title="<?php the_title_attribute('echo=0'); ?>" rel="attachment">
                                        <?php echo wp_get_attachment_image( $post->ID, 'post-image' ); ?>
                                    </a>
                                    
                                    <?php if ( has_excerpt() ) : ?>
                                        
                                        <div class="entry-caption">
                                            <?php the_excerpt(); ?>
                                        </div><!-- .entry-caption -->
                                        
                                    <?php endif; ?>
                                    
                                </div><!-- .entry-attachment -->
                                
                                <?php the_content(); ?>
                                
                            </div><!-- .entry-content -->
                            
                        </article>
                        
                        <nav class="post-navigation navigation cf" role="navigation">
                            <div class="nav-links cf">
                                <div class="post-nav nav-prev">
                                    <?php previous_image_link( '%link', '<span class="imgnav-meta">'.esc_html__( 'Previous Image', 'ef-practical' ).'</span>' ); ?>
                                </div>
                                <div class="post-nav nav-next">
                                    <?php next_image_link( '%link', '<span class="imgtnav-meta">'.esc_html__( 'Next Image', 'ef-practical' ).'</span>' ); ?>
                                </div>
                            </div>
                        </nav>
                        
                        <?php
                            // If comments are open or we have at least one comment, load up the comment template
                            if ( comments_open() || get_comments_number() )
                                comments_template( '', true );
                        ?>
                        
                    <?php endwhile; ?>
                    
                </main><!-- #main -->
            </div><!-- #primary -->
            
            <?php practical_sidebar(); ?>
            
        </div>
    </div>
</div><!-- #content -->

<?php get_footer(); ?>