<?php
/**
 * Entry footer part.
 *
 * @package Ef Practical
 */

if ( is_single() ) {
    $categories = get_theme_mod( 'practical_single_post_categories', 0 );
    $tags       = get_theme_mod( 'practical_single_post_tags', 0 );
} elseif ( is_archive() ) {
    $categories = get_theme_mod( 'practical_archives_categories', 0 );
} elseif ( is_search() ) {
    $categories = get_theme_mod( 'practical_search_results_categories', 0 );
} else {
    $categories = get_theme_mod( 'practical_blog_posts_categories', 0 );
}

if ( 0 == $categories || ( ! post_password_required() && is_single() && 0 == $tags ) ) :

?>

<div class="entry-footer cf">
    
    <?php if ( 0 == $categories ) : ?>
        <span class="cat-links cf"><i class="fa fa-folder-open"></i> <?php the_category( ', ', get_the_ID() ); ?></span>
    <?php endif; ?>
    
    <?php if ( ! post_password_required() && is_single() ) : ?>
        <?php if ( has_tag() ) : ?>
            <span class="tags-links cf"><?php the_tags( '<i class="fa fa-tags"></i> ', ', ' ); ?></span>
        <?php endif; ?>
    <?php endif; ?>
    
</div>

<?php endif; ?>