<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Ef Practical
 */

get_header(); ?>

<div id="content" class="site-content cf">
    
    <?php
        if ( '' != get_the_archive_title() && 1 == get_theme_mod( 'practical_header_title_bar', 1 ) ) :
            get_template_part( '/template-parts/title-bar' );
        endif;
    ?>
    
    <div class="ef-container">
        <div class="row">
            
            <div id="primary" class="content-area col-md-12">
                <main id="main" class="site-main" role="main">
                    
                    <section class="error-404 not-found">
                        
                        <header class="page-header">
                            <h1 class="page-title"><?php esc_html_e( 'Oops! That page can&rsquo;t be found.', 'ef-practical' ); ?></h1>
                        </header><!-- .page-header -->
                        
                        <div class="page-content">
                            
                            <p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'ef-practical' ); ?></p>
                            <br>
                            <?php get_search_form(); ?>
                            <br>
                            <div class="row row-grid">

                                <div class="col-md-6">
                                    <?php the_widget( 'WP_Widget_Recent_Posts' ); ?>
                                </div>
                                <div class="col-md-6">
                                    <div class="widget widget_categories">
                                        <h3 class="widget-title"><?php esc_html_e( 'Most Used Categories', 'ef-practical' ); ?></h3>
                                        <ul>
                                        <?php
                                            wp_list_categories( array(
                                                'orderby'    => 'count',
                                                'order'      => 'DESC',
                                                'show_count' => 1,
                                                'title_li'   => '',
                                                'number'     => 10,
                                            ) );
                                        ?>
                                        </ul>
                                    </div><!-- .widget -->
                                </div>
                            </div>
                            <div class="row row-grid">
                                
                                <div class="col-md-6">
                                    <?php
                                        /* translators: %1$s: smiley */
                                        $archive_content = '<p>' . sprintf( esc_html__( 'Try looking in the monthly archives. %1$s', 'ef-practical' ), convert_smilies( ':)' ) ) . '</p>';
                                        the_widget( 'WP_Widget_Archives', 'dropdown=1', "after_title=</h3>$archive_content" );
                                    ?>
                                </div>
                                <div class="col-md-6">
                                    <?php the_widget( 'WP_Widget_Tag_Cloud' ); ?>
                                </div>
                            </div>
                            
                        </div><!-- .page-content -->
                    </section><!-- .error-404 -->
                    
                </main><!-- #main -->
            </div><!-- #primary -->
            
        </div>
    </div>
</div><!-- #content -->

<?php get_footer(); ?>