<div id="ec-store-developers" class="settings-page ec-ui-framework-page">
	<div class="settings-page__header">
		<div class="settings-page__titles settings-page__titles--left">
			<h1 class="settings-page__title"><?php echo esc_html__( 'Developers', 'ecwid-shopping-cart' ); ?></h1>
			<div class="settings-page__subtitle">
				<?php echo esc_html__( 'Build the store your client needs and realize your own vision with Ecwid. Use the Ecwid plugin, powerful API, apps and integrations to design stores and build your own solutions. Become an Ecwid partner and grow your business effectively.', 'ecwid-shopping-cart' ); ?>
			</div>
		</div>
	</div>
	<div class="settings-page__body" style="padding-bottom: .1px">
		<div class="named-area">
			<div class="named-area__header">
				<div class="named-area__titles">
					<div class="named-area__title">
						<?php echo esc_html__( 'Ecwid plugin features', 'ecwid-shopping-cart' ); ?>
					</div>
					<div class="named-area__subtitle">
						<?php echo esc_html__( 'Extend your site with an easy-to-use plugin compatible with WordPress page builders and editors.', 'ecwid-shopping-cart' ); ?>
					</div>
				</div>
				<div class="named-area__description"></div>
				<div class="named-area__additional"></div>
			</div>
			<div class="named-area__body">
				<div class="a-card-stack">
					<div class="a-card a-card--normal">
						<div class="a-card__paddings">
							<div class="feature-element has-icon">
								<div class="feature-element__core">
									<div class="feature-element__data">
										<div class="feature-element__title">
											<?php echo esc_html__( 'Store blocks for your website', 'ecwid-shopping-cart' ); ?>
										</div>
										<div class="feature-element__content">
											<div class="feature-element__text">
												<div class="titled-item">
													<div class="titled-item__title"></div>
													<div class="titled-item__content">
														<div>
															<?php echo esc_html__( 'Add store components to any place of your WordPress site using shortcodes or WordPress site builders and editors.', 'ecwid-shopping-cart' ); ?>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
									<div class="feature-element__icon">
										<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 56 56">
											<path d="M28 1.68a26.3 26.3 0 0114.71 4.49 26.6 26.6 0 017.12 7.12 26.33 26.33 0 010 29.42 26.6 26.6 0 01-7.12 7.12 26.33 26.33 0 01-29.42 0 26.6 26.6 0 01-7.12-7.12 26.33 26.33 0 010-29.42 26.6 26.6 0 017.12-7.12A26.3 26.3 0 0128 1.68M28 0a28 28 0 1028 28A28 28 0 0028 0" fill="#32373c" />
											<path d="M4.67 28a23.33 23.33 0 0013.15 21L6.69 18.5a23.18 23.18 0 00-2 9.5m39.08-1.18a12.25 12.25 0 00-1.92-6.43c-1.18-1.93-2.29-3.55-2.29-5.48a4 4 0 013.91-4.14h.31A23.35 23.35 0 008.5 15.18h1.51c2.44 0 6.22-.3 6.22-.3a1 1 0 01.14 1.93s-1.26.15-2.67.22l8.5 25.27L27.31 27l-3.64-10c-1.25-.07-2.44-.22-2.44-.22a1 1 0 01.14-1.93s3.86.3 6.15.3c2.44 0 6.22-.3 6.22-.3a1 1 0 01.15 1.93s-1.27.15-2.67.22l8.43 25.08 2.41-7.63c1.06-3.33 1.69-5.69 1.69-7.69M28.41 30l-7 20.34a23.13 23.13 0 006.59.95A23.4 23.4 0 0035.75 50a3.24 3.24 0 01-.17-.32zm20.07-13.19a17.92 17.92 0 01.15 2.39 22 22 0 01-1.77 8.36l-7.13 20.61a23.35 23.35 0 008.75-31.36" fill="#32373c" />
										</svg>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="a-card a-card--normal">
						<div class="a-card__paddings">
							<div class="iconable-block">
								<div class="iconable-block__infographics">
									<span class="iconable-block__icon">
										<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 56 56"><defs><style>.shortcode-cls-3{fill:#6d839b}</style></defs><path d="M3 17h50v29a4 4 0 0 1-4 4H7a4 4 0 0 1-4-4V17Z" fill="#fff"/><path d="M6.62 6h42.27A4.11 4.11 0 0 1 53 10.11V17H3V9.62A3.62 3.62 0 0 1 6.62 6Z" fill="#fbd88e"/><path class="shortcode-cls-3" d="M54 10.11A5.11 5.11 0 0 0 48.89 5H6.61A4.62 4.62 0 0 0 2 9.62V46a5 5 0 0 0 5 5h42.3a4.75 4.75 0 0 0 4.7-4.74ZM6.61 7h42.28A3.11 3.11 0 0 1 52 10.11V16H4V9.62A2.61 2.61 0 0 1 6.61 7ZM49.3 49H7a3 3 0 0 1-3-3V18h48v28.26A2.74 2.74 0 0 1 49.3 49Z"/><path class="shortcode-cls-3" d="M8 10h3v3H8zM14 10h3v3h-3zM20 10h3v3h-3zM19 43h-6a1 1 0 0 1-1-1V25a1 1 0 0 1 1-1h6v2h-5v15h5ZM43 43h-6v-2h5V26h-5v-2h6a1 1 0 0 1 1 1v17a1 1 0 0 1-1 1Z"/><path class="shortcode-cls-3" transform="rotate(-70.81 28 33.5)" d="M15.82 32.5h24.35v2H15.82z"/></svg>
									</span>
								</div>
								<div class="iconable-block__content">
									<div class="cta-block">
										<div class="cta-block__central">
											<div class="cta-block__title">
												<?php echo esc_html__( 'Shortcodes', 'ecwid-shopping-cart' ); ?>
											</div>
											<div class="cta-block__content">
												<?php echo esc_html__( 'Add shortcodes to the WordPress site to apply basic changes to your store appearance.', 'ecwid-shopping-cart' ); ?>
											</div>
										</div>
										<div class="cta-block__cta">
											<a href="https://support.ecwid.com/hc/en-us/articles/360002137520?utm_source=wp-plugin" target="_blank" type="button" class="btn btn-default btn-medium"> <span><?php echo esc_html__( 'Learn More', 'ecwid-shopping-cart' ); ?></span> </a>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="a-card a-card--normal">
						<div class="a-card__paddings">
							<div class="iconable-block">
								<div class="iconable-block__infographics">
									<span class="iconable-block__icon">
										<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 56 56"><defs><style>.blocks-cls-2{fill:#6d839b}.blocks-cls-3{fill:#edf7fd}</style></defs><path d="M6.63 4H23v29H3V7.63A3.63 3.63 0 0 1 6.63 4Z" fill="#fbd88e"/><path class="blocks-cls-2" d="M24 34H2V7.63A4.64 4.64 0 0 1 6.63 3H24ZM4 32h18V5H6.63A2.63 2.63 0 0 0 4 7.63Z"/><path class="blocks-cls-3" d="M3 38h20v14H7a4 4 0 0 1-4-4V38Z"/><path class="blocks-cls-2" d="M24 53H7a5 5 0 0 1-5-5V37h22ZM4 39v9a3 3 0 0 0 3 3h15V39Z"/><path class="blocks-cls-3" d="M28 4h21.37A3.63 3.63 0 0 1 53 7.63V19H28V4Z"/><path class="blocks-cls-2" d="M54 20H27V3h22.37A4.64 4.64 0 0 1 54 7.63Zm-25-2h23V7.63A2.63 2.63 0 0 0 49.37 5H29Z"/><path d="M28 24h25v24.26A3.74 3.74 0 0 1 49.26 52H28V24Z" fill="#cbe87c"/><path class="blocks-cls-2" d="M49.26 53H27V23h27v25.26A4.75 4.75 0 0 1 49.26 53ZM29 51h20.26A2.74 2.74 0 0 0 52 48.26V25H29Z"/></svg>
									</span>
								</div>
								<div class="iconable-block__content">
									<div class="cta-block">
										<div class="cta-block__central">
											<div class="cta-block__title">
												<?php echo esc_html__( 'Store blocks for Gutenberg', 'ecwid-shopping-cart' ); ?>
											</div>
											<div class="cta-block__content">
												<?php echo esc_html__( 'Add store plugin to the WordPress site in Gutenberg block editor, with no HTML or shortcodes.', 'ecwid-shopping-cart' ); ?>
											</div>
										</div>
										<div class="cta-block__cta">
											<a href="https://support.ecwid.com/hc/en-us/articles/4489063443612?utm_source=wp-plugin" target="_blank" type="button" class="btn btn-default btn-medium"> <span><?php echo esc_html__( 'Learn More', 'ecwid-shopping-cart' ); ?></span> </a>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="a-card a-card--normal">
						<div class="a-card__paddings">
							<div class="iconable-block">
								<div class="iconable-block__infographics"> 
									<span class="iconable-block__icon">
										<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 56 56"><defs><style>.elementor-cls-2{fill:#fff}</style></defs><g id="_109-elementor" data-name="109-elementor"><path d="M51.4 2H4.6A2.59 2.59 0 0 0 2 4.6v46.8A2.59 2.59 0 0 0 4.6 54h46.8a2.59 2.59 0 0 0 2.6-2.6V4.6A2.59 2.59 0 0 0 51.4 2" fill="#d63362"/><path class="elementor-cls-2" d="M16.96 16.96h4.46v22.32h-4.46zM25.89 34.81h13.4v4.46h-13.4zM25.89 25.89h13.4v4.46h-13.4zM25.89 16.95h13.4v4.46h-13.4z"/></g></svg>
									</span>
								</div>
								<div class="iconable-block__content">
									<div class="cta-block">
										<div class="cta-block__central">
											<div class="cta-block__title">
												<?php echo esc_html__( 'Store blocks for Elementor', 'ecwid-shopping-cart' ); ?>
											</div>
											<div class="cta-block__content">
												<?php echo esc_html__( 'Create a store from your website with the Ecwid plugin and Elementor page builder, with no coding required.', 'ecwid-shopping-cart' ); ?>
											</div>
										</div>
										<div class="cta-block__cta">
											<a href="https://support.ecwid.com/hc/en-us/articles/4489039710364?utm_source=wp-plugin" target="_blank" type="button" class="btn btn-default btn-medium"> <span><?php echo esc_html__( 'Learn More', 'ecwid-shopping-cart' ); ?></span> </a>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="a-card-stack">
					<div class="a-card a-card--normal">
						<div class="a-card__paddings">
							<div class="feature-element has-icon">
								<div class="feature-element__core">
									<div class="feature-element__data">
										<div class="feature-element__title">
											<?php echo esc_html__( 'Advanced customization', 'ecwid-shopping-cart' ); ?>
										</div>
										<div class="feature-element__content">
											<div class="feature-element__text">
												<div class="titled-item">
													<div class="titled-item__title"></div>
													<div class="titled-item__content">
														<div>
															<?php echo esc_html__( 'Use advanced settings and Ecwid API capabilities to tailor the look and functionality of your site.', 'ecwid-shopping-cart' ); ?>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
									<div class="feature-element__icon">
										<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 56 56"><defs><style>.settings-cls-3{fill:#6d839b}</style></defs><path d="M37.73 31.73a17.75 17.75 0 0 0 1.78-4.21l5.2-.77a21.81 21.81 0 0 0 0-7.12l-5.19-.87a15.12 15.12 0 0 0-.64-2.18 16.89 16.89 0 0 0-1-2L41 10.31a21.92 21.92 0 0 0-5-5.09l-4.27 3.05a17.75 17.75 0 0 0-4.21-1.78l-.77-5.2a21.81 21.81 0 0 0-7.12 0l-.87 5.19a15.41 15.41 0 0 0-2.18.71 16.89 16.89 0 0 0-2 1l-4.27-3.12a21.88 21.88 0 0 0-5.09 5l3.05 4.29a17.86 17.86 0 0 0-1.78 4.2l-5.2.78a21.81 21.81 0 0 0 0 7.12l5.19.86a18 18 0 0 0 .69 2.19 18 18 0 0 0 .95 2L5 35.69a21.92 21.92 0 0 0 5 5.09l4.28-3.05a17.75 17.75 0 0 0 4.21 1.78l.77 5.2a21.81 21.81 0 0 0 7.12 0l.87-5.19a15.41 15.41 0 0 0 2.18-.71 18.08 18.08 0 0 0 2-.93M23 30a7 7 0 1 1 7-7 7 7 0 0 1-7 7Z" fill="#edf7fd"/><path d="M51.1 36.91a10.38 10.38 0 0 0-.63-1.3l2-2.69a13.88 13.88 0 0 0-3.17-3.23l-2.73 1.94a10.67 10.67 0 0 0-2.67-1.13l-.5-3.31a13.77 13.77 0 0 0-4.53 0l-.55 3.3a8.66 8.66 0 0 0-1.39.45 10.45 10.45 0 0 0-1.3.64l-2.69-2a13.88 13.88 0 0 0-3.23 3.17l1.94 2.73a11 11 0 0 0-1.13 2.67l-3.31.5a13.77 13.77 0 0 0 0 4.53l3.3.55a9.75 9.75 0 0 0 .44 1.39 10.35 10.35 0 0 0 .6 1.26l-2 2.69a13.88 13.88 0 0 0 3.17 3.23l2.73-1.94a10.67 10.67 0 0 0 2.67 1.13l.5 3.31a13.77 13.77 0 0 0 4.53 0l.55-3.3a8.66 8.66 0 0 0 1.39-.45 12.64 12.64 0 0 0 1.3-.59l2.69 2a13.88 13.88 0 0 0 3.23-3.17l-1.94-2.73a10.67 10.67 0 0 0 1.13-2.67l3.31-.5a13.77 13.77 0 0 0 0-4.53l-3.3-.55a10 10 0 0 0-.41-1.4ZM41 45a4 4 0 1 1 4-4 4 4 0 0 1-4 4Z" fill="#f9d485"/><path class="settings-cls-3" d="M31 23a8 8 0 1 0-8 8 8 8 0 0 0 8-8Zm-8 6a6 6 0 1 1 6-6 6 6 0 0 1-6 6ZM41 36a5 5 0 1 0 5 5 5 5 0 0 0-5-5Zm0 8a3 3 0 1 1 3-3 3 3 0 0 1-3 3Z"/><path class="settings-cls-3" d="m55.8 38.69-.12-.69-3.36-.55a8 8 0 0 0-.28-.87c-.12-.28-.24-.56-.38-.84l2-2.75-.41-.59a14.74 14.74 0 0 0-3.4-3.47l-.58-.43-2.8 2a11.84 11.84 0 0 0-1.72-.73l-.29-1.94 1.09-.15.12-.72a22.72 22.72 0 0 0 0-7.45l-.11-.7-5.24-.87a15.06 15.06 0 0 0-.54-1.69c-.22-.54-.47-1.07-.74-1.59l3.17-4.29-.42-.59a22.79 22.79 0 0 0-5.2-5.31L36 4l-4.35 3.1a18.5 18.5 0 0 0-3.25-1.37L27.63.42l-.72-.11a22.72 22.72 0 0 0-7.45 0l-.7.11-.88 5.26a16.66 16.66 0 0 0-1.68.58c-.54.23-1.07.47-1.59.75l-4.29-3.17-.59.41a22.84 22.84 0 0 0-5.31 5.21L4 10l3.1 4.36a18.19 18.19 0 0 0-1.37 3.25l-5.29.79-.12.72a22.66 22.66 0 0 0 0 7.44l.11.71 5.26.88a17.31 17.31 0 0 0 .57 1.67c.2.52.44 1 .69 1.53l-3.18 4.33.42.59a22.79 22.79 0 0 0 5.2 5.31L10 42l4.35-3.1a18.5 18.5 0 0 0 3.25 1.37l.79 5.3.72.11a22.54 22.54 0 0 0 7.45 0l.7-.11.28-1.32 2.17.36c.09.3.2.59.31.88s.23.54.36.8l-2 2.76.41.59a14.74 14.74 0 0 0 3.4 3.47l.58.43 2.8-2a11.84 11.84 0 0 0 1.72.73l.51 3.4.71.12a14.86 14.86 0 0 0 4.86 0l.7-.12.57-3.37c.3-.1.59-.2.86-.31s.57-.23.85-.36l2.77 2 .59-.41a14.93 14.93 0 0 0 3.47-3.4l.43-.58-2-2.8a11.84 11.84 0 0 0 .73-1.72l3.4-.51.12-.71a14.68 14.68 0 0 0-.06-4.81Zm-35.67 5.14-.76-5.12-.63-.17a15.89 15.89 0 0 1-4-1.68l-.56-.32-4.22 3a21.69 21.69 0 0 1-3.72-3.84l3.07-4.15L9 31a18.65 18.65 0 0 1-.9-1.86 17.1 17.1 0 0 1-.65-2.07l-.16-.63-5.12-.86a21 21 0 0 1 0-5.37l5.12-.76.17-.63a16.27 16.27 0 0 1 1.68-4l.33-.56-3-4.22a21.36 21.36 0 0 1 3.83-3.73l4.16 3.07.54-.32a15.09 15.09 0 0 1 2-.94 13.52 13.52 0 0 1 2-.67l.64-.16.86-5.12a21 21 0 0 1 5.37 0l.76 5.12.63.17a15.89 15.89 0 0 1 4 1.68l.56.32 4.22-3a21.69 21.69 0 0 1 3.76 3.84l-3.07 4.16.27.54a16 16 0 0 1 .93 1.91 13.36 13.36 0 0 1 .6 2.05l.15.66 5.14.85a21.06 21.06 0 0 1 0 5.38l-1.35.2a14.6 14.6 0 0 0-3.79.13l-.7.12-.57 3.37c-.3.1-.6.2-.89.32s-.56.25-.84.39l-2.75-2-.59.41a14.93 14.93 0 0 0-3.47 3.4l-.43.58 2 2.81a11.72 11.72 0 0 0-.73 1.71l-3.4.51-.12.72a15.29 15.29 0 0 0-.2 2.34l-.5 3a21 21 0 0 1-5.36-.03Zm33.79-1.32-3.21.49-.17.62a10.28 10.28 0 0 1-1 2.44l-.33.56 1.89 2.65a13.58 13.58 0 0 1-2 2l-2.6-1.92-.56.3a12.27 12.27 0 0 1-1.21.55 9.55 9.55 0 0 1-1.25.4l-.64.16-.54 3.22a12.31 12.31 0 0 1-2.78 0L39 50.71l-.62-.17a9.88 9.88 0 0 1-2.44-1l-.55-.33-2.66 1.89a13.11 13.11 0 0 1-2-2l1.93-2.61-.31-.57a9 9 0 0 1-.55-1.13 9.82 9.82 0 0 1-.4-1.27l-.16-.64-3.22-.54a11.75 11.75 0 0 1 0-2.78l3.21-.48.17-.63a10.21 10.21 0 0 1 1-2.43l.33-.56-1.89-2.65a12.65 12.65 0 0 1 2-1.95l2.62 1.93.56-.33c.39-.21.79-.41 1.19-.58a9.55 9.55 0 0 1 1.25-.4l.64-.16.54-3.22a12.31 12.31 0 0 1 2.78 0l.58 3.19.62.17a9.88 9.88 0 0 1 2.44 1l.55.33 2.66-1.89a13.11 13.11 0 0 1 2 2l-1.93 2.62.32.56a9.14 9.14 0 0 1 .57 1.18 8.84 8.84 0 0 1 .37 1.24l.14.66 3.24.54a11.84 11.84 0 0 1-.06 2.81Z"/></svg>
									</div>
								</div>
							</div>
						</div>
					</div>

					<?php if ( current_user_can( 'manage_options' ) ) { ?>
					<div class="a-card a-card--normal">
						<div class="a-card__paddings">
							<div class="iconable-block">
								<div class="iconable-block__infographics"> 
									<span class="iconable-block__icon">
										<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 56 56"><defs><style>.hidden-cls-2{fill:#6d839b}</style></defs><rect x="3" y="4" width="50" height="48" rx="4" fill="#edf7fd"/><path class="hidden-cls-2" d="M49 53H7a5 5 0 0 1-5-5V8a5 5 0 0 1 5-5h42a5 5 0 0 1 5 5v40a5 5 0 0 1-5 5ZM7 5a3 3 0 0 0-3 3v40a3 3 0 0 0 3 3h42a3 3 0 0 0 3-3V8a3 3 0 0 0-3-3Z"/><rect x="10" y="21" width="10" height="7" rx="2" fill="#bcdbf2"/><rect x="23" y="29" width="10" height="7" rx="2" fill="#cbe87c"/><rect x="36" y="17" width="10" height="7" rx="2" fill="#fbd88e"/><path class="hidden-cls-2" d="M18 20h-1v-5a2 2 0 0 0-4 0v5h-1a3 3 0 0 0-3 3v3a3 3 0 0 0 3 3h1v12a2 2 0 0 0 4 0V29h1a3 3 0 0 0 3-3v-3a3 3 0 0 0-3-3Zm1 6a1 1 0 0 1-1 1h-6a1 1 0 0 1-1-1v-3a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1ZM31 28h-1V15a2 2 0 0 0-4 0v13h-1a3 3 0 0 0-3 3v3a3 3 0 0 0 3 3h1v4a2 2 0 0 0 4 0v-4h1a3 3 0 0 0 3-3v-3a3 3 0 0 0-3-3Zm1 6a1 1 0 0 1-1 1h-6a1 1 0 0 1-1-1v-3a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1ZM44 16h-1v-1a2 2 0 0 0-4 0v1h-1a3 3 0 0 0-3 3v3a3 3 0 0 0 3 3h1v16a2 2 0 0 0 4 0V25h1a3 3 0 0 0 3-3v-3a3 3 0 0 0-3-3Zm1 6a1 1 0 0 1-1 1h-6a1 1 0 0 1-1-1v-3a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1Z"/></svg>
									</span>
								</div>
								<div class="iconable-block__content">
									<div class="cta-block">
										<div class="cta-block__central">
											<div class="cta-block__title">
												<?php echo esc_html__( 'Advanced settings', 'ecwid-shopping-cart' ); ?>
											</div>
											<div class="cta-block__content">
												<?php echo esc_html__( 'Change functionality of the plugin with advanced settings, like dashboard visibility for webmasters, display of store components, clean URLs, and more.', 'ecwid-shopping-cart' ); ?>
											</div>
										</div>
										<div class="cta-block__cta">
											<a href="<?php echo esc_url( admin_url( 'admin.php?page=ec-params' ) ); ?>" target="_blank" type="button" class="btn btn-default btn-medium"> <span><?php echo esc_html__( 'Go to Settings', 'ecwid-shopping-cart' ); ?></span> </a>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
						<?php
					}//end if
					?>

					<div class="a-card a-card--normal">
						<div class="a-card__paddings">
							<div class="iconable-block">
								<div class="iconable-block__infographics">
									<span class="iconable-block__icon">
										<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 56 56"><defs><style>.api-settings-cls-3{fill:#6d839b}</style></defs><path d="M47.49 20.12a22.58 22.58 0 0 0-1.23-2.52l3.83-5.18A27 27 0 0 0 44 6.18l-5.29 3.75a21.36 21.36 0 0 0-5.16-2.19l-.95-6.38a26.7 26.7 0 0 0-8.74 0L22.8 7.72a19.53 19.53 0 0 0-2.68.88 20.9 20.9 0 0 0-2.52 1.22L12.42 6a27 27 0 0 0-6.24 6.11l3.75 5.26a21.53 21.53 0 0 0-2.19 5.16l-6.38 1a26.64 26.64 0 0 0 0 8.73l6.36 1.06A21.56 21.56 0 0 0 8.58 36a20.77 20.77 0 0 0 1.16 2.4l-3.83 5.18A27 27 0 0 0 12 49.82l5.26-3.75a21.36 21.36 0 0 0 5.16 2.19l.95 6.38a26.7 26.7 0 0 0 8.74 0l1.06-6.36a19.53 19.53 0 0 0 2.68-.88 21.87 21.87 0 0 0 2.52-1.14l5.18 3.83A27 27 0 0 0 49.82 44l-3.75-5.26a21.36 21.36 0 0 0 2.19-5.16l6.38-.95a26.7 26.7 0 0 0 0-8.74l-6.36-1.09a19.16 19.16 0 0 0-.79-2.68Z" fill="#ecf5fe"/><path class="api-settings-cls-3" d="M27.77 56a27.59 27.59 0 0 1-4.53-.37 1 1 0 0 1-.82-.84L21.55 49a23.12 23.12 0 0 1-4.2-1.78l-4.74 3.37a1 1 0 0 1-1.17 0 27.66 27.66 0 0 1-6.35-6.47 1 1 0 0 1 0-1.17l3.45-4.67A20.27 20.27 0 0 1 6.9 34.1l-5.7-.89a1 1 0 0 1-.83-.82 27.61 27.61 0 0 1 0-9.07 1 1 0 0 1 .84-.82L7 21.64a22.92 22.92 0 0 1 1.78-4.21l-3.41-4.74a1 1 0 0 1 0-1.17 27.62 27.62 0 0 1 6.47-6.34 1 1 0 0 1 1.17 0l4.66 3.45a22.72 22.72 0 0 1 2.06-1 20.76 20.76 0 0 1 2.18-.75l1-5.73a1 1 0 0 1 .79-.78 28.1 28.1 0 0 1 9.06 0 1 1 0 0 1 .82.84L34.45 7a23.12 23.12 0 0 1 4.2 1.78l4.74-3.37a1 1 0 0 1 1.17 0 27.66 27.66 0 0 1 6.35 6.47 1 1 0 0 1 0 1.17l-3.44 4.66a22.63 22.63 0 0 1 1 2.06 19.88 19.88 0 0 1 .68 2.15l5.7 1a1 1 0 0 1 .83.82 27.55 27.55 0 0 1 0 9.06 1 1 0 0 1-.84.82l-5.84.83a23.12 23.12 0 0 1-1.78 4.2l3.37 4.74a1 1 0 0 1 0 1.17 27.86 27.86 0 0 1-6.47 6.35 1 1 0 0 1-1.17 0l-4.65-3.48a22.21 22.21 0 0 1-2.06.91 21.1 21.1 0 0 1-2.16.74l-1 5.73a1 1 0 0 1-.82.82 27.5 27.5 0 0 1-4.49.37Zm-3.49-2.24a25.57 25.57 0 0 0 7 0l.94-5.65a1 1 0 0 1 .75-.8 19.84 19.84 0 0 0 2.54-.83 20.65 20.65 0 0 0 2.43-1.1 1 1 0 0 1 1.06.08l4.59 3.39a25.74 25.74 0 0 0 5-4.89l-3.32-4.67a1 1 0 0 1 0-1.09 20 20 0 0 0 2.08-4.91 1 1 0 0 1 .82-.73l5.65-.84a25.57 25.57 0 0 0 0-7l-5.65-.94a1 1 0 0 1-.87-.78 19.85 19.85 0 0 0-.74-2.53 21.85 21.85 0 0 0-1.17-2.38 1 1 0 0 1 .07-1.09l3.39-4.59a25.74 25.74 0 0 0-4.89-5l-4.67 3.32a1 1 0 0 1-1.09 0 20 20 0 0 0-4.91-2.08 1 1 0 0 1-.73-.82l-.84-5.65a25.57 25.57 0 0 0-7 0l-.94 5.65a1 1 0 0 1-.75.8 19.84 19.84 0 0 0-2.54.83 20.48 20.48 0 0 0-2.4 1.17 1 1 0 0 1-1.09 0l-4.59-3.4a25.79 25.79 0 0 0-5 4.9l3.32 4.66a1 1 0 0 1 0 1.09 19.94 19.94 0 0 0-2.02 4.92 1 1 0 0 1-.82.72l-5.65.85a25.5 25.5 0 0 0 0 7l5.65.95a1 1 0 0 1 .8.74 21.17 21.17 0 0 0 .82 2.56 19.54 19.54 0 0 0 1.1 2.31 1 1 0 0 1-.07 1.07l-3.39 4.58a25.74 25.74 0 0 0 4.89 5l4.67-3.32a1 1 0 0 1 1.09 0 20 20 0 0 0 4.91 2.08 1 1 0 0 1 .73.82Z"/><path class="api-settings-cls-3" d="M20.59 21h-3.67l-5.34 14H15l.86-2.37h5.92l.81 2.37H26Zm-4 9 2.16-6 2.15 6ZM33.56 21H27.1v14H30v-5h3.52a4.34 4.34 0 0 0 4.62-4.05 3.09 3.09 0 0 0 0-.43A4.32 4.32 0 0 0 34.05 21a2.66 2.66 0 0 0-.49 0Zm-.4 6.36H30v-3.73h3.12a1.87 1.87 0 0 1 2 1.73 1.84 1.84 0 0 1-1.72 2ZM40 21v14h3V21Z"/></svg>
									</span>
								</div>
								<div class="iconable-block__content">
									<div class="cta-block">
										<div class="cta-block__central">
											<div class="cta-block__title">
												<?php echo esc_html__( 'Customization with API', 'ecwid-shopping-cart' ); ?>
											</div>
											<div class="cta-block__content">
												<?php echo esc_html__( 'Use the powerful Ecwid API to customize your store design, layout, and functionality.', 'ecwid-shopping-cart' ); ?>
											</div>
										</div>
										<div class="cta-block__cta">
											<a href="https://api-docs.ecwid.com/reference/customize-appearance?utm_source=wp-plugin" target="_blank" type="button" class="btn btn-default btn-medium"> <span><?php echo esc_html__( 'Learn More', 'ecwid-shopping-cart' ); ?></span> </a>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="named-area">
			<div class="named-area__header">
				<div class="named-area__titles">
					<div class="named-area__title">
						<?php echo esc_html__( 'Apps and integrations', 'ecwid-shopping-cart' ); ?>
					</div>
					<div class="named-area__subtitle">
						<?php echo esc_html__( 'Integrate your store with external services to enhance its functionality.', 'ecwid-shopping-cart' ); ?>
					</div>
				</div>
				<div class="named-area__description"></div>
				<div class="named-area__additional"></div>
			</div>
			<div class="named-area__body">
				<div class="a-card a-card--normal">
					<div class="a-card__paddings">
						<div class="iconable-block">
							<div class="iconable-block__infographics"> 
								<span class="iconable-block__icon">
									<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 56 56"><defs><style>.woo-cls-2{fill:#6d839b}</style></defs><path fill="#fbd88e" d="M1 1v9h3v32h44V10h3V1H1z"/><path class="woo-cls-2" d="M51 0H1a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h2v31a1 1 0 0 0 1 1h44a1 1 0 0 0 1-1V11h2a1 1 0 0 0 1-1V1a1 1 0 0 0-1-1Zm-4 41H5V11h42Zm3-32H2V2h48Z"/><path d="M20.3 36.53a3.35 3.35 0 0 1 3-2h29.29A3.34 3.34 0 0 1 56 37.91v11.22a3.36 3.36 0 0 1-3.17 3.23H42.16l1.44 3.54c-2.13-1.17-4.21-2.37-6.35-3.52h-14A3.37 3.37 0 0 1 20 49.13v-11a4 4 0 0 1 .28-1.63" fill-rule="evenodd" fill="#945c87"/><path d="M34.59 36.8a1.3 1.3 0 0 1 2 .26 1.21 1.21 0 0 1 0 1.15A17.11 17.11 0 0 0 35.27 43a31.15 31.15 0 0 0-.52 6.39 1.24 1.24 0 0 1-.81 1.34 1.56 1.56 0 0 1-1.42-.63 15.3 15.3 0 0 1-3.15-6.14l-1.94 3.89a9.16 9.16 0 0 1-1.63 2.49c-.3.3-.81.57-1.2.27a4.44 4.44 0 0 1-1-2 87.67 87.67 0 0 1-2-9.9 1.24 1.24 0 0 1 .65-1.44 1.43 1.43 0 0 1 1.4.14 1.47 1.47 0 0 1 .39.94 80 80 0 0 0 1.47 7.68c1.06-2 2.12-4 3.18-6.07a2 2 0 0 1 .64-.78 1 1 0 0 1 1.29.13 2 2 0 0 1 .44 1.06 28.71 28.71 0 0 0 1.36 4.9 28.71 28.71 0 0 1 1.47-7.06 5 5 0 0 1 .69-1.34m6 1.29a3.7 3.7 0 0 1 3.17 1.11 4.93 4.93 0 0 1 1.11 2.6 8 8 0 0 1-.86 4.67 5.21 5.21 0 0 1-1.83 2.09 3.72 3.72 0 0 1-3.92-.12 4.33 4.33 0 0 1-1.65-2.76A7.58 7.58 0 0 1 38.72 39a3.5 3.5 0 0 1 1.87-.86m.23 2.47a2.52 2.52 0 0 0-1.2 1.15 4.37 4.37 0 0 0-.36 4.07 1.23 1.23 0 0 0 .82.78 1.42 1.42 0 0 0 1.11-.44 4.13 4.13 0 0 0 1.19-2.32 4 4 0 0 0-.48-2.9 1 1 0 0 0-1.08-.34m9-2.47a3.7 3.7 0 0 1 3.12 1 4.87 4.87 0 0 1 1.18 2.8 7.93 7.93 0 0 1-.87 4.56 5.16 5.16 0 0 1-1.87 2.14 3.78 3.78 0 0 1-3.79-.05A3.92 3.92 0 0 1 46 46.51a7.62 7.62 0 0 1 1.71-7.41 3.9 3.9 0 0 1 2.09-1m.2 2.46a2.78 2.78 0 0 0-1.27 1.31 4.32 4.32 0 0 0-.23 4 1.08 1.08 0 0 0 .86.71 1.62 1.62 0 0 0 1.17-.58 4.17 4.17 0 0 0 1.1-2.56 3.71 3.71 0 0 0-.55-2.55 1 1 0 0 0-1.08-.33" fill="#fff" fill-rule="evenodd"/><path class="woo-cls-2" d="M29 31v-8h3l-6-7-6 7h3v8h6z"/></svg>
								</span>
							</div>
							<div class="iconable-block__content">
								<div class="cta-block">
									<div class="cta-block__central">
										<div class="cta-block__title">
											<?php echo esc_html__( 'Import product catalog from WooCommerce', 'ecwid-shopping-cart' ); ?>
										</div>
										<div class="cta-block__content">
											<?php echo esc_html__( 'If you want to move your WooCommerce store to Ecwid or have another store outside WooCommerce, use the Ecwid migration tool to import your products in bulk.', 'ecwid-shopping-cart' ); ?>
										</div>
									</div>
									<div class="cta-block__cta">
									<?php if ( class_exists( 'woocommerce' ) && class_exists( 'Ecwid_Importer' ) ) { ?>
										<a href="<?php echo esc_url( admin_url( 'admin.php?page=ec-store-import-woocommerce' ) ); ?>" target="_blank" type="button" class="btn btn-default btn-medium"> <span><?php echo esc_html__( 'Go to Import Page', 'ecwid-shopping-cart' ); ?></span> </a>
									<?php } else { ?>
										<a href="https://support.ecwid.com/hc/en-us/articles/360000049040?utm_source=wp-plugin" target="_blank" type="button" class="btn btn-default btn-medium"> <span><?php echo esc_html__( 'Learn More', 'ecwid-shopping-cart' ); ?></span> </a>
									<?php } ?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="a-card a-card--normal">
					<div class="a-card__paddings">
						<div class="iconable-block">
							<div class="iconable-block__infographics">
								<span class="iconable-block__icon">
									<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 56 56"><defs><style>.app-market-cls-5{fill:#6d839b}</style></defs><rect x="2.98" y="3" width="25" height="25" rx="4" fill="#cbe87c"/><rect x="3" y="28" width="25" height="25" rx="4" fill="#cfe7ff"/><rect x="28" y="28" width="25" height="25" rx="4" fill="#fbd88e"/><rect x="28" y="3" width="25" height="25" rx="4" fill="#ecf5fe"/><path class="app-market-cls-5" d="M17.2 9.25h-3.46l-5 13h3.16l.81-2.2h5.56l.8 2.2h3.17Zm-3.76 8.35 2-5.58 2 5.58ZM43.1 9.22a3.53 3.53 0 0 0-.46 0h-6.07v13h2.76v-4.63h3.31A4.07 4.07 0 0 0 47 13.82v-.4a4.06 4.06 0 0 0-3.9-4.2Zm-.56 6h-3.21v-3.53h2.94a1.76 1.76 0 1 1 .27 3.5ZM18.57 34.18a3.87 3.87 0 0 0-1.27 0h-6.07v13H14v-4.64h3.3a4.23 4.23 0 1 0 1.27-8.36Zm-1.6 6H14v-3.57h3a1.77 1.77 0 1 1 0 3.53ZM34.44 45.29l1.49-2.11a5.71 5.71 0 0 0 1.88 1.3 5.79 5.79 0 0 0 2.25.45c1.51 0 2.25-.7 2.25-1.45 0-2.29-7.47-.72-7.47-5.59 0-2.11 1.86-4 4.91-4a7.26 7.26 0 0 1 5.07 1.8l-1.55 2a5.55 5.55 0 0 0-3.77-1.41c-1.18 0-1.85.53-1.85 1.3 0 2.06 7.4.68 7.4 5.53 0 2.38-1.69 4.16-5.19 4.16a7.38 7.38 0 0 1-5.42-1.98Z"/><path class="app-market-cls-5" d="M54 24V7a5 5 0 0 0-5-5H32a5 5 0 0 0-4 2 5 5 0 0 0-4-2H7a5 5 0 0 0-5 5v17a5 5 0 0 0 2 4 5 5 0 0 0-2 4v17a5 5 0 0 0 5 5h17a5 5 0 0 0 4-2 5 5 0 0 0 4 2h17a5 5 0 0 0 5-5V32a5 5 0 0 0-2-4 5 5 0 0 0 2-4Zm-25 4ZM4 24V7a3 3 0 0 1 3-3h17a3 3 0 0 1 3 3v17a3 3 0 0 1-3 3H7a3 3 0 0 1-3-3Zm23 25a3 3 0 0 1-3 3H7a3 3 0 0 1-3-3V32a3 3 0 0 1 3-3h17a3 3 0 0 1 3 3Zm1-20Zm24 3v17a3 3 0 0 1-3 3H32a3 3 0 0 1-3-3V32a3 3 0 0 1 3-3h17a3 3 0 0 1 3 3Zm0-8a3 3 0 0 1-3 3H32a3 3 0 0 1-3-3V7a3 3 0 0 1 3-3h17a3 3 0 0 1 3 3Z"/></svg>
								</span>
							</div>
							<div class="iconable-block__content">
								<div class="cta-block">
									<div class="cta-block__central">
										<div class="cta-block__title">
											<?php echo esc_html__( 'App Market', 'ecwid-shopping-cart' ); ?>
										</div>
										<div class="cta-block__content">
											<?php echo esc_html__( 'Enhance your store functionality, add new features, or connect backend systems with powerful apps, tools, and extensions.', 'ecwid-shopping-cart' ); ?>
										</div>
									</div>
									<div class="cta-block__cta">
										<?php
										if ( ecwid_is_demo_store() ) {
											$app_market_link = 'https://www.ecwid.com/apps?utm_source=wp-plugin';
										} else {
											$app_market_link = admin_url( 'admin.php?page=ec-store-admin-appmarket' );
										}
										?>
										<a href="<?php echo esc_url( $app_market_link ); ?>" target="_blank" type="button" class="btn btn-default btn-medium"> <span><?php echo esc_html__( 'Go to App Market', 'ecwid-shopping-cart' ); ?></span> </a>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="a-card a-card--normal">
					<div class="a-card__paddings">
						<div class="iconable-block">
							<div class="iconable-block__infographics">
								<span class="iconable-block__icon">
									<svg data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 56 56"><rect x="2" y="2" width="52" height="52" rx="4" fill="#ff4a00"/><path d="M33 28a11.94 11.94 0 0 1-.77 4.22A11.94 11.94 0 0 1 28 33a11.84 11.84 0 0 1-4.22-.77A11.94 11.94 0 0 1 23 28a11.94 11.94 0 0 1 .77-4.22A11.94 11.94 0 0 1 28 23a11.94 11.94 0 0 1 4.22.77A11.94 11.94 0 0 1 33 28Zm14.72-3.34H36.05l8.25-8.26a20.22 20.22 0 0 0-2.16-2.55 20.22 20.22 0 0 0-2.55-2.16L31.33 20V8.28A19.49 19.49 0 0 0 28 8a20.19 20.19 0 0 0-3.32.28V20l-8.27-8.3a20.22 20.22 0 0 0-2.55 2.16 20.15 20.15 0 0 0-2.15 2.55L20 24.67H8.28S8 26.86 8 28a20.19 20.19 0 0 0 .28 3.32H20l-8.3 8.27a20.25 20.25 0 0 0 4.71 4.71l8.26-8.25v11.67A19.32 19.32 0 0 0 28 48a19.32 19.32 0 0 0 3.32-.28V36.05l8.26 8.25a19.42 19.42 0 0 0 2.55-2.16 20.22 20.22 0 0 0 2.16-2.55l-8.25-8.26h11.68A20.1 20.1 0 0 0 48 28a20.1 20.1 0 0 0-.28-3.32Z" fill="#fff"/></svg>
								</span>
							</div>
							<div class="iconable-block__content">
								<div class="cta-block">
									<div class="cta-block__central">
										<div class="cta-block__title">
											<?php echo esc_html__( 'Zapier integration', 'ecwid-shopping-cart' ); ?>
										</div>
										<div class="cta-block__content">
											<?php echo esc_html__( 'Connect thousands of popular apps to your online store with Zapier integration and streamline store management workflows without writing code.', 'ecwid-shopping-cart' ); ?>
										</div>
									</div>
									<div class="cta-block__cta">
										<a href="https://www.ecwid.com/blog/how-to-connect-ecwid-with-2000-online-business-tools.html?utm_source=wp-plugin" target="_blank" type="button" class="btn btn-default btn-medium"> <span><?php echo esc_html__( 'Learn More', 'ecwid-shopping-cart' ); ?></span> </a>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="a-card a-card--normal">
					<div class="a-card__paddings">
						<div class="iconable-block">
							<div class="iconable-block__infographics"> 
								<span class="iconable-block__icon">
									<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 56 56"><defs><style>.api-cls-3{fill:#6d839b}</style></defs><path d="M53 41H8a5 5 0 0 0-5 5 5 5 0 0 0 5 5h45" fill="#fff"/><path d="M8 1a5 5 0 0 0-5 5v39h.1A5 5 0 0 1 8 41h45V1Z" fill="#edf7fd"/><path class="api-cls-3" d="M23.87 14h-3.68l-5.33 13.76h3.37l.87-2.34H25l.85 2.34h3.37Zm-4 8.88L22 16.89l2.15 5.94ZM36.83 13.92h-6.46V27.8h2.94v-5h3.52a4.33 4.33 0 0 0 4.63-4 3.09 3.09 0 0 0 0-.43 4.31 4.31 0 0 0-4.14-4.47Zm-.39 6.32h-3.13v-3.69h3.13a1.86 1.86 0 0 1 2 1.71 1.83 1.83 0 0 1-1.71 2ZM42.53 13.92V27.8h2.94V13.92Z"/><path fill="#fe948d" d="M33 45h12v10l-6-4-6 4V45z"/><path class="api-cls-3" d="M54 41.92V0H8a6 6 0 0 0-6 6v40.08A6 6 0 0 0 8 52h24v3a1 1 0 0 0 .53.88 1 1 0 0 0 1-.05L39 52.2l5.45 3.63A1 1 0 0 0 46 55v-3h8v-5h-8v-2a1 1 0 0 0-1-1H33a1 1 0 0 0-1 1v2H8a4 4 0 0 1-3.69-2.54A4 4 0 0 1 8 42h45ZM34 46h10v7.13l-4.45-3a1 1 0 0 0-1.1 0l-4.45 3ZM8 40a6 6 0 0 0-4 1.54V6a4 4 0 0 1 4-4Zm2-38h42v38H10Z"/></svg>
								</span>
							</div>
							<div class="iconable-block__content">
								<div class="cta-block">
									<div class="cta-block__central">
										<div class="cta-block__title">
											<?php echo esc_html__( 'API for catalog and sales', 'ecwid-shopping-cart' ); ?>
										</div>
										<div class="cta-block__content">
											<?php echo esc_html__( 'Use a powerful RESTful API to manage your store, mass update your product catalog and orders.', 'ecwid-shopping-cart' ); ?>
										</div>
									</div>
									<div class="cta-block__cta">
										<a href="https://api-docs.ecwid.com/reference/rest-api?utm_source=wp-plugin" target="_blank" type="button" class="btn btn-default btn-medium"> <span><?php echo esc_html__( 'Learn More', 'ecwid-shopping-cart' ); ?></span> </a>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="named-area">
			<div class="named-area__header">
				<div class="named-area__titles">
					<div class="named-area__title">
						<?php echo esc_html__( 'Partnership', 'ecwid-shopping-cart' ); ?>
					</div>
					<div class="named-area__subtitle">
						<?php echo wp_kses_post( sprintf( __( 'Join our partnership program to build and scale your offering in ecommerce. <a %s>More about partnership</a>', 'ecwid-shopping-cart' ), 'href="https://www.ecwid.com/partners/?utm_source=wp-plugin" target="_blank"' ) ); ?>
					</div>
				</div>
				<div class="named-area__description"></div>
				<div class="named-area__additional"></div>
			</div>
			<div class="named-area__body">
				<div class="a-card a-card--normal">
					<div class="a-card__paddings">
						<div class="iconable-block">
							<div class="iconable-block__infographics">
								<span class="iconable-block__icon">
									<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 56 56"><defs><style>.affiliate-cls-2{fill:#fbd88e}.affiliate-cls-3{fill:#6d839b}</style></defs><circle cx="28" cy="28" r="21" fill="#ecf5fe"/><path class="affiliate-cls-2" d="M28 12a7.31 7.31 0 0 1 7 7.57v2.16c0 4.19-3.13 8.69-7 8.69s-7-4.42-7-8.68v-2.16A7.3 7.3 0 0 1 28 12"/><path class="affiliate-cls-3" d="M28 31.44c-4.58 0-8-5.12-8-9.7v-2.16A8.31 8.31 0 0 1 28 11a8.31 8.31 0 0 1 8 8.57v2.17c0 4.58-3.42 9.7-8 9.7ZM28 13a6.31 6.31 0 0 0-6 6.57v2.17c0 3.56 2.62 7.7 6 7.7s6-4.14 6-7.7v-2.16A6.32 6.32 0 0 0 28 13Z"/><path class="affiliate-cls-2" d="M43.38 42.27v-2.5a5.55 5.55 0 0 0-3.5-5.15l-6.08-2.17h-.06a8.34 8.34 0 0 1-5.74 2 8.39 8.39 0 0 1-5.72-2l-.08-.07-6.08 2.17a5.55 5.55 0 0 0-3.5 5.15v2.5A20.94 20.94 0 0 0 28 49a20.94 20.94 0 0 0 15.38-6.73Z"/><path class="affiliate-cls-3" d="M28 50a22.06 22.06 0 0 1-16.11-7l-.27-.29v-2.94a6.51 6.51 0 0 1 4.13-6.08l6.71-2.4.45.45A7.42 7.42 0 0 0 28 33.49a7.41 7.41 0 0 0 5-1.71l.53-.53.56.26 6.08 2.17a6.52 6.52 0 0 1 4.16 6.09v2.89l-.27.29A22.06 22.06 0 0 1 28 50Zm-14.38-8.13a19.93 19.93 0 0 0 28.76 0v-2.1a4.53 4.53 0 0 0-2.86-4.22l-5.5-2a9.54 9.54 0 0 1-6 1.9 9.64 9.64 0 0 1-6-1.9l-5.53 2a4.52 4.52 0 0 0-2.83 4.21Z"/><path class="affiliate-cls-3" d="M51 46a5 5 0 0 0-2.75.83l-4-4a22 22 0 0 0 0-29.66l4-4a5 5 0 1 0-1.42-1.42l-4 4a22 22 0 0 0-29.66 0l-4-4a5 5 0 1 0-1.42 1.42l4 4a22 22 0 0 0 0 29.66l-4 4a5 5 0 1 0 1.42 1.42l4-4a22 22 0 0 0 29.66 0l4 4A5 5 0 1 0 51 46Zm-15.66.59-.21.08c-.49.18-1 .36-1.49.51l-.51.13c-.42.11-.85.23-1.28.31s-.62.1-.93.14-.63.11-1 .14c-.65.06-1.31.1-2 .1s-1.32 0-2-.1c-.32 0-.63-.09-1-.14s-.62-.08-.93-.14-.86-.2-1.28-.31l-.51-.13c-.51-.15-1-.33-1.49-.51l-.21-.08A20 20 0 0 1 9.41 35.34c0-.07-.05-.14-.08-.2-.18-.5-.36-1-.51-1.5l-.13-.5c-.11-.43-.23-.86-.31-1.29s-.1-.62-.14-.93-.11-.63-.14-1C8 29.32 8 28.66 8 28s0-1.32.1-2c0-.32.09-.63.14-1s.08-.62.14-.93.2-.86.31-1.29l.13-.5c.15-.51.33-1 .51-1.5 0-.06.05-.13.08-.2A20 20 0 0 1 20.66 9.41l.21-.08c.49-.18 1-.36 1.49-.51l.51-.13c.42-.11.85-.23 1.28-.31s.62-.1.93-.14.63-.11 1-.14C26.68 8 27.34 8 28 8s1.32 0 2 .1c.32 0 .63.09 1 .14s.62.08.93.14.86.2 1.28.31l.51.13c.51.15 1 .33 1.49.51l.21.08a20 20 0 0 1 11.17 11.25c0 .07 0 .14.08.2.18.5.36 1 .51 1.5 0 .16.08.34.13.5.11.43.23.86.31 1.29s.1.62.14.93.11.63.14 1c.06.65.1 1.31.1 2s0 1.32-.1 2c0 .32-.09.63-.14 1s-.08.62-.14.93-.2.86-.31 1.29l-.13.5c-.15.51-.33 1-.51 1.5 0 .06-.05.13-.08.2a20 20 0 0 1-11.25 11.09Z"/></svg>
								</span>
							</div>
							<div class="iconable-block__content">
								<div class="cta-block">
									<div class="cta-block__central">
										<div class="cta-block__title">
											<?php echo esc_html__( 'Become an Ecwid Referral Partner', 'ecwid-shopping-cart' ); ?>
										</div>
										<div class="cta-block__content">
											<?php echo esc_html__( 'Recommend Ecwid within your network and get a 20% lifetime commission for every referral that creates an account through your link.', 'ecwid-shopping-cart' ); ?>
										</div>
									</div>
									<div class="cta-block__cta">
										<a href="https://www.ecwid.com/partners/referral?utm_source=wp-plugin" target="_blank" type="button" class="btn btn-default btn-medium"> <span><?php echo esc_html__( 'Learn More', 'ecwid-shopping-cart' ); ?></span> </a>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="a-card a-card--normal">
					<div class="a-card__paddings">
						<div class="iconable-block">
							<div class="iconable-block__infographics">
								<span class="iconable-block__icon">
									<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 56 56"><path d="M16.33 22.28l-13.2 13.2a3.78 3.78 0 000 5.35l8.71 8.71a3.78 3.78 0 005.35 0l13.2-13.19" fill="#fe948d"/><path d="M50.94 30.85L22.19 2.09l-6.72 19.64-13 13A4.74 4.74 0 001 38.15a4.79 4.79 0 001.4 3.39l8.71 8.71a4.75 4.75 0 003.38 1.4 4.79 4.79 0 003.39-1.4l4.6-4.6L32.87 56l5.44-5.44-10.37-10.35 3.1-3.1zM32.87 53.19L24 44.28l2.61-2.62 8.91 8.92zM23 5.77l24.2 24.17-16.52 5.19L17.51 22zm-6.52 43.06a2.74 2.74 0 01-2 .82 2.77 2.77 0 01-2-.82l-8.7-8.71a2.74 2.74 0 01-.82-2 2.77 2.77 0 01.82-2l12.6-12.47L29 36.3zM36.32 12.55a2 2 0 011.4.58l2.46 2.47a2 2 0 010 2.79l1.42 1.42a4 4 0 000-5.62l-2.47-2.47a4 4 0 00-2.81-1.17 4 4 0 00-2.81 1.17l1.41 1.41a2 2 0 011.4-.58zM36 0h2v7h-2zM44.801 7.98l4.64-5.08 1.477 1.348-4.64 5.08zM47 15h8v2h-8z" fill="#7e94aa"/></svg>
								</span>
							</div>
							<div class="iconable-block__content">
								<div class="cta-block">
									<div class="cta-block__central">
										<div class="cta-block__title">
											<?php echo esc_html__( 'Promote your services as Ecwid Expert', 'ecwid-shopping-cart' ); ?>
										</div>
										<div class="cta-block__content">
											<?php echo esc_html__( 'Join our community of experts and promote your services to clients who need help with store setup, design, or customization.', 'ecwid-shopping-cart' ); ?>
										</div>
									</div>
									<div class="cta-block__cta">
										<a href="https://www.ecwid.com/experts?utm_source=wp-plugin" target="_blank" type="button" class="btn btn-default btn-medium"> <span><?php echo esc_html__( 'Learn More', 'ecwid-shopping-cart' ); ?></span> </a>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="a-card a-card--normal">
					<div class="a-card__paddings">
						<div class="iconable-block">
							<div class="iconable-block__infographics">
								<span class="iconable-block__icon">
									<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 56 56"><path fill="#FBD88E" d="M28.09 3.79c-.61 0-1.23.32-1.55.96l-7.02 14.22-15.68 2.28c-1.41.21-1.98 1.94-.96 2.94l11.35 11.07-2.68 15.63c-.19 1.11.69 2.02 1.7 2.02.26 0 .54-.06.8-.2l14.03-7.38 14.03 7.38c.26.14.54.2.8.2 1 0 1.89-.9 1.7-2.02l-2.68-15.63L53.3 24.19c1.02-1 .46-2.73-.96-2.94l-15.69-2.28-7.02-14.22c-.31-.64-.93-.96-1.54-.96z"/><path fill="#7E94AA" d="M28.09 3.79c.61 0 1.23.32 1.55.96l7.02 14.22 15.69 2.28c1.41.21 1.98 1.94.96 2.94L41.94 35.25l2.68 15.63c.19 1.11-.69 2.02-1.7 2.02-.26 0-.54-.06-.8-.2l-14.03-7.38-14.03 7.38c-.26.14-.54.2-.8.2-1 0-1.89-.9-1.7-2.02l2.68-15.63L2.88 24.19c-1.02-1-.46-2.73.96-2.94l15.69-2.28 7.02-14.22c.31-.64.92-.96 1.54-.96m0-2.03c-1.44 0-2.73.8-3.36 2.09l-6.55 13.26-14.63 2.13a3.74 3.74 0 00-3.03 2.55c-.44 1.37-.08 2.84.95 3.84l10.59 10.32-2.5 14.58c-.19 1.09.11 2.2.82 3.04.72.85 1.77 1.34 2.87 1.34.6 0 1.2-.15 1.74-.43l13.09-6.88 13.09 6.88a3.751 3.751 0 004.62-.91c.71-.84 1.01-1.95.82-3.04l-2.5-14.58L54.7 25.63c1.03-1 1.39-2.48.95-3.84a3.698 3.698 0 00-3.03-2.55L38 17.12 31.45 3.85a3.712 3.712 0 00-3.36-2.09z"/><path fill="#D8AB50" d="M39.33 48.61c-.37 0-.73-.09-1.07-.27L28.09 43l-10.17 5.35c-.96.5-2.16.25-2.84-.56-.44-.52-.62-1.2-.5-1.87l1.94-11.33-8.23-8.02c-.63-.62-.86-1.52-.58-2.36.27-.84.99-1.44 1.86-1.57l11.37-1.65 5.09-10.3c.39-.79 1.18-1.29 2.07-1.29s1.68.49 2.07 1.29l5.08 10.3 11.37 1.65c.88.13 1.59.73 1.86 1.57.27.84.05 1.75-.58 2.36l-8.23 8.02 1.94 11.33c.12.67-.07 1.35-.5 1.87-.45.52-1.1.82-1.78.82zm-11.24-7.87l11.1 5.84c.13.07.29.03.38-.08.06-.07.08-.15.06-.24L37.51 33.9l8.98-8.75c.11-.11.1-.23.08-.31a.281.281 0 00-.25-.21l-12.41-1.8-5.55-11.25c-.14-.28-.41-.28-.55 0l-5.55 11.25-12.41 1.8c-.16.02-.22.13-.25.21-.02.07-.04.2.08.31l8.98 8.75-2.12 12.36c-.02.09 0 .17.06.24.09.11.24.15.38.08l11.11-5.84z"/></svg>
								</span>
							</div>
							<div class="iconable-block__content">
								<div class="cta-block">
									<div class="cta-block__central">
										<div class="cta-block__title">
											<?php echo esc_html__( 'Use Ecwid premium plan for free', 'ecwid-shopping-cart' ); ?>
										</div>
										<div class="cta-block__content">
											<?php echo esc_html__( 'If you’re developing sites on WordPress, you can get a free subscription to the Ecwid premium plan. Use it to build and test stores on the WordPress sites, check out the platform features, and get access to Ecwid API. Just apply for the free subscription, and we’ll get in touch with you soon.', 'ecwid-shopping-cart' ); ?>
										</div>
									</div>
									<div class="cta-block__cta">
										<a href="https://ecommerce-store.typeform.com/to/Heh5d4?utm_source=wp-plugin" target="_blank" type="button" class="btn btn-default btn-medium"> <span><?php echo esc_html__( 'Apply for Free Plan', 'ecwid-shopping-cart' ); ?></span> </a>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="named-area">
			<div class="named-area__header">
				<div class="named-area__titles">
					<div class="named-area__title">
						<?php echo esc_html__( 'Need a hand?', 'ecwid-shopping-cart' ); ?>
					</div>
					<div class="named-area__subtitle"></div>
				</div>
				<div class="named-area__description"></div>
				<div class="named-area__additional"></div>
			</div>
			<div class="named-area__body">
				<div class="a-card a-card--normal">
					<div class="a-card__paddings">
						<div class="iconable-block">
							<div class="iconable-block__infographics"> 
								<span class="iconable-block__icon">
									<svg data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 56 56"><path d="M21.08 2a5.2 5.2 0 0 0 0 10.4h5.19V7.2A5.19 5.19 0 0 0 21.08 2m0 13.87H7.24a5.2 5.2 0 0 0 0 10.4h13.84a5.2 5.2 0 0 0 0-10.4Z" fill-rule="evenodd" fill="#46bce6"/><path d="M54 21.07a5.19 5.19 0 1 0-10.38 0v5.2h5.19a5.2 5.2 0 0 0 5.19-5.2Zm-13.84 0V7.2a5.19 5.19 0 1 0-10.38 0v13.87a5.19 5.19 0 1 0 10.38 0Z" fill="#3bac7b" fill-rule="evenodd"/><path d="M34.92 54a5.2 5.2 0 0 0 0-10.4h-5.19v5.2a5.19 5.19 0 0 0 5.19 5.2Zm0-13.87h13.84a5.2 5.2 0 0 0 0-10.4H34.92a5.2 5.2 0 0 0 0 10.4Z" fill="#e9b244" fill-rule="evenodd"/><path d="M2.05 34.93a5.19 5.19 0 1 0 10.38 0v-5.2H7.24a5.2 5.2 0 0 0-5.19 5.2Zm13.84 0V48.8a5.19 5.19 0 1 0 10.38 0V34.94a5.19 5.19 0 1 0-10.38 0" fill="#da355f" fill-rule="evenodd"/></svg>
								</span>
							</div>
							<div class="iconable-block__content">
								<div class="cta-block">
									<div class="cta-block__central">
										<div class="cta-block__title">
											<?php echo esc_html__( 'Join developer community on Slack', 'ecwid-shopping-cart' ); ?>
										</div>
										<div class="cta-block__content">
											<?php echo esc_html__( 'Join the community of professionals to get help with questions that are not covered by Help Center or API documentation.', 'ecwid-shopping-cart' ); ?>
										</div>
									</div>
									<div class="cta-block__cta">
										<a href="https://join.slack.com/t/lightspeed-ecom-comm/shared_invite/zt-1hvv9uar5-BtF5AQGJHqd~T7fR2~Boyw" target="_blank" type="button" class="btn btn-default btn-medium"> <span>Join Community</span> </a>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="a-card a-card--normal">
					<div class="a-card__paddings">
						<div class="iconable-block">
							<div class="iconable-block__infographics"> <span class="iconable-block__icon">
					<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 80 80"><path fill="#FFF" d="M11 37.11v33.4c0 1.93 1.44 3.49 3.22 3.49h52.56c1.78 0 3.22-1.56 3.22-3.49V37"/><path fill-rule="evenodd" clip-rule="evenodd" fill="#FBD88E" d="M46 49.34c0-2.4 2.02-4.34 4.5-4.34h9.02c2.49 0 4.5 1.95 4.5 4.34v20.32c0 2.4-2.02 4.34-4.5 4.34H50.5c-2.49 0-4.5-1.95-4.5-4.34V49.34z"/><path fill="#FE948D" d="M8 28l4.64-14c0-2.22 2.14-2 2.79-2h8.12L21 28"/><path fill="#FBD88E" d="M21 28l2.54-16h11.39L34 28"/><path fill="#CBE87C" d="M34 28l.93-16h11.14L47 28"/><path fill="#BCDEFA" d="M47 28l-.93-16h11.39L60 28"/><path fill="#FE948D" d="M60 28l-2.54-16h8.12c.64 0 2.79-.22 2.79 2L73 28"/><path fill="#ECF5FE" d="M17 49.72c0-2.61 1.92-4.72 4.33-4.72h14.35c2.39 0 4.33 2.11 4.33 4.72v12.56c0 2.61-1.92 4.72-4.33 4.72H21.33C18.94 67 17 64.89 17 62.28V49.72z"/><path fill="#7E94AA" d="M35.67 68H21.33C18.39 68 16 65.43 16 62.28V49.72c0-3.15 2.39-5.72 5.33-5.72h14.35c2.94 0 5.33 2.57 5.33 5.72v12.56C41 65.43 38.61 68 35.67 68zM21.33 46C19.49 46 18 47.67 18 49.72v12.56c0 2.05 1.49 3.72 3.33 3.72h14.35c1.83 0 3.33-1.67 3.33-3.72V49.72c0-2.05-1.49-3.72-3.33-3.72H21.33z"/><path fill-rule="evenodd" clip-rule="evenodd" fill="#ECF5FE" d="M17 49.72c0-2.61 1.92-4.72 4.33-4.72h14.35c2.39 0 4.33 2.11 4.33 4.72v12.56c0 2.61-1.92 4.72-4.33 4.72H21.33C18.94 67 17 64.89 17 62.28V49.72z"/><path fill="#7E94AA" d="M52.61 61h-3.23c-.76 0-1.38-.67-1.38-1.5s.62-1.5 1.39-1.5h3.23c.76 0 1.39.67 1.39 1.5-.01.83-.63 1.5-1.4 1.5z"/><path fill="#FE948D" d="M14.5 40.01c-3.58 0-6.5-2.92-6.5-6.5v-4.33c0-.64.53-1.17 1.17-1.17h10.66c.64 0 1.17.53 1.17 1.17v4.33c0 3.57-2.92 6.5-6.5 6.5z"/><path fill="#FBD88E" d="M27.5 40.01c-3.58 0-6.5-2.92-6.5-6.5v-4.33c0-.64.53-1.17 1.17-1.17h10.66c.64 0 1.17.53 1.17 1.17v4.33c0 3.57-2.92 6.5-6.5 6.5z"/><path fill="#CBE87C" d="M40.5 40.01c-3.58 0-6.5-2.92-6.5-6.5v-4.33c0-.64.53-1.17 1.17-1.17h10.66c.64 0 1.17.53 1.17 1.17v4.33c0 3.57-2.92 6.5-6.5 6.5z"/><path fill="#BCDEFA" d="M53.5 40.01c-3.58 0-6.5-2.92-6.5-6.5v-4.33c0-.64.53-1.17 1.17-1.17h10.66c.64 0 1.17.53 1.17 1.17v4.33c0 3.57-2.92 6.5-6.5 6.5z"/><path fill="#FE948D" d="M66.5 40.01c-3.58 0-6.5-2.92-6.5-6.5v-4.33c0-.64.53-1.17 1.17-1.17h10.66c.64 0 1.17.53 1.17 1.17v4.33c0 3.57-2.92 6.5-6.5 6.5z"/><path fill="#BCDEFA" d="M14.98 63.86c0-.47 2.26-.86 5.08-.86H36.9c2.81 0 5.08.38 5.08.86v2.28c0 .47-2.26.86-5.08.86H20.06c-2.81 0-5.08-.38-5.08-.86v-2.28z"/><path fill="#7E94AA" d="M36.9 68H20.06c-6.08 0-6.08-1.3-6.08-1.86v-2.28c0-.56 0-1.86 6.08-1.86H36.9c6.08 0 6.08 1.3 6.08 1.86v2.28c0 .56 0 1.86-6.08 1.86zm-20.92-2.38c.59.16 1.95.38 4.08.38H36.9c2.13 0 3.49-.21 4.08-.37v-1.25c-.59-.17-1.95-.38-4.08-.38H20.06c-2.13 0-3.49.21-4.08.37v1.25z"/><path fill-rule="evenodd" clip-rule="evenodd" fill="#CBE87C" d="M14.98 63.86c0-.47-.37-.86 2.46-.86h22.1c2.81 0 2.46.38 2.46.86v2.28c0 .47.37.86-2.46.86h-22.1c-2.81 0-2.46-.38-2.46-.86v-2.28z"/><path fill="#7E94AA" d="M78 73h-7.71c.45-.71.71-1.57.71-2.49V39.49a7.48 7.48 0 003-5.99s.04-5.55-.05-5.82l-4.59-13.86c-.9-2.79-3.02-2.85-3.64-2.83H15.29c-.62-.02-2.62.04-3.64 2.83l-4.6 13.86c-.09.28-.05 5.83-.05 5.83a7.48 7.48 0 003 5.99v31.02c0 .92.26 1.78.71 2.49H2c-.55 0-1 .45-1 1s.45 1 1 1h76c.55 0 1-.45 1-1S78.55 73 78 73zm-6-39.49c0 3.03-2.47 5.5-5.5 5.5s-5.5-2.47-5.5-5.5v-4.33c0-.09.08-.17.17-.17h10.66c.09 0 .17.08.17.17v4.33zm-50-4.33c0-.09.08-.17.17-.17h10.66c.09 0 .17.08.17.17v4.33c0 3.03-2.47 5.5-5.5 5.5s-5.5-2.47-5.5-5.5v-4.33zm23.94-2.16c-.04 0-.07-.01-.11-.01H35.17c-.04 0-.07.01-.11.01L35.87 13h9.26l.81 14.02zM35 29.18c0-.09.08-.17.17-.17h10.66c.09 0 .17.08.17.17v4.33c0 3.03-2.47 5.5-5.5 5.5s-5.5-2.47-5.5-5.5v-4.33zm13 0c0-.09.08-.17.17-.17h10.66c.09 0 .17.08.17.17v4.33c0 3.03-2.47 5.5-5.5 5.5s-5.5-2.47-5.5-5.5v-4.33zM65.57 13h.18c.35-.01 1.09-.02 1.39.28.14.14.21.38.21.73 0 .11.02.21.05.31l4.21 12.69H61.17c-.11 0-.21.02-.31.03L58.63 13h6.94zm-8.97 0l2.23 14.01H48.17c-.08 0-.15.01-.22.02L47.13 13h9.47zM33.05 27.03c-.07-.01-.15-.02-.22-.02H22.17L24.4 13h9.47l-.82 14.03zM13.59 14.31c.03-.1.05-.21.05-.31 0-.34.07-.59.21-.73.3-.3 1.04-.29 1.39-.28h7.13l-2.23 14.04c-.1-.01-.2-.03-.31-.03H9.38l4.21-12.69zM9 33.51v-4.33c0-.09.08-.17.17-.17h10.66c.09 0 .17.08.17.17v4.33c0 3.03-2.47 5.5-5.5 5.5S9 36.54 9 33.51zM50.5 73c-1.93 0-3.5-1.5-3.5-3.34V49.34C47 47.5 48.57 46 50.5 46h9.02c1.93 0 3.5 1.5 3.5 3.34v20.32c0 1.84-1.57 3.34-3.5 3.34H50.5zm13.31 0a5.23 5.23 0 001.22-3.34V49.34c0-2.95-2.47-5.34-5.5-5.34H50.5c-3.03 0-5.5 2.4-5.5 5.34v20.32c0 1.26.46 2.43 1.22 3.34h-32C13 73 12 71.88 12 70.51V40.57c.78.28 1.62.44 2.5.44 2.78 0 5.2-1.52 6.5-3.77 1.3 2.25 3.72 3.77 6.5 3.77s5.2-1.52 6.5-3.77c1.3 2.25 3.72 3.77 6.5 3.77s5.2-1.52 6.5-3.77c1.3 2.25 3.72 3.77 6.5 3.77s5.2-1.52 6.5-3.77c1.3 2.25 3.72 3.77 6.5 3.77.88 0 1.72-.16 2.5-.44v29.94c0 1.37-1 2.49-2.22 2.49h-2.97z"/><path fill="#7E94AA" d="M42.99 63.79c.02-.21.06-.71-.34-1.14-.31-.34-.78-.52-1.65-.6V49.72c0-3.15-2.39-5.72-5.33-5.72H21.33C18.39 44 16 46.57 16 49.72v12.33c-.9.08-1.37.26-1.69.6-.4.43-.35.93-.33 1.21v2.35c-.02.21-.06.71.34 1.14.46.49 1.21.65 3.12.65h22.1c1.91 0 2.67-.16 3.12-.65.4-.43.36-.93.33-1.21v-2.35zM21.33 46h14.35c1.83 0 3.33 1.67 3.33 3.72V62H18V49.72c0-2.05 1.49-3.72 3.33-3.72zm19.65 19.94c-.26.03-.7.06-1.45.06h-22.1c-.75 0-1.19-.03-1.46-.06v-1.88c.26-.03.71-.06 1.46-.06h22.1c.75 0 1.19.03 1.46.06v1.88z"/></svg>
				</span> </div>
							<div class="iconable-block__content">
								<div class="cta-block">
									<div class="cta-block__central">
										<div class="cta-block__title">
											<?php echo esc_html__( 'Request custom development', 'ecwid-shopping-cart' ); ?>
										</div>
										<div class="cta-block__content">
											<?php echo esc_html__( 'The Ecwid team can help you build the desired features and options that Ecwid does not have out of the box — from integrations with other tools to your own mobile app. Custom development is a paid service, the price depends on the complexity of the request.', 'ecwid-shopping-cart' ); ?>
										</div>
									</div>
									<div class="cta-block__cta">
										<a href="https://support.ecwid.com/hc/en-us/articles/115005821245?utm_source=wp-plugin" target="_blank" type="button" class="btn btn-default btn-medium"> <span><?php echo esc_html__( 'Submit Request', 'ecwid-shopping-cart' ); ?></span> </a>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="a-card a-card--normal">
					<div class="a-card__paddings">
						<div class="iconable-block">
							<div class="iconable-block__infographics"> 
								<span class="iconable-block__icon">
									<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 56 56"><path d="M4.59 37A3.76 3.76 0 011 33.08V4.92A3.76 3.76 0 014.59 1h28.82A3.76 3.76 0 0137 4.92v28.16A3.76 3.76 0 0133.41 37z" fill="#fbd88e"/><path fill="#7e94aa" d="M33.41 38H4.59A4.77 4.77 0 010 33.08V4.92A4.77 4.77 0 014.59 0h28.82A4.77 4.77 0 0138 4.92v28.16A4.77 4.77 0 0133.41 38zM4.59 2A2.77 2.77 0 002 4.92v28.16A2.77 2.77 0 004.59 36h28.82A2.77 2.77 0 0036 33.08V4.92A2.77 2.77 0 0033.41 2z"/><path fill="#fff" d="M21 47h18.08L47 53.63V47h4a4 4 0 004-4V16a4 4 0 00-4-4H21a4 4 0 00-4 4v27a4 4 0 004 4z"/><path fill="#7e94aa" d="M48 55.77L38.71 48H21a5 5 0 01-5-5V16a5 5 0 015-5h30a5 5 0 015 5v27a5 5 0 01-5 5h-3zM21 13a3 3 0 00-3 3v27a3 3 0 003 3h18.44L46 51.49V46h5a3 3 0 003-3V16a3 3 0 00-3-3z"/><path fill="#ffbf09" d="M36.09 17.61l3.66 7.25 8.2 1.16-5.93 5.64 1.4 7.97-7.33-3.76-7.33 3.76 1.4-7.97-5.93-5.64 8.19-1.16 3.67-7.25z"/></svg>
								</span>
							</div>
							<div class="iconable-block__content">
								<div class="cta-block">
									<div class="cta-block__central">
										<div class="cta-block__title">
											<?php echo esc_html__( 'Leave feedback', 'ecwid-shopping-cart' ); ?>
										</div>
										<div class="cta-block__content">
											<?php echo esc_html__( 'Tell us what can be improved regarding Ecwid features, integrations, and functionality.', 'ecwid-shopping-cart' ); ?>
										</div>
									</div>
									<div class="cta-block__cta">
										<a href="https://ecommerce-store.typeform.com/to/qMgJpSBq?utm_source=wp-plugin#store_id=<?php echo esc_attr( get_ecwid_store_id() ); ?>&email=<?php echo esc_attr( $admin_email ); ?>" target="_blank" type="button" class="btn btn-default btn-medium"> <span><?php echo esc_html__( 'Leave Feedback', 'ecwid-shopping-cart' ); ?></span> </a>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
