<?php
/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package Ef Practical
 */

if ( ! function_exists( 'practical_site_branding' ) ) :
    /**
     * Display header logo and title/description
     */
    function practical_site_branding() { 
        
        $site_branding = get_theme_mod( 'practical_site_logo', 'logo_text' );
        
        if ( 'logo_image' == $site_branding && function_exists( 'the_custom_logo' ) ) {  
            
            the_custom_logo();
            
        } else {
        
    ?>
        
        <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
        <?php
            $description = get_bloginfo( 'description', 'display' );
            if ( $description || is_customize_preview() ) : ?>
                <p class="site-description"><?php echo $description; /* WPCS: xss ok. */ ?></p>
                <?php
            endif; 
        ?>
        
    <?php }
    
}
endif;

if ( ! function_exists( 'practical_social_links' ) ) :
    /**
     * Function for social links.
     */
    function practical_social_links() {
        
        $social_links = array(
            'social_facebook'   => __( 'Facebook', 'ef-practical' ),
            'social_twitter'	=> __( 'Twitter', 'ef-practical' ),
            'social_googleplus' => __( 'Google-Plus', 'ef-practical' ),
            'social_youtube'    => __( 'Youtube', 'ef-practical' ),
            'social_pinterest'  => __( 'Pinterest', 'ef-practical' ),
            'social_instagram'  => __( 'Instagram', 'ef-practical' ),
            'social_linkedin'   => __( 'Linkedin', 'ef-practical' ),
            'social_flickr'     => __( 'Flickr', 'ef-practical' ),
            'social_rss'        => __( 'Rss', 'ef-practical' )
        );
        
        ?>
        <div class="social-links">
            <?php $i=0;
                $links_output = '';
                foreach( $social_links as $key => $value ) {
                    $link = get_theme_mod( $key , '' );
                    if ( !empty( $link ) ) {
                        if ( 0 != get_theme_mod( $key.'_check', 0 ) ) {
                            $new_tab = 'target="_blank"';
                        } else {
                            $new_tab = '';
                        }
                        $links_output .= '<a class="social-icon '. esc_attr(strtolower($value)) .'" href="'.esc_url( $link ).'" '.$new_tab.' rel="nofollow"><i class="fa fa-'.strtolower($value).'"></i><span></span></a>';
                    } $i++;
                }
                echo $links_output; // WPCS: XSS ok.
            ?>
        </div><!-- .social-links -->
        <?php
    }
endif;

if ( ! function_exists( 'practical_header_image' ) ) :
    /**
     * Displays header image
     */
    function practical_header_image() {
        if ( has_header_image() ) {
            $header_image_title    = get_theme_mod( 'practical_header_img_title', '' );
            $header_image_desc     = get_theme_mod( 'practical_header_img_desc', '' );
            $header_image_btn_text = get_theme_mod( 'practical_header_img_text', '' );
            $header_image_btn_url  = get_theme_mod( 'practical_header_img_url', '' );
            
    ?>
        
        <div class="header-image" style="background-image: url(<?php header_image(); ?>);">
            
            <div class="ef-container">
                <?php if( '' != $header_image_title || '' != $header_image_desc ) : ?>
                    <div class="header-img-content">
                        <?php
                            if ( '' != $header_image_title ) {
                                echo '<h1 class="header-img-title wow fadeInDown">' . esc_html( $header_image_title ) . '</h1>';
                            }
                            if ( '' != $header_image_desc ) {
                                echo '<div class="header-img-desc wow fadeInDown">' . wp_kses_post( $header_image_desc ) . '</div>';
                            }
                            if ( '' != $header_image_btn_text && '' != $header_image_btn_url ) {
                                echo '<a href="' . esc_url( $header_image_btn_url ) . '" class="button header-img-btn wow fadeInDown">' . esc_html( $header_image_btn_text ) . '</a>';
                            }
                        ?>
                    </div>
                <?php endif; ?>
            </div>
            
        </div>
        
    <?php
        }
    }
endif;

if ( ! function_exists( 'practical_archive_title' ) ) :
    /**
     * Show the page title before content.
     */
    function practical_archive_title( $title ) {

        if( is_archive() ) {
            if ( is_category() ) :
                $title = single_cat_title( '', FALSE );

            elseif ( is_tag() ) :
                $title = single_tag_title( '', FALSE );

            elseif ( is_author() ) :
                /* Queue the first post, that way we know
                 * what author we're dealing with (if that is the case).
                */
                the_post();
                /* translators: %s: author. */
                $title =  sprintf( esc_html__( 'Author: %s', 'ef-practical' ), get_the_author() );
                /* Since we called the_post() above, we need to
                 * rewind the loop back to the beginning that way
                 * we can run the loop properly, in full.
                 */
                rewind_posts();

            elseif ( is_day() ) :
                /* translators: %s: day. */
                $title = sprintf( esc_html__( 'Day: %s', 'ef-practical' ), get_the_date() );

            elseif ( is_month() ) :
                /* translators: %s: month. */
                $title = sprintf( esc_html__( 'Month: %s', 'ef-practical' ), get_the_date( 'F Y' ) );

            elseif ( is_year() ) :
                /* translators: %s: year. */
                $title = sprintf( esc_html__( 'Year: %s', 'ef-practical' ), get_the_date( 'Y' ) );

            elseif ( is_tax( 'post_format', 'post-format-aside' ) ) :
                $title = esc_html__( 'Asides', 'ef-practical' );

            elseif ( is_tax( 'post_format', 'post-format-gallery' ) ) :
                $title = esc_html__( 'Galleries', 'ef-practical' );

            elseif ( is_tax( 'post_format', 'post-format-image' ) ) :
                $title = esc_html__( 'Images', 'ef-practical' );

            elseif ( is_tax( 'post_format', 'post-format-video' ) ) :
                $title = esc_html__( 'Videos', 'ef-practical' );

            elseif ( is_tax( 'post_format', 'post-format-quote' ) ) :
                $title = esc_html__( 'Quotes', 'ef-practical' );

            elseif ( is_tax( 'post_format', 'post-format-link' ) ) :
                $title = esc_html__( 'Links', 'ef-practical' );

            elseif ( is_tax( 'post_format', 'post-format-status' ) ) :
                $title = esc_html__( 'Status', 'ef-practical' );

            elseif ( is_tax( 'post_format', 'post-format-audio' ) ) :
                $title = esc_html__( 'Audio', 'ef-practical' );

            elseif ( is_tax( 'post_format', 'post-format-chat' ) ) :
                $title = esc_html__( 'Chat', 'ef-practical' );

            else :
                $title = esc_html__( 'Archives', 'ef-practical' );

            endif;
        }
        elseif( is_404() ) {
            $title = esc_html__( 'Error 404 ! - Page Not Found', 'ef-practical' );
        }
        elseif( is_search() ) {
            /* translators: %s: search term. */
            $title = sprintf( esc_html__( 'Search Results for: %s', 'ef-practical' ), get_search_query() );
        }
        elseif( is_page()  ) {
            $title = get_the_title();
        }
        elseif( is_single()  ) {
            $title = get_the_title();
        }
        elseif( is_home() ) {
            $queried_id = get_option( 'page_for_posts' );
            $title = get_the_title( $queried_id );
        }
        else {
            $title = '';
        }

        return $title;

    }
    add_filter( 'get_the_archive_title', 'practical_archive_title', 10, 1 );
endif;

if ( ! function_exists( 'practical_link_pages' ) ) :
	/**
	 * Pages links.
	 */
	function practical_link_pages() {
		wp_link_pages( array(
            'before'      => '<div class="page-links cf"><div class="page-links-title">' . esc_html__( 'Pages:', 'ef-practical' ) . '</div>',
            'after'       => '</div>',
			'link_before' => '<div class="page-number">',
			'link_after'  => '</div>',
		) );
	}
endif;

if ( ! function_exists( 'practical_post_navigation' ) ) :
    /**
     * Navigation : next/prev for single post
     */
    function practical_post_navigation() {
        // Don't print empty markup if there's nowhere to navigate.
        $previous = ( is_attachment() ) ? get_post( get_post()->post_parent ) : get_adjacent_post( false, '', true );
        $next     = get_adjacent_post( false, '', false );
        
        if ( ! $next && ! $previous ) {
            return;
        }
        
        if ( 'below' == get_theme_mod( 'practical_single_post_nav_type', 'below' ) ) :
        
        ?>
            <nav class="post-navigation navigation cf" role="navigation">
                <div class="nav-links cf">
                    <?php
                        previous_post_link('<div class="post-nav nav-prev">%link', '<span class="postnav-meta">'.esc_html__( 'Previous Post', 'ef-practical' ).'</span><span class="postnav-title">%title</span></div>');
                        next_post_link('<div class="post-nav nav-next">%link', '<span class="postnav-meta">'.esc_html__( 'Next Post', 'ef-practical' ).'</span><span class="postnav-title">%title</span></div>');
                    ?>
                </div><!-- .nav-links -->
            </nav><!-- .navigation -->
        <?php else: ?>
            <nav class="side-navigation navigation" role="navigation">
                <?php previous_post_link('<div class="side-nav-prev">%link', '<span class="postnav-meta">'.esc_html__( 'Previous Post', 'ef-practical' ).'</span><span class="postnav-title">%title</span></div>'); ?>
                <?php next_post_link('<div class="side-nav-next">%link', '<span class="postnav-meta">'.esc_html__( 'Next Post', 'ef-practical' ).'</span><span class="postnav-title">%title</span></div>'); ?>
            </nav>
    <?php
        endif;
    }
endif; // practical_post_navigation

if ( ! function_exists( 'practical_posts_navigation' ) ) :
    /**
     * Navigation : next/prev for set of posts
     */
    function practical_posts_navigation() {
        global $wp_query;
        if ( $wp_query->max_num_pages < 2 )
            return;
        ?>
        <nav class="posts-navigation navigation cf" role="navigation">
            <div class="nav-links cf">
                <?php if ( get_previous_posts_link() ) : ?>
                    <div class="post-nav nav-prev"><?php previous_posts_link( '<i class="fa fa-angle-double-left"></i> ' . esc_html__( 'Previous Page', 'ef-practical' ) ); ?></div>
                <?php endif; ?>
                <?php if ( get_next_posts_link() ) : ?>
                    <div class="post-nav nav-next"><?php next_posts_link( esc_html__( 'Next Page', 'ef-practical' ) . ' <i class="fa fa-angle-double-right"></i>' ); ?></div>
                <?php endif; ?>
            </div>
        </nav><!-- .posts-navigation -->
    <?php
    }
endif; // practical_posts_navigation

if ( ! function_exists( 'practical_comment' ) ) :
    
    function practical_comment( $comment, $args, $depth ) { ?>
        <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
            <div class="single-comment" id="comment-<?php comment_ID(); ?>">
                <div class="comment-inner-top cf">
                    <div class="gravatar"><?php echo get_avatar( $comment, $size='60', $default='' ); ?></div>
                    <div class="comment-meta">
                        <div class="comment-author"><?php echo get_comment_author_link() ?></div>
                        <time class="comment-time">
                            <?php
                                /* translators: 1: author  2: date. */
                                printf(esc_html__('%1$s at %2$s', 'ef-practical'), get_comment_date(),  get_comment_time());
                            ?>
                        </time>
                    </div>
                </div>
                <div class="comment-content cf">
                    <?php if ( $comment->comment_approved == '0' ) : ?>
                        <span class="unapproved"><?php esc_html_e( 'Your comment is awaiting moderation.', 'ef-practical' );?></span>
                    <?php endif; ?>
                    <?php comment_text(); ?>
                    <?php edit_comment_link('<i class="fa fa-pencil"></i> ' . esc_html__( 'Edit', 'ef-practical' ),'  ','' ) ?>
                    <?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ) ?>
                </div>
            </div>		
    <?php
    }
endif; // ends check for practical_comment()

if ( ! function_exists( 'practical_pings' ) ) :
    
    function practical_pings( $comment, $args, $depth ) { ?>
        <li>
            <span class="ping-author"><?php comment_author_link( $comment ); ?></span> &nbsp;<span class="ping-date"><?php comment_date( get_option( 'date_format' ), $comment ); ?></span>
            <div class="ping-content"><?php comment_text( $comment ); ?></div>
    <?php
    }
endif; // ends check for practical_pings()