imary-navigation .sub-menu .sub-menu {
	border: none;
}
@media only screen and (min-width: 482px) {

	.primary-navigation .sub-menu > .menu-item > .sub-menu {
		padding: 0;
	}
}
@media only screen and (max-width: 481px) {

	.primary-navigation .sub-menu .menu-item:last-child {
		margin-bottom: 0;
	}
}

.primary-navigation .sub-menu .menu-item > a {
	padding: calc(1.25 * var(--primary-nav--padding)) var(--primary-nav--padding);
	display: block;
	font-size: var(--primary-nav--font-size-sub-menu-mobile);
	font-style: var(--primary-nav--font-style-sub-menu-mobile);
}
@media only screen and (min-width: 482px) {

	.primary-navigation .sub-menu .menu-item > a {
		font-size: var(--primary-nav--font-size-sub-menu);
		font-style: var(--primary-nav--font-style);
	}
}

.primary-navigation .menu-item-has-children > .svg-icon {
	display: none;
}
@media only screen and (min-width: 482px) {

	.primary-navigation .menu-item-has-children > .svg-icon {
		display: inline-block;
		height: 100%;
	}

	.primary-navigation .menu-item-has-children .sub-menu .svg-icon {
		display: none;
	}
}

.primary-navigation .menu-item-description {
	display: block;
	clear: both;
	font-size: var(--global--font-size-xs);
	text-transform: none;
	line-height: 1.7;
}

.primary-navigation .menu-item-description > span {
	display: inline-block;
}

@media only screen and (max-width: 481px) {

	.lock-scrolling .site {
		position: fixed;
		max-width: 100%;
		width: 100%;
	}
}
@keyframes twentytwentyone-close-button-transition {

	from {
		opacity: 0;
	}

	to {
		opacity: 1;
	}
}

.footer-navigation {
	margin-top: calc(2 * var(--global--spacing-vertical));
	margin-bottom: var(--global--spacing-vertical);
	color: var(--footer--color-text);
	font-size: var(--global--font-size-xs);
	font-family: var(--footer--font-family);
}

.footer-navigation-wrapper {
	display: flex;
	justify-content: center;
	flex-wrap: wrap;
	list-style: none;
	padding-left: 0;
}

.footer-navigation-wrapper li {
	display: inline;
	line-height: 3;
}

.footer-navigation-wrapper li a {
	padding: calc(1.25 * var(--primary-nav--padding)) var(--primary-nav--padding);
	transition: transform 0.1s ease;
	color: var(--footer--color-link);
}

.footer-navigation-wrapper li a:link,
.footer-navigation-wrapper li a:visited,
.footer-navigation-wrapper li a:active {
	color: var(--footer--color-link);
}

.footer-navigation-wrapper li a:hover {
	text-decoration: underline;
	text-decoration-style: dotted;
	text-decoration-skip-ink: none;
	color: var(--footer--color-link-hover);
}

.is-dark-theme .footer-navigation-wrapper li a:focus .svg-icon {
	fill: var(--wp--style--color--link, var(--global--color-background));
}

.has-background-white .footer-navigation-wrapper li a:focus .svg-icon {
	fill: var(--wp--style--color--link, var(--global--color-white));
}

.footer-navigation-wrapper li .svg-icon {
	vertical-align: middle;
	fill: var(--footer--color-link);
}

.footer-navigation-wrapper li .svg-icon:hover {
	transform: scale(1.1);
}

.footer-navigation-wrapper .sub-menu-toggle,
.footer-navigation-wrapper .menu-item-description {
	display: none;
}

/* Next/Previous navigation */
.navigation {
	color: var(--global--color-primary);
}

.navigation a {
	color: var(--global--color-primary);
	text-decoration: none;
}

.navigation a:hover {
	color: var(--global--color-primary-hover);
	text-decoration: underline;
	text-decoration-style: dotted;
}

.navigation a:focus {
	color: var(--global--color-secondary);
}

.navigation a:active {
	color: var(--global--color-primary);
}

.navigation .nav-links > * {
	min-width: 44px;
	min-height: 44px;
}

.navigation .nav-links .nav-next a,
.navigation .nav-links .nav-previous a {
	display: flex;
	flex-direction: column;
}

.navigation .nav-links .dots {
	text-align: center;
}
@media only screen and (min-width: 592px) {

	.navigation .nav-links {
		display: flex;
		justify-content: center;
		flex-wrap: wrap;
	}

	.navigation .nav-links .nav-next,
	.navigation .nav-links .nav-previous {
		flex: 0 1 auto;
		margin-bottom: inherit;
		margin-top: inherit;
		max-width: calc(50% - (0.5 * var(--global--spacing-unit)));
	}

	.navigation .nav-links .nav-next {
		text-align: right;
	}
}

.navigation .svg-icon {
	display: inline-block;
	fill: currentColor;
	vertical-align: middle;
	position: relative;
}

.navigation .nav-previous .svg-icon,
.navigation .prev .svg-icon {
	top: -2px;
	margin-right: calc(0.25 * var(--global--spacing-unit));
}

.navigation .nav-next .svg-icon,
.navigation .next .svg-icon {
	top: -1px;
	margin-left: calc(0.25 * var(--global--spacing-unit));
}

.post-navigation {
	margin: var(--global--spacing-vertical) auto;
}
@media only screen and (min-width: 822px) {

	.post-navigation {
		margin: var(--global--spacing-vertical) auto;
	}
}

.post-navigation .meta-nav {
	line-height: var(--global--line-height-body);
	color: var(--global--color-primary);
}

.post-navigation .post-title {
	display: inline-block;
	font-family: var(--global--font-primary);
	font-size: var(--global--font-size-lg);
	font-weight: var(--pagination--font-weight-strong);
	line-height: var(--global--line-height-heading);
}
@media only screen and (min-width: 822px) {

	.post-navigation .post-title {
		margin: 5px calc(24px + (0.25 * var(--global--spacing-unit))) 0;
	}
}
@media only screen and (min-width: 482px) {

	.post-navigation .nav-links {
		justify-content: space-between;
	}
}

.post-navigation .nav-next,
.post-navigation .nav-previous {
	margin-top: var(--global--spacing-vertical);
	margin-bottom: var(--global--spacing-vertical);
}

.post-navigation .nav-next:first-child,
.post-navigation .nav-previous:first-child {
	margin-top: 0;
}

.post-navigation .nav-next:last-child,
.post-navigation .nav-previous:last-child {
	margin-bottom: 0;
}

.pagination,
.comments-pagination {
	border-top: 3px solid var(--global--color-border);
	padding-top: var(--global--spacing-vertical);
	margin: var(--global--spacing-vertical) auto;
}
@media only screen and (min-width: 822px) {

	.pagination,
	.comments-pagination {
		margin: var(--global--spacing-vertical) auto;
	}
}

.pagination .nav-links,
.comments-pagination .nav-links {
	margin-top: calc(-1 * var(--global--spacing-vertical));
}

.pagination .nav-links a:hover,
.comments-pagination .nav-links a:hover {
	color: var(--pagination--color-link-hover);
}

.is-dark-theme .pagination .nav-links a:active,
.is-dark-theme .pagination .nav-links a:hover:active,
.is-dark-theme .pagination .nav-links a:hover:focus,
.is-dark-theme .comments-pagination .nav-links a:active,
.is-dark-theme .comments-pagination .nav-links a:hover:active,
.is-dark-theme .comments-pagination .nav-links a:hover:focus {
	color: var(--global--color-background);
}

.has-background-white .pagination .nav-links a:active,
.has-background-white .pagination .nav-links a:hover:active,
.has-background-white .pagination .nav-links a:hover:focus,
.has-background-white .comments-pagination .nav-links a:active,
.has-background-white .comments-pagination .nav-links a:hover:active,
.has-background-white .comments-pagination .nav-links a:hover:focus {
	color: var(--global--color-white);
}

.pagination .nav-links > *,
.comments-pagination .nav-links > * {
	color: var(--pagination--color-text);
	font-family: var(--pagination--font-family);
	font-size: var(--pagination--font-size);
	font-weight: var(--pagination--font-weight);
	margin-top: var(--global--spacing-vertical);
	margin-left: calc(0.66 * var(--global--spacing-unit));
	margin-right: calc(0.66 * var(--global--spacing-unit));
}

.pagination .nav-links > *.current,
.comments-pagination .nav-links > *.current {
	text-decoration: underline;
}

.pagination .nav-links > *:not(.dots):not(.current):hover,
.comments-pagination .nav-links > *:not(.dots):not(.current):hover {
	text-decoration-style: dotted;
}

.pagination .nav-links > *:first-child,
.comments-pagination .nav-links > *:first-child {
	margin-left: 0;
}

.pagination .nav-links > *:last-child,
.comments-pagination .nav-links > *:last-child {
	margin-right: 0;
}

.pagination .nav-links > *.next,
.comments-pagination .nav-links > *.next {
	margin-left: auto;
}

.pagination .nav-links > *.prev,
.comments-pagination .nav-links > *.prev {
	margin-right: auto;
}
@media only screen and (max-width: 821px) {

	.pagination .nav-links,
	.comments-pagination .nav-links {
		display: flex;
		flex-wrap: wrap;
	}

	.pagination .page-numbers,
	.comments-pagination .page-numbers {
		display: none;
	}

	.pagination .page-numbers.prev,
	.pagination .page-numbers.next,
	.comments-pagination .page-numbers.prev,
	.comments-pagination .page-numbers.next {
		display: inline-block;
		flex: 0 1 auto;
	}
}
@media only screen and (max-width: 481px) {

	.pagination .nav-short,
	.comments-pagination .nav-short {
		display: none;
	}
}

.comments-pagination {
	padding-top: calc(0.66 * var(--global--spacing-vertical));
	margin: calc(3 * var(--global--spacing-vertical)) auto;
}
@media only screen and (min-width: 822px) {

	.comments-pagination {
		margin: calc(3 * var(--global--spacing-vertical)) auto calc(4 * var(--global--spacing-vertical)) auto;
	}
}

.comments-pagination .nav-links > * {
	font-size: var(--global--font-size-md);
}

.widget-area {
	margin-top: calc(6 * var(--global--spacing-vertical));
	padding-bottom: calc(var(--global--spacing-vertical) / 3);
	color: var(--footer--color-text);
	font-size: var(--footer--font-size);
	font-family: var(--footer--font-family);
}
@media only screen and (min-width: 652px) {

	.widget-area {
		display: grid;
		grid-template-columns: repeat(2, 1fr);
		column-gap: calc(2 * var(--global--spacing-horizontal));
	}
}
@media only screen and (min-width: 1024px) {

	.widget-area {
		grid-template-columns: repeat(3, 1fr);
	}
}
@media only screen and (max-width: 481px) {

	.widget-area {
		margin-top: calc(3 * var(--global--spacing-vertical));
	}
}

.widget-area ul {
	list-style-type: none;
	padding: 0;
}

.widget-area ul li {
	line-height: var(--widget--line-height-list);
}

.widget-area ul.sub-menu,
.widget-area ul.children {
	margin-left: var(--widget--spacing-menu);
}

.widget-area ul .sub-menu-toggle {
	display: none;
}

.widget-area a {
	color: var(--footer--color-link);
	text-decoration: underline;
	text-decoration-style: solid;
	text-decoration-color: currentColor;
}

.widget-area a:link,
.widget-area a:visited,
.widget-area a:active {
	color: var(--footer--color-link);
}

.widget-area a:hover {
	color: var(--footer--color-link-hover);
	text-decoration-style: dotted;
}

.widget-area .wp-block-social-links.alignright {
	margin-top: var(--global--spacing-vertical);
	justify-content: flex-end;
}

.widget-area .wp-block-social-links.alignleft {
	margin-top: var(--global--spacing-vertical);
}

.widget-area:after {
	content: "";
	display: table;
	clear: both;
}

.widget-title {
	font-size: var(--global--font-size-sm);
	font-weight: var(--widget--font-weight-title);
	line-height: var(--widget--line-height-title);
}

.search-form {
	display: flex;
	flex-wrap: wrap;
	margin: auto;
	max-width: var(--responsive--aligndefault-width);
}

.search-form > label {
	width: 100%;
	margin-bottom: 0;
	font-weight: var(--form--label-weight);
}

.search-form .search-field {
	flex-grow: 1;
	max-width: inherit;
	margin-top: calc(var(--global--spacing-vertical) / 3);
	margin-right: calc(0.66 * var(--global--spacing-horizontal));
}

.search-form .search-submit {
	margin-top: calc(var(--global--spacing-vertical) / 3);
	margin-left: 10px;
}

.widget_search > .search-form .search-field {
	margin-right: calc(-1 * var(--button--border-width));
	-webkit-appearance: none;
	margin-bottom: calc(0.5 * var(--global--spacing-vertical));
}

.widget_search > .search-form .search-submit {
	margin-left: 0;
	margin-bottom: calc(0.5 * var(--global--spacing-vertical));
}

.widget_rss a.rsswidget .rss-widget-icon {
	display: none;
}

/* Category 07 is for any utility classes that are not assigned to a specific component. */
.screen-reader-text {
	border: 0;
	clip: rect(1px, 1px, 1px, 1px);
	-webkit-clip-path: inset(50%);
	clip-path: inset(50%);
	height: 1px;
	margin: -1px;
	overflow: hidden;
	padding: 0;
	position: absolute !important;
	width: 1px;
	word-wrap: normal !important;
	word-break: normal;
}

.skip-link:focus {
	background-color: #f1f1f1;
	border-radius: 3px;
	box-shadow: 0 0 2px 2px rgba(0, 0, 0, 0.6);
	clip: auto !important;
	-webkit-clip-path: none;
	clip-path: none;
	color: #21759b;
	display: block;
	font-size: 0.875rem;
	font-weight: 700;
	height: auto;
	left: 5px;
	line-height: normal;
	padding: 15px 23px 14px;
	text-decoration: none;
	top: 5px;
	width: auto;
	z-index: 100000;
}

/* Do not show the outline on the skip link target. */
#content[tabindex="-1"]:focus {
	outline: 0;
}

@media (prefers-reduced-motion) {

	* {
		transition-delay: 0s !important;
		transition-duration: 0s !important;
	}
}

.has-black-color[class] {
	color: var(--global--color-black);
}

.has-black-color[class] > [class*=__inner-container] {
	--local--color-primary: var(--global--color-black, #000);
	color: var(--local--color-primary);
}

.has-gray-color[class] {
	color: var(--global--color-gray);
}

.has-gray-color[class] > [class*=__inner-container] {
	--local--color-primary: var(--global--color-gray, #000);
	color: var(--local--color-primary);
}

.has-dark-gray-color[class] {
	color: var(--global--color-dark-gray);
}

.has-dark-gray-color[class] > [class*=__inner-container] {
	--local--color-primary: var(--global--color-dark-gray, #000);
	color: var(--local--color-primary);
}

.has-green-color[class] {
	color: var(--global--color-green);
}

.has-green-color[class] > [class*=__inner-container] {
	--local--color-primary: var(--global--color-green, #fff);
	color: var(--local--color-primary);
}

.has-blue-color[class] {
	color: var(--global--color-blue);
}

.has-blue-color[class] > [class*=__inner-container] {
	--local--color-primary: var(--global--color-blue, #fff);
	color: var(--local--color-primary);
}

.has-purple-color[class] {
	color: var(--global--color-purple);
}

.has-purple-color[class] > [class*=__inner-container] {
	--local--color-primary: var(--global--color-purple, #fff);
	color: var(--local--color-primary);
}

.has-red-color[class] {
	color: var(--global--color-red);
}

.has-red-color[class] > [class*=__inner-container] {
	--local--color-primary: var(--global--color-red, #fff);
	color: var(--local--color-primary);
}

.has-orange-color[class] {
	color: var(--global--color-orange);
}

.has-orange-color[class] > [class*=__inner-container] {
	--local--color-primary: var(--global--color-orange, #fff);
	color: var(--local--color-primary);
}

.has-yellow-color[class] {
	color: var(--global--color-yellow);
}

.has-yellow-color[class] > [class*=__inner-container] {
	--local--color-primary: var(--global--color-yellow, #fff);
	color: var(--local--color-primary);
}

.has-white-color[class] {
	color: var(--global--color-white);
}

.has-white-color[class] > [class*=__inner-container] {
	--local--color-primary: var(--global--color-white, #fff);
	color: var(--local--color-primary);
}

.has-background a,
.has-background p,
.has-background h1,
.has-background h2,
.has-background h3,
.has-background h4,
.has-background h5,
.has-background h6 {
	color: currentColor;
}

.has-black-background-color[class] {
	background-color: var(--global--color-black);
}

.has-black-background-color[class] > [class*=__inner-container] {
	--local--color-background: var(--global--color-black, #000);
	background-color: var(--local--color-background);
}

.has-dark-gray-background-color[class] {
	background-color: var(--global--color-dark-gray);
}

.has-dark-gray-background-color[class] > [class*=__inner-container] {
	--local--color-background: var(--global--color-dark-gray, #000);
	background-color: var(--local--color-background);
}

.has-gray-background-color[class] {
	background-color: var(--global--color-gray);
}

.has-gray-background-color[class] > [class*=__inner-container] {
	--local--color-background: var(--global--color-gray, #000);
	background-color: var(--local--color-background);
}

.has-light-gray-background-color[class] {
	background-color: var(--global--color-light-gray);
}

.has-light-gray-background-color[class] > [class*=__inner-container] {
	--local--color-background: var(--global--color-light-gray, #fff);
	background-color: var(--local--color-background);
}

.has-green-background-color[class] {
	background-color: var(--global--color-green);
}

.has-green-background-color[class] > [class*=__inner-container] {
	--local--color-background: var(--global--color-green, #fff);
	background-color: var(--local--color-background);
}

.has-blue-background-color[class] {
	background-color: var(--global--color-blue);
}

.has-blue-background-color[class] > [class*