--color-link);
}

.menu-button-container #primary-mobile-menu .dropdown-icon {
	display: flex;
	align-items: center;
}

.menu-button-container #primary-mobile-menu .dropdown-icon .svg-icon {
	margin-left: calc(0.25 * var(--global--spacing-unit));
}

.menu-button-container #primary-mobile-menu .dropdown-icon.open .svg-icon {
	position: relative;
	top: -1px;
}

.menu-button-container #primary-mobile-menu .dropdown-icon.close {
	display: none;
}

.menu-button-container #primary-mobile-menu[aria-expanded*=true] .dropdown-icon.open {
	display: none;
}

.menu-button-container #primary-mobile-menu[aria-expanded*=true] .dropdown-icon.close {
	display: flex;
}

.has-logo.has-title-and-tagline .menu-button-container #primary-mobile-menu[aria-expanded*=true] .dropdown-icon.close {
	animation-name: twentytwentyone-close-button-transition;
	animation-duration: 0.3s;
}

.primary-navigation-open .menu-button-container {
	width: 100%;
	z-index: 500;
	background-color: var(--global--color-background);
}

.primary-navigation-open .menu-button-container #primary-mobile-menu {
	position: static;
}

.primary-navigation {
	position: absolute;
	top: var(--global--admin-bar--height);
	right: 0;
	color: var(--primary-nav--color-text);
	font-size: var(--primary-nav--font-size);
	line-height: 1.15;
	margin-top: 0;
	margin-bottom: 0;
}

.primary-navigation > .primary-menu-container {
	position: fixed;
	visibility: hidden;
	opacity: 0;
	top: 0;
	right: 0;
	bottom: 0;
	left: 0;
	padding-top: calc(var(--button--line-height) * var(--primary-nav--font-size-button) + 42px + 5px);
	padding-left: var(--global--spacing-unit);
	padding-right: var(--global--spacing-unit);
	padding-bottom: var(--global--spacing-horizontal);
	background-color: var(--global--color-background);
	transition: all 0.15s ease-in-out;
	transform: translateY(var(--global--spacing-vertical));
}
@media only screen and (max-width: 481px) {

	.primary-navigation > .primary-menu-container {
		height: 100vh;
		z-index: 499;
		overflow-x: hidden;
		overflow-y: auto;
		border: 2px solid transparent;
	}

	.has-logo.has-title-and-tagline .primary-navigation > .primary-menu-container {
		position: fixed;
		transform: translateY(0) translateX(100%);
	}

	.admin-bar .has-logo.has-title-and-tagline .primary-navigation > .primary-menu-container {
		top: var(--global--admin-bar--height);
	}

	.admin-bar .primary-navigation > .primary-menu-container {
		height: calc(100vh - var(--global--admin-bar--height));
	}

	.primary-navigation > .primary-menu-container:focus {
		border: 2px solid var(--global--color-primary);
	}
}
@media only screen and (max-width: 481px) {

	.primary-navigation-open .primary-navigation {
		width: 100%;
		position: fixed;
		z-index: 2;
	}
}

.primary-navigation-open .primary-navigation > .primary-menu-container {
	position: absolute;
	visibility: visible;
	opacity: 1;
	transform: translateY(0);
}
@media only screen and (max-width: 481px) {

	.primary-navigation-open .has-logo.has-title-and-tagline .primary-navigation > .primary-menu-container {
		transform: translateX(0) translateY(0);
	}
}
@media only screen and (min-width: 482px) {

	.primary-navigation {
		position: relative;
		margin-left: auto;
	}

	.primary-navigation > .primary-menu-container {
		visibility: visible;
		opacity: 1;
		position: relative;
		padding: 0;
		background-color: transparent;
		overflow: initial;
		transform: none;
	}

	.primary-navigation #toggle-menu {
		display: none;
	}

	.primary-navigation > .primary-menu-container ul > li .sub-menu-toggle[aria-expanded=false] ~ ul {
		display: none;
	}

	.admin-bar .primary-navigation {
		top: initial;
	}

	.admin-bar .primary-navigation > .primary-menu-container {
		top: initial;
	}
}

.primary-navigation > div > .menu-wrapper {
	display: flex;
	justify-content: flex-start;
	flex-wrap: wrap;
	list-style: none;
	margin: 0;
	max-width: none;
	padding-left: 0;
	position: relative;
}
@media only screen and (max-width: 481px) {

	.primary-navigation > div > .menu-wrapper {
		padding-bottom: 100px;
	}

	.primary-navigation > div > .menu-wrapper ul {
		padding-left: 0;
	}
}

.primary-navigation > div > .menu-wrapper li {
	display: block;
	position: relative;
	width: 100%;
}
@media only screen and (min-width: 482px) {

	.primary-navigation > div > .menu-wrapper li {
		margin: 0;
		width: inherit;
	}

	.primary-navigation > div > .menu-wrapper li:last-child {
		margin-right: 0;
	}
}

.primary-navigation > div > .menu-wrapper .sub-menu-toggle {
	display: flex;
	height: calc(2 * var(--primary-nav--padding) + 1.15em + 1px);
	width: 44px;
	padding: 0;
	justify-content: center;
	align-items: center;
	background: transparent;
	color: currentColor;
	border: none;
}

.primary-navigation > div > .menu-wrapper .sub-menu-toggle:focus {
	outline: 2px solid var(--wp--style--color--link, var(--global--color-primary));
}
@media only screen and (max-width: 481px) {

	.primary-navigation > div > .menu-wrapper .sub-menu-toggle {
		display: none;
	}
}

.primary-navigation > div > .menu-wrapper .sub-menu-toggle .icon-plus,
.primary-navigation > div > .menu-wrapper .sub-menu-toggle .icon-minus {
	height: 100%;
	display: flex;
	align-items: center;
}

.primary-navigation > div > .menu-wrapper .sub-menu-toggle .icon-plus svg,
.primary-navigation > div > .menu-wrapper .sub-menu-toggle .icon-minus svg {
	margin-top: -1px;
}

.primary-navigation > div > .menu-wrapper .sub-menu-toggle .icon-minus {
	display: none;
}

.primary-navigation > div > .menu-wrapper .sub-menu-toggle[aria-expanded=true] .icon-minus {
	display: flex;
}

.primary-navigation > div > .menu-wrapper .sub-menu-toggle[aria-expanded=true] .icon-plus {
	display: none;
}

.primary-navigation > div > .menu-wrapper > li > .sub-menu {
	position: relative;
}
@media only screen and (min-width: 482px) {

	.primary-navigation > div > .menu-wrapper > li > .sub-menu {
		left: 0;
		margin: 0;
		min-width: max-content;
		position: absolute;
		top: 100%;
		padding-top: 3px;
		transition: all 0.5s ease;
		z-index: 88888;
	}

	.primary-navigation > div > .menu-wrapper > li > .sub-menu:before,
	.primary-navigation > div > .menu-wrapper > li > .sub-menu:after {
		content: "";
		display: block;
		position: absolute;
		width: 0;
		top: -10px;
		left: var(--global--spacing-horizontal);
		border-style: solid;
		border-color: var(--primary-nav--border-color) transparent;
		border-width: 0 7px 10px 7px;
	}

	.primary-navigation > div > .menu-wrapper > li > .sub-menu:after {
		top: -9px;
		border-color: var(--global--color-background) transparent;
	}

	.primary-navigation > div > .menu-wrapper > li > .sub-menu li {
		background: var(--global--color-background);
	}

	.primary-navigation > div > .menu-wrapper > li > .sub-menu.submenu-reposition-left {

		/* rtl:ignore */
		left: 0;

		/* rtl:ignore */
		right: auto;
	}

	.primary-navigation > div > .menu-wrapper > li > .sub-menu.submenu-reposition-left:before,
	.primary-navigation > div > .menu-wrapper > li > .sub-menu.submenu-reposition-left:after {

		/* rtl:ignore */
		left: var(--global--spacing-horizontal);

		/* rtl:ignore */
		right: auto;
	}

	.primary-navigation > div > .menu-wrapper > li > .sub-menu.submenu-reposition-right {

		/* rtl:ignore */
		right: 0;

		/* rtl:ignore */
		left: auto;
	}

	.primary-navigation > div > .menu-wrapper > li > .sub-menu.submenu-reposition-right:before,
	.primary-navigation > div > .menu-wrapper > li > .sub-menu.submenu-reposition-right:after {

		/* rtl:ignore */
		left: auto;

		/* rtl:ignore */
		right: var(--global--spacing-horizontal);
	}
}

.primary-navigation .primary-menu > .menu-item:hover > a {
	color: var(--primary-nav--color-link-hover);
}
@media only screen and (min-width: 482px) {

	.primary-navigation .primary-menu-container {
		margin-right: calc(0px - var(--primary-nav--padding));
		margin-left: calc(0px - var(--primary-nav--padding));
	}

	.primary-navigation .primary-menu-container > ul > .menu-item {
		display: flex;
	}

	.primary-navigation .primary-menu-container > ul > .menu-item > a {
		padding-left: var(--primary-nav--padding);
		padding-right: var(--primary-nav--padding);
	}

	.primary-navigation .primary-menu-container > ul > .menu-item > a + .sub-menu-toggle {
		margin-left: calc(5px - var(--primary-nav--padding));
	}
}

.primary-navigation a {
	display: block;
	font-family: var(--primary-nav--font-family-mobile);
	font-size: var(--primary-nav--font-size-mobile);
	font-weight: var(--primary-nav--font-weight);
	padding: var(--primary-nav--padding) 0;
	text-decoration: none;
}
@media only screen and (min-width: 482px) {

	.primary-navigation a {
		display: block;
		font-family: var(--primary-nav--font-family);
		font-size: var(--primary-nav--font-size);
		font-weight: var(--prima