t .children {
	list-style: none;
	padding-left: 0;
}

.comment-list .children > li {
	margin-top: var(--global--spacing-vertical);
	margin-bottom: var(--global--spacing-vertical);
}

@media only screen and (min-width: 482px) {

	.comment-list .depth-2,
	.comment-list .depth-3 {
		padding-left: calc(4 * var(--global--spacing-horizontal));
	}
}

/**
 * Comment Meta
 */
.comment-meta .comment-author {
	line-height: var(--global--line-height-heading);
	margin-bottom: calc(0.25 * var(--global--spacing-unit));
}
@media only screen and (min-width: 482px) {

	.comment-meta .comment-author {
		margin-bottom: 0;
		padding-right: 0;
	}
}

.comment-meta .comment-author .fn {
	font-family: var(--global--font-secondary);
	font-weight: normal;
	font-size: var(--global--font-size-lg);
	hyphens: auto;
	word-wrap: break-word;
	word-break: break-word;
}

.comment-meta .comment-metadata {
	color: var(--global--color-primary);
	font-size: var(--global--font-size-xs);
	padding: 8px 0 9px 0;
}

.comment-meta .comment-metadata .edit-link {
	margin-left: var(--global--spacing-horizontal);
}
@media only screen and (min-width: 482px) {

	.comment-meta {
		margin-right: inherit;
	}

	.comment-meta .comment-author {
		max-width: inherit;
	}
}

.reply {
	font-size: var(--global--font-size-sm);
	line-height: var(--global--line-height-heading);
}

.bypostauthor {
	display: block;
}

.says {
	display: none;
}

.pingback .url,
.trackback .url {
	font-family: var(--global--font-primary);
}

.comment-body {
	position: relative;
	margin-bottom: calc(1.7 * var(--global--spacing-vertical));
}

.comment-body > * {
	margin-top: var(--global--spacing-vertical);
	margin-bottom: var(--global--spacing-vertical);
}

.comment-body .reply {
	margin: 0;
}

.comment-content {
	word-wrap: break-word;
}

.pingback .comment-body,
.trackback .comment-body {
	margin-top: var(--global--spacing-vertical);
	margin-bottom: var(--global--spacing-vertical);
}

.comment-respond {
	margin-top: var(--global--spacing-vertical);
}

.comment-respond > * {
	margin-top: var(--global--spacing-unit);
	margin-bottom: var(--global--spacing-unit);
}

.comment-respond > *:first-child {
	margin-top: 0;
}

.comment-respond > *:last-child {
	margin-bottom: 0;
}

.comment-respond > *:last-child.comment-form {
	margin-bottom: var(--global--spacing-vertical);
}

.comment-author {
	padding-top: 3px;
}

.comment-author .url {
	color: currentColor;
}

.comment-form {
	display: flex;
	flex-wrap: wrap;
}

.comment-form > * {
	flex-basis: 100%;
}

.comment-form .comment-notes {
	font-size: var(--global--font-size-sm);
}

.comment-form .comment-form-url,
.comment-form .comment-form-comment {
	width: 100%;
}

.comment-form .comment-form-author,
.comment-form .comment-form-email {
	flex-basis: 0;
	flex-grow: 1;
}
@media only screen and (max-width: 481px) {

	.comment-form .comment-form-author,
	.comment-form .comment-form-email {
		flex-basis: 100%;
	}
}

.comment-form .comment-form-cookies-consent > label,
.comment-form .comment-notes {
	font-size: var(--global--font-size-xs);
	font-weight: normal;
}

.comment-form > p {
	margin-bottom: var(--global--spacing-unit);
}

.comment-form > p:first-of-type {
	margin-top: 0;
}

.comment-form > p:last-of-type {
	margin-bottom: 0;
}

.comment-form > p label,
.comment-form > p input[type=email],
.comment-form > p input[type=text],
.comment-form > p input[type=url],
.comment-form > p textarea {
	display: block;
	font-size: var(--global--font-size-sm);
	margin-bottom: calc(.5 * var(--global--spacing-unit));
	width: 100%;
	font-weight: var(--form--label-weight);
}

.comment-form 