search button.wp-block-search__button.has-icon svg {
	width: 40px;
	height: 40px;
	fill: currentColor;
}

.has-background .wp-block-search button.wp-block-search__button:hover,
.has-background .wp-block-search button.wp-block-search__button:active {
	background-color: var(--local--color-background, var(--global--color-background)) !important;
	color: var(--local--color-primary, var(--global--color-primary)) !important;
}

.has-text-color .wp-block-search button.wp-block-search__button:hover,
.has-text-color .wp-block-search button.wp-block-search__button:active {
	color: var(--local--color-primary, var(--global--color-primary)) !important;
}

.wp-block-search.wp-block-search__button-inside .wp-block-search__inside-wrapper {
	background-color: var(--global--color-white);
	border: var(--form--border-width) solid var(--form--border-color);
	border-radius: var(--form--border-radius);
	padding: var(--form--border-width);
}

.has-background .wp-block-search.wp-block-search__button-inside .wp-block-search__inside-wrapper {
	border-color: var(--local--color-primary, var(--global--color-primary)) !important;
}

.wp-block-search.wp-block-search__button-inside .wp-block-search__inside-wrapper .wp-block-search__input {
	margin-left: 0;
	margin-right: 0;
	padding-left: var(--form--spacing-unit);
}

.wp-block-search.wp-block-search__button-inside .wp-block-search__inside-wrapper .wp-block-search__input:focus {
	color: var(--form--color-text);
	outline-offset: -2px;
	outline: 2px dotted var(--form--border-color);
}

.wp-block-search.wp-block-search__button-inside .wp-block-search__inside-wrapper button.wp-block-search__button {
	padding: var(--button--padding-vertical) var(--button--padding-horizontal);
}

.wp-block-search.wp-block-search__button-inside .wp-block-search__inside-wrapper button.wp-block-search__button:hover {
	color: var(--global--color-dark-gray);
}

.is-dark-theme .wp-block-search.wp-block-search__button-inside .wp-block-search__inside-wrapper button.wp-block-search__button {
	color: var(--global--color-dark-gray);
}

.is-dark-theme .wp-block-search.wp-block-search__button-inside .wp-block-search__inside-wrapper button.wp-block-search__button:hover {
	background-color: var(--global--color-dark-gray);
	color: var(--global--color-white);
}

.wp-block-search.wp-block-search__button-inside .wp-block-search__inside-wrapper button.wp-block-search__button.has-icon {
	padding: 6px calc(0.5 * var(--button--padding-horizontal));
}

.wp-block-search__button {
	box-shadow: none;
}

hr {
	border-style: none;
	border-bottom: var(--separator--height) solid var(--separator--border-color);
	clear: both;
	margin-left: auto;
	margin-right: auto;
}

hr.wp-block-separator {
	border-bottom: var(--separator--height) solid var(--separator--border-color);
	opacity: 1;

	/**
   * Block Options
   */
}

hr.wp-block-separator:not(.is-style-dots):not(.alignwide) {
	max-width: var(--responsive--aligndefault-width);
}

hr.wp-block-separator:not(.is-style-dots).alignwide {
	max-width: var(--responsive--alignwide-width);
}

hr.wp-block-separator:not(.is-style-dots).alignfull {
	max-width: var(--responsive--alignfull-width);
}

hr.wp-block-separator.is-style-twentytwentyone-separator-thick {
	border-bottom-width: calc(3 * var(--separator--height));
}

hr.wp-block-separator.is-style-dots.has-background,
hr.wp-block-separator.is-style-dots.has-text-color {
	background-color: transparent !important;
}

hr.wp-block-separator.is-style-dots.has-background:before,
hr.wp-block-separator.is-style-dots.has-text-color:before {
	color: currentColor !important;
}

hr.wp-block-separator.is-style-dots:before {
	color: var(--separator--border-color);
	font-size: var(--global--font-size-xl);
	letter-spacing: var(--global--font-size-sm);
	padding-left: var(--global--font-size-sm);
}

.has-background hr.wp-block-separator,
[class*=background-color] hr.wp-block-separator,
[style*=background-color] hr.wp-block-separator,
.wp-block-cover[style*=background-image] hr.wp-block-separator {
	border-color: currentColor;
}

.wp-block-social-links a:focus {
	color: var(--global--color-primary);
}

.wp-block-social-links.is-style-twentytwentyone-social-icons-color a {
	color: var(--global--color-primary);
}

.wp-block-social-links.is-style-twentytwentyone-social-icons-color .wp-social-link,
.wp-block-social-links.is-style-twentytwentyone-social-icons-color.has-icon-background-color.has-icon-background-color .wp-social-link {
	background: none;
}

.wp-block-spacer {
	display: block;
	margin-bottom: 0 !important;
	margin-top: 0 !important;
}
@media only screen and (max-width: 481px) {

	.wp-block-spacer[style] {
		height: var(--global--spacing-unit) !important;
	}
}

table,
.wp-block-table {
	width: 100%;
	min-width: 240px;
	border-collapse: collapse;
}

table thead,
table tfoot,
.wp-block-table thead,
.wp-block-table tfoot {
	text-align: center;
}

table th,
.wp-block-table th {
	font-family: var(--heading--font-family);
}

table td,
table th,
.wp-block-table td,
.wp-block-table th {
	padding: calc(0.5 * var(--global--spacing-unit));
	border: 1px solid;
}

table figcaption,
.wp-block-table figcaption {
	color: var(--global--color-primary);
	font-size: var(--global--font-size-xs);
}

table.is-style-regular .has-background,
table.is-style-stripes .has-background,
table.is-style-stripes .has-background thead tr,
table.is-style-stripes .has-background tfoot tr,
table.is-style-stripes .has-background tbody tr,
.wp-block-table.is-style-regular .has-background,
.wp-block-table.is-style-stripes .has-background,
.wp-block-table.is-style-stripes .has-background thead tr,
.wp-block-table.is-style-stripes .has-background tfoot tr,
.wp-block-table.is-style-stripes .has-background tbody tr {
	color: var(--table--has-background-text-color);
}

table.is-style-stripes,
.wp-block-table.is-style-stripes {
	border-color: var(--table--stripes-border-color);
}

table.is-style-stripes th,
table.is-style-stripes td,
.wp-block-table.is-style-stripes th,
.wp-block-table.is-style-stripes td {
	border-width: 0;
}

table.is-style-stripes tbody tr:nth-child(odd),
.wp-block-table.is-style-stripes tbody tr:nth-child(odd) {
	background-color: var(--table--stripes-background-color);
}

table.is-style-stripes .has-background tbody tr:nth-child(odd),
.wp-block-table.is-style-stripes .has-background tbody tr:nth-child(odd) {
	background-color: var(--global--color-white-90);
}

table.wp-calendar-table td,
table.wp-calendar-table th {
	background: transparent;
	border: 0;
	text-align: center;
	line-height: 2;
	vertical-align: middle;
	word-break: normal;
}

table.wp-calendar-table th {
	font-weight: bold;
}

table.wp-calendar-table thead,
table.wp-calendar-table tbody {
	color: currentColor;
	border: 1px solid;
}

table.wp-calendar-table caption {
	font-weight: bold;
	text-align: left;
	margin-bottom: var(--global--spacing-unit);
	color: currentColor;
}

.wp-calendar-nav {
	text-align: left;
	margin-top: calc(var(--global--spacing-unit) / 2);
}

.wp-calendar-nav svg {
	height: 1em;
	vertical-align: middle;
}

.wp-calendar-nav svg path {
	fill: currentColor;
}

.wp-calendar-nav .wp-calendar-nav-next {
	float: right;
}

.wp-block-tag-cloud.alignfull {
	padding-left: var(--global--spacing-unit);
	padding-right: var(--global--spacing-unit);
}

.wp-block-verse {
	font-family: var(--entry-content--font-family);
}

.wp-block-video figcaption {
	color: var(--global--color-primary);
	font-size: var(--global--font-size-xs);
	margin-top: calc(0.5 * var(--global--spacing-unit));
	margin-bottom: var(--global--spacing-unit);
	text-align: center;
}

* > figure > video {
	max-width: unset;
	width: 100%;
	vertical-align: middle;
}

:root .is-extra-small-text,
:root .has-extra-small-font-size {
	font-size: var(--global--font-size-xs);
}

:root .is-small-text,
:root .has-small-font-size {
	font-size: var(--global--font-size-sm);
}

:root .is-regular-text,
:root .has-regular-font-size,
:root .is-normal-font-size,
:root .has-normal-font-size,
:root .has-medium-font-size {
	font-size: var(--global--font-size-base);
}

:root .is-large-text,
:root .has-large-font-size {
	font-size: var(--global--font-size-lg);
	line-height: var(--global--line-height-heading);
}

:root .is-larger-text,
:root .has-larger-font-size,
:root .is-extra-large-text,
:root .has-extra-large-font-size {
	font-size: var(--global--font-size-xl);
	line-height: var(--global--line-height-heading);
}

:root .is-huge-text,
:root .has-huge-font-size {
	font-size: var(--global--font-size-xxl);
	line-height: var(--global--line-height-heading);
	font-weight: var(--heading--font-weight-page-title);
}

:root .is-gigantic-text,
:root .has-gigantic-font-size {
	font-size: var(--global--font-size-xxxl);
	line-height: var(--global--line-height-heading);
	font-weight: var(--heading--font-weight-page-title);
}

/* Block Alignments */

/**
 * These selectors set the default max width for content appearing inside a post or page.
 */

/**
 * .alignleft
 */
.alignleft {

	/*rtl:ignore*/
	text-align: left;
	margin-top: 0;
}

.entry-content > .alignleft {
	max-width: var(--responsive--aligndefault-width);
}

@media only screen and (min-width: 482px) {

	.alignleft {

		/*rtl:ignore*/
		float: left;

		/*rtl:ignore*/
		margin-right: var(--global--spacing-horizontal);
		margin-bottom: var(--global--spacing-vertical);
	}

	.entry-content > .alignleft {
		max-width: calc(50% - var(--responsive--alignleft-margin));
	}
}

/**
 * .aligncenter
 */
.aligncenter {
	clear: both;
	display: block;
	float: none;
	margin-right: auto;
	margin-left: auto;
	text-align: center;
}

/**
 * .alignright
 */
.alignright {
	margin-top: 0;
	margin-bottom: var(--global--spacing-vertical);
}

.entry-content > .alignright {
	max-width: var(--responsive--aligndefault-width);
}

@media only screen and (min-width: 482px) {

	.alignright {

		/*rtl:ignore*/
		float: right;

		/*rtl:ignore*/
		margin-left: var(--global--spacing-horizontal);
	}

	.entry-content > .alignright {
		max-width: calc(50% - var(--responsive--alignright-margin));
	}
}

[class*=inner-container] > .alignleft + *,
[class*=inner-container] > .alignright + * {
	margin-top: 0;
}

/**
 * .alignwide
 */
.alignwide {
	clear: both;
}

/**
 * .alignfull
 */
.alignfull {
	clear: both;
}

.has-left-content {
	justify-content: flex-start;
}

.has-right-content {
	justify-content: flex-end;
}

.has-parallax {
	background-attachment: fixed;
}

.has-drop-cap:not(:focus)::first-letter {
	font-family: var(--heading--font-family);
	font-weight: var(--heading--font-weight);
	line-height: 0.66;
	text-transform: uppercase;
	font-style: normal;
	float: left;
	margin: 0.1em 0.1em 0 0;
	font-size: calc(1.2 * var(--heading--font-size-h1));
}

.has-drop-cap:not(:focus)::after {
	content: "";
	display: table;
	clear: both;
	padding-top: 14px;
}

.desktop-only {
	display: none;
}
@media only screen and (min-width: 482px) {

	.desktop-only {
		display: block;
	}
}

/* Category 06 contains all "bigger" components which contain elements of the previous two categories like header, footer, page template, single template, comments section, archives, ... */
.site-header {
	display: flex;
	align-items: flex-start;
	flex-wrap: wrap;
	row-gap: var(--global--spacing-vertical);
}

.wp-custom-logo .site-header {
	align-items: center;
}
@media only screen and (min-width: 482px) {

	.site-header {
		padding-top: calc(var(--global--spacing-vertical) / 0.75);
	}
}
@media only screen and (min-width: 822px) {

	.site-header {
		padding-top: calc(2.4 * var(--global--spacing-vertical));
	}
}

.site-branding {
	color: var(--branding--color-text);
	margin-right: 140px;
}

.site-branding:last-child {
	margin-right: 0;
	width: 100%;
	text-align: center;
}
@media only screen and (min-width: 482px) {

	.site-branding {
		margin-right: initial;
		margin-top: 4px;
	}
}

.site-title {
	color: var(--branding--color-link);
	font-family: var(--branding--title--font-family);
	font-size: var(--branding--title--font-size-mobile);
	letter-spacing: normal;
	text-transform: var(--branding--title--text-transform);
	line-height: var(--global--line-height-heading);
	margin-bottom: calc(var(--global--spacing-vertical) / 6);
}

.site-title a {
	color: currentColor;
	font-weight: var(--branding--title--font-weight);
}

.site-title a:link,
.site-title a:visited,
.site-title a:active {
	color: currentColor;
}

.site-title a:hover,
.site-title a:focus {
	color: var(--branding--color-link-hover);
}
@media only screen and (min-width: 482px) {

	.site-title {
		font-size: var(--branding--title--font-size);
	}
}

.site-description {
	color: currentColor;
	font-family: var(--branding--description--font-family);
	font-size: var(--branding--description--font-size);
	line-height: 1.4;
}

.site-title > a {
	text-decoration-color: var(--global--color-secondary);
}

.site-logo {
	margin: calc(var(--global--spacing-vertical) / 2) 0;
}

.site-header > .site-logo {
	width: 100%;
	padding-bottom: calc(var(--global--spacing-vertical) * 1.5);
	border-bottom: 1px solid;
	text-align: center;
}

.site-logo .custom-logo {
	margin-left: auto;
	margin-right: auto;
	max-width: var(--branding--logo--max-width-mobile);
	max-height: var(--branding--logo--max-height-mobile);
	height: auto;
	display: inline-block;
	width: auto;
}
@media only screen and (min-width: 482px) {

	.site-logo .custom-logo {
		max-width: var(--branding--logo--max-width);
		max-height: var(--branding--logo--max-height);
		height: auto;
		width: auto;
	}
}

@media only screen and (max-width: 481px) {

	.site-header.has-logo:not(.has-title-and-tagline).has-menu .site-logo {
		position: absolute;
		padding-top: calc(0.5 * var(--global--spacing-vertical));
		margin-top: 0;
		top: var(--global--admin-bar--height);
	}

	.primary-navigation-open .site-header.has-logo:not(.has-title-and-tagline).has-menu .site-logo {
		display: none;
	}

	.site-header.has-logo:not(.has-title-and-tagline).has-menu .site-logo img {
		max-height: calc(var(--button--padding-vertical) - (0.25 * var(--global--spacing-unit)) + 1.7em);
	}

	.site-header.has-logo.has-title-and-tagline {
		align-items: flex-start;
	}

	.site-header.has-logo.has-title-and-tagline.has-menu {
		justify-content: space-between;
	}

	.site-header.has-logo.has-title-and-tagline.has-menu .site-branding {
		max-width: calc(100% - 160px);
	}

	.site-header.has-logo.has-title-and-tagline .site-branding {
		margin-right: 0;
	}

	body:not(.primary-navigation-open) .site-header.has-logo.has-title-and-tagline:after {
		display: none;
	}

	body:not(.primary-navigation-open) .site-header.has-logo.has-title-and-tagline .primary-navigation {
		position: relative;
		top: 0;
	}

	body:not(.primary-navigation-open) .site-header.has-logo.has-title-and-tagline .menu-button-container {
		position: relative;
		padding-top: 0;
		margin-top: calc(0px - var(--button--padding-vertical) + (0.25 * var(--global--spacing-unit)));
	}

	body:not(.primary-navigation-open) .site-header.has-logo.has-title-and-tagline .menu-button-container #primary-mobile-menu {
		padding-left: calc(var(--global--spacing-horizontal) * 0.6 - 4.5px);
		padding-right: calc(var(--global--spacing-horizontal) * 0.6 - 4.5px);
		margin-right: calc(0px - var(--global--spacing-horizontal) * 0.6);
	}

	.site-header:not(.has-logo).has-title-and-tagline .site-branding {
		margin-right: 0;
		max-width: calc(100% - 160px);
	}

	.site-header:not(.has-menu) {
		justify-content: center;
	}
}

.site-footer {
	padding-top: 0;
	padding-bottom: calc(1.7 * var(--global--spacing-vertical));
}

.no-widgets .site-footer {
	margin-top: calc(6 * var(--global--spacing-vertical));
}
@media only screen and (max-width: 481px) {

	.no-widgets .site-footer {
		margin-top: calc(3 * var(--global--spacing-vertical));
	}
}

.site-footer > .site-info {
	padding-top: var(--global--spacing-vertical);
	color: var(--footer--color-text);
	font-family: var(--footer--font-family);
	font-size: var(--footer--font-size);
	line-height: var(--global--line-height-body);
	border-top: 3px solid var(--global--color-border);
}

.site-footer > .site-info .site-name {
	text-transform: var(--branding--title--text-transform);
	font-size: var(--branding--title--font-size);
}

.site-footer > .site-info .powered-by {
	margin-top: calc(0.5 * var(--global--spacing-vertical));
}
@media only screen and (min-width: 822px) {

	.site-footer > .site-info {
		display: flex;
		align-items: center;
	}

	.site-footer > .site-info .powered-by {
		margin-top: initial;
		margin-left: auto;
	}
}

.site-footer > .site-info a {
	color: var(--footer--color-link);
}

.site-footer > .site-info a:link,
.site-footer > .site-info a:visited,
.site-footer > .site-info a:active {
	color: var(--footer--color-link);
}

.site-footer > .site-info a:hover {
	color: var(--footer--color-link-hover);
}

.site-footer > .site-info a:focus {
	color: var(--footer--color-link-hover);
}

.is-dark-theme .site-footer > .site-info a:focus {
	color: var(--wp--style--color--link, var(--global--color-background));
}

.has-background-white .site-footer > .site-info a:focus {
	color: var(--wp--style--color--link, var(--global--color-white));
}

.singular .entry-header {
	border-bottom: 3px solid var(--global--color-border);
	padding-bottom: calc(2 * var(--global--spacing-vertical));
	margin-bottom: calc(3 * var(--global--spacing-vertical));
}

.home .entry-header {
	border-bottom: none;
	padding-bottom: 0;
	margin-bottom: 0;
}

.singular .has-post-thumbnail .entry-header {
	border-bottom: none;
	padding-bottom: calc(1.3 * var(--global--spacing-vertical));
	margin-bottom: 0;
}

.no-results.not-found > *:first-child {
	margin-bottom: calc(3 * var(--global--spacing-vertical));
}

.page-links {
	clear: both;
}

.page-links .post-page-numbers {
	display: inline-block;
	margin-left: calc(0.66 * var(--global--spacing-unit));
	margin-right: calc(0.66 * var(--global--spacing-unit));
	min-width: 44px;
	min-height: 44px;
}

.page-links .post-page-numbers:first-child {
	margin-left: 0;
}

.entry-title {
	color: var(--entry-header--color);
	font-size: var(--entry-header--font-size);
	letter-spacing: var(--heading--letter-spacing-h2);
	line-height: var(--heading--line-height-h2);
	overflow-wrap: break-word;
}

.entry-title a {
	color: var(--entry-header--color-link);
	text-underline-offset: 0.15em;
}

.entry-title a:hover {
	color: var(--entry-header--color-hover);
}

.entry-title a:focus {
	color: var(--entry-header--color-focus);
}

.entry-title a:active {
	color: var(--entry-header--color-link);
}

.singular .entry-title {
	font-size: var(--global--font-size-page-title);
}

h1.entry-title {
	line-height: var(--heading--line-height-h1);
	font-weight: var(--heading--font-weight-page-title);
}

/**
 * Entry Content
 */
.entry-content,
.entry-summary {
	font-family: var(--entry-content--font-family);
}

.entry-content p {
	word-wrap: break-word;
}

.entry-content > iframe[style] {
	margin: var(--global--spacing-vertical) 0 !important;
	max-width: 100% !important;
}

.entry-footer {
	color: var(--global--color-primary);
	clear: both;
	float: none;
	font-size: var(--global--font-size-xs);
	display: block;
}

.entry-footer > span {
	display: inline-block;
}

.entry-footer a {
	color: currentColor;
}

.entry-footer a:hover,
.entry-footer a:focus {
	color: var(--global--color-primary-hover);
}

.entry-footer a:active {
	color: currentColor;
}

.site-main > article > .entry-footer {
	margin-top: var(--global--spacing-vertical);
	padding-top: var(--global--spacing-unit);
	padding-bottom: calc(3 * var(--global--spacing-vertical));
	border-bottom: var(--separator--height) solid var(--separator--border-color);
}

body:not(.single) .site-main > article:last-of-type .entry-footer {
	border-bottom: var(--separator--height) solid transparent;
}

.single .site-main > article > .entry-footer {
	margin-t