Group................Specific styles for the group block.
 * Heading..............Specific styles for the heading block.
 * Image................Specific styles for the image block.
 * Latest comments......Specific styles for the latest comments block.
 * Latest posts.........Specific styles for the latest posts block.
 * Legacy...............Specific styles for the legacy gallery.
 * List.................Specific styles for the list block.
 * Media text...........Specific styles for the media and text block.
 * Navigation...........Specific styles for the navigation block.
 * Paragraph............Specific styles for the paragraph block.
 * Pullquote............Specific styles for the pullquote block.
 * Quote................Specific styles for the quote block.
 * Search...............Specific styles for the search block.
 * Separator............Specific styles for the separator block.
 * Spacer...............Specific styles for the spacer block.
 * Table................Specific styles for the table block.
 * Verse................Specific styles for the verse block.
 * Video................Specific styles for the video block.
 * Utilities............Block alignments.
 *
 * COMPONENTS
 * Header...............Header styles.
 * Footer...............Footer styles.
 * Comments.............Comment styles.
 * Archives.............Archive styles.
 * 404..................404 styles.
 * Search...............Search styles.
 * Navigation...........Navigation styles.
 * Footer Navigation....Footer Navigation styles.
 * Pagination...........Pagination styles.
 * Single...............Single page and post styles.
 * Posts and pages......Misc, sticky post styles.
 * Entry................Entry, author biography.
 * Widget...............Widget styles.
 * Editor...............Editor styles.
 *
 * UTILITIES
 * A11y.................Screen reader text, prefers reduced motion etc.
 * Color Palette........Classes for the color palette colors.
 * Editor Font Sizes....Editor Font Sizes.
 * Measure..............The width of a line of text, in characters.
 */

/* Categories 01 to 03 are the basics. */

/* Variables */
:root {

	/* Font Family */
	--global--font-primary: var(--font-headings, -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif);
	--global--font-secondary: var(--font-base, -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif);

	/* Font Size */
	--global--font-size-base: 1.25rem;
	--global--font-size-xs: 1rem;
	--global--font-size-sm: 1.125rem;
	--global--font-size-md: 1.25rem;
	--global--font-size-lg: 1.5rem;
	--global--font-size-xl: 2.25rem;
	--global--font-size-xxl: 4rem;
	--global--font-size-xxxl: 5rem;
	--global--font-size-page-title: var(--global--font-size-xxl);
	--global--letter-spacing: normal;

	/* Line Height */
	--global--line-height-body: 1.7;
	--global--line-height-heading: 1.3;
	--global--line-height-page-title: 1.1;

	/* Headings */
	--heading--font-family: var(--global--font-primary);
	--heading--font-size-h6: var(--global--font-size-xs);
	--heading--font-size-h5: var(--global--font-size-sm);
	--heading--font-size-h4: var(--global--font-size-lg);
	--heading--font-size-h3: calc(1.25 * var(--global--font-size-lg));
	--heading--font-size-h2: var(--global--font-size-xl);
	--heading--font-size-h1: var(--global--font-size-page-title);
	--heading--letter-spacing-h6: 0.05em;
	--heading--letter-spacing-h5: 0.05em;
	--heading--letter-spacing-h4: var(--global--letter-spacing);
	--heading--letter-spacing-h3: var(--global--letter-spacing);
	--heading--letter-spacing-h2: var(--global--letter-spacing);
	--heading--letter-spacing-h1: var(--global--letter-spacing);
	--heading--line-height-h6: var(--global--line-height-heading);
	--heading--line-height-h5: var(--global--line-height-heading);
	--heading--line-height-h4: var(--global--line-height-heading);
	--heading--line-height-h3: var(--global--line-height-heading);
	--heading--line-height-h2: var(--global--line-height-heading);
	--heading--line-height-h1: var(--global--line-height-page-title);
	--heading--font-weight: normal;
	--heading--font-weight-page-title: 300;
	--heading--font-weight-strong: 600;

	/* Block: Latest posts */
	--latest-posts--title-font-family: var(--heading--font-family);
	--latest-posts--title-font-size: var(--heading--font-size-h3);
	--latest-posts--description-font-family: var(--global--font-secondary);
	--latest-posts--description-font-size: var(--global--font-size-sm);
	--list--font-family: var(--global--font-secondary);
	--definition-term--font-family: var(--global--font-primary);

	/* Colors */
	--global--color-black: #000;
	--global--color-dark-gray: #28303d;
	--global--color-gray: #39414d;
	--global--color-light-gray: #f0f0f0;
	--global--color-green: #d1e4dd;
	--global--color-blue: #d1dfe4;
	--global--color-purple: #d1d1e4;
	--global--color-red: #e4d1d1;
	--global--color-orange: #e4dad1;
	--global--color-yellow: #eeeadd;
	--global--color-white: #fff;
	--global--color-white-50: rgba(255, 255, 255, 0.5);
	--global--color-white-90: rgba(255, 255, 255, 0.9);
	--global--color-primary: var(--global--color-dark-gray);

	/* Body text color, site title, footer text color. */
	--global--color-secondary: var(--global--color-gray);

	/* Headings */
	--global--color-primary-hover: var(--global--color-primary);
	--global--color-background: var(--global--color-green);

	/* Mint, default body background */
	--global--color-border: var(--global--color-primary);

	/* Used for borders (separators) */

	/* Spacing */
	--global--spacing-unit: 20px;
	--global--spacing-measure: unset;
	--global--spacing-horizontal: 25px;
	--global--spacing-vertical: 30px;

	/* Elevation */
	--global--elevation: 1px 1px 3px 0 rgba(0, 0, 0, 0.2);

	/* Forms */
	--form--font-family: var(--global--font-secondary);
	--form--font-size: var(--global--font-size-sm);
	--form--line-height: var(--global--line-height-body);
	--form--color-text: var(--global--color-dark-gray);
	--form--color-ranged: var(--global--color-secondary);
	--form--label-weight: 500;
	--form--border-color: var(--global--color-secondary);
	--form--border-width: 3px;
	--form--border-radius: 0;
	--form--spacing-unit: calc(0.5 * var(--global--spacing-unit));

	/* Cover block */
	--cover--height: calc(15 * var(--global--spacing-vertical));
	--cover--color-foreground: var(--global--color-white);
	--cover--color-background: var(--global--color-black);

	/* Buttons */
	--button--color-text: var(--global--color-background);
	--button--color-text-hover: var(--global--color-secondary);
	--button--color-text-active: var(--global--color-secondary);
	--button--color-background: var(--global--color-secondary);
	--button--color-background-active: var(--global--color-background);
	--button--font-family: var(--global--font-primary);
	--button--font-size: var(--global--font-size-base);
	--button--font-weight: 500;
	--button--line-height: 1.5;
	--button--border-width: 3px;
	--button--border-radius: 0;
	--button--padding-vertical: 15px;
	--button--padding-horizontal: calc(2 * var(--button--padding-vertical));

	/* entry */
	--entry-header--color: var(--global--color-primary);
	--entry-header--color-link: currentColor;
	--entry-header--color-hover: var(--global--color-primary-hover);
	--entry-header--color-focus: var(--global--color-secondary);
	--entry-header--font-size: var(--heading--font-size-h2);
	--entry-content--font-family: var(--global--font-secondary);
	--entry-author-bio--font-family: var(--heading--font-family);
	--entry-author-bio--font-size: var(--heading--font-size-h4);

	/* Header */
	--branding--color-text: var(--global--color-primary);
	--branding--color-link: var(--global--color-primary);
	--branding--color-link-hover: var(--global--color-secondary);
	--branding--title--font-family: var(--global--font-primary);
	--branding--title--font-size: var(--global--font-size-lg);
	--branding--title--font-size-mobile: var(--heading--font-size-h4);
	--branding--title--font-weight: normal;
	--branding--title--text-transform: uppercase;
	--branding--description--font-family: var(--global--font-secondary);
	--branding--description--font-size: var(--global--font-size-sm);
	--branding--description--font-family: var(--global--font-secondary);
	--branding--logo--max-width: 300px;
	--branding--logo--max-height: 100px;
	--branding--logo--max-width-mobile: 96px;
	--branding--logo--max-height-mobile: 96px;

	/* Main navigation */
	--primary-nav--font-family: var(--global--font-secondary);
	--primary-nav--font-family-mobile: var(--global--font-primary);
	--primary-nav--font-size: var(--global--font-size-md);
	--primary-nav--font-size-sub-menu: var(--global--font-size-xs);
	--primary-nav--font-size-mobile: var(--global--font-size-sm);
	--primary-nav--font-size-sub-menu-mobile: var(--global--font-size-sm);
	--primary-nav--font-size-button: var(--global--font-size-xs);
	--primary-nav--font-style: normal;
	--primary-nav--font-style-sub-menu-mobile: normal;
	--primary-nav--font-weight: normal;
	--primary-nav--font-weight-button: 500;
	--primary-nav--color-link: var(--global--color-primary);
	--primary-nav--color-link-hover: var(--global--color-primary-hover);
	--primary-nav--color-text: var(--global--color-primary);
	--primary-nav--padding: calc(0.66 * var(--global--spacing-unit));
	--primary-nav--border-color: var(--global--color-primary);

	/* Pagination */
	--pagination--color-text: var(--global--color-primary);
	--pagination--color-link-hover: var(--global--color-primary-hover);
	--pagination--font-family: var(--global--font-secondary);
	--pagination--font-size: var(--global--font-size-lg);
	--pagination--font-weight: normal;
	--pagination--font-weight-strong: 600;

	/* Footer */
	--footer--color-text: var(--global--color-primary);
	--footer--color-link: var(--global--color-primary);
	--footer--color-link-hover: var(--global--color-primary-hover);
	--footer--font-family: var(--global--font-primary);
	--footer--font-size: var(--global--font-size-sm);

	/* Block: Pull quote */
	--pullquote--font-family: var(--global--font-primary);
	--pullquote--font-size: var(--heading--font-size-h3);
	--pullquote--font-style: normal;
	--pullquote--letter-spacing: var(--heading--letter-spacing-h4);
	--pullquote--line-height: var(--global--line-height-heading);
	--pullquote--border-width: 3px;
	--pullquote--border-color: var(--global--color-primary);
	--pullquote--color-foreground: var(--global--color-primary);
	--pullquote--color-background: var(--global--color-background);
	--quote--font-family: var(--global--font-secondary);
	--quote--font-size: var(--global--font-size-md);
	--quote--font-size-large: var(--global--font-size-xl);
	--quote--font-style: normal;
	--quote--font-weight: 700;
	--quote--font-weight-strong: bolder;
	--quote--font-style-large: normal;
	--quote--font-style-cite: normal;
	--quote--line-height: var(--global--line-height-body);
	--quote--line-height-large: 1.35;
	--separator--border-color: var(--global--color-border);
	--separator--height: 1px;

	/* Block: Table */
	--table--stripes-border-color: var(--global--color-light-gray);
	--table--stripes-background-color: var(--global--color-light-gray);
	--table--has-background-text-color: var(--global--color-dark-gray);

	/* Widgets */
	--widget--line-height-list: 1.9;
	--widget--line-height-title: 1.4;
	--widget--font-weight-title: 700;
	--widget--spacing-menu: calc(0.66 * var(--global--spacing-unit));

	/* Admin-bar height */
	--global--admin-bar--height: 0px;
}

.admin-bar {
	--global--admin-bar--height: 32px;
}
@media only screen and (max-width: 782px) {

	.admin-bar {
		--global--admin-bar--height: 46px;
	}
}

@media only screen and (min-width: 652px) {

	:root {
		--global--font-size-xl: 2.5rem;
		--global--font-size-xxl: 6rem;
		--global--font-size-xxxl: 9rem;
		--heading--font-size-h3: 2rem;
		--heading--font-size-h2: 3rem;
	}
}

/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */

/* Document
   ========================================================================== */

/**
 * 1. Correct the line height in all browsers.
 * 2. Prevent adjustments of font size after orientation changes in iOS.
 */
html {
	line-height: 1.15;

	/* 1 */
	-webkit-text-size-adjust: 100%;

	/* 2 */
}

/* Sections
   ========================================================================== */

/**
 * Remove the margin in all browsers.
 */
body {
	margin: 0;
}

/**
 * Render the `main` element consistently in IE.
 */
main {
	display: block;
}

/**
 * Correct the font size and margin on `h1` elements within `section` and
 * `article` contexts in Chrome, Firefox, and Safari.
 */
h1 {
	font-size: 2em;
	margin: 0.67em 0;
}

/* Grouping content
   ========================================================================== */

/**
 * 1. Add the correct box sizing in Firefox.
 * 2. Show the overflow in Edge and IE.
 */
hr {
	box-sizing: content-box;

	/* 1 */
	height: 0;

	/* 1 */
	overflow: visible;

	/* 2 */
}

/**
 * 1. Correct the inheritance and scaling of font size in all browsers.
 * 2. Correct the odd `em` font sizing in all browsers.
 */
pre {
	font-family: monospace;

	/* 1 */
	font-size: 1em;

	/* 2 */
}

/* Text-level semantics
   ========================================================================== */

/**
 * Remove the gray background on active links in IE 10.
 */
a {
	background-color: transparent;
	text-decoration-thickness: 1px;
}

/**
 * 1. Remove the bottom border in Chrome 57-
 * 2. Add the correct text decoration in Chrome, Edge, IE, Opera, and Safari.
 */
abbr[title] {
	border-bottom: none;

	/* 1 */
	text-decoration: underline;

	/* 2 */
	text-decoration-style: dotted;

	/* 2 */
}

/**
 * Add the correct font weight in Chrome, Edge, and Safari.
 */
b,
strong {
	font-weight: bolder;
}

/**
 * 1. Correct the inheritance and scaling of font size in all browsers.
 * 2. Correct the odd `em` font sizing in all browsers.
 */
code,
kbd,
samp {
	font-family: monospace;

	/* 1 */
	font-size: 1em;

	/* 2 */
}

/**
 * Add the correct font size in all browsers.
 */
small {
	font-size: 80%;
}

/**
 * Prevent `sub` and `sup` elements from affecting the line height in
 * all browsers.
 */
sub,
sup {
	font-size: 75%;
	line-height: 0;
	position: relative;
	vertical-align: baseline;
}

sub {
	bottom: -0.25em;
}

sup {
	top: -0.5em;
}

/* Embedded content
   ========================================================================== */

/**
 * Remove the border on images inside links in IE 10.
 */
img {
	border-style: none;
}

/* Forms
   ========================================================================== */

/**
 * 1. Change the font styles in all browsers.
 * 2. Remove the margin in Firefox and Safari.
 */
button,
input,
optgroup,
select,
textarea {
	font-family: inherit;

	/* 1 */
	font-size: 100%;

	/* 1 */
	line-height: 1.15;

	/* 1 */
	margin: 0;

	/* 2 */
}

/**
 * Show the overflow in IE.
 * 1. Show the overflow in Edge.
 */
button,
input {

	/* 1 */
	overflow: visible;
}

/**
 * Remove the inheritance of text transform in Edge, Firefox, and IE.
 * 1. Remove the inheritance of text transform in Firefox.
 */
button,
select {

	/* 1 */
	text-transform: none;
}

/**
 * Correct the inability to style clickable types in iOS and Safari.
 */
button,
[type=button],
[type=reset],
[type=submit] {
	-webkit-appearance: button;
}

/**
 * Remove the inner border and padding in Firefox.
 */
button::-moz-focus-inner,
[type=button]::-moz-focus-inner,
[type=reset]::-moz-focus-inner,
[type=submit]::-moz-focus-inner {
	border-style: none;
	padding: 0;
}

/**
 * Restore the focus styles unset by the previous rule.
 */
button:-moz-focusring,
[type=button]:-moz-focusring,
[type=reset]:-moz-focusring,
[type=submit]:-moz-focusring {
	outline: 1px dotted ButtonText;
}

/**
 * Correct the padding in Firefox.
 */
fieldset {
	padding: 0.35em 0.75em 0.625em;
}

/**
 * 1. Correct the text wrapping in Edge and IE.
 * 2. Correct the color inheritance from `fieldset` elements in IE.
 * 3. Remove the padding so developers are not caught out when they zero out
 *    `fieldset` elements in all browsers.
 */
legend {
	box-sizing: border-box;

	/* 1 */
	color: inherit;

	/* 2 */
	display: table;

	/* 1 */
	max-width: 100%;

	/* 1 */
	padding: 0;

	/* 3 */
	white-space: normal;

	/* 1 */
}

/**
 * Add the correct vertical alignment in Chrome, Firefox, and Opera.
 */
progress {
	vertical-align: baseline;
}

/**
 * Remove the default vertical scrollbar in IE 10+.
 */
textarea {
	overflow: auto;
}

/**
 * 1. Add the correct box sizing in IE 10.
 * 2. Remove the padding in IE 10.
 */
[type=checkbox],
[type=radio] {
	box-sizing: border-box;

	/* 1 */
	padding: 0;

	/* 2 */
}

/**
 * Correct the cursor style of increment and decrement buttons in Chrome.
 */
[type=number]::-webkit-inner-spin-button,
[type=number]::-webkit-outer-spin-button {
	height: auto;
}

/**
 * 1. Correct the odd appearance in Chrome and Safari.
 * 2. Correct the outline style in Safari.
 */
[type=search] {
	-webkit-appearance: textfield;

	/* 1 */
	outline-offset: -2px;

	/* 2 */
}

/**
 * Remove the inner padding in Chrome and Safari on macOS.
 */
[type=search]::-webkit-search-decoration {
	-webkit-appearance: none;
}

/**
 * 1. Correct the inability to style clickable types in iOS and Safari.
 * 2. Change font properties to `inherit` in Safari.
 */
::-webkit-file-upload-button {
	-webkit-appearance: button;

	/* 1 */
	font: inherit;

	/* 2 */
}

/* Interactive
   ========================================================================== */

/*
 * Add the correct display in Edge, IE 10+, and Firefox.
 */
details {
	display: block;
}

/*
 * Add the correct display in all browsers.
 */
summary {
	display: list-item;
}

/* Misc
   ========================================================================== */

/**
 * Add the correct display in IE 10+.
 */
template {
	display: none;
}

/**
 * Add the correct display in IE 10.
 */
[hidden] {
	display: none;
}

/**
 * Responsive Styles
 */

/**
 * Required Variables
 */

/**
 * Root Media Query Variables
 */
:root {
	--responsive--spacing-horizontal: calc(2 * var(--global--spacing-horizontal) * 0.6);
	--responsive--aligndefault-width: calc(100vw - var(--responsive--spacing-horizontal));
	--responsive--alignwide-width: calc(100vw - var(--responsive--spacing-horizontal));
	--responsive--alignfull-width: 100%;
	--responsive--alignright-margin: var(--global--spacing-horizontal);
	--responsive--alignleft-margin: var(--global--spacing-horizontal);
}

@media only screen and (min-width: 482px) {

	:root {
		--responsive--aligndefault-width: min(calc(100vw - 4 * var(--global--spacing-horizontal)), 610px);
		--responsive--alignwide-width: calc(100vw - 4 * var(--global--spacing-horizontal));
		--responsive--alignright-margin: calc(0.5 * (100vw - var(--responsive--aligndefault-width)));
		--responsive--alignleft-margin: calc(0.5 * (100vw - var(--responsive--aligndefault-width)));
	}
}
@media only screen and (min-width: 822px) {

	:root {
		--responsive--aligndefault-width: min(calc(100vw - 8 * var(--global--spacing-horizontal)), 610px);
		--responsive--alignwide-width: min(calc(100vw - 8 * var(--global--spacing-horizontal)), 1240px);
	}
}

/**
 * Extends
 */
.post-thumbnail,
.entry-content .wp-audio-shortcode,
.entry-content > *:not(.alignwide):not(.alignfull):not(.alignleft):not(.alignright):not(.wp-block-separator):not(.woocommerce),
*[class*=inner-container] > *:not(.entry-content):not(.alignwide):not(.alignfull):not(.alignleft):not(.alignright):not(.wp-block-separator):not(.woocommerce),
.default-max-width {
	max-width: var(--responsive--aligndefault-width);
	margin-left: auto;
	margin-right: auto;
}

.widget-area,
.pagination,
.comments-pagination,
.post-navigation,
.site-footer,
.site-header,
.alignwide,
.wide-max-width {
	max-width: var(--responsive--alignwide-width);
	margin-left: auto;
	margin-right: auto;
}

.alignfull,
.wp-block-group .wp-block-group__inner-container > *.alignfull,
.full-max-width {
	max-width: var(--responsive--alignfull-width);
	width: var(--responsive--alignfull-width);
	margin-left: auto;
	margin-right: auto;
}

@media only screen and (min-width: 482px) {

	.alignfull,
	.full-max-width {
		max-width: var(--responsive--alignfull-width);
		width: auto;
		margin-left: auto;
		margin-right: auto;
	}
}

.entry-header .post-thumbnail,
.singular .post-thumbnail,
.alignfull [class*=inner-container] > .alignwide,
.alignwide [class*=inner-container] > .alignwide {
	margin-left: auto;
	margin-right: auto;
	width: var(--responsive--alignwide-width);
	max-width: var(--responsive--alignfull-width);
}

@media only screen and (min-width: 482px) {

	.entry-content > .alignleft {

		/*rtl:ignore*/
		margin-left: var(--responsive--alignleft-margin);

		/*rtl:ignore*/
		margin-right: var(--global--spacing-horizontal);
	}
}
@media only screen and (min-width: 482px) {

	.entry-content > .alignright {

		/*rtl:ignore*/
		margin-left: var(--global--spacing-horizontal);

		/*rtl:ignore*/
		margin-right: var(--responsive--alignright-margin);
	}
}

/**
 * Site Structure
 *
 * - Set vertical margins and responsive widths on
 *   top-level wrappers and content wrappers
 * - `--global--width-content` is a responsive variable
 * - See: globals/_global-width-responsive.scss
 */

/**
 * Top Level Wrappers (header, main, footer)
 * - Set vertical padding and horizontal margins
 */
.site-header,
.site-main,
.widget-area,
.site-footer {
	padding-top: var(--global--spacing-vertical);
	padding-bottom: var(--global--spacing-vertical);
	margin-left: auto;
	margin-right: auto;
}

.site-header {
	padding-top: calc(0.75 * var(--global--spacing-vertical));
	padding-bottom: calc(2 * var(--global--spacing-vertical));
}
@media only screen and (min-width: 482px) {

	.site-header {
		padding-bottom: calc(3 * var(--global--spacing-vertical));
	}
}

/**
 * Site-main children wrappers
 * - Add double vertical margins here for clearer hierarchy
 */
.site-main > * {
	margin-top: calc(3 * var(--global--spacing-vertical));
	margin-bottom: calc(3 * var(--global--spacing-vertical));
}

.site-main > *:first-child {
	margin-top: 0;
}

.site-main > *:last-child {
	margin-bottom: 0;
}

/**
 * Set the default maximum responsive content-width
 */

/**
 * Set the wide maximum responsive content-width
 */

/**
 * Set the full maximum responsive content-width
 */

/*
 * Block & non-gutenberg content wrappers
 * - Set margins
 */
.entry-header,
.post-thumbnail,
.entry-content,
.entry-footer,
.author-bio {
	margin-top: var(--global--spacing-vertical);
	margin-right: auto;
	margin-bottom: var(--global--spacing-vertical);
	margin-left: auto;
}

/*
 * Block & non-gutenberg content wrapper children
 * - Sets spacing-vertical margin logic
 */
.site-main > article > *,
.site-main > .not-found > *,
.entry-content > *,
[class*=inner-container] > *,
.wp-block-template-part > * {
	margin-top: calc(0.666 * var(--global--spacing-vertical));
	margin-bottom: calc(0.666 * var(--global--spacing-vertical));
}
@media only screen and (min-width: 482px) {

	.site-main > article > *,
	.site-main > .not-found > *,
	.entry-content > *,
	[class*=inner-container] > *,
	.wp-block-template-part > * {
		margin-top: var(--global--spacing-vertical);
		margin-bottom: var(--global--spacing-vertical);
	}
}

.site-main > article > *:first-child,
.site-main > .not-found > *:first-child,
.entry-content > *:first-child,
[class*=inner-container] > *:first-child,
.wp-block-template-part > *:first-child {
	margin-top: 0;
}

.site-main > article > *:last-child,
.site-main > .not-found > *:last-child,
.entry-content > *:last-child,
[class*=inner-container] > *:last-child,
.wp-block-template-part > *:last-child {
	margin-bottom: 0;
}

.site-footer > *,
.widget-area > * {
	margin-top: calc(0.666 * var(--global--spacing-vertical));
	margin-bottom: calc(0.666 * var(--global--spacing-vertical));
}
@media only screen and (min-width: 482px) {

	.site-footer > *,
	.widget-area > * {
		margin-top: var(--global--spacing-vertical);
		margin-bottom: var(--global--spacing-vertical);
	}
}

/*
 * Block & non-gutenberg content wrapper children
 * - Sets spacing-unit margins
 */
.entry-header > *,
.post-thumbnail > *,
.page-content > *,
.comment-content > *,
.widget > * {
	margin-top: var(--global--spacing-unit);
	margin-bottom: var(--global--spacing-unit);
}

.entry-header > *:first-child,
.post-thumbnail > *:first-child,
.page-content > *:first-child,
.comment-content > *:first-child,
.widget > *:first-child {
	margin-top: 0;
}

.entry-header > *:last-child,
.post-thumbnail > *:last-child,
.page-content > *:last-child,
.comment-content > *:last-child,
.widget > *:last-child {
	margin-bottom: 0;
}

/*
 * .entry-content children specific controls
 * - Adds special margin overrides for alignment utility classes
 */
.entry-content > * {

	/* Reset alignleft and alignright margins after alignfull */
}

.entry-content > *.alignleft,
.entry-content > *.alignright,
.entry-content > *.alignleft:first-child + *,
.entry-content > *.alignright:first-child + *,
.entry-content > *.alignfull.has-background {
	margin-top: 0;
}

.entry-content > *:last-child,
.entry-content > *.alignfull.has-background {
	margin-bottom: 0;
}

.entry-content > *.alignfull + .alignleft,
.entry-content > *.alignfull + .alignright {
	margin-top: var(--global--spacing-vertical);
}

/**
 * Reset specific elements to make them easier to style in other contexts.
 */
html,
body,
p,
ol,
ul,
li,
dl,
dt,
dd,
blockquote,
figure,
fieldset,
form,
legend,
textarea,
pre,
iframe,
hr,
h1,
h2,
h3,
h4,
h5,
h6 {
	padding: 0;
	margin: 0;
	-moz-osx-font-smoothing: grayscale;
	-webkit-font-smoothing: antialiased;
}

/**
 * Apply generic border-box to all elements.
 * See:
 * https://css-tricks.com/inheriting-box-sizing-probably-slightly-better-best-practice/
 */
html {

	/* Apply border-box across the entire page. */
	box-sizing: border-box;
	font-family: var(--global--font-secondary);
	line-height: var(--global--line-height-body);
}

/**
 * Relax the definition a bit, to allow components to override it manually.
 */
*,
*::before,
*::after {
	box-sizing: inherit;
}

body {
	font-size: var(--global--font-size-base);
	font-weight: normal;
	color: var(--global--color-primary);
	text-align: left;
	background-color: var(--global--color-background);
}

button {
	cursor: pointer;
}

.clear:before,
.clear:after,
.entry-content:before,
.entry-content:after,
.comment-content:before,
.comment-content:after,
.site-header:before,
.site-header:after,
.site-content:before,
.site-content:after,
.site-footer:before,
.site-footer:after {
	content: "";
	display: table;
	table-layout: fixed;
}

.clear:after,
.entry-content:after,
.comment-content:after,
.site-header:after,
.site-content:after,
.site-footer:after {
	clear: both;
}

/* Category 04 can contain any default HTML element. Do not add classes here, just give the elements some basic styles. */
blockquote {
	padding: 0;
	position: relative;
	margin: var(--global--spacing-vertical) 0 var(--global--spacing-vertical) var(--global--spacing-horizontal);
}

blockquote > * {
	margin-top: var(--global--spacing-unit);
	margin-bottom: var(--global--spacing-unit);
}

blockquote > *:first-child {
	margin-top: 0;
}

blockquote > *:last-child {
	margin-bottom: 0;
}

blockquote p {
	letter-spacing: var(--heading--letter-spacing-h4);
	font-family: var(--quote--font-family);
	font-size: var(--quote--font-size);
	font-style: var(--quote--font-style);
	font-weight: var(--quote--font-weight);
	line-height: var(--quote--line-height);
}

blockquote cite,
blockquote footer {
	font-weight: normal;
	color: var(--global--color-primary);
	font-size: var(--global--font-size-xs);
	letter-spacing: var(--global--letter-spacing);
}

blockquote.alignleft,
blockquote.alignright {
	padding-left: inherit;
}

blockquote.alignleft p,
blockquote.alignright p {
	font-size: var(--heading--font-size-h5);
	max-width: inherit;
	width: inherit;
}

blockquote.alignleft cite,
blockquote.alignleft footer,
blockquote.alignright cite,
blockquote.alignright footer {
	font-size: var(--global--font-size-xs);
	letter-spacing: var(--global--letter-spacing);
}

blockquote strong {
	font-weight: var(--quote--font-weight-strong);
}

blockquote:before {
	content: "“";
	font-size: var(--quote--font-size);
	line-height: var(--quote--line-height);
	position: absolute;
	left: calc(-0.5 * var(--global--spacing-horizontal));
}

blockquote .wp-block-quote__citation,
blockquote cite,
blockquote footer {
	color: var(--global--color-primary);
	font-size: var(--global--font-size-xs);
	font-style: var(--quote--font-style-cite);
}
@media only screen and (max-width: 481px) {

	blockquote {
		padding-left: calc(0.5 * var(--global--spacing-horizontal));
	}

	blockquote:before {
		left: 0;
	}
}

input[type=text],
input[type=email],
input[type=url],
input[type=password],
input[type=search],
input[type=number],
input[type=tel],
input[type=date],
input[type=month],
input[type=week],
input[type=time],
input[type=datetime],
input[type=datetime-local],
input[type=color],
.site textarea {
	border: var(--form--border-width) solid var(--form--border-color);
	border-radius: var(--form--border-radius);
	color: var(--form--color-text);
	line-height: var(--global--line-height-body);
	padding: var(--form--spacing-unit);
	margin: 0 2px;
	max-width: 100%;
}

input[type=text]:focus,
input[type=email]:focus,
input[type=url]:focus,
input[type=password]:focus,
input[type=search]:focus,
input[type=number]:focus,
input[type=tel]:focus,
input[type=date]:focus,
input[type=month]:focus,
input[type=week]:focus,
input[type=time]:focus,
input[type=datetime]:focus,
input[type=datetime-local]:focus,
input[type=color]:focus,
.site textarea:focus {
	color: var(--form--color-text);
	outline-offset: 2px;
	outline: 2px dotted var(--form--border-color);
}

input[type=text]:disabled,
input[type=email]:disabled,
input[type=url]:disabled,
input[type=password]:disabled,
input[type=search]:disabled,
input[type=number]:disabled,
input[type=tel]:disabled,
input[type=date]:disabled,
input[type=month]:disabled,
input[type=week]:disabled,
input[type=time]:disabled,
input[type=datetime]:disabled,
input[type=datetime-local]:disabled,
input[type=color]:disabled,
.site textarea:disabled {
	opacity: 0.7;
}

.is-dark-theme input[type=text],
.is-dark-theme input[type=email],
.is-dark-theme input[type=url],
.is-dark-theme input[type=password],
.is-dark-theme input[type=search],
.is-dark-theme input[type=number],
.is-dark-theme input[type=tel],
.is-dark-theme input[type=date],
.is-dark-theme input[type=month],
.is-dark-theme input[type=week],
.is-dark-theme input[type=time],
.is-dark-theme input[type=datetime],
.is-dark-theme input[type=datetime-local],
.is-dark-theme input[type=color],
.is-dark-theme .site textarea {
	background: var(--global--color-white-90);
}

input[type=search]:focus {
	outline-offset: -7px;
}

.is-dark-theme input[type=search]:focus {
	outline-color: var(--global--color-background);
}

input[type=color] {
	padding: calc(var(--form--spacing-unit) / 2);
	height: calc(4 * var(--form--spacing-unit));
}

input[type=email],
input[type=url] {

	/*rtl:ignore*/
	direction: ltr;
}

select {
	border: var(--form--border-width) solid var(--form--border-color);
	color: var(--form--color-text);
	-moz-appearance: none;
	-webkit-appearance: none;
	appearance: none;
	line-height: var(--global--line-height-body);
	padding: var(--form--spacing-unit) calc(3 * var(--form--spacing-unit)) var(--form--spacing-unit) var(--form--spacing-unit);
	background: var(--global--color-white) url("data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='10' height='10' fill='%2328303d'><polygon points='0,0 10,0 5,5'/></svg>") no-repeat;
	background-position: right var(--form--spacing-unit) top 60%;
}

select:focus {
	outline-offset: 2px;
	outline: 2px dotted var(--form--border-color);
}

.is-dark-theme select {
	background: var(--global--color-white-90) url("data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='10' height='10' fill='%2328303d'><polygon points='0,0 10,0 5,5'/></svg>") no-repeat;
	background-position: right var(--form--spacing-unit) top 60%;
}

textarea {
	width: 100%;
}

label {
	font-size: var(--form--font-size);
	font-weight: var(--form--label-weight);
	margin-bottom: calc(var(--global--spacing-vertical) / 3);
}

/**
https://css-tricks.com/custom-styling-form-inputs-with-modern-css-features/
https://codepen.io/aaroniker/pen/ZEYoxEY by Aaron Iker.
License: MIT.
*/
@supports (-webkit-appearance: none) or (-moz-appearance: none) {

	input[type=checkbox],
	input[type=radio] {
		-webkit-appearance: none;
		-moz-appearance: none;
		position: relative;
		width: 25px;
		height: 25px;
		border: var(--form--border-width) solid var(--form--border-color);
		background: var(--global--color-white);
	}

	input[type=checkbox]:disabled,
	input[type=radio]:disabled {
		opacity: 0.7;
	}

	.is-dark-theme input[type=checkbox],
	.is-dark-theme input[type=radio] {
		background: var(--global--color-white-90);
	}

	input[type=checkbox]:focus {
		outline-offset: 2px;
		outline: 2px dotted var(--form--border-color);
	}

	input[type=checkbox]:after {
		content: "";
		opacity: 0;
		display: block;
		left: 5px;
		top: 2px;
		position: absolute;
		width: 7px;
		height: 13px;
		border: 3px solid var(--form--color-text);
		border-top: 0;
		border-left: 0;
		transform: rotate(30deg);
	}

	input[type=checkbox]:checked {
		color: var(--form--color-text);
	}

	input[type=checkbox]:checked:after {
		opacity: 1;
	}

	input[type=radio] {
		border-radius: 50%;
	}

	input[type=radio]:focus {
		outline-offset: 2px;
		outline: 2px dotted var(--form--border-color);
	}

	input[type=radio]:after {
		content: "";
		opacity: 0;
		display: block;
		left: 3px;
		top: 3px;
		position: absolute;
		width: 11px;
		height: 11px;
		border-radius: 50%;
		background: var(--form--color-text);
	}

	input[type=radio]:checked {
		border: 4px solid var(--form--border-color);
	}

	input[type=radio]:checked:after {
		opacity: 1;
	}

	input[type=radio]:checked:focus {
		outline-offset: 4px;
		outline: 2px dotted var(--form--border-color);
	}
}

input[type=checkbox] + label,
input[type=radio] + label {
	display: inline-block;
	padding-left: 10px;
	font-size: var(--global--font-size-xs);
	vertical-align: top;
}

/**
 * https://css-tricks.com/styling-cross-browser-compatible-range-inputs-css/
*/
@supports (-webkit-appearance: none) or (-moz-appearance: none) {

	input[type=range] {
		-webkit-appearance: none;

		/* Hides the slider so that custom slider can be made */
		width: 100%;

		/* Specific width is required for Firefox. */
		height: 6px;
		background: var(--form--color-ranged);
		border-radius: 6px;
		outline-offset: 10px;
	}

	input[type=range]:disabled {
		opacity: 0.7;
	}

	input[type=range]::-webkit-slider-thumb {
		-webkit-appearance: none;
		border: 3px solid var(--form--color-ranged);
		height: 44px;
		width: 44px;
		border-radius: 50%;
		background: var(--global--color-background);
		cursor: pointer;
	}

	input[type=range]::-moz-range-thumb {
		border: 3px solid var(--form--color-ranged);
		height: 44px;
		width: 44px;
		border-radius: 50%;
		background: var(--global--color-background);
		cursor: pointer;
		box-sizing: border-box;
	}
}

input[type=range]::-ms-track {
	width: 100%;
	height: 6px;
	border-radius: 6px;
	border-width: 19px 0;
	border-color: var(--global--color-background);
	background: transparent;
	color: transparent;
	cursor: pointer;
}

input[type=range]::-ms-fill-upper {
	background: var(--form--color-ranged);
	border-radius: 6px;
}

input[type=range]::-ms-fill-lower {
	background: var(--form--color-ranged);
	border-radius: 6px;
}

input[type=range]::-ms-thumb {
	border: 3px solid var(--form--color-ranged);
	height: 44px;
	width: 44px;
	border-radius: 50%;
	background: var(--global--color-background);
	cursor: pointer;
}

fieldset {
	display: grid;
	border-color: var(--global--color-secondary);
	padding: var(--global--spacing-horizontal);
}

fieldset legend {
	font-size: var(--global--font-size-lg);
}

fieldset input[type=submit] {
	max-width: max-content;
}

fieldset input:not([type=submit]) {
	margin-bottom: var(--global--spacing-unit);
}

fieldset input[type=radio],
fieldset input[type=checkbox] {
	margin-bottom: 0;
}

fieldset input[type=radio] + label,
fieldset input[type=checkbox] + label {
	font-size: var(--form--font-size);
	padding-left: 0;
	margin-bottom: var(--global--spacing-unit);
}

::-moz-placeholder {
	opacity: 1;
}

.post-password-message {
	font-size: var(--global--font-size-lg);
}

.post-password-form {
	display: flex;
	flex-wrap: wrap;
}

.post-password-form__label {
	width: 100%;
	margin-bottom: 0;
}

.post-password-form input[type=password] {
	flex-grow: 1;
	margin-top: calc(var(--global--spacing-vertical) / 3);
	margin-right: calc(0.66 * var(--global--spacing-horizontal));
}

.post-password-form__submit {
	margin-top: calc(var(--global--spacing-vertical) / 3);
}
@media only screen and (min-width: 592px) {

	.post-password-form__submit {
		margin-left: calc(0.4 * var(--global--spacing-horizontal));
	}
}

img {
	height: auto;
	max-width: 100%;
	vertical-align: middle;
}

/* Classic editor images */
.entry-content img {
	max-width: 100%;
}

/* Make sure embeds and iframes fit their containers. */
embed,
iframe,
object,
video {
	max-width: 100%;
}

/* Media captions */
figcaption,
.wp-caption,
.wp-caption-text,
.wp-block-embed figcaption {
	color: currentColor;
	font-size: var(--global--font-size-xs);
	line-height: var(--global--line-height-body);
	margin-top: calc(0.5 * var(--global--spacing-unit));
	margin-bottom: var(--global--spacing-unit);
	text-align: center;
}

.alignleft figcaption,
.alignright figcaption,
.alignleft .wp-caption,
.alignright .wp-caption,
.alignleft .wp-caption-text,
.alignright .wp-caption-text,
.alignleft .wp-block-embed figcaption,
.alignright .wp-block-embed figcaption {
	margin-bottom: 0;
}

/* WP Smiley */
.page-content .wp-smiley,
.entry-content .wp-smiley,
.comment-content .wp-smiley {
	border: none;
	margin-bottom: 0;
	margin-top: 0;
	padding: 0;
}

/* Over here, place any elements that do not need to have their own file. */
b,
strong {
	font-weight: 700;
}

dfn,
cite,
em,
i {
	font-style: italic;
}

pre {
	white-space: pre;
	overflow-x: auto;
}

/*
 * text-underline-offset doesn't work in Chrome at all 👎
 * But looks nice in Safari/Firefox, so let's keep it and
 * maybe Chrome will support it soon.
 */
a {
	cursor: pointer;
	color: var(--wp--style--color--link, var(--global--color-primary));
	text-underline-offset: 3px;
	text-decoration-skip-ink: all;
}

a:hover {
	text-decoration-style: dotted;
	text-decoration-skip-ink: none;
}

.site a:focus:not(.wp-block-button__link):not(.wp-block-file__button) {

	/* Only visible in Windows High Contrast mode */
	outline: 2px solid transparent;
	text-decoration: underline 1px dotted currentColor;
	text-decoration-skip-ink: none;
	background: rgba(255, 255, 255, 0.9);
}

.is-dark-theme .site a:focus:not(.wp-block-button__link):not(.wp-block-file__button) {
	background: var(--global--color-black);
	color: var(--global--color-white);
	text-decoration: none;
}

.is-dark-theme .site a:focus:not(.wp-block-button__link):not(.wp-block-file__button) .meta-nav {
	color: var(--wp--style--color--link, var(--global--color-white));
}

.has-background-white .site a:focus:not(.wp-block-button__link):not(.wp-block-file__button) {
	background: rgba(0, 0, 0, 0.9);
	color: var(--wp--style--color--link, var(--global--color-white));
}

.has-background-white .site a:focus:not(.wp-block-button__link):not(.wp-block-file__button) .meta-nav {
	color: var(--wp--style--color--link, var(--global--color-white));
}

.site a:focus:not(.wp-block-button__link):not(.wp-block-file__button).skip-link {

	/* Only visible in Windows High Contrast mode */
	outline: 2px solid transparent;
	outline-offset: -2px;
}

.site a:focus:not(.wp-block-button__link):not(.wp-block-file__button).skip-link:focus {
	color: #21759b;
	background-color: #f1f1f1;
}

.site a:focus:not(.wp-block-button__link):not(.wp-block-file__button).custom-logo-link {
	background: none;
}

.site a:focus:not(.wp-block-button__link):not(.wp-block-file__button) img {
	outline: 2px dotted var(--wp--style--color--link, var(--global--color-primary));
}

.has-background .has-link-color a,
.has-background.has-link-color a {
	color: var(--wp--style--color--link, var(--global--color-primary));
}

/* Category 05 is all about adjusting the default block styles to the given layout. I only added three blocks as examples. */
.wp-block-audio audio:focus {
	outline-offset: 5px;
	outline: 2px solid var(--global--color-primary);
}

/**
 * Button
 */
.site .button,
button,
input[type=submit],
input[type=reset],
.wp-block-search .wp-block-search__button,
.wp-block-button .wp-block-button__link,
.wp-block-file a.wp-block-file__button {
	border: var(--button--border-width) solid transparent;
	border-radius: var(--button--border-radius);
	cursor: pointer;
	font-weight: var(--button--font-weight);
	font-family: var(--button--font-family);
	font-size: var(--button--font-size);
	line-height: var(--button--line-height);
	padding: var(--button--padding-vertical) var(--button--padding-horizontal);
	text-decoration: none;
}

.site .button:not(:hover):not(:active):not(.has-text-color),
button:not(:hover):not(:active):not(.has-text-color),
input[type=submit]:not(:hover):not(:active):not(.has-text-color),
input[type=reset]:not(:hover):not(:active):not(.has-text-color),
.wp-block-search .wp-block-search__button:not(:hover):not(:active):not(.has-text-color),
.wp-block-button .wp-block-button__link:not(:hover):not(:active):not(.has-text-color),
.wp-block-file a.wp-block-file__button:not(:hover):not(:active):not(.has-text-color) {
	color: var(--global--color-background);
}

.has-background .site .button:not(:hover):not(:active):not(.has-text-color),
.has-background button:not(:hover):not(:active):not(.has-text-color),
.has-background input[type=submit]:not(:hover):not(:active):not(.has-text-color),
.has-background input[type=reset]:not(:hover):not(:active):not(.has-text-color),
.has-background .wp-block-search .wp-block-search__button:not(:hover):not(:active):not(.has-text-color),
.has-background .wp-block-button .wp-block-button__link:not(:hover):not(:active):not(.has-text-color),
.has-background .wp-block-file a.wp-block-file__button:not(:hover):not(:active):not(.has-text-color) {
	color: var(--local--color-background, var(--global--color-primary));
}

.has-background .site .button:not(:hover):not(:active):not(.has-text-color).has-background,
.has-background button:not(:hover):not(:active):not(.has-text-color).has-background,
.has-background input[type=submit]:not(:hover):not(:active):not(.has-text-color).has-background,
.has-background input[type=reset]:not(:hover):not(:active):not(.has-text-color).has-background,
.has-background .wp-block-search .wp-block-search__button:not(:hover):not(:active):not(.has-text-color).has-background,
.has-background .wp-block-button .wp-block-button__link:not(:hover):not(:active):not(.has-text-color).has-background,
.has-background .wp-block-file a.wp-block-file__button:not(:hover):not(:active):not(.has-text-color).has-background {
	color: var(--global--color-primary);
}

.site .button:not(:hover):not(:active):not(.has-background),
button:not(:hover):not(:active):not(.has-background),
input[type=submit]:not(:hover):not(:active):not(.has-background),
input[type=reset]:not(:hover):not(:active):not(.has-background),
.wp-block-search .wp-block-search__button:not(:hover):not(:active):not(.has-background),
.wp-block-button .wp-block-button__link:not(:hover):not(:active):not(.has-background),
.wp-block-file a.wp-block-file__button:not(:hover):not(:active):not(.has-background) {
	background-color: var(--global--color-primary);
}

.has-background .site .button:not(:hover):not(:active):not(.has-background),
.has-background button:not(:hover):not(:active):not(.has-background),
.has-background input[type=submit]:not(:hover):not(:active):not(.has-background),
.has-background input[type=reset]:not(:hover):not(:active):not(.has-background),
.has-background .wp-block-search .wp-block-search__button:not(:hover):not(:active):not(.has-background),
.has-background .wp-block-button .wp-block-button__link:not(:hover):not(:active):not(.has-background),
.has-background .wp-block-file a.wp-block-file__button:not(:hover):not(:active):not(.has-background) {
	background-color: var(--local--color-primary, var(--global--color-primary));
}

.site .button:hover,
.site .button:active,
button:hover,
button:active,
input[type=submit]:hover,
input[type=submit]:active,
input[type=reset]:hover,
input[type=reset]:active,
.wp-block-search .wp-block-search__button:hover,
.wp-block-search .wp-block-search__button:active,
.wp-block-button .wp-block-button__link:hover,
.wp-block-button .wp-block-button__link:active,
.wp-block-file a.wp-block-file__button:hover,
.wp-block-file a.wp-block-file__button:active {
	background-color: transparent;
	border-color: currentColor;
	color: inherit;
}

.site .button:focus,
button:focus,
input[type=submit]:focus,
input[type=reset]:focus,
.wp-block-search .wp-block-search__button:focus,
.wp-block-button .wp-block-button__link:focus,
.wp-block-file a.wp-block-file__button:focus {
	outline-offset: -6px;
	outline: 2px dotted currentColor;
}

.site .button:disabled,
button:disabled,
input[type=submit]:disabled,
input[type=reset]:disabled,
.wp-block-search .wp-block-search__button:disabled,
.wp-block-button .wp-block-button__link:disabled,
.wp-block-file a.wp-block-file__button:disabled {
	background-color: var(--global--color-white-50);
	border-color: var(--global--color-white-50);
	color: var(--button--color-text-active);
}

/**
 * Block Options
 */
.wp-block-button:not(.is-style-outline) .wp-block-button__link:not(:hover):not(:active):not(.has-text-color) {
	color: var(--global--color-background);
}

.has-background .wp-block-button:not(.is-style-outline) .wp-block-button__link:not(:hover):not(:active):not(.has-text-color) {
	color: var(--local--color-background, var(--global--color-background));
}

.has-background .wp-block-button:not(.is-style-outline) .wp-block-button__link:not(:hover):not(:active):not(.has-text-color).has-background {
	color: var(--global--color-primary);
}

.wp-block-button:not(.is-style-outline) .wp-block-button__link:not(:hover):not(:active):not(.has-background) {
	background-color: var(--global--color-primary);
}

.has-background .wp-block-button:not(.is-style-outline) .wp-block-button__link:not(:hover):not(:active):not(.has-background) {
	background-color: var(--local--color-primary, var(--global--color-primary));
}

.wp-block-button:not(.is-style-outline) .wp-block-button__link:hover,
.wp-block-button:not(.is-style-outline) .wp-block-button__link:active {
	border-color: currentColor !important;
	background-color: transparent !important;
	color: inherit !important;
}

.wp-block-button.is-style-outline .wp-block-button__link:not(:hover):not(:active):not(.has-text-color),
.wp-block-button.is-style-outline .wp-block-button__link:not(:hover):not(:active):not(.has-background),
.wp-block-button.is-style-outline .wp-block-button__link:not(:hover):not(:active).has-background {
	border-color: currentColor;
}

.wp-block-button.is-style-outline .wp-block-button__link:not(:hover):not(:active):not(.has-text-color) {
	color: var(--global--color-primary);
}

.has-background .wp-block-button.is-style-outline .wp-block-button__link:not(:hover):not(:active):not(.has-text-color) {
	color: var(--local--color-primary, var(--global--color-primary));
}

.has-background .wp-block-button.is-style-outline .wp-block-button__link:not(:hover):not(:active).has-background:not(.has-text-color) {
	color: inherit;
}

.wp-block-button.is-style-outline .wp-block-button__link:not(:hover):not(:active):not(.has-background) {
	background-color: transparent;
}

.wp-block-button.is-style-outline .wp-block-button__link:hover,
.wp-block-button.is-style-outline .wp-block-button__link:active {
	border-color: transparent !important;
	background-color: var(--global--color-primary) !important;
	color: var(--global--color-background) !important;
}

.has-background .wp-block-button.is-style-outline .wp-block-button__link:hover,
.has-background .wp-block-button.is-style-outline .wp-block-button__link:active {
	background-color: var(--local--color-primary, var(--global--color-primary)) !important;
	color: var(--local--color-background, var(--global--color-background)) !important;
}

.has-text-color .wp-block-button.is-style-outline .wp-block-button__link:hover,
.has-text-color .wp-block-button.is-style-outline .wp-block-button__link:active {
	color: var(--local--color-background, var(--global--color-background)) !important;
}

.wp-block-button .is-style-squared .wp-block-button__link {
	border-radius: 0;
}

.is-style-outline .wp-block-button__link[style*=radius]:focus,
.wp-block-button a.wp-block-button__link[style*=radius]:focus {
	outline-offset: 2px;
	outline: 2px dotted var(--button--color-background);
}

.wp-block-code {
	border-color: var(--global--color-border);
	border-radius: 0;
	border-style: solid;
	border-width: 0.1rem;
	padding: var(--global--spacing-unit);
}

.wp-block-code code {
	color: var(--global--color-primary);
	white-space: pre;
	overflow-x: auto;
	display: block;
}

.wp-block-columns:not(.alignwide):not(.alignfull) {
	clear: both;
}

.wp-block-columns .wp-block-column > * {
	margin-top: calc(0.66 * var(--global--spacing-vertical));
	margin-bottom: calc(0.66 * var(--global--spacing-vertical));
}
@media only screen and (min-width: 482px) {

	.wp-block-columns .wp-block-column > * {
		margin-top: var(--global--spacing-vertical);
		margin-bottom: var(--global--spacing-vertical);
	}
}

.wp-block-columns .wp-block-column > *:first-child {
	margin-top: 0;
}

.wp-block-columns .wp-block-column > *:last-child {
	margin-bottom: 0;
}

.wp-block-columns .wp-block-column:last-child {
	margin-bottom: 0;
}

.wp-block-columns .wp-block-column:not(:last-child) {
	margin-bottom: calc(0.66 * var(--global--spacing-vertical));
}
@media only screen and (min-width: 482px) {

	.wp-block-columns .wp-block-column:not(:last-child) {
		margin-bottom: var(--global--spacing-vertical);
	}
}
@media only screen and (min-width: 822px) {

	.wp-block-columns .wp-block-column:not(:last-child) {
		margin-bottom: 0;
	}
}

.wp-block-columns.is-style-twentytwentyone-columns-overlap {
	justify-content: space-around;
}
@media only screen and (min-width: 652px) {

	.wp-block-columns.is-style-twentytwentyone-columns-overlap .wp-block-column:nth-child(2n) {
		margin-left: calc(-2 * var(--global--spacing-horizontal));
		margin-top: calc(2.5 * var(--global--spacing-horizontal));
		z-index: 2;
	}

	.wp-block-columns.is-style-twentytwentyone-columns-overlap .wp-block-column:nth-child(2n) > p:not(.has-background),
	.wp-block-columns.is-style-twentytwentyone-columns-overlap .wp-block-column:nth-child(2n) > h1:not(.has-background),
	.wp-block-columns.is-style-twentytwentyone-columns-overlap .wp-block-column:nth-child(2n) > h2:not(.has-background),
	.wp-block-columns.is-style-twentytwentyone-columns-overlap .wp-block-column:nth-child(2n) > h3:not(.has-background),
	.wp-block-columns.is-style-twentytwentyone-columns-overlap .wp-block-column:nth-child(2n) > h4:not(.has-background),
	.wp-block-columns.is-style-twentytwentyone-columns-overlap .wp-block-column:nth-child(2n) > h5:not(.has-background),
	.wp-block-columns.is-style-twentytwentyone-columns-overlap .wp-block-column:nth-child(2n) > h6:not(.has-background),
	.wp-block-columns.is-style-twentytwentyone-columns-overlap .wp-block-column:nth-child(2n) > ul:not(.has-background),
	.wp-block-columns.is-style-twentytwentyone-columns-overlap .wp-block-column:nth-child(2n) > ol:not(.has-background),
	.wp-block-columns.is-style-twentytwentyone-columns-overlap .wp-block-column:nth-child(2n) > pre:not(.has-background) {
		background-color: var(--global--color-background);
		padding: var(--global--spacing-unit);
	}

	.wp-block-columns.is-style-twentytwentyone-columns-overlap .wp-block-column:nth-child(2n) > ul:not(.has-background),
	.wp-block-columns.is-style-twentytwentyone-columns-overlap .wp-block-column:nth-child(2n) > ol:not(.has-background) {
		padding-left: calc(2 * var(--global--spacing-horizontal));
	}

	.wp-block-columns.is-style-twentytwentyone-columns-overlap .wp-block-column:nth-child(2n).is-vertically-aligned-center {
		margin-top: 0;
	}
}

.wp-block-columns.alignfull .wp-block-column p:not(.has-background),
.wp-block-columns.alignfull .wp-block-column h1:not(.has-background),
.wp-block-columns.alignfull .wp-block-column h2:not(.has-background),
.wp-block-columns.alignfull .wp-block-column h3:not(.has-background),
.wp-block-columns.alignfull .wp-block-column h4:not(.has-background),
.wp-block-columns.alignfull .wp-block-column h5:not(.has-background),
.wp-block-columns.alignfull .wp-block-column h6:not(.has-background) {
	padding-left: var(--globa