ext,
	.comments-pagination .page-numbers.prev,
	.comments-pagination .page-numbers.next {
		display: inline-block;
		flex: 0 1 auto;
	}
}
@media only screen and (max-width: 481px) {

	.pagination .nav-short,
	.comments-pagination .nav-short {
		display: none;
	}
}

.comments-pagination {
	padding-top: calc(0.66 * var(--global--spacing-vertical));
	margin: calc(3 * var(--global--spacing-vertical)) auto;
}
@media only screen and (min-width: 822px) {

	.comments-pagination {
		margin: calc(3 * var(--global--spacing-vertical)) auto calc(4 * var(--global--spacing-vertical)) auto;
	}
}

.comments-pagination .nav-links > * {
	font-size: var(--global--font-size-md);
}

.widget-area {
	margin-top: calc(6 * var(--global--spacing-vertical));
	padding-bottom: calc(var(--global--spacing-vertical) / 3);
	color: var(--footer--color-text);
	font-size: var(--footer--font-size);
	font-family: var(--footer--font-family);
}
@media only screen and (min-width: 652px) {

	.widget-area {
		display: grid;
		grid-template-columns: repeat(2, 1fr);
		column-gap: calc(2 * var(--global--spacing-horizontal));
	}
}
@media only screen and (min-width: 1024px) {

	.widget-area {
		grid-template-columns: repeat(3, 1fr);
	}
}
@media only screen and (max-width: 481px) {

	.widget-area {
		margin-top: calc(3 * var(--global--spacing-vertical));
	}
}

.widget-area ul {
	list-style-type: none;
	padding: 0;
}

.widget-area ul li {
	line-height: var(--widget--line-height-list);
}

.widget-area ul.sub-menu,
.widget-area ul.children {
	margin-right: var(--widget--spacing-menu);
}

.widget-area ul .sub-menu-toggle {
	display: none;
}

.widget-area a {
	color: var(--footer--color-link);
	text-decoration: underline;
	text-decoration-style: solid;
	text-decoration-color: currentColor;
}

.widget-area a:link,
.widget-area a:visited,
.widget-area a:active {
	color: var(--footer--color-link);
}

.widget-area a:hover {
	color: var(--footer--color-link-hover);
	text-decoration-style: dotted;
}

.widget-area .wp-block-social-links.alignright {
	margin-top: var(--global--spacing-vertical);
	justify-content: flex-end;
}

.widget-area .wp-block-social-links.alignleft {
	margin-top: var(--global--spacing-vertical);
}

.widget-area:after {
	content: "";
	display: table;
	clear: both;
}

.widget-title {
	font-size: var(--global--font-size-sm);
	font-weight: var(--widget--font-weight-title);
	line-height: var(--widget--line-height-title);
}

.search-form {
	display: flex;
	flex-wrap: wrap;
	margin: auto;
	max-width: var(--responsive--aligndefault-width);
}

.search-form > label {
	width: 100%;
	margin-bottom: 0;
	font-weight: var(--form--label-weight);
}

.search-form .search-field {
	flex-grow: 1;
	max-width: inherit;
	margin-top: calc(var(--global--spacing-vertical) / 3);
	margin-left: calc(0.66 * var(--global--spacing-horizontal));
}

.search-form .search-submit {
	margin-top: calc(var(--global--spacing-vertical) / 3);
	margin-right: 10px;
}

.widget_search > .search-form .search-field {
	margin-left: calc(-1 * var(--button--border-width));
	-webkit-appearance: none;
	margin-bottom: calc(0.5 * var(--global--spacing-vertical));
}

.widget_search > .search-form .search-submit {
	margin-right: 0;
	margin-bottom: calc(0.5 * var(--global--spacing-vertical));
}

.widget_rss a.rsswidget .rss-widget-icon {
	display: none;
}

/* Category 07 is for any utility classes that are not assigned to a specific component. */
.screen-reader-text {
	border: 0;
	clip: rect(1px, 1px, 1px, 1px);
	-webkit-clip-path: inset(50%);
	clip-path: inset(50%);
	height: 1px;
	margin: -1px;
	overflow: hidden;
	padding: 0;
	position: absolute !important;
	width: 1px;
	word-wrap: normal !important;
	word-break: normal;
}

.skip-link:focus {
	background-color: #f1f1f1;
	border-radius: 3px;
	box-shadow: 0 0 2px 2px rgba(0, 0, 0, 0.6);
	clip: auto !important;
	-webkit-clip-path: none;
	clip-path: none;
	color: #21759b;
	display: block;
	font-size: 0.875rem;
	font-weight: 700;
	height: auto;
	right: 5px;
	line-height: normal;
	padding: 15px 23px 14px;
	text-decoration: none;
	top: 5px;
	width: auto;
	z-index: 100000;
}

/* Do not show the outline on the skip link target. */
#content[tabindex="-1"]:focus {
	outline: 0;
}

@media (prefers-reduced-motion) {

	* {
		transition-delay: 0s !important;
		transition-duration: 0s !important;
	}
}

.has-black-color[class] {
	color: var(--global--color-black);
}

.has-black-color[class] > [class*=__inner-container] {
	--local--color-primary: var(--global--color-black, #000);
	color: var(--local--color-primary);
}

.has-gray-color[class] {
	color: var(--global--color-gray);
}

.has-gray-color[class] > [class*=__inner-container] {
	--local--color-primary: var(--global--color-gray, #000);
	color: var(--local--color-primary);
}

.has-dark-gray-color[class] {
	color: var(--global--color-dark-gray);
}

.has-dark-gray-color[class] > [class*=__inner-container] {
	--local--color-primary: var(--global--color-dark-gray, #000);
	color: var(--local--color-primary);
}

.has-green-color[class] {
	color: var(--global--color-green);
}

.has-green-color[cla