t-meta .meta-icon {
	flex-shrink: 0;
	margin-left: 1rem;
}

.sticky .post-sticky {
	color: inherit;
}

.post-meta .post-author .meta-icon svg {
	width: 1.6rem;
	height: 1.8rem;
}

.post-meta .post-categories .meta-icon svg {
	width: 1.8rem;
	height: 1.7rem;
}

.post-meta .post-comment-link .meta-icon svg {
	width: 1.8rem;
	height: 1.8rem;
}

.post-meta .post-date .meta-icon svg {
	width: 1.7rem;
	height: 1.8rem;
}

.post-meta .post-edit .meta-icon svg {
	width: 1.8rem;
	height: 1.8rem;
}

.post-meta .post-sticky .meta-icon svg {
	width: 1.5rem;
	height: 1.8rem;
}

.post-meta .post-tags .meta-icon svg {
	width: 1.8rem;
	height: 1.8rem;
}

.post-meta svg * {
	fill: currentColor;
}


/* Featured Media ---------------------------- */

.featured-media {
	margin-top: 5rem;
	position: relative;
}

.singular .featured-media {
	margin-top: 0;
}

.singular .featured-media-inner {
	position: relative;
	right: calc(50% - 50vw);
	width: 100vw;
}

.singular .featured-media::before {
	background: #fff;
	content: "";
	display: block;
	position: absolute;
	bottom: 50%;
	right: 0;
	left: 0;
	top: 0;
}

.featured-media img {
	margin: 0 auto;
}

.featured-media figcaption {
	margin: 1.5rem auto 0 auto;
	text-align: center;
	width: calc(100% - 5rem);
}

.post-inner {
	padding-top: 5rem;
}

.reduced-spacing.missing-post-thumbnail .post-inner {
	padding-top: 0;
}


/* Post Footer ------------------------------- */

/* POST NAV LINKS */

.post-nav-links {
	border-radius: 0.4rem;
	display: flex;
	font-size: 0.9em;
	font-weight: 600;
	line-height: 1;
	margin: 3em auto 0 auto;
	padding: 0;
	width: calc(100% - 4rem);
	max-width: 58rem;
}

.post-nav-links > span.label {
	padding: 1em 0;
}

.post-nav-links > * {
	padding: 1em 0.75em;
}

/* POST META BOTTOM */

.post-meta-wrapper.post-meta-single-bottom {
	margin-top: 3rem;
}


/* Author Bio -------------------------------- */

.author-bio {
	margin-top: 4rem;
	margin-left: auto;
	margin-right: auto;
	max-width: 58rem;
	width: 100%;
}

.hide-avatars .author-bio {
	padding-right: 0;
}

.author-bio .author-title-wrapper {
	align-items: center;
	display: flex;
	margin: 0 0 1rem 0;
}

.author-bio .avatar {
	border-radius: 50%;
	margin-left: 1.5rem;
	height: 5rem;
	width: 5rem;
}

.hide-avatars img.avatar {
	display: none;
}

.author-bio p:last-child {
	margin-bottom: 0;
}

.author-bio .author-title {
	margin: 0;
}

.author-bio .author-link {
	display: block;
	font-size: 1.6rem;
	font-weight: 600;
	margin-top: 1em;
	text-decoration: none;
}

.author-bio .author-link:focus,
.author-bio .author-link:hover {
	text-decoration: underline;
}


/* Single Pagination ------------------------- */

.pagination-single {
	font-size: 1.8rem;
	margin-top: 5rem;
}

.pagination-single-inner {
	display: flex;
	flex-direction: column;
}

.pagination-single hr:first-child {
	margin: 0 0 2.8rem 0;
}

.pagination-single hr:last-child {
	margin: 2.8rem 0 0.8rem 0;
}

.pagination-single a {
	align-items: baseline;
	display: flex;
	font-weight: 600;
	letter-spacing: -0.0275em;
	text-decoration: none;
	flex: 1;
}

.pagination-single a + a {
	margin-top: 1rem;
}

.pagination-single a .arrow {
	margin-left: 1rem;
}

.pagination-single a:focus .title,
.pagination-single a:hover .title {
	text-decoration: underline;
}


/* -------------------------------------------------------------------------- */

/*	10. Blocks
/* -------------------------------------------------------------------------- */


/* Block Colors ------------------------------ */

.has-text-color a {
	color: inherit;
}

/* CUSTOM COLORS */

:root .has-accent-color {
	color: #cd2653;
}

:root .has-accent-background-color {
	background-color: #cd2653;
	color: #fff;
}

:root .has-primary-color {
	color: #000;
}

:root .has-primary-background-color {
	background-color: #000;
	color: #f5efe0;
}

:root .has-secondary-color {
	color: #6d6d6d;
}

:root .has-secondary-background-color {
	background-color: #6d6d6d;
	color: #fff;
}

:root .has-subtle-background-color {
	color: #dcd7ca;
}

:root .has-subtle-background-background-color {
	background-color: #dcd7ca;
	color: #000;
}

:root .has-background-color {
	color: #f5efe0;
}

:root .has-background-background-color {
	background-color: #f5efe0;
	color: #000;
}


/* Block Typography Classes ------------------ */

.has-text-align-left {
	text-align: left;
}

.has-text-align-center {
	text-align: center;
}

.has-text-align-right {
	text-align: left;
}

.has-drop-cap:not(:focus)::first-letter {
	color: #cd2653;
	font-family: -apple-system, BlinkMacSystemFont, "Helvetica Neue", Helvetica, sans-serif;
	font-size: 5.1em;
	font-weight: 800;
	margin: 0.05em 0 0 0.1em;
}

.has-drop-cap:not(:focus)::first-letter::after {
	content: "";
	display: table;
	clear: both;
}

.has-drop-cap:not(:focus)::after {
	padding: 0;
}


/* Block Font Families ----------------------- */

.has-drop-cap:not(:focus)::first-letter,
.entry-content .wp-block-archives,
.entry-content .wp-block-categories,
.entry-content .wp-block-cover-image,
.entry-content .wp-block-latest-comments,
.entry-content .wp-block-latest-posts,
.entry-content .wp-block-pullquote,
.entry-content .wp-block-quote.is-large,
.entry-content .wp-block-quote.is-style-large {
	font-family: -apple-system, BlinkMacSystemFont, "Helvetica Neue", Helvetica, sans-serif;
}

@supports ( font-variation-settings: normal ) {

	.has-drop-cap:not(:focus)::first-letter,
	.entry-content .wp-block-archives,
	.entry-content .wp-block-categories,
	.entry-content .wp-block-latest-posts,
	.entry-content .wp-block-latest-comments,
	.entry-content .wp-block-cover-image p,
	.entry-content .wp-block-pullquote {
		font-family: "Inter var", -apple-system, BlinkMacSystemFont, "Helvetica Neue", Helvetica, sans-serif;
	}
}

/* Block Font Sizes -------------------------- */

.entry-content .has-small-font-size {
	font-size: 0.842em;
}

.entry-content .has-normal-font-size,
.entry-content .has-regular-font-size {
	font-size: 1em;
}

.entry-content .has-medium-font-size {
	font-size: 1.1em;
	line-height: 1.45;
}

.entry-content .has-large-font-size {
	font-size: 1.25em;
	line-height: 1.4;
}

.entry-content .has-larger-font-size {
	font-size: 1.5em;
	line-height: 1.3;
}


/* Block: Base Margins ----------------------- */

*[class*="_inner-container"] > *:first-child {
	margin-top: 0;
}

*[class*="_inner-container"] > *:last-child {
	margin-bottom: 0;
}

.wp-block-archives:not(.alignwide):not(.alignfull),
.wp-block-categories:not(.alignwide):not(.alignfull),
.wp-block-code,
.wp-block-columns:not(.alignwide):not(.alignfull),
.wp-block-cover:not(.alignwide):not(.alignfull):not(.alignleft):not(.alignright):not(.aligncenter),
.wp-block-embed:not(.alignwide):not(.alignfull):not(.alignleft):not(.alignright):not(.aligncenter),
.wp-block-gallery:not(.alignwide):not(.alignfull):not(.alignleft):not(.alignright):not(.aligncenter),
.wp-block-group:not(.has-background):not(.alignwide):not(.alignfull),
.wp-block-image:not(.alignwide):not(.alignfull):not(.alignleft):not(.alignright):not(.aligncenter),
.wp-block-latest-comments:not(.aligncenter):not(.alignleft):not(.alignright),
.wp-block-latest-posts:not(.aligncenter):not(.alignleft):not(.alignright),
.wp-block-media-text:not(.alignwide):not(.alignfull),
.wp-block-preformatted,
.wp-block-pullquote:not(.alignwide):not(.alignfull):not(.alignleft):not(.alignright),
.wp-block-quote,
.wp-block-quote.is-large,
.wp-block-quote.is-style-large,
.wp-block-verse,
.wp-block-video:not(.alignwide):not(.alignfull) {
	margin-bottom: 3rem;
	margin-top: 3rem;
}


/* Block: Shared Nesting Alignment Resets ---- */

[class*="__inner-container"] .wp-block-group:not(.alignfull):not(.alignwide):not(.alignleft):not(.alignright),
[class*="__inner-container"] .wp-block-cover:not(.alignfull):not(.alignwide):not(.alignleft):not(.alignright) {
	margin-right: auto;
	margin-left: auto;
	max-width: 58rem;
}


/* Block: Shared Widget Styles --------------- */

.wp-block-archives,
.wp-block-categories,
.wp-block-latest-posts,
.wp-block-latest-comments {
	list-style: none;
	margin-right: 0;
}

.wp-block-archives ul,
.wp-block-categories ul,
.wp-block-latest-posts ul,
.wp-block-latest-comments ul {
	list-style: none;
}

.entry-content .wp-block-archives > li,
.entry-content .wp-block-categories > li,
.entry-content .wp-block-latest-posts > li,
.entry-content .wp-block-latest-comment > li {
	margin-right: 0;
}

.entry-content .wp-block-archives > li:last-child,
.entry-content .wp-block-categories > li:last-child,
.entry-content .wp-block-latest-posts > li:last-child,
.entry-content .wp-block-latest-comment > li:last-child {
	margin-bottom: 0;
}

.entry-content .wp-block-archives *,
.entry-content .wp-block-categories *,
.entry-content .wp-block-latest-posts *,
.entry-content .wp-block-latest-comments * {
	font-family: inherit;
}

.entry-content .wp-block-archives li,
.entry-content .wp-block-categories li,
.entry-content .wp-block-latest-posts li {
	color: #6d6d6d;
}

.wp-block-archives a,
.wp-block-categories a,
.wp-block-latest-posts a,
.wp-block-latest-comments a {
	font-weight: 700;
	text-decoration: none;
}

.wp-block-archives a:hover,
.wp-block-categories a:hover,
.wp-block-latest-posts a:hover,
.wp-block-latest-comments a:hover,
.wp-block-archives a:focus,
.wp-block-categories a:focus,
.wp-block-latest-posts a:focus,
.wp-block-latest-comments a:focus {
	text-decoration: underline;
}

.wp-block-latest-posts a,
.wp-block-latest-comments__comment-meta {
	font-weight: 700;
	letter-spacing: -0.025em;
	line-height: 1.25;
}

.wp-block-latest-comments__comment-date,
.wp-block-latest-posts__post-date {
	color: #6d6d6d;
	font-size: 0.7em;
	font-weight: 600;
	letter-spacing: normal;
	margin-top: 0.15em;
}


/* Block: Shared Media Styles ---------------- */

.wp-block-embed figcaption,
.wp-block-image figcaption {
	color: #6d6d6d;
	font-size: 1.4rem;
	margin-bottom: 0;
	margin-top: 1.5rem;
}

/* Block: Audio ------------------------------ */

.wp-block-audio audio {
	width: 100%;
}

/* Block: Button ----------------------------- */

.wp-block-button {
	margin: 3rem 0;
}

.wp-block-button.is-style-outline {
	color: #cd2653;
}

.is-style-outline .wp-block-button__link:not(.has-text-color) {
	color: inherit;
}

.is-style-outline .wp-block-button__link {
	padding: calc(1.1em - 0.2rem) calc(1.44em - 0.2rem);
}

/* Block: Columns ---------------------------- */

.wp-block-columns.alignfull,
.alignfull:not(.has-background) .wp-block-columns {
	padding-right: 2rem;
	padding-left: 2rem;
}

.wp-block-column {
	margin-bottom: 3.2rem;
}

.wp-block-column > *:first-child {
	margin-top: 0;
}

.wp-block-column > *:last-child {
	margin-bottom: 0;
}

/* Block: Cover ------------------------------ */

.wp-block-cover-image .wp-block-cover__inner-container,
.wp-block-cover .wp-block-cover__inner-container {
	width: calc(100% - 4rem);
	padding: 2rem 0;
}

.wp-block-cover-image .wp-block-cover-image-text,
.wp-block-cover-image .wp-block-cover-text,
.wp-block-cover-image h2,
.wp-block-cover .wp-block-cover-image-text,
.wp-block-cover .wp-block-cover-text,
.wp-block-cover h2 {
	max-width: 100%;
	padding: 0;
}

.wp-block-cover-image h2,
.wp-block-cover h2 {
	font-size: 3.2rem;
}

/* Block: Embed ------------------------------ */

/* Block: File ------------------------------- */

.wp-block-file {
	align-items: center;
	display: flex;
	flex-wrap: wrap;
	justify-content: space-between;
}

.wp-block-file a:not(.wp-block-file__button) {
	font-weight: 700;
	text-decoration: none;
}

.wp-block-file a:not(.wp-block-file__button):not(:last-child) {
	margin-left: 1rem;
}

.wp-block-file a:not(.wp-block-file__button):focus,
.wp-block-file a:not(.wp-block-file__button):hover {
	text-decoration: underline;
}

.wp-block-file .wp-block-file__button {
	font-size: 1.5rem;
	padding: 1em 1.25em;
}

.wp-block-file a.wp-block-file__button:visited {
	opacity: 1;
}

.wp-block-file a.wp-block-file__button:active,