ial-menu .menu-item {
	width: auto;
}

.menu-wrapper.is-animating .menu-item,
.menu-wrapper.is-animating .toggling-target {
	transition-duration: 250ms;
}

.menu-wrapper.is-animating .menu-item {
	transition-property: transform;
}

.menu-wrapper.is-toggling .toggling-target {
	display: block;
	position: absolute;
	top: 0;
	right: 0;
	opacity: 1;
}

.menu-wrapper.is-toggling .toggling-target.active {
	opacity: 0;
}

.menu-wrapper.is-animating.is-toggling .toggling-target {
	display: block;
	transition-property: opacity;
	opacity: 0;
}

.menu-wrapper.is-animating.is-toggling .toggling-target.active {
	opacity: 1;
}

.menu-wrapper.is-toggling .modal-menu > li:last-child li {
	border-top-color: transparent;
	border-bottom-width: 0.1rem;
}

@media (prefers-reduced-motion: reduce) {

	.menu-wrapper.is-animating .menu-item,
	.menu-wrapper.is-animating .toggling-target {
		transition-duration: 1ms !important;
	}

}


/* Expanded Menu ----------------------------- */

.expanded-menu {
	display: none;
}

.mobile-menu {
	display: block;
}


/* Menu Bottom ------------------------------- */

.menu-bottom {
	flex-shrink: 0;
	padding: 4rem 0;
}

.menu-bottom nav {
	width: 100%;
}

.menu-copyright {
	display: none;
	font-size: 1.6rem;
	font-weight: 500;
	margin: 0;
}

.menu-copyright a:focus,
.menu-copyright a:hover {
	text-decoration: underline;
}

.menu-bottom .social-menu {
	justify-content: center;
}


/* -------------------------------------------------------------------------- */

/*	6. Search Modal
/* -------------------------------------------------------------------------- */


.search-modal {
	background: rgba(0, 0, 0, 0.2);
	display: none;
	opacity: 0;
	position: fixed;
	bottom: 0;
	right: -9999rem;
	top: 0;
	transition: opacity 0.2s linear, right 0s 0.2s linear;
	width: 100%;
	z-index: 999;
}

.admin-bar .search-modal.active {
	top: 32px;
}

@media (max-width: 782px) {

	.admin-bar .search-modal.active {
		top: 46px;
	}
}

.search-modal-inner {
	background: #fff;
	transform: translateY(-100%);
	transition: transform 0.15s linear, box-shadow 0.15s linear;
}

.search-modal-inner .section-inner {
	display: flex;
	justify-content: space-between;
	max-width: 168rem;
}

.search-modal.active {
	right: 0;
	opacity: 1;
	transition: opacity 0.2s linear;
}

.search-modal.active .search-modal-inner {
	box-shadow: 0 0 2rem 0 rgba(0, 0, 0, 0.08);
	transform: translateY(0);
	transition: transform 0.25s ease-in-out, box-shadow 0.1s 0.25s linear;
}

button.search-untoggle {
	align-items: center;
	display: flex;
	flex-shrink: 0;
	justify-content: center;
	margin-left: -2.5rem;
	padding: 0 2.5rem;
}

.search-modal button.search-untoggle {
	color: inherit;
}

.search-modal.active .search-untoggle {
	animation: popIn both 0.3s 0.2s;
}

.search-untoggle svg {
	height: 1.5rem;
	transition: transform 0.15s ease-in-out;
	width: 1.5rem;
}

.search-untoggle:focus svg,
.search-untoggle:hover svg {
	transform: scale(1.15);
}


/* Modal Search Form ------------------------- */

.search-modal form {
	margin: 0;
	position: relative;
	width: 100%;
}

.search-modal .search-field {
	background: none;
	border: none;
	border-radius: 0;
	color: inherit;
	font-size: 2rem;
	letter-spacing: -0.0277em;
	height: 8.4rem;
	margin: 0 -2rem 0 0;
	max-width: calc(100% + 2rem);
	padding: 0 2rem 0 0;
	width: calc(100% + 2rem);
}

.search-modal .search-field::-webkit-input-placeholder {
	color: inherit;
}

.search-modal .search-field:-ms-input-placeholder {
	color: inherit;
}

.search-modal .search-field::-moz-placeholder {
	color: inherit;
	line-height: 4;
}

.search-modal .search-submit {
	position: absolute;
	left: -9999rem;
	top: 50%;
	transform: translateY(-50%);
}

.search-modal .search-submit:focus {
	left: 0;
}


/* -------------------------------------------------------------------------- */

/*	7a. Template: Cover Template
/* -------------------------------------------------------------------------- */


.cover-header {
	display: flex;
	overflow: hidden;
}

.cover-header-inner-wrapper {
	display: flex;
	position: relative;
	flex-direction: column;
	justify-content: flex-end;
	width: 100%;
}

.cover-header-inner {
	padding: 10rem 0 5rem 0;
	width: 100%;
}

.cover-color-overlay,
.cover-color-overlay::before {
	position: absolute;
	bottom: 0;
	right: 0;
	left: 0;
	top: 0;
}

.cover-color-overlay::before {
	background: currentColor;
	content: "";
	display: block;
}

.cover-header .entry-header {
	position: relative;
	width: 100%;
	z-index: 1;
}

.cover-header .entry-header * {
	color: #fff;
}

body.template-cover .entry-header {
	background: transparent;
	padding: 0;
}

.cover-header h1,
.cover-header h2,
.cover-header h3,
.cover-header h4,
.cover-header h5,
.cover-header h6,
.cover-header .faux-heading {
	color: inherit;
}

.cover-header .entry-header a {
	color: inherit;
}

/* To The Content ---------------------------- */

.to-the-content-wrapper {
	position: absolute;
	right: 0;
	left: 0;
	top: calc(100% + 0.5rem);
}

.to-the-content {
	align-items: center;
	display: flex;
	justify-content: center;
	height: 4rem;
	text-decoration: none;
}

.to-the-content svg {
	height: 2rem;
	transition: transform 0.15s linear;
	transform: translateY(0);
	width: 1.767rem;
}

.to-the-content:focus svg,
.to-the-content:hover svg {
	transform: translateY(20%);
}


/* -------------------------------------------------------------------------- */

/*	7c. Template: Full Width
/* -------------------------------------------------------------------------- */


body.template-full-width .entry-content > *:not(.alignwide):not(.alignfull):not(.alignleft):not(.alignright):not(.is-style-wide),
body.template-full-width [class*="__inner-container"] > *:not(.alignwide):not(.alignfull):not(.alignleft):not(.alignright):not(.is-style-wide) {
	max-width: 120rem;
}

body.template-full-width .entry-content .alignleft,
body.template-full-width .entry-content .alignright {
	position: static;
}

body.template-full-width .entry-content .alignleft,
body.template-full-width [class*="wp-block"].alignwide [class*="__inner-container"] > .alignleft,
body.template-full-width [class*="wp-block"].alignwide [class*="__inner-container"] > p .alignleft,
body.template-full-width [class*="wp-block"].alignwide [class*="__inner-container"] > .wp-block-image .alignleft {
	margin-left: 0;
	position: static;
}

body.template-full-width .entry-content > .alignleft,
body.template-full-width [class*="wp-block"].alignfull:not(.has-background) [class*="__inner-container"] > .alignleft,
body.template-full-width [class*="wp-block"].alignfull:not(.has-background) [class*="__inner-container"] > p .alignleft,
body.template-full-width [class*="wp-block"].alignfull:not(.has-background) [class*="__inner-container"] > .wp-block-image .alignleft {
	margin-left: 2rem;
	position: static;
}

body.template-full-width .entry-content .alignright,
body.template-full-width [class*="wp-block"].alignwide [class*="__inner-container"] > .alignright,
body.template-full-width [class*="wp-block"].alignwide [class*="__inner-container"] > p .alignright,
body.template-full-width [class*="wp-block"].alignwide [class*="__inner-container"] > .wp-block-image .alignright {
	margin-right: 0;
	position: static;
}

body.template-full-width .entry-content > .alignright,
body.template-full-width [class*="wp-block"].alignfull:not(.has-background) [class*="__inner-container"] > .alignright,
body.template-full-width [class*="wp-block"].alignfull:not(.has-background) [class*="__inner-container"] > p .alignright,
body.template-full-width [class*="wp-block"].alignfull:not(.has-background) [class*="__inner-container"] > .wp-block-image .alignright {
	margin-right: 2rem;
	position: static;
}


/* -------------------------------------------------------------------------- */

/*	8. Post: Archive
/* -------------------------------------------------------------------------- */


/* Archive Header ---------------------------- */

.archive-header {
	background-color: #fff;
	padding: 4rem 0;
}

.reduced-spacing .archive-header {
	padding-bottom: 2rem;
}

.archive-title {
	font-size: 2.4rem;
	font-weight: 700;
	letter-spacing: -0.026666667em;
	margin: 0;
}

.archive-subtitle p:last-child {
	margin-bottom: 0;
}


/* Posts ------------------------------------- */

body:not(.singular) main > article:first-of-type {
	padding: 4rem 0 0;
}


/* Search Results ---------------------------- */

.no-search-results-form {
	padding-top: 5rem;
}


/* -------------------------------------------------------------------------- */

/*	9. Post: Single
/* -------------------------------------------------------------------------- */


/* Post Header ------------------------------- */

.singular .entry-header {
	background-color: #fff;
	padding: 4rem 0;
}

.entry-categories {
	line-height: 1.25;
	margin-bottom: 2rem;
}

.entry-categories-inner {
	justify-content: center;
	display: flex;
	flex-wrap: wrap;
	margin: -0.5rem -1rem 0 0;
}

.entry-categories a {
	border-bottom: 0.15rem solid currentColor;
	font-size: 1.4rem;
	font-weight: 700;
	letter-spacing: 0.036666667em;
	margin: 0.5rem 1rem 0 0;
	text-decoration: none;
	text-transform: uppercase;
}

.entry-categories a:focus,
.entry-categories a:hover {
	border-bottom-color: transparent;