ay: none !important;
}

.cover-modal.show-modal {
	display: block;
	cursor: pointer;
}

.cover-modal.show-modal > * {
	cursor: default;
}


/* -------------------------------------------------------------------------- */

/*	4.	Site Header
/* -------------------------------------------------------------------------- */


#site-header {
	background: #fff;
	position: relative;
}

.header-inner {
	max-width: 168rem;
	padding: 3.15rem 0;
	z-index: 100;
}

/* Header Titles ----------------------------- */

.header-titles-wrapper {
	align-items: center;
	display: flex;
	justify-content: center;
	padding: 0 4rem;
	text-align: center;
}

body:not(.enable-search-modal) .header-titles-wrapper {
	justify-content: flex-start;
	padding-right: 0;
	text-align: right;
}

.site-title,
.site-logo,
.site-description {
	margin: 0;
}

.site-title {
	font-size: 2.1rem;
	font-weight: 600;
	line-height: 1;
}

.site-title a {
	color: inherit;
	display: block;
	text-decoration: none;
}

.site-title a:hover,
.site-title a:focus {
	text-decoration: underline;
}

.site-description {
	margin-top: 1rem;
	color: #6d6d6d;
	font-size: 1.8rem;
	font-weight: 500;
	display: none;
	letter-spacing: -0.0311em;
	transition: all 0.15s linear;
}

.site-logo a,
.site-logo img {
	display: block;
}

.header-titles .site-logo .site-logo {
	margin: 0;
}

.site-logo img {
	max-height: 6rem;
	margin: 0 auto;
	width: auto;
}

body:not(.enable-search-modal) .site-logo img {
	margin: 0;
}

/* Overlay Header ---------------------------- */

.overlay-header #site-header {
	background: transparent;
	margin: 0;
	position: absolute;
	right: 0;
	left: 0;
	top: 0;
	z-index: 2;
}

.overlay-header .header-inner {
	color: #fff;
}

.overlay-header .site-description,
.overlay-header .toggle {
	color: inherit;
}

.overlay-header .header-inner .toggle-wrapper::before {
	background-color: currentColor;
	opacity: 0.25;
}

.admin-bar.overlay-header #site-header {
	top: 32px;
}

@media (max-width: 782px) {

	.admin-bar.overlay-header #site-header {
		top: 46px;
	}
}

/* Header Navigation ------------------------- */

.header-navigation-wrapper {
	display: none;
}

/* Header Toggles ---------------------------- */

.header-toggles {
	display: none;
}

.header-inner .toggle {
	align-items: center;
	display: flex;
	overflow: visible;
	padding: 0 2rem;
}

.header-inner .toggle svg {
	display: block;
	position: relative;
	z-index: 1;
}

.header-inner .toggle path {
	fill: currentColor;
}

.toggle-inner {
	display: flex;
	justify-content: center;
	height: 2.3rem;
	position: relative;
}

.toggle-icon {
	display: block;
	overflow: hidden;
}

.toggle-inner .toggle-text {
	color: #6d6d6d;
	font-size: 1rem;
	font-weight: 600;
	position: absolute;
	top: calc(100% + 0.5rem);
	width: auto;
	white-space: nowrap;
	word-break: break-all;
}

.overlay-header .toggle-text {
	color: inherit;
}

.header-inner .toggle:focus .toggle-text,
.header-inner .toggle:hover .toggle-text {
	text-decoration: underline;
}

/* Search Toggle ----------------------------- */

.search-toggle {
	position: absolute;
	bottom: 0;
	right: 0;
	top: 0;
}

.search-toggle .toggle-icon,
.search-toggle svg {
	height: 2.5rem;
	max-width: 2.3rem;
	width: 2.3rem;
}

/* Navigation Toggle ------------------------- */

.nav-toggle {
	position: absolute;
	bottom: 0;
	left: 0;
	top: 0;
	width: 6.6rem;
}

.nav-toggle .toggle-icon,
.nav-toggle svg {
	height: 0.8rem;
	width: 2.6rem;
}

.nav-toggle .toggle-inner {
	padding-top: 0.8rem;
}

/* Primary Menu ---------------------------- */

.primary-menu-wrapper {
	display: none;
}

ul.primary-menu {
	display: flex;
	font-size: 1.8rem;
	font-weight: 500;
	letter-spacing: -0.0277em;
	flex-wrap: wrap;
	justify-content: flex-end;
	margin: -0.8rem -1.6rem 0 0;
}

.primary-menu .icon {
	display: block;
	height: 0.7rem;
	position: absolute;
	pointer-events: none;
	transform: rotate(45deg);
	width: 1.3rem;
}

.primary-menu .icon::before,
.primary-menu .icon::after {
	content: "";
	display: block;
	background-color: currentColor;
	position: absolute;
	bottom: calc(50% - 0.1rem);
	right: 0;
}

.primary-menu .icon::before {
	height: 0.9rem;
	width: 0.2rem;
}

.primary-menu .icon::after {
	height: 0.2rem;
	width: 0.9rem;
}

.primary-menu li {
	font-size: inherit;
	line-height: 1.25;
	position: relative;
}

.primary-menu > li {
	margin: 0.8rem 1.6rem 0 0;
}

.primary-menu > li.menu-item-has-children > a {
	padding-left: 2rem;
}

.primary-menu > li > .icon {
	left: -0.5rem;
	top: calc(50% - 0.4rem);
}

.primary-menu a {
	color: inherit;
	display: block;
	line-height: 1.2;
	text-decoration: none;
	word-break: normal;
	word-wrap: normal;
}

.primary-menu a:hover,
.primary-menu a:focus,
.primary-menu .current_page_ancestor {
	text-decoration: underline;
}

.primary-menu li.current-menu-item > a,
.primary-menu li.current-menu-item > .link-icon-wrapper > a {
	text-decoration: underline;
}

.primary-menu li.current-menu-item > a:hover,
.primary-menu li.current-menu-item > .link-icon-wrapper > a:hover,
.primary-menu li.current-menu-item > a:focus,
.primary-menu li.current-menu-item > .link-icon-wrapper > a:focus {
	text-decoration: none;
}

/* SUB MENU */

.primary-menu ul {
	background: #000;
	border-radius: 0.4rem;
	color: #fff;
	font-size: 1.7rem;
	opacity: 0;
	padding: 1rem 0;
	position: absolute;
	left: 9999rem;
	top: calc(100% + 2rem);
	transition: opacity 0.15s linear, transform 0.15s linear, left 0s 0.15s;
	transform: translateY(0.6rem);
	width: 20rem;
	z-index: 1;
}

.primary-menu li.menu-item-has-children:hover > ul,
.primary-menu li.menu-item-has-children:focus > ul,
.primary-menu li.menu-item-has-children.focus > ul {
	left: 0;
	opacity: 1;
	transform: translateY(0);
	transition: opacity 0.15s linear, transform 0.15s linear;
}

.primary-menu ul::before,
.primary-menu ul::after {
	content: "";
	display: block;
	position: absolute;
	bottom: 100%;
}

.primary-menu ul::before {
	height: 2rem;
	right: 0;
	left: 0;
}

.primary-menu ul::after {
	border: 0.8rem solid transparent;
	border-bottom-color: #000;
	left: 1.8rem;
}

.primary-menu ul a {
	background: transparent;
	border: none;
	color: inherit;
	display: block;
	padding: 1rem 2rem;
	transition: background-color 0.15s linear;
	width: 100%;
}

.primary-menu ul li.menu-item-has-children > a {
	padding-left: 4.5rem;
}

.primary-menu ul li.menu-item-has-children .icon {
	position: absolute;
	left: 1.5rem;
	top: calc(50% - 0.5rem);
}

/* DEEP DOWN */

.primary-menu ul ul {
	top: -1rem;
}

.primary-menu ul li.menu-item-has-children:hover > ul,
.primary-menu ul li.menu-item-has-children:focus > ul,
.primary-menu ul li.menu-item-has-children.focus > ul {
	left: calc(100% + 2rem);
}

.primary-menu ul ul::before {
	bottom: 0;
	height: auto;
	right: auto;
	left: -2rem;
	top: 0;
	width: 2rem;
}

.primary-menu ul ul::after {
	border-bottom-color: transparent;
	border-left-color: #000;
	bottom: auto;
	left: -1.6rem;
	top: 2rem;
}

.rtl .primary-menu ul ul::after {
	transform: rotate(-180deg);
}

/*
 * Enable nav submenu expansion with tapping on arrows on large-viewport
 * touch interfaces (e.g. tablets or laptops with touch screens).
 * These rules are supported by all browsers (>IE11) and when JS is disabled.
 */
@media (any-pointer: coarse) {

	.primary-menu > li.menu-item-has-children > a {
		padding-left: 0;
		margin-left: 2rem;
	}

	.primary-menu ul li.menu-item-has-children > a {
		margin-left: 4.5rem;
		padding-left: 0;
		width: unset;
	}

}

/* Repeat previous rules for IE11 (when JS enabled for polyfill). */
body.touch-enabled .primary-menu > li.menu-item-has-children > a {
	padding-left: 0;
	margin-left: 2rem;
}

body.touch-enabled .primary-menu ul li.menu-item-has-children > a {
	margin-left: 4.5rem;
	padding-left: 0;
	width: unset;
}

/* -------------------------------------------------------------------------- */

/*	5. Menu Modal
/* -------------------------------------------------------------------------- */


.menu-modal {
	background: #fff;
	display: none;
	opacity: 0;
	overflow-y: auto;
	overflow-x: hidden;
	position: fixed;
	bottom: 0;
	right: -99999rem;
	left: 99999rem;
	top: 0;
	transition: opacity 0.25s ease-in, right 0s 0.25s, left 0s 0.25s;
	z-index: 99;
}

.admin-bar .menu-modal {
	top: 32px;
}

@media (max-width: 782px) {

	.admin-bar .menu-modal {
		top: 46px;
	}
}

.menu-modal.show-modal {
	display: flex;
}

.menu-modal.active {
	right: 0;
	opacity: 1;
	left: 0;
	transition: opacity 0.25s ease-out;
}

.menu-modal-inner {
	background: #fff;
	display: flex;
	justify-content: stretch;
	overflow: auto;
	-ms-overflow-style: auto;
	width: 100%;
}

.menu-wrapper {
	display: flex;
	flex-direction: column;
	justify-content: space-between;
	position: relative;
}

button.close-nav-toggle {
	align-items: center;
	display: flex;
	font-size: 1.6rem;
	font-weight: 500;
	justify-content: flex-end;
	padding: 3.1rem 0;
	width: 100%;
}

button.close-nav-toggle svg {
	height: 1.6rem;
	width: 1.6rem;
}

button.close-nav-toggle .toggle-text {
	margin-left: 1.6rem;
}

.menu-modal .menu-top {
	flex-shrink: 0;
}


/* Main Menu --------------------------------- */

.modal-menu {
	position: relative;
	right: calc(50% - 50vw);
	width: 100vw;
}

.modal-menu li {
	border-color: #dedfdf;
	border-style: solid;
	border-width: 0.1rem 0 0 0;
	display: flex;
	flex-wrap: wrap;
	line-height: 1;
	justify-content: flex-start;
	margin: 0;
}

.modal-menu > li > a,
.modal-menu > li > .ancestor-wrapper > a {
	font-size: 2rem;
	font-weight: 700;
	letter-spacing: -0.0375em;
}

.modal-menu > li:last-child {
	border-bottom-width: 0.1rem;
}

.modal-menu .ancestor-wrapper {
	display: flex;
	justify-content: space-between;
	width: 100%;
}

.modal-menu a {
	display: block;
	padding: 2rem 2.5rem;
	text-decoration: none;
	width: 100%;
}

.modal-menu a:focus,
.modal-menu a:hover,
.modal-menu li.current-menu-item > .ancestor-wrapper > a,
.modal-menu li.current_page_ancestor > .ancestor-wrapper > a {
	text-decoration: u