om cascading too deeply
 * - helps with plugin compatibility
 */
.entry .entry-content .entry-content,
.entry .entry-content .entry-summary,
.entry .entry-content .entry,
.entry .entry-summary .entry-content,
.entry .entry-summary .entry-summary,
.entry .entry-summary .entry {
  margin: inherit;
  max-width: inherit;
  padding: inherit;
}

@media only screen and (min-width: 768px) {
  .entry .entry-content .entry-content,
  .entry .entry-content .entry-summary,
  .entry .entry-content .entry,
  .entry .entry-summary .entry-content,
  .entry .entry-summary .entry-summary,
  .entry .entry-summary .entry {
    margin: inherit;
    max-width: inherit;
    padding: inherit;
  }
}

.entry .entry-content p.has-background {
  padding: 20px 30px;
}

.entry .entry-content .wp-block-audio {
  width: 100%;
}

.entry .entry-content .wp-block-audio audio {
  width: 100%;
}

.entry .entry-content .wp-block-audio.alignleft audio,
.entry .entry-content .wp-block-audio.alignright audio {
  max-width: 198px;
}

@media only screen and (min-width: 768px) {
  .entry .entry-content .wp-block-audio.alignleft audio,
  .entry .entry-content .wp-block-audio.alignright audio {
    max-width: 384px;
  }
}

@media only screen and (min-width: 1379px) {
  .entry .entry-content .wp-block-audio.alignleft audio,
  .entry .entry-content .wp-block-audio.alignright audio {
    max-width: 385.44px;
  }
}

.entry .entry-content .wp-block-video video {
  width: 100%;
}

.entry .entry-content .wp-block-button .wp-block-button__link {
  transition: background 150ms ease-in-out;
  border: none;
  font-size: 0.88889em;
  font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", "Roboto", "Oxygen", "Ubuntu", "Cantarell", "Fira Sans", "Droid Sans", "Helvetica Neue", sans-serif;
  line-height: 1.2;
  box-sizing: border-box;
  font-weight: bold;
  text-decoration: none;
  padding: 0.76rem 1rem;
  outline: none;
  outline: none;
}

.entry .entry-content .wp-block-button .wp-block-button__link:not(.has-background) {
  background-color: #0073aa;
}

.entry .entry-content .wp-block-button .wp-block-button__link:not(.has-text-color) {
  color: white;
}

.entry .entry-content .wp-block-button .wp-block-button__link:hover {
  color: white;
  background: #111;
  cursor: pointer;
}

.entry .entry-content .wp-block-button .wp-block-button__link:focus {
  color: white;
  background: #111;
  outline: thin dotted;
  outline-offset: -4px;
}

.entry .entry-content .wp-block-button:not(.is-style-squared) .wp-block-button__link {
  border-radius: 5px;
}

.entry .entry-content .wp-block-button.is-style-outline .wp-block-button__link,
.entry .entry-content .wp-block-button.is-style-outline .wp-block-button__link:focus,
.entry .entry-content .wp-block-button.is-style-outline .wp-block-button__link:active {
  transition: all 150ms ease-in-out;
  border-width: 2px;
  border-style: solid;
}

.entry .entry-content .wp-block-button.is-style-outline .wp-block-button__link:not(.has-background),
.entry .entry-content .wp-block-button.is-style-outline .wp-block-button__link:focus:not(.has-background),
.entry .entry-content .wp-block-button.is-style-outline .wp-block-button__link:active:not(.has-background) {
  background: transparent;
}

.entry .entry-content .wp-block-button.is-style-outline .wp-block-button__link:not(.has-text-color),
.entry .entry-content .wp-block-button.is-style-outline .wp-block-button__link:focus:not(.has-text-color),
.entry .entry-content .wp-block-button.is-style-outline .wp-block-button__link:active:not(.has-text-color) {
  color: #0073aa;
  border-color: currentColor;
}

.entry .entry-content .wp-block-button.is-style-outline .wp-block-button__link:hover {
  color: white;
  border-color: #111;
}

.entry .entry-content .wp-block-button.is-style-outline .wp-block-button__link:hover:not(.has-background) {
  color: #111;
}

.entry .entry-content .wp-block-archives,
.entry .entry-content .wp-block-categories,
.entry .entry-content .wp-block-latest-posts {
  padding: 0;
  list-style: none;
}

.entry .entry-content .wp-block-archives li > a,
.entry .entry-content .wp-block-categories li > a,
.entry .entry-content .wp-block-latest-posts li > a {
  font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", "Roboto", "Oxygen", "Ubuntu", "Cantarell", "Fira Sans", "Droid Sans", "Helvetica Neue", sans-serif;
  font-size: calc(22px * 1.125);
  font-weight: bold;
  line-height: 1.2;
  text-decoration: none;
}

.entry .entry-content .wp-block-archives.aligncenter,
.entry .entry-content .wp-block-categories.aligncenter {
  text-align: center;
}

.entry .entry-content .wp-block-categories ul {
  padding-top: 0.75rem;
}

.entry .entry-content .wp-block-categories li ul {
  list-style: none;
  padding-right: 0;
}

.entry .entry-content .wp-block-categories ul {
  counter-reset: submenu;
}

.entry .entry-content .wp-block-categories ul > li > a::before {
  font-family: "NonBreakingSpaceOverride", "Hoefler Text", Garamond, "Times New Roman", serif;
  font-weight: normal;
  content: "– " counters(submenu, "– ", none);
  counter-increment: submenu;
}

.entry .entry-content .wp-block-latest-posts .wp-block-latest-posts__post-date {
  font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", "Roboto", "Oxygen", "Ubuntu", "Cantarell", "Fira Sans", "Droid Sans", "Helvetica Neue", sans-serif;
  font-size: 0.71111em;
  color: #767676;
  line-height: 1.2;
}

.entry .entry-content .wp-block-latest-posts .wp-block-latest-posts__post-full-content,
.entry .entry-content .wp-block-latest-posts .wp-block-latest-posts__post-excerpt {
  margin-top: 1rem;
  margin-bottom: 1rem;
}

.entry .entry-content .wp-block-latest-posts li {
  padding-bottom: 0.5rem;
}

.entry .entry-content .wp-block-latest-posts li.menu-item-has-children, .entry .entry-content .wp-block-latest-posts li:last-child {
  padding-bottom: 0;
}

.entry .entry-content .wp-block-latest-posts li :not(:last-child) .wp-block-latest-posts__post-excerpt {
  padding-bottom: 0.5rem;
}

.entry .entry-content .wp-block-latest-posts.is-grid li {
  border-top: 2px solid #ccc;
  padding-top: 1rem;
  margin-bottom: 2rem;
}

.entry .entry-content .wp-block-latest-posts.is-grid li a:after {
  content: '';
}

.entry .entry-content .wp-block-latest-posts.is-grid li:last-child {
  margin-bottom: auto;
}

.entry .entry-content .wp-block-latest-posts.is-grid li:last-child a:after {
  content: '';
}

.entry .entry-content .wp-block-preformatted {
  font-size: 0.71111em;
  line-height: 1.8;
  padding: 1rem;
}

.entry .entry-content .wp-block-verse {
  font-family: "NonBreakingSpaceOverride", "Hoefler Text", Garamond, "Times New Roman", serif;
  font-size: 22px;
  line-height: 1.8;
}

.entry .entry-content .has-drop-cap:not(:focus):first-letter {
  font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", "Roboto", "Oxygen", "Ubuntu", "Cantarell", "Fira Sans", "Droid Sans", "Helvetica Neue", sans-serif;
  font-size: 3.375em;
  line-height: 1;
  font-weight: bold;
  margin: 0 0 0 0.25em;
}

@-moz-document url-prefix() {
  .entry .entry-content .has-drop-cap:not(:focus):first-letter {
    margin-top: 0.2em;
  }
}

.entry .entry-content .wp-block-pullquote {
  border-color: transparent;
  border-width: 2px;
  padding: 1rem;
}

.entry .entry-content .wp-block-pullquote blockquote {
  color: #111;
  border: none;
  margin-top: calc(4 * 1rem);
  margin-bottom: calc(4.33 * 1rem);
  margin-left: 0;
  padding-right: 0;
}

.entry .entry-content .wp-block-pullquote p {
  font-size: 1.6875em;
  font-style: italic;
  line-height: 1.3;
  margin-bottom: 0.5em;
  margin-top: 0.5em;
}

.entry .entry-content .wp-block-pullquote p em {
  font-style: normal;
}

@media only screen and (min-width: 768px) {
  .entry .entry-content .wp-block-pullquote p {
    font-size: 2.25em;
  }
}

.entry .entry-content .wp-block-pullquote cite {
  display: inline-block;
  font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", "Roboto", "Oxygen", "Ubuntu", "Cantarell", "Fira Sans", "Droid Sans", "Helvetica Neue", sans-serif;
  line-height: 1.6;
  text-transform: none;
  color: #767676;
  /*
			 * This requires a rem-based font size calculation instead of our normal em-based one,
			 * because the cite tag sometimes gets wrapped in a p tag. This is equivalent to $font-size_xs.
			 */
  font-size: calc(1rem / (1.25 * 1.125));
}

.entry .entry-content .wp-block-pullquote.alignleft, .entry .entry-content .wp-block-pullquote.alignright {
  width: 100%;
  padding: 0;
}

.entry .entry-content .wp-block-pullquote.alignleft blockquote, .entry .entry-content .wp-block-pullquote.alignright blockquote {
  margin: 1rem 0;
  padding: 0;
  text-align: right;
  max-width: 100%;
}

.entry .entry-content .wp-block-pullquote.alignleft blockquote p:first-child, .entry .entry-content .wp-block-pullquote.alignright blockquote p:first-child {
  margin-top: 0;
}

.entry .entry-content .wp-block-pullquote.is-style-solid-color {
  background-color: #0073aa;
  padding-right: 0;
  padding-left: 0;
}

@media only screen and (min-width: 768px) {
  .entry .entry-content .wp-block-pullquote.is-style-solid-color {
    padding-right: 10%;
    padding-left: 10%;
  }
}

.entry .entry-content .wp-block-pullquote.is-style-solid-color p {
  font-size: 1.6875em;
  line-height: 1.3;
  margin-bottom: 0.5em;
  margin-top: 0.5em;
}

@media only screen and (min-width: 768px) {
  .entry .entry-content .wp-block-pullquote.is-style-solid-color p {
    font-size: 2.25em;
  }
}

.entry .entry-content .wp-block-pullquote.is-style-solid-color a {
  color: #fff;
}

.entry .entry-content .wp-block-pullquote.is-style-solid-color cite {
  color: inherit;
}

.entry .entry-content .wp-block-pullquote.is-style-solid-color blockquote {
  max-width: 100%;
  color: #fff;
  padding-right: 0;
  margin-right: 1rem;
  margin-left: 1rem;
}

.entry .entry-content .wp-block-pullquote.is-style-solid-color blockquote.has-text-color p,
.entry .entry-content .wp-block-pullquote.is-style-solid-color blockquote.has-text-color a, .entry .entry-content .wp-block-pullquote.is-style-solid-color blockquote.has-primary-color, .entry .entry-content .wp-block-pullquote.is-style-solid-color blockquote.has-secondary-color, .entry .entry-content .wp-block-pullquote.is-style-solid-color blockquote.has-dark-gray-color, .entry .entry-content .wp-block-pullquote.is-style-solid-color blockquote.has-light-gray-color, .entry .entry-content .wp-block-pullquote.is-style-solid-color blockquote.has-white-color {
  color: inherit;
}

@media only screen and (min-width: 768px) {
  .entry .entry-content .wp-block-pullquote.is-style-solid-color blockquote {
    margin-right: 0;
    margin-left: 0;
  }
}

@media only screen and (min-width: 768px) {
  .entry .entry-content .wp-block-pullquote.is-style-solid-color.alignright, .entry .entry-content .wp-block-pullquote.is-style-solid-color.alignleft {
    padding: 1rem calc(2 * 1rem);
  }
}

@media only screen and (min-width: 768px) {
  .entry .entry-content .wp-block-pullquote.is-style-solid-color.alignfull {
    padding-right: calc(10% + 58px + (2 * 1rem));
    padding-left: calc(10% + 58px + (2 * 1rem));
  }
}

.entry .entry-content .wp-block-quote:not(.is-large), .entry .entry-content .wp-block-quote:not(.is-style-large) {
  border-width: 2px;
  border-color: #0073aa;
  padding-top: 0;
  padding-bottom: 0;
}

.entry .entry-content .wp-block-quote p {
  font-size: 1em;
  font-style: normal;
  line-height: 1.8;
}

.entry .entry-content .wp-block-quote cite {
  /*
			 * This requires a rem-based font size calculation instead of our normal em-based one,
			 * because the cite tag sometimes gets wrapped in a p tag. This is equivalent to $font-size_xs.
			 */
  font-size: calc(1rem / (1.25 * 1.125));
}

.entry .entry-content .wp-block-quote.is-large, .entry .entry-content .wp-block-quote.is-style-large {
  margin: 1rem 0;
  padding: 0;
  border-right: none;
}

.entry .entry-content .wp-block-quote.is-large p, .entry .entry-content .wp-block-quote.is-style-large p {
  font-size: 1.6875em;
  line-height: 1.4;
  font-style: italic;
}

.entry .entry-content .wp-block-quote.is-large cite,
.entry .entry-content .wp-block-quote.is-large footer, .entry .entry-content .wp-block-quote.is-style-large cite,
.entry .entry-content .wp-block-quote.is-style-large footer {
  /*
				 * This requires a rem-based font size calculation instead of our normal em-based one,
				 * because the cite tag sometimes gets wrapped in a p tag. This is equivalent to $font-size_xs.
				 */
  font-size: calc(1rem / (1.25 * 1.125));
}

@media only screen and (min-width: 768px) {
  .entry .entry-content .wp-block-quote.is-large, .entry .entry-content .wp-block-quote.is-style-large {
