background-color,
.has-light-gray-background-color {
  color: #fff;
}

.has-primary-background-color p,
.has-primary-background-color h1,
.has-primary-background-color h2,
.has-primary-background-color h3,
.has-primary-background-color h4,
.has-primary-background-color h5,
.has-primary-background-color h6,
.has-primary-background-color a,
.has-secondary-background-color p,
.has-secondary-background-color h1,
.has-secondary-background-color h2,
.has-secondary-background-color h3,
.has-secondary-background-color h4,
.has-secondary-background-color h5,
.has-secondary-background-color h6,
.has-secondary-background-color a,
.has-dark-gray-background-color p,
.has-dark-gray-background-color h1,
.has-dark-gray-background-color h2,
.has-dark-gray-background-color h3,
.has-dark-gray-background-color h4,
.has-dark-gray-background-color h5,
.has-dark-gray-background-color h6,
.has-dark-gray-background-color a,
.has-light-gray-background-color p,
.has-light-gray-background-color h1,
.has-light-gray-background-color h2,
.has-light-gray-background-color h3,
.has-light-gray-background-color h4,
.has-light-gray-background-color h5,
.has-light-gray-background-color h6,
.has-light-gray-background-color a {
  color: #fff;
}

.has-white-background-color {
  color: #111;
}

.has-white-background-color p,
.has-white-background-color h1,
.has-white-background-color h2,
.has-white-background-color h3,
.has-white-background-color h4,
.has-white-background-color h5,
.has-white-background-color h6,
.has-white-background-color a {
  color: #111;
}

figcaption,
.gallery-caption {
  font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", "Roboto", "Oxygen", "Ubuntu", "Cantarell", "Fira Sans", "Droid Sans", "Helvetica Neue", sans-serif;
  font-size: 0.71111em;
  line-height: 1.6;
  color: #767676;
}

/** === Post Title === */
.editor-post-title__block {
  width: 100%;
}

.editor-post-title__block:before {
  background: #767676;
  content: "\020";
  display: block;
  height: 2px;
  margin: 1rem 0;
  width: 1em;
}

.editor-post-title__block.has-text-align-center:before {
  margin-left: auto;
  margin-right: auto;
}

.editor-post-title__block.has-text-align-right:before {
  margin-left: auto;
}

.editor-post-title__block:before {
  width: 2.8125em;
  margin-top: 0;
  margin-bottom: 0;
  margin-left: 1rem;
  position: relative;
  top: 0.5em;
}

@media only screen and (min-width: 600px) {
  .editor-post-title__block:before {
    margin-left: 0;
  }
}

.editor-post-title__block .editor-post-title__input {
  font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", "Roboto", "Oxygen", "Ubuntu", "Cantarell", "Fira Sans", "Droid Sans", "Helvetica Neue", sans-serif;
  font-size: 2.8125em;
  font-weight: 700;
}

/** === Default Appender === */
.block-editor-default-block-appender textarea.block-editor-default-block-appender__content {
  font-family: "NonBreakingSpaceOverride", "Hoefler Text", Garamond, "Times New Roman", serif;
  font-size: 22px;
}

/** === Heading === */
.wp-block-heading strong {
  font-weight: bolder;
}

/** === Paragraph === */
.wp-block-paragraph.has-drop-cap:not(:focus)::first-letter {
  font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", "Roboto", "Oxygen", "Ubuntu", "Cantarell", "Fira Sans", "Droid Sans", "Helvetica Neue", sans-serif;
  font-size: 3.375em;
  line-height: 1;
  font-weight: bold;
  margin: 0 0.25em 0 0;
}

@-moz-document url-prefix() {
  .wp-block-paragraph.has-drop-cap:not(:focus)::first-letter {
    margin-top: 0.2em;
  }
}

/** === Table === */
.wp-block-table {
  font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", "Roboto", "Oxygen", "Ubuntu", "Cantarell", "Fira Sans", "Droid Sans", "Helvetica Neue", sans-serif;
}

/** === Cover === */
.wp-block-cover h2,
.wp-block-cover .wp-block-cover-text {
  font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", "Roboto", "Oxygen", "Ubuntu", "Cantarell", "Fira Sans", "Droid Sans", "Helvetica Neue", sans-serif;
  font-size: 1.6875em;
  font-weight: bold;
  line-height: 1.4;
  padding-left: 1rem;
  padding-right: 1rem;
}

.wp-block-cover h2 strong,
.wp-block-cover .wp-block-cover-text strong {
  font-weight: bolder;
}

@media only screen and (min-width: 768px) {
  .wp-block-cover h2,
  .wp-block-cover .wp-block-cover-text {
    margin-left: auto;
    margin-right: auto;
    padding: 0;
  }
}

@media only screen and (min-width: 768px) {
  .wp-block-cover {
    padding-left: 10%;
    padding-right: 10%;
  }
  .wp-block-cover h2,
  .wp-block-cover .wp-block-cover-text {
    font-size: 2.25em;
  }
}

.wp-block[data-type="core/cover"][data-align="left"] .editor-block-list__block-edit,
.wp-block[data-type="core/cover"][data-align="right"] .editor-block-list__block-edit {
  width: calc(4 * (100vw / 12));
}

.wp-block[data-type="core/cover"][data-align="left"] .wp-block-cover,
.wp-block[data-type="core/cover"][data-align="right"] .wp-block-cover {
  width: 100%;
  max-width: 100%;
  padding: calc(1.375 * 1rem);
}

.wp-block[data-type="core/cover"][data-align="left"] .wp-block-cover p,
.wp-block[data-type="core/cover"][data-align="right"] .wp-block-cover p {
  padding-left: 0;
  padding-right: 0;
}

@media only screen and (min-width: 768px) {
  .wp-block[data-type="core/cover"][data-align="left"] .wp-block-cover,
  .wp-block[data-type="core/cover"][data-align="right"] .wp-block-cover {
    padding: calc(2.75 * 1rem) calc(2.75 * 1rem) calc(3.125 * 1rem);
  }
}

@media only screen and (min-width: 768px) {
  .wp-block[data-type="core/cover"][data-align="wide"] h2,
  .wp-block[data-type="core/cover"][data-align="wide"] .wp-block-cover-text,
  .wp-block[data-type="core/cover"][data-align="full"] h2,
  .wp-block[data-type="core/cover"][data-align="full"] .wp-block-cover-text {
    max-width: calc(8 * (100vw / 12));
  }
}

@media only screen and (min-width: 1168px) {
  .wp-block[data-type="core/cover"][data-align="wide"] h2,
  .wp-block[data-type="core/cover"][data-align="wide"] .wp-block-cover-text,
  .wp-block[data-type="core/cover"][data-align="full"] h2,
  .wp-block[data-type="core/cover"][data-align="full"] .wp-block-cover-text {
    max-width: calc(6 * (100vw / 12));
  }
}

@media only screen and (min-width: 768px) {
  .wp-block[data-type="core/cover"][data-align="full"] .wp-block-cover {
    padding-left: calc(10% + 64px);
    padding-right: calc(10% + 64px);
  }
}

/** === Gallery === */
.wp-block-gallery .blocks-gallery-image figcaption,
.wp-block-gallery .blocks-gallery-item figcaption,
.wp-block-gallery .gallery-item .gallery-caption {
  font-size: 0.71111em;
  line-height: 1.6;
}

/** === Button === */
.wp-block-button .wp-block-button__link {
  line-height: 1.8;
  font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", "Roboto", "Oxygen", "Ubuntu", "Cantarell", "Fira Sans", "Droid Sans", "Helvetica Neue", sans-serif;
  font-size: 0.88889em;
  font-weight: bold;
}

.wp-block-button:not(.is-style-outline) .wp-block-button__link {
  background: #0073aa;
}

.wp-block-button:not(.is-style-squared) .wp-block-button__link {
  border-radius: 5px;
}

.wp-block-button.is-style-outline, .wp-block-button.is-style-outline:hover, .wp-block-button.is-style-outline:focus, .wp-block-button.is-style-outline:active {
  background: transparent;
  color: #0073aa;
}

.wp-block-button.is-style-outline .wp-block-button__link, .wp-block-button.is-style-outline:hover .wp-block-button__link, .wp-block-button.is-style-outline:focus .wp-block-button__link, .wp-block-button.is-style-outline:active .wp-block-button__link {
  background: transparent;
}

.wp-block-button.is-style-outline .wp-block-button__link:not(.has-text-color), .wp-block-button.is-style-outline:hover .wp-block-button__link:not(.has-text-color), .wp-block-button.is-style-outline:focus .wp-block-button__link:not(.has-text-color), .wp-block-button.is-style-outline:active .wp-block-button__link:not(.has-text-color) {
  color: #0073aa;
}

/** === Blockquote === */
.wp-block-quote:not(.is-large):not(.is-style-large) {
  border-width: 2px;
  border-color: #0073aa;
}

.wp-block-quote.is-large, .wp-block-quote.is-style-large {
  margin-top: 2.8125em;
  margin-bottom: 2.8125em;
}

.wp-block-quote.is-large p,
.wp-block-quote.is-style-large p {
  font-size: 1.6875em;
  line-height: 1.3;
  margin-bottom: 0.5em;
  margin-top: 0.5em;
}

.wp-block-quote cite,
.wp-block-quote footer,
.wp-block-quote .wp-block-quote__citation {
  font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", "Roboto", "Oxygen", "Ubuntu", "Cantarell", "Fira Sans", "Droid Sans", "Helvetica Neue", sans-serif;
  font-size: 0.71111em;
  line-height: 1.6;
  color: #767676;
}

/** === Pullquote === */
.wp-block-pullquote {
  border-color: transparent;
  border-width: 2px;
  color: #000;
}

.wp-block-pullquote blockquote {
  margin-top: calc(3 * 1rem);
  margin-bottom: calc(3.33 * 1rem);
  hyphens: auto;
  word-break: break-word;
}

.wp-block-pullquote:not(.is-style-solid-color) .wp-block-pullquote__citation {
  color: #767676;
}

.wp-block-pullquote.is-style-solid-color blockquote {
  width: calc(100% - (2 * 1rem));
  max-width: calc( 100% - (2 * 1rem));
}

.wp-block-pullquote.is-style-solid-color blockquote a,
.wp-block-pullquote.is-style-solid-color blockquote.has-text-color p,
.wp-block-pullquote.is-style-solid-color blockquote.has-text-color a {
  color: inherit;
}

.wp-block-pullquote.is-style-solid-color blockquote:not(.has-text-color) {
  color: #fff;
}

@media only screen and (min-width: 768px) {
  .wp-block-pullquote.is-style-solid-color blockquote {
    max-width: 80%;
  }
}

.wp-block-pullquote.is-style-solid-color:not(.has-background-color) {
  background-color: #0073aa;
}

.wp-block[data-type="core/pullquote"] blockquote > .block-library-pullquote__content .editor-rich-text__tinymce[data-is-empty="true"]::before,
.wp-block[data-type="core/pullquote"] blockquote > .editor-rich-text p,
.wp-block[data-type="core/pullquote"] p,
.wp-block[data-type="core/pullquote"][data-align="left"] blockquote > .block-library-pullquote__content .editor-rich-text__tinymce[data-is-empty="true"]::before,
.wp-block[data-type="core/pullquote"][data-align="left"] blockquote > .editor-rich-text p,
.wp-block[data-type="core/pullquote"][data-align="left"] p,
.wp-block[data-type="core/pullquote"][data-align="right"] blockquote > .block-library-pullquote__content .editor-rich-text__tinymce[data-is-empty="true"]::before,
.wp-block[data-type="core/pullquote"][data-align="right"] blockquote > .editor-rich-text p,
.wp-block[data-type="core/pullquote"][data-align="right"] p {
  font-size: 1.6875em;
  font-style: italic;
  line-height: 1.3;
  margin-bottom: 0.5em;
  margin-top: 0.5em;
}

@media only screen and (min-width: 768px) {
  .wp-block[data-type="core/pullquote"] blockquote > .block-library-pullquote__content .editor-rich-text__tinymce[data-is-empty="true"]::before,
  .wp-block[data-type="core/pullquote"] blockquote > .editor-rich-text p,
  .wp-block[data-type="core/pullquote"] p,
  .wp-block[data-type="core/pullquote"][data-align="left"] blockquote > .block-library-pullquote__content .editor-rich-text__tinymce[data-is-empty="true"]::before,
  .wp-block[data-type="core/pullquote"][data-align="left"] blockquote > .editor-rich-text p,
  .wp-block[data-type="core/pullquote"][data-align="left"] p,
  .wp-bl