
	color: inherit;
	font-weight: 500;
}

/* Main menu animation ----------------------- */

.menu-wrapper .menu-item {
	position: relative;
}

.menu-wrapper .active {
	display: block;
}

.menu-wrapper.is-toggling {
	pointer-events: none;
}

.menu-wrapper.is-toggling .menu-item {
	position: absolute;
	top: 0;
	right: 0;
	margin: 0;
	width: 100%;
}

.menu-wrapper.is-toggling .menu-bottom .social-menu .menu-item {
	width: auto;
}

.menu-wrapper.is-animating .menu-item,
.menu-wrapper.is-animating .toggling-target {
	transition-duration: 250ms;
}

.menu-wrapper.is-animating .menu-item {
	transition-property: transform;
}

.menu-wrapper.is-toggling .toggling-target {
	display: block;
	position: absolute;
	top: 0;
	right: 0;
	opacity: 1;
}

.menu-wrapper.is-toggling .toggling-target.active {
	opacity: 0;
}

.menu-wrapper.is-animating.is-toggling .toggling-target {
	display: block;
	transition-property: opacity;
	opacity: 0;
}

.menu-wrapper.is-animating.is-toggling .toggling-target.active {
	opacity: 1;
}

.menu-wrapper.is-toggling .modal-menu > li:last-child li {
	border-top-color: transparent;
	border-bottom-width: 0.1rem;
}

@media (prefers-reduced-motion: reduce) {

	.menu-wrapper.is-animating .menu-item,
	.menu-wrapper.is-animating .toggling-target {
		transition-duration: 1ms !important;
	}

}


/* Expanded Menu ----------------------------- */

.expanded-menu {
	display: none;
}

.mobile-menu {
	display: block;
}


/* Menu Bottom ------------------------------- */

.menu-bottom {
	flex-shrink: 0;
	padding: 4rem 0;
}

.menu-bottom nav {
	width: 100%;
}

.menu-copyright {
	display: none;
	font-size: 1.6rem;
	font-weight: 500;
	margin: 0;
}

.menu-copyright a:focus,
.menu-copyright a:hover {
	text-decoration: underline;
}

.menu-bottom .social-menu {
	justify-content: center;
}


/* -------------------------------------------------------------------------- */

/*	6. Search Modal
/* -------------------------------------------------------------------------- */


.search-modal {
	background: rgba(0, 0, 0, 0.2);
	display: none;
	opacity: 0;
	position: fixed;
	bottom: 0;
	right: -9999rem;
	top: 0;
	transition: opacity 0.2s linear, right 0s 0.2s linear;
	width: 100%;
	z-index: 999;
}

.admin-bar .search-modal.active {
	top: 32px;
}

@media (max-width: 782px) {

	.admin-bar .search-modal.active {
		top: 46px;
	}
}

.search-modal-inner {
	background: #fff;
	transform: translateY(-100%);
	transition: transform 0.15s linear, box-shadow 0.15s linear;
}

.search-modal-inner .section-inner {
	display: flex;
	justify-content: space-between;
	max-width: 168rem;
}

.search-modal.active {
	right: 0;
	opacity: 1;
	transition: opacity 0.2s linear;
}

.search-modal.active .search-modal-inner {
	box-shadow: 0 0 2rem 0 rgba(0, 0, 0, 0.08);
	transform: translateY(0);
	transition: transform 0.25s ease-in-out, box-shadow 0.1s 0.25s linear;
}

button.search-untoggle {
	align-items: center;
	display: flex;
	flex-shrink: 0;
	justify-content: center;
	margin-left: -2.5rem;
	padding: 0 2.5rem;
}

.search-modal button.search-untoggle {
	color: inherit;
}

.search-modal.active .search-untoggle {
	animation: popIn both 0.3s 0.2s;
}

.search-untoggle svg {
	height: 1.5rem;
	transition: transform 0.15s ease-in-out;
	width: 1.5rem;
}

.search-untoggle:focus svg,
.search-untoggle:hover svg {
	transform: scale(1.15);
}


/* Modal Search Form ------------------------- */

.search-modal form {
	margin: 0;
	position: relative;
	width: 100%;
}

.search-modal .search-field {
	background: none;
	border: none;
	border-radius: 0;
	color: inherit;
	font-s