enu-item-has-children:hover > ul,
.primary-menu ul li.menu-item-has-children:focus > ul,
.primary-menu ul li.menu-item-has-children.focus > ul {
	left: calc(100% + 2rem);
}

.primary-menu ul ul::before {
	bottom: 0;
	height: auto;
	right: auto;
	left: -2rem;
	top: 0;
	width: 2rem;
}

.primary-menu ul ul::after {
	border-bottom-color: transparent;
	border-left-color: #000;
	bottom: auto;
	left: -1.6rem;
	top: 2rem;
}

.rtl .primary-menu ul ul::after {
	transform: rotate(-180deg);
}

/*
 * Enable nav submenu expansion with tapping on arrows on large-viewport
 * touch interfaces (e.g. tablets or laptops with touch screens).
 * These rules are supported by all browsers (>IE11) and when JS is disabled.
 */
@media (any-pointer: coarse) {

	.primary-menu > li.menu-item-has-children > a {
		padding-left: 0;
		margin-left: 2rem;
	}

	.primary-menu ul li.menu-item-has-children > a {
		margin-left: 4.5rem;
		padding-left: 0;
		width: unset;
	}

}

/* Repeat previous rules for IE11 (when JS enabled for polyfill). */
body.touch-enabled .primary-menu > li.menu-item-has-children > a {
	padding-left: 0;
	margin-left: 2rem;
}

body.touch-enabled .primary-menu ul li.menu-item-has-children > a {
	margin-left: 4.5rem;
	padding-left: 0;
	width: unset;
}

/* -------------------------------------------------------------------------- */

/*	5. Menu Modal
/* -------------------------------------------------------------------------- */


.menu-modal {
	background: #fff;
	display: none;
	opacity: 0;
	overflow-y: auto;
	overflow-x: hidden;
	position: fixed;
	bottom: 0;
	right: -99999rem;
	left: 99999rem;
	top: 0;
	transition: opacity 0.25s ease-in, right 0s 0.25s, left 0s 0.25s;
	z-index: 99;
}

.admin-bar .menu-modal {
	top: 32px;
}

@media (max-width: 782px) {

	.admin-bar .menu-modal {
		top: 46px;
	}
}

.menu-modal.show-modal {
	display: flex;
}

.menu-modal.active {
	right: 0;
	opacity: 1;
	left: 0;
	transition: opacity 0.25s ease-out;
}

.menu-modal-inner {
	background: #fff;
	display: flex;
	justify-content: stretch;
	overflow: auto;
	-ms-overflow-style: auto;
	width: 100%;
}

.menu-wrapper {
	display: flex;
	flex-direction: column;
	justify-content: space-between;
	position: relative;
}

button.close-nav-toggle {
	align-items: center;
	display: flex;
	font-size: 1.6rem;
	font-weight: 500;
	justify-content: flex-end;
	padding: 3.1rem 0;
	width: 100%;
}

button.close-nav-toggle svg {
	height: 1.6rem;
	width: 1.6rem;
}

button.close-nav-toggle .toggle-text {
	margin-left: 1.6rem;
}

.menu-modal .menu-top {
	flex-shrink: 0;
}


/* Main Menu --------------------------------- */

.modal-menu {
	position: relative;
	right: calc(50% - 50vw);
	width: 100vw;
}

.modal-menu li {
	border-color: #dedfdf;
	border-style: solid;
	border-width: 0.1rem 0 0 0;
	display: flex;
	flex-wrap: wrap;
	line-height: 1;
	justify-content: flex-start;
	margin: 0;
}

.modal-menu > li > a,
.modal-menu > li > .ancestor-wrapper > a {
	font-size: 2rem;
	font-weight: 700;
	letter-spacing: -0.0375em;
}

.modal-menu > li:last-child {
	border-bottom-width: 0.1rem;
}

.modal-menu .ancestor-wrapper {
	display: flex;
	justify-cont