om: 6rem;
	}

	.comment-respond p.comment-notes,
	.comment-respond p.logged-in-as {
		margin: -4rem 0 6rem 0;
	}

	.comments .comment-respond .comment-reply-title {
		font-size: 4.8rem;
	}

	.comments .comment-respond p.comment-notes,
	.comments .comment-respond p.logged-in-as {
		margin: -4.5rem 0 4rem 0;
	}

	/* Site Pagination ----------------------- */

	/* Widgets ------------------------------- */

	.widget-content {
		font-size: 2.1rem;
	}

	/* Site Footer --------------------------- */

	.footer-menu {
		font-size: 2.4rem;
		margin: -1.5rem 0 0 -3rem;
	}

	.footer-menu li {
		margin: 1.5rem 0 0 3rem;
	}

	ul.footer-social {
		margin: -1rem 0 0 -1rem;
	}

	ul.footer-social li {
		margin: 1rem 0 0 1rem;
	}

	.footer-social a {
		height: 4.4rem;
		width: 4.4rem;
	}

	.footer-social a::before {
		font-size: 2rem;
	}

	/* FOOTER WIDGETS */

	.footer-widgets-wrapper {
		margin-left: -6rem;
		width: calc(100% + 6rem);
	}

	.footer-widgets {
		margin-left: 6rem;
	}

}

@media ( min-width: 1240px ) {


	/* Blocks -------------------------------- */

	body.template-full-width .entry-content > .alignleft {

		/*rtl:ignore*/
		margin-left: calc(( 100vw - 120rem ) / 2);
	}

	body.template-full-width .entry-content > .alignright {

		/*rtl:ignore*/
		margin-right: calc(( 100vw - 120rem ) / 2);
	}

}

@media ( min-width: 1280px ) {

	/* Blocks -------------------------------- */

	/* BLOCK: GALLERY */

	figure.wp-block-gallery.alignleft {

		/*rtl:ignore*/
		margin-left: -31rem;
	}

	figure.wp-block-gallery.alignright {

		/*rtl:ignore*/
		margin-right: -31rem;
	}

	/* BLOCK: SEPARATOR */

	.wp-block-separator.is-style-wide {
		max-width: 120rem;
		width: 120rem;
	}

	/* Entry Content ------------------------- */

	/* ALIGNMENT CLASSES */

	.entry-content > .alignleft,
	.entry-content > p .alignleft,
	.entry-content > .wp-block-image .alignleft {

		/*rtl:ignore*/
		right: calc((100vw - 58rem) / 2 + 58rem + 4rem);

		/*rtl:ignore*/
		margin-left: -31rem;
	}

	.entry-content > .alignright,
	.entry-content > p .alignright,
	.entry-content > .wp-block-image .alignright {

		/*rtl:ignore*/
		left: calc((100vw - 58rem) / 2 + 58rem + 4rem);

		/*rtl:ignore*/
		margin-right: -31rem;
	}

	.entry-content > .alignwide {
		max-width: 120rem;
		width: 120rem;
	}

	[class*="__inner-container"] > .alignwide {
		max-width: 120rem;
		width: 100%;
	}

	.alignleft,
	.alignright,
	.entry-content > .alignleft,
	.entry-content > p .alignleft,
	.entry-content > .wp-block-image .alignleft,
	.entry-content > .alignright,
	.entry-content > p .alignright,
	.entry-content > .wp-block-image .alignright,
	[class*="wp-block"].alignwide:not(.has-background) [class*="__inner-container"] > .alignleft,
	[class*="wp-block"].alignwide:not(.has-background) [class*="__inner-container"] > p .alignleft,
	[class*="wp-block"].alignwide:not(.has-background) [class*="__inner-container"] > .wp-block-image .alignleft,
	[class*="wp-block"].alignfull [class*="__inner-container"] > .alignleft,
	[class*="wp-block"].alignfull [class*="__inner-container"] > p .alignleft,
	[class*="wp-block"].alignfull [class*="__inner-container"] > .wp-block-image .alignleft,
	[class*="wp-block"].alignwide:not(.has-background) [class*="__inner-container"] > .alignright,
	[class*="wp-block"].alignwide:not(.has-background) [class*="__inner-container"] > p .alignright,
	[class*="wp-block"].alignwide:not(.has-background) [class*="__inner-container"] > .wp-block-image .alignright,
	[class*="wp-block"].alignfull [class*="__inner-container"] > .alignright,
	[class*="wp-block"].alignfull [class*="__inner-container"] > p .alignright,
	[class*="wp-block"].alignfull [class*="__inner-container"] > .wp-block-image .alignright {
		max-width: 25rem;
	}

	/* Template: Full Width ------------------ */

	body.template-full-width .alignfull:not(.has-background) > .wp-block-group__inner-container > p:not(.has-background-color) {
		padding-left: 0;
		padding-right: 0;
	}

	body.template-full-width [class*="wp-block"].alignfull [class*="__inner-container"] > .wp-block-image .alignleft {

		/*rtl:ignore*/
		margin-left: 0;
	}

	body.template-full-width [class*="wp-block"].alignfull [class*="__inner-container"] > .wp-block-image .alignright {

		/*rtl:ignore*/
		margin-right: 0;
	}

}

@media ( min-width: 1330px ) {


	/* Entry Content ------------------------- */

	/* ALIGNMENT CLASSES */

	.alignleft,
	.alignright,
	.entry-content > .alignleft,
	.entry-content > p .alignleft,
	.entry-content > .wp-block-image .alignleft,
	.entry-content > .alignright,
	.entry-content > p .alignright,
	.entry-content > .wp-block-image .alignright,
	[class*="wp-block"].alignwide:not(.has-background) [class*="__inner-container"] > .alignleft,
	[class*="wp-block"].alignwide:not(.has-background) [class*="__inner-container"] > p .alignleft,
	[class*="wp-block"].alignwide:not(.has-background) [class*="__inner-container"] > .wp-block-image .alignleft,
	[class*="wp-block"].alignfull [class*="__inner-container"] > .alignleft,
	[class*="wp-block"].alignfull [class*="__inner-container"] > p .alignleft,
	[class*="wp-block"].alignfull [class*="__inner-container"] > .wp-block-image .alignleft,
	[class*="wp-block"].alignwide:not(.has-background) [class*="__inner-container"] > .alignright,
	[class*="wp-block"].alignwide:not(.has-background) [class*="__inner-container"] > p .alignright,
	[class*="wp-block"].alignwide:not(.has-background) [class*="__inner-container"] > .wp-block-image .alignright,
	[class*="wp-block"].alignfull [class*="__inner-container"] > .alignright,
	[class*="wp-block"].alignfull [class*="__inner-container"] > p .alignright,
	[class*="wp-block"].alignfull [class*="__inner-container"] > .wp-block-image .alignright {
		max-width: 29rem;
	}

	/* Blocks -------------------------------- */

	/* BLOCK: PULLQUOTE */

	.wp-block-pullquote.is-style-solid-color.alignleft::before,
	.wp-block-pullquote.is-style-solid-color.alignright::before {
		top: 0;
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              themes/twentyfive/style-rtl.css                                                                     0000644                 00000366711 15122266566 0012737 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       /*
Theme Name: Twenty Twenty
Text Domain: twentytwenty
Version: 1.5
Requires at least: 4.7
Requires PHP: 5.2.4
Description: Our default theme for 2020 is designed to take full advantage of the flexibility of the block editor. Organizations and businesses have the ability to create dynamic landing pages with endless layouts using the group and column blocks. The centered content column and fine-tuned typography also makes it perfect for traditional blogs. Complete editor styles give you a good idea of what your content will look like, even before you publish. You can give your site a personal touch by changing the background colors and the accent color in the Customizer. The colors of all elements on your site are automatically calculated based on the colors you pick, ensuring a high, accessible color contrast for your visitors.
Tags: blog, one-column, custom-background, custom-colors, custom-logo, custom-menu, editor-style, featured-images, footer-widgets, full-width-template, rtl-language-support, sticky-post, theme-options, threaded-comments, translation-ready, block-styles, wide-blocks, accessibility-ready
Author: the WordPress team
Author URI: https://wordpress.org/
Theme URI: https://wordpress.org/themes/twentytwenty/
License: GNU General Public License v2 or later
License URI: http://www.gnu.org/licenses/gpl-2.0.html

All files, unless otherwise stated, are released under the GNU General Public
License version 2.0 (http://www.gnu.org/licenses/gpl-2.0.html)

This theme, like WordPress, is licensed under the GPL.
Use it to make something cool, have fun, and share what you've learned
with others.
*/

/*--------------------------------------------------------------
>>> TABLE OF CONTENTS:
----------------------------------------------------------------

	0. 	CSS Reset
	1. 	Document Setup
	2. 	Element Base
	3. 	Helper Classes
	4. 	Site Header
	5. 	Menu Modal
	6. 	Search Modal
	7. 	Page Templates
		a. 	Template: Cover Template
		c. 	Template: Full Width
	8.  Post: Archive
	9.  Post: Single
	10. Blocks
	11. Entry Content
	12. Comments
	13. Site Pagination
	14. Error 404
	15. Widgets
	16. Site Footer
	17. Media Queries

----------------------------------------------------------------------------- */


/* -------------------------------------------------------------------------- */

/*	0. CSS Reset
/* -------------------------------------------------------------------------- */


html,
body {
	border: none;
	margin: 0;
	padding: 0;
}

h1,
h2,
h3,
h4,
h5,
h6,
p,
blockquote,
address,
big,
cite,
code,
em,
font,
img,
small,
strike,
sub,
sup,
li,
ol,
ul,
fieldset,
form,
label,
legend,
button,
table,
caption,
tr,
th,
td {
	border: none;
	font-size: inherit;
	line-height: inherit;
	margin: 0;
	padding: 0;
	text-align: inherit;
}

blockquote::before,
blockquote::after {
	content: "";
}


/* -------------------------------------------------------------------------- */

/*	1. Document Setup
/* -------------------------------------------------------------------------- */


html {
	font-size: 62.5%; /* 1rem = 10px */
	scroll-behavior: smooth;
}

@media (prefers-reduced-motion: reduce) {
	html {
		scroll-behavior: auto;
	}
}

body {
	background: #f5efe0;
	box-sizing: border-box;
	color: #000;
	font-family: -apple-system, BlinkMacSystemFont, "Helvetica Neue", Helvetica, sans-serif;
	font-size: 1.8rem;
	letter-spacing: -0.015em;
	text-align: right;
}

@supports ( font-variation-settings: normal ) {

	body {
		font-family: "Inter var", -apple-system, BlinkMacSystemFont, "Helvetica Neue", Helvetica, sans-serif;
	}
}

*,
*::before,
*::after {
	box-sizing: inherit;
	-webkit-font-smoothing: antialiased;
	word-break: break-word;
	word-wrap: break-word;
}

#site-content {
	overflow: hidden;
}


/* Clearing ---------------------------------- */

.group::after,
.entry-content::after {
	clear: both;
	content: "";
	display: block;
}


/* Base Transitions -------------------------- */

a,
path {
	transition: all 0.15s linear;
}


/* Screen Reader Text ------------------------ */

.screen-reader-text {
	border: 0;
	clip: rect(1px, 1px, 1px, 1px);
	-webkit-clip-path: inset(50%);
	clip-path: inset(50%);
	height: 1px;
	margin: -1px;
	overflow: hidden;
	padding: 0;
	position: absolute !important;
	width: 1px;
	word-wrap: normal !important;
	word-break: normal;
}

.screen-reader-text:focus {
	background-color: #f1f1f1;
	border-radius: 3px;
	box-shadow: 0 0 2px 2px rgba(0, 0, 0, 0.6);
	clip: auto !important;
	-webkit-clip-path: none;
	clip-path: none;
	color: #21759b;
	display: block;
	font-size: 0.875rem;
	font-weight: 700;
	height: auto;
	left: 5px;
	line-height: normal;
	padding: 15px 23px 14px;
	text-decoration: none;
	top: 5px;
	width: auto;
	z-index: 100000;
}


/* Skip Link --------------------------------- */

.skip-link {
	right: -9999rem;
	top: 2.5rem;
	z-index: 999999999;
	text-decoration: underline;
}

.skip-link:focus {
	display: block;
	right: 6px;
	top: 7px;
	font-size: 14px;
	font-weight: 600;
	text-decoration: none;
	line-height: normal;
	padding: 15px 23px 14px;
	z-index: 100000;
	left: auto;
}


/* Fonts ------------------------------------- */

/*
 * Chrome renders extra-wide &nbsp; characters for the Hoefler Text font.
 * This results in a jumping cursor when typing in both the classic editor and
 * block editor. The following font-face override fixes the issue by manually
 * inserting a custom font that includes just a Hoefler Text space replacement
 * for that character instead.
 */
@font-face {
	font-family: NonBreakingSpaceOverride;
	src: url(data:application/font-woff2;charset=utf-8;base64,d09GMgABAAAAAAMoAA0AAAAACDQAAALTAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP0ZGVE0cGh4GYACCahEICjx3CywAATYCJANUBCAFhiEHgWwbXQfILgpsY+rQRRARwyAs6uL7pxzYhxEE+32b3aeHmifR6tklkS9hiZA0ewkqGRJE+H7/+6378ASViK/PGeavqJyOzsceKi1s3BCiQsiOdn1r/RBgIJYEgCUhbm/8/8/h4saPssnTNkkiWUBrTRtjmQSajw3Ui3pZ3LYDPD+XG2C3JA/yKAS8/rU5eNfuGqRf4eNNgV4YAlIIgxglEkWe6FYpq10+wi3g+/nUgvgPFczNrz/RsTgVm/zfbPuHZlsuQECxuyqBcQwKFBjFgKO8AqP4bAN9tFJtnM9xPcbNjeXS/x1wY/xU52f5W/X1+9cnH4YwKIaoRRAkUkj/YlAAeF/624foiIDBgBmgQBeGAyhBljUPZUm/l2dTvmpqcBDUOHdbPZWd8JsBAsGr4w8/EDn82/bUPx4eh0YNrQTBuHO2FjQEAGBwK0DeI37DpQVqdERS4gZBhpeUhWCfLFz7J99aEBgsJCHvUGAdAPp4IADDCAPCEFMGpMZ9AQpTfQtQGhLbGVBZFV8BaqNyP68oTZgHNj3M8kBPfXTTC9t90UuzYhy9ciH0grVlOcqyCytisvbsERsEYztiznR0WCrmTksJwbSNK6fd1Rvr25I9oLvctUoEbNOmXJbqgYgPXEHJ82IUsrCnpkxh23F1rfZ2zcRnJYoXtauB3VTFkFXQg3uoZYD5qE0kdjDtoDoF1h2bulGmev5HbYhbrjtohQSRI4aNOkffIcT+d3v6atpaYh3JvPoQsztCcqvaBkppDSPcQ3bw3KaCBo1f5CJWTZEgW3LjLofYg51MaVezrx8xZitYbQ9KYeoRaqQdVLwSEfrKXLK1otCWOKNdR/YwYAfon5Yk8O2MJfSD10dPGA5PIJJQMkah0ugMJiv6x4Dm7LEa8xnrRGGGLAg4sAlbsA07sAt76DOsXKO3hIjtIlpnnFrt1qW4kh6NhS83P/6HB/fl1SMAAA==) format("woff2"), url(data:application/font-woff;charset=utf-8;base64,d09GRgABAAAAAAUQAA0AAAAACDQAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAABGRlRNAAAE9AAAABwAAAAchf5yU0dERUYAAATYAAAAHAAAAB4AJwAbT1MvMgAAAaAAAABJAAAAYJAcgU5jbWFwAAACIAAAAF4AAAFqUUxBZ2dhc3AAAATQAAAACAAAAAgAAAAQZ2x5ZgAAApAAAAAyAAAAPL0n8y9oZWFkAAABMAAAADAAAAA2Fi93Z2hoZWEAAAFgAAAAHQAAACQOSgWaaG10eAAAAewAAAAzAAAAVC7TAQBsb2NhAAACgAAAABAAAAAsAOQBAm1heHAAAAGAAAAAHQAAACAAWQALbmFtZQAAAsQAAAF6AAADIYvD/Adwb3N0AAAEQAAAAI4AAADsapk2o3jaY2BkYGAA4ov5mwzj+W2+MnCzXwCKMNzgCBSB0LfbQDQ7AxuI4mBgAlEAFKQIRHjaY2BkYGD3+NvCwMDBAALsDAyMDKhAFAA3+wH3AAAAeNpjYGRgYBBl4GBgYgABEMnIABJzAPMZAAVmAGUAAAB42mNgZlJhnMDAysDCKsKygYGBYRqEZtrDYMT4D8gHSmEHjgUFOQwODAqqf9g9/rYwMLB7MNUAhRlBcsxBrMlASoGBEQAj8QtyAAAAeNrjYGBkAAGmWQwMjO8gmBnIZ2NA0ExAzNjAAFYJVn0ASBsD6VAIDZb7AtELAgANIgb9AHjaY2BgYGaAYBkGRgYQSAHyGMF8FgYPIM3HwMHAxMDGoMCwQIFLQV8hXvXP//9AcRCfAcb///h/ygPW+w/vb7olBjUHCTCyMcAFGZmABBO6AogThgZgIUsXAEDcEzcAAHjaY2BgECMCyoEgACZaAed42mNgYmRgYGBnYGNgYAZSDJqMgorCgoqCjECRXwwNrCAKSP5mAAFGBiRgyAAAi/YFBQAAeNqtkc1OwkAUhU/5M25cEhcsZick0AwlBJq6MWwgJkAgYV/KAA2lJeUn+hY+gktXvpKv4dLTMqKycGHsTZNv7px7z50ZAFd4hYHjdw1Ls4EiHjVncIFnzVnc4F1zDkWjrzmPW+NNcwGlzIRKI3fJlUyrEjZQxb3mDH2fNGfRx4vmHKqG0JzHg6E0F9DOlFBGBxUI1GEzLNT4S0aLuTtsGAEUuYcQHkyg3KmIum1bNUvKlrjbbAIleqHHnS4iSudpQcySMYtdFiXlAxzSbAwfMxK6kZoHKhbjjespMTioOPZnzI+4ucCeTVyKMVKLfeAS6vSWaTinuZwzyy/Dc7vaed+6KaV0kukdPUk6yOcctZPvvxxqksq2lEW8RvHjMEO2FCl/zy6p3NEm0R9OFSafJdldc4QVeyaaObMBO0/5cCaa6d9Ggyubxire+lEojscdjoWUR1xGOy8KD8mG2ZLO2l2paDc3A39qmU2z2W5YNv5+u79e6QfGJY/hAAB42m3NywrCMBQE0DupWp/1AYI7/6DEaLQu66Mrd35BKUWKJSlFv1+rue4cGM7shgR981qSon+ZNwUJ8iDgoYU2OvDRRQ99DDDECAHGmGCKmf80hZSx/Kik/LliFbtmN6xmt+yOjdg9GztV4tROnRwX/Bsaaw51nt4Lc7tWaZYHp/MlzKx51LZs5htNri+2AAAAAQAB//8AD3jaY2BkYGDgAWIxIGZiYARCESBmAfMYAAR6AEMAAAABAAAAANXtRbgAAAAA2AhRFAAAAADYCNuG) format("woff");
}

/* ----------------------------------------------
Inter variable font. Usage:

@supports (font-variation-settings: normal) {
	html { font-family: 'Inter var', sans-serif; }
}
---------------------------------------------- */

@font-face {
	font-family: "Inter var";
	font-weight: 100 900; /* stylelint-disable-line font-weight-notation */
	font-style: normal;
	font-display: swap;
	src: url(./assets/fonts/inter/Inter-upright-var.woff2) format("woff2");
}

@font-face {
	font-family: "Inter var";
	font-weight: 100 900; /* stylelint-disable-line font-weight-notation */
	font-style: italic;
	font-display: swap;
	src: url(./assets/fonts/inter/Inter-italic-var.woff2) format("woff2");
}


/* Accessibility Settings -------------------- */

@media ( prefers-reduced-motion: reduce ) {

	* {
		animation-duration: 0s !important;
		transition-duration: 0s !important;
	}
}


/* -------------------------------------------------------------------------- */

/*	2. Element Base
/* ---------------------------------------------*---------------------------- */


main {
	display: block;
}

h1,
h2,
h3,
h4,
h5,
h6,
.faux-heading {
	font-feature-settings: "lnum";
	font-variant-numeric: lining-nums;
	font-weight: 700;
	letter-spacing: -0.0415625em;
	line-height: 1.25;
	margin: 3.5rem 0 2rem;
}

h1,
.heading-size-1 {
	font-size: 3.6rem;
	font-weight: 800;
	line-height: 1.138888889;
}

h2,
.heading-size-2 {
	font-size: 3.2rem;
}

h3,
.heading-size-3 {
	font-size: 2.8rem;
}

h4,
.heading-size-4 {
	font-size: 2.4rem;
}

h5,
.heading-size-5 {
	font-size: 2.1rem;
}

h6,
.heading-size-6 {
	font-size: 1.6rem;
	letter-spacing: 0.03125em;
	text-transform: uppercase;
}

p {
	line-height: 1.5;
	margin: 0 0 1em 0;
}

em,
i,
q,
dfn {
	font-style: italic;
}

em em,
em i,
i em,
i i,
cite em,
cite i {
	font-weight: bolder;
}

big {
	font-size: 1.2em;
}

small {
	font-size: 0.75em;
}

b,
strong {
	font-weight: 700;
}

ins {
	text-decoration: underline;
}

sub,
sup {
	font-size: 75%;
	line-height: 0;
	position: relative;
	vertical-align: baseline;
}

sup {
	top: -0.5em;
}

sub {
	bottom: -0.25em;
}

abbr,
acronym {
	cursor: help;
}

address {
	line-height: 1.5;
	margin: 0 0 2rem 0;
}

hr {
	border-style: solid;
	border-width: 0.1rem 0 0 0;
	border-color: #dcd7ca;
	margin: 4rem 0;
}

.entry-content hr,
hr.styled-separator {
	background: linear-gradient(to right, currentColor calc(50% - 16px), transparent calc(50% - 16px), transparent calc(50% + 16px), currentColor calc(50% + 16px));
	background-color: transparent !important;
	border: none;
	height: 0.1rem;
	overflow: visible;
	position: relative;
}

.entry-content hr:not(.has-background),
hr.styled-separator {
	color: #6d6d6d;
}

.entry-content hr::before,
.entry-content hr::after,
hr.styled-separator::before,
hr.styled-separator::after {
	background: currentColor;
	content: "";
	display: block;
	height: 1.6rem;
	position: absolute;
	top: calc(50% - 0.8rem);
	transform: rotate(-22.5deg);
	width: 0.1rem;
}

.entry-content hr::before,
hr.styled-separator::before {
	right: calc(50% - 0.5rem);
}

.entry-content hr::after,
hr.styled-separator::after {
	left: calc(50% - 0.5rem);
}

a {
	color: #cd2653;
	text-decoration: underline;
}

a:hover,
a:focus {
	text-decoration: none;
}


/* Lists ------------------------------------- */

ul,
ol {
	margin: 0 3rem 3rem 0;
}

ul {
	list-style: disc;
}

ul ul {
	list-style: circle;
}

ul ul ul {
	list-style: square;
}

ol {
	list-style: decimal;
}

ol ol {
	list-style: lower-alpha;
}

ol ol ol {
	list-style: lower-roman;
}

li {
	line-height: 1.5;
	margin: 0.5rem 2rem 0 0;
}

li > ul,
li > ol {
	margin: 1rem 2rem 0 0;
}

.reset-list-style,
.reset-list-style ul,
.reset-list-style ol {
	list-style: none;
	margin: 0;
}

.reset-list-style li {
	margin: 0;
}

dt,
dd {
	line-height: 1.5;
}

dt {
	font-weight: 700;
}

dt + dd {
	margin-top: 0.5rem;
}

dd + dt {
	margin-top: 1.5rem;
}


/* Quotes ------------------------------------ */

blockquote {
	border-color: #cd2653;
	border-style: solid;
	border-width: 0 0 0 0.2rem;
	color: inherit;
	font-size: 1em;
	margin: 4rem 0;
	padding: 0.5rem 0 0.5rem 2rem;
}

cite {
	color: #6d6d6d;
	font-size: 1.4rem;
	font-style: normal;
	font-weight: 600;
	line-height: 1.25;
}

blockquote cite {
	display: block;
	margin: 2rem 0 0 0;
}

blockquote p:last-child {
	margin: 0;
}


/* Code -------------------------------------- */

code,
kbd,
pre,
samp {
	font-family: monospace;
	font-size: 0.9em;
	padding: 0.4rem 0.6rem;
}

code,
kbd,
samp {
	background: rgba(0, 0, 0, 0.075);
	border-radius: 0.2rem;
}

pre {
	border: 0.1rem solid #dcd7ca;
	line-height: 1.5;
	margin: 4rem 0;
	overflow: auto;
	padding: 3rem 2rem;
	text-align: right;
}

pre code {
	background: transparent;
	padding: 0;
}


/* Media ------------------------------------- */

figure {
	display: block;
	margin: 0;
}

iframe {
	display: block;
	max-width: 100%;
}

video {
	display: block;
}

svg,
img,
embed,
object {
	display: block;
	height: auto;
	max-width: 100%;
}

figcaption,
.wp-caption-text {
	color: #6d6d6d;
	display: block;
	font-size: 1.5rem;
	font-weight: 500;
	line-height: 1.2;
	margin-top: 1.5rem;
}

figcaption a,
.wp-caption-text a {
	color: inherit;
}

blockquote.instagram-media,
iframe.instagram-media {
	margin: auto !important;
}


/* GALLERIES */

.gallery {
	display: flex;
	flex-wrap: wrap;
	margin: 3em -0.8em 3em 0;
	width: calc(100% + 1.6em);
}

.gallery-item {
	margin: 0.8em 0;
	padding: 0 0.8em;
	width: 100%;
}

.gallery-caption {
	display: block;
	margin-top: 0.8em;
}


/* Inputs ------------------------------------ */

fieldset {
	border: 0.2rem solid #dcd7ca;
	padding: 2rem;
}

legend {
	font-size: 0.85em;
	font-weight: 700;
	padding: 0 1rem;
}

label {
	display: block;
	font-size: 1.6rem;
	font-weight: 400;
	margin: 0 0 0.5rem 0;
}

label.inline,
input[type="checkbox"] + label {
	display: inline;
	font-weight: 400;
	margin-right: 0.5rem;
}

input[type="checkbox"] {
	-webkit-appearance: none;
	-moz-appearance: none;
	position: relative;
	top: 2px;
	display: inline-block;
	margin: 0;
	width: 1.5rem;
	min-width: 1.5rem;
	height: 1.5rem;
	background: #fff;
	border-radius: 0;
	border-style: solid;
	border-width: 0.1rem;
	border-color: #dcd7ca;
	box-shadow: none;
	cursor: pointer;
}

input[type="checkbox"]:checked::before {
	/* Use the "Yes" SVG Dashicon */
	content: url("data:image/svg+xml;utf8,%3Csvg%20xmlns%3D%27http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%27%20viewBox%3D%270%200%2020%2020%27%3E%3Cpath%20d%3D%27M14.83%204.89l1.34.94-5.81%208.38H9.02L5.78%209.67l1.34-1.25%202.57%202.4z%27%20fill%3D%27%23000000%27%2F%3E%3C%2Fsvg%3E");
	position: absolute;
	display: inline-block;
	margin: -0.1875rem -0.25rem 0 0;
	height: 1.75rem;
	width: 1.75rem;
}

input,
textarea,
button,
.button,
.faux-button,
.wp-block-button__link,
.wp-block-file__button {
	font-family: -apple-system, BlinkMacSystemFont, "Helvetica Neue", Helvetica, sans-serif;
	line-height: 1;
}

@supports ( font-varia