lock-file a.wp-block-file__button:visited {
	opacity: 1;
}

.wp-block-file a.wp-block-file__button:active,
.wp-block-file a.wp-block-file__button:focus,
.wp-block-file a.wp-block-file__button:hover {
	opacity: 1;
	text-decoration: underline;
}


/* Block: Gallery ---------------------------- */

.wp-block-gallery ul {
	list-style: none;
	margin: 0 0 -1.6rem 0;
}

figure.wp-block-gallery.alignnone,
figure.wp-block-gallery.aligncenter {
	margin-bottom: 3rem;
	margin-top: 3rem;
}

figure.wp-block-gallery.alignleft {
	margin: 0.3rem 0 2rem 2rem;
}

figure.wp-block-gallery.alignright {
	margin: 0.3rem 2rem 2rem 0;
}

figure.wp-block-gallery.alignwide {
	margin-bottom: 4rem;
	margin-top: 4rem;
}

figure.wp-block-gallery.alignfull {
	margin-bottom: 5rem;
	margin-top: 5rem;
}

/* Block: Group ------------------------------ */

.wp-block-group.has-background {
	padding: 2rem;
	margin-bottom: 0;
	margin-top: 0;
}

.wp-block-group__inner-container {
	margin: 0 auto;
}

.wp-block-group__inner-container,
.entry-content .wp-block-group p {
	max-width: 100%;
}

.alignfull:not(.has-background) > .wp-block-group__inner-container > p:not(.has-background-color) {
	padding-right: 2rem;
	padding-left: 2rem;
}

/* Block: Image ------------------------------ */

/* Block: Media And Text --------------------- */

.wp-block-media-text .wp-block-media-text__content {
	padding: 3rem 2rem;
}

.wp-block-media-text .wp-block-media-text__content p {
	max-width: none;
}

.wp-block-media-text__content > *:first-child {
	margin-top: 0;
}

.wp-block-media-text__content > *:last-child {
	margin-bottom: 0;
}

/* Block: Pullquote -------------------------- */

/* STYLE: DEFAULT */

.wp-block-pullquote {
	padding: 0;
	position: relative;
}

.wp-block-pullquote.alignleft,
.wp-block-pullquote.alignright {
	max-width: calc(100% - 4rem);
}

.wp-block-pullquote::before {
	background: #fff;
	border-radius: 50%;
	color: #cd2653;
	content: "”";
	display: block;
	font-size: 6.2rem;
	font-weight: 500;
	line-height: 1.2;
	margin: 0 auto 1.5rem auto;
	text-align: center;
	height: 4.4rem;
	width: 4.4rem;
}

.reduced-spacing .wp-block-pullquote::before {
	border: 0.1rem solid currentColor;
	font-size: 5.9rem;
}

.wp-block-pullquote blockquote {
	border: none;
	margin: 0;
	padding: 0;
}

.wp-block-pullquote blockquote p {
	font-family: inherit;
	font-size: 2.8rem;
	font-weight: 700;
	line-height: 1.178571429;
	letter-spacing: -0.041785714em;
	max-width: 100%;
}

.wp-block-pullquote p:last-of-type {
	margin-bottom: 0;
}

.wp-block-pullquote cite {
	color: #6d6d6d;
	font-size: 1.6rem;
	font-weight: 500;
	margin-top: 1.2rem;
}

.wp-block-pullquote.alignleft p,
.wp-block-pullquote.alignright p {
	font-size: 2.8rem;
}

.wp-block-pullquote.alignleft {
	text-align: right;
}

.wp-block-pullquote.alignright {
	text-align: left;
}

.wp-block-pullquote.alignleft::before {
	margin-right: 0;
}

.wp-block-pullquote.alignright::before {
	margin-left: 0;
}

/* STYLE: SOLID BACKGROUND COLOR */

.wp-block-pullquote.is-style-solid-color {
	padding: 3rem 2rem;
}

.wp-block-pullquote.is-style-solid-color::before {
	position: absolute;
	top: 0;
	right: 50%;
	transform: translateY(-50%) translateX(50%);
}

.wp-block-pullquote.is-style-solid-color.alignleft::before,
.wp-block-pullquote.is-style-solid-color.alignright::before {
	transform: translateY(-50%);
}

.wp-block-pullquote.is-style-solid-color.alignleft::before {
	right: 2rem;
}

.wp-block-pullquote.is-style-solid-color.alignright::before {
	right: auto;
	left: 2rem;
}

.wp-block-pullquote.is-style-solid-color blockquote {
	max-width: 100%;
	text-align: inherit;
}

.wp-block-pullquote.is-style-solid-color cite {
	color: inherit;
}

/* Block: Separator  ------------------------- */

hr.wp-block-separator {
	margin: 3rem 0;
}

/* STYLE: WIDE */

.wp-block-separator.is-style-wide {
	max-width: calc(100vw - 4rem);
	position: relative;
	width: 100%;
}

/* STYLE: DOTS */

.wp-block-separator.is-style-dots::before {
	background: none;
	color: inherit;
	font-size: 3.2rem;
	font-weight: 700;
	height: auto;
	letter-spacing: 1em;
	padding-right: 1em;
	position: static;
	transform: none;
	width: auto;
}

.wp-block-separator.is-style-dots::after {
	content: none;
}


/* Block: Search ----------------------------- */

.wp-block-search .wp-block-search__input {
	width: auto;
}

/* Block: Table ------------------------------ */

.wp-block-table.is-style-stripes tbody tr:nth-child(odd) {
	background: #dcd7ca;
}

figure.wp-block-table.is-style-stripes {
	border-bottom: none;
}

.wp-block-table.is-style-stripes table {
	border-collapse: inherit;
}

/* Block: Quote ------------------------------ */

.wp-block-quote p,
.wp-block-quote cite {
	text-align: inherit;
}

.wp-block-quote[style="text-align:center"] {
	border-width: 0;
	padding: 0;
}

.wp-block-quote[style="text-align:right"] {
	border-width: 0 0.2rem 0 0;
	padding: 0 2rem 0 0;
}

/* STYLE: LARGE */

.wp-block-quote.is-large,
.wp-block-quote.is-style-large {
	border: none;
	padding: 0;
	margin-right: auto;
	margin-left: auto;
}

.wp-block-quote.is-large p,
.wp-block-quote.is-style-large p {
	font-family: inherit;
	font-size: 2.4rem;
	font-style: normal;
	font-weight: 700;
	letter-spacing: -0.02em;
	line-height: 1.285;
}

.wp-block-quote.is-large cite,
.wp-block-quote.is-large footer,
.wp-block-quote.is-style-large cite,
.wp-block-quote.is-style-large footer {
	font-size: 1.6rem;
	text-align: inherit;
}

/* Block: Widget Latest Comments ------------- */

.entry-content .wp-block-latest-comments li {
	margin: 2rem 0;
}

.has-avatars .wp-block-latest-comments__comment .wp-block-latest-comments__comment-excerpt,
.has-avatars .wp-block-latest-comments__comment .wp-block-latest-comments__comment-meta {
	margin-right: 5.5rem;
}

.entry-content .wp-block-latest-comments a {
	text-decoration: none;
}

.entry-content .wp-block-latest-comments a:hover,
.entry-content .wp-block-latest-comments a:focus {
	text-decoration: underline;
}

.wp-block-latest-comments__comment {
	font-size: inherit;
}

.wp-block-latest-comments__comment-date {
	margin-top: 0.4em;
}

.wp-block-latest-comments__comment-excerpt p {
	font-size: 0.7em;
	margin: 0.9rem 0 2rem 0;
}

/* Block: Widget Latest Posts ---------------- */

.wp-block-latest-posts.is-grid li {
	border-top: 0.2rem solid #dcd7ca;
	margin-top: 2rem;
	padding-top: 1rem;
}

.wp-block-latest-posts.has-dates {
	list-style: none;
}

.wp-block-latest-posts.has-dates:not(.is-grid) li {
	margin-top: 1.5rem;
}

.wp-block-latest-posts.has-dates:not(.is-grid) li:first-child {
	margin-top: 0;
}


/* -------------------------------------------------------------------------- */

/*	11. Entry Content
/* -------------------------------------------------------------------------- */


.entry-content {
	line-height: 1.5;
}

.entry-content > * {
	margin-right: auto;
	margin-left: auto;
	margin-bottom: 1.25em;
}

.entry-content > *:first-child {
	margin-top: 0;
}

.entry-content > *:last-child {
	margin-bottom: 0;
}

.read-more-button-wrap {
	margin-top: 1em;
	text-align: center;
}

.entry-content a:hover,
.entry-content a:focus {
	text-decoration: none;
}

.entry-content p,
.entry-content li {
	line-height: 1.4;
}

.entry-content li img {
	display: inline-block;
}

.entry-content h1,
.entry-content h2,
.entry-content h3,
.entry-content h4,
.entry-content h5,
.entry-content h6 {
	margin: 3.5rem auto 2rem;
}

.entry-content ul ul,
.entry-content ol ol,
.entry-content ul ol,
.entry-content ol ul {
	margin-bottom: 1rem;
}

.entry-content hr {
	margin: 4rem auto;
}

.post-inner .entry-content > .wp-block-cover.alignwide:first-child,
.post-inner .entry-content > .wp-block-cover.alignfull:first-child {
	margin-top: 0;
}

/* Font Families ----------------------------- */

.entry-content {
	font-family: NonBreakingSpaceOverride, "Hoefler Text", Garamond, "Times New Roman", serif;
	letter-spacing: normal;
}

.entry-content h1,
.entry-content h2,
.entry-content h3,
.entry-content h4,
.entry-content h5,
.entry-content h6,
.entry-content cite,
.entry-content figcaption,
.entry-content table,
.entry-content address,
.entry-content .wp-caption-text,
.entry-content .wp-block-file {
	font-family: -apple-system, BlinkMacSystemFont, "Helvetica Neue", Helvetica, sans-serif;
}

@supports ( font-variation-settings: normal ) {

	.entry-content h1,
	.entry-content h2,
	.entry-content h3,
	.entry-content h4,
	.entry-content h5,
	.entry-content h6,
	.entry-content cite,
	.entry-content figcaption,
	.entry-content table,
	.entry-content address,
	.entry-content .wp-caption-text,
	.entry-content .wp-block-file {
		font-family: "Inter var", -apple-system, BlinkMacSystemFont, "Helvetica Neue", Helvetica, sans-serif;
	}
}


/* Alignment Classes ------------------------- */

.entry-content > *:not(.alignwide):not(.alignfull):not(.alignleft):not(.alignright):not(.is-style-wide) {
	max-width: 58rem;
	width: calc(100% - 4rem);
}

[class*="__inner-container"] > *:not(.alignwide):not(.alignfull):not(.alignleft):not(.alignright):not(.is-style-wide) {
	max-width: 58rem;
	width: 100%;
}

.alignnone,
.aligncenter,
.alignleft,
.alignright,
.alignwide {
	margin-top: 4rem;
	margin-left: auto;
	margin-bottom: 4rem;
	margin-right: auto;
}

[class*="__inner-container"] > *:not(.alignwide):not(.alignfull):not(.alignleft):not(.alignright) {
	margin-right: auto;
	margin-left: auto;
}

/* Full */

.alignfull {
	margin-top: 5rem;
	margin-left: auto;
	margin-bottom: 5rem;
	margin-right: auto;
	max-width: 100vw;
	position: relative;
	width: 100%;
}

[class*="__inner-container"] > .alignfull {
	max-width: 100%;
}

/* Wide */

.alignwide {
	max-width: 120rem;
	position: relative;
	width: calc(100% - 4rem);
}

[class*="__inner-container"] > .alignwide {
	width: 100%;
}

/* Center */

.aligncenter,
.aligncenter img {
	margin-right: auto;
	margin-left: auto;
}

/* Left and right */

.alignleft,
.alignright {
	max-width: 50%;
}

.alignleft {
	float: left;
	margin: 0.3rem 2rem 2rem 2rem;
}

.alignright {
	float: right;
	margin: 0.3rem 2rem 2rem 2rem;
}

[class*="wp-block"].alignfull:not(.has-background) [class*="__inner-container"] > .alignleft,
[class*="wp-block"].alignfull:not(.has-background) [class*="__inner-container"] > p .alignleft,
[class*="wp-block"].alignfull:not(.has-background) [class*="__inner-container"] > .wp-block-image .alignleft {
	margin-left: 2rem;
}

[class*="wp-block"].alignfull:not(.has-background) [class*="__inner-container"] > .alignright,
[class*="wp-block"].alignfull:not(.has-background) [class*="__inner-container"] > p .alignright,
[class*="wp-block"].alignfull:not(.has-background) [class*="__inner-container"] > .wp-block-image .alignright {
	margin-right: 2rem;
}

/* Entry Media ------------------------------- */

.alignfull > figcaption,
.alignfull > .wp-caption-text {
	margin-right: auto;
	margin-left: auto;
	max-width: 58rem;
	width: calc(100% - 4rem);
}


/* -------------------------------------------------------------------------- */

/*	12. Comments
/* -------------------------------------------------------------------------- */


/* Comment Headers ----------------------------- */

.comments-wrapper {
	margin-top: 5rem;
}

.comment-reply-title {
	margin: 0 0 4rem 0;
	text-align: center;
}


/* Comment Item ----------------------------- */

/* COMMENT HEADER */

.comments .comment,
.comments .pingback,
.comments .trackback,
.comments .review {
	padding-top: 3.5rem;
}

div.comment:first-of-type {
	margin-top: 3.5rem;
	padding-top: 0;
}

.comments .comments-header + div {
	margin-top: 0;
	padding-top: 0;
}

.comment-body {
	position: relative;
}

.comment .comment {
	padding-right: 5%;
}

.comment-meta {
	line-height: 1.1;
	margin-bottom: 1.5rem;
	min-height: 5rem;
	padding-right: 5rem;
	position: relative;
}

.hide-avatars .comment-meta {
	min-height: 0;
	padding-right: 0;
}

.comment-meta a {
	color: inherit;
}

.comment-author {
	font-size: 1.8rem;
	font-weight: 700;
	letter-spacing: -0.027777778em;
}

.comment-author a {
	text-decoration: underline;
}

.comment-author a:hover,
.comment-author a:focus {
	text-decoration: none;
}

.comment-meta .avatar {
	height: 4rem;
	position: absolute;
	right: 0;
	top: 0;
	width: 4rem;
}

.comment-author .url {
	text-decoration: underline;
}

.comment-metadata {
	color: #6d6d6d;
	font-size: 1.4rem;
	font-weight: 500;
	margin-top: 0.6rem;
}

.comment-metadata a {
	text-decoration: none;
}

.comment-metadata a:focus,
.comment-metadata a:hover {
	text-decoration: underline;
}


/* COMMENT CONTENT */

.comment-content.entry-content > *:not(.alignwide):not(.alignfull):not(.alignleft):not(.alignright):not(.is-style-wide) {
	width: 100%;
}

.comment-content.entry-content .alignleft {
	margin-left: 0;
}

.comment-content.entry-content .alignright {
	margin-right: 0;
}

/* COMMENT FOOTER */

.comment-footer-meta {
	align-items: center;
	display: flex;
	flex-wrap: wrap;
	font-size: 1.2rem;
	font-weight: 600;
	justify-content: flex-start;
	letter-spacing: 0.030833333em;
	line-height: 1;
	margin: 1.5rem -1.5rem -1rem 0;
	text-transform: uppercase;
}

.comment-footer-meta > * {
	margin: 0 1.5rem 1rem 0;
}

.comment-reply-link {
	background-color: #cd2653;
	color: #fff;
	display: block;
	padding: 0.7rem;
}

.bypostauthor .comment-footer-meta .by-post-author {
	display: block;
}

.comment-footer-meta a {
	text-decoration: none;
}

.comment-footer-meta a:focus,
.comment-footer-meta a:hover {
	text-decoration: underline;
}


/* Pingbacks & Trackbacks ------------------------- */

.pingback .comment-meta,
.trackback .comment-meta {
	padding-right: 0;
}


/* Comments Pagination ---------------------------- */

.comments-pagination {
	display: flex;
	flex-wrap: wrap;
	justify-content: space-between;
	margin-top: 6rem;
	text-align: center;
}

.comments-pagination.only-next {
	justify-content: flex-end;
}

.comments-pagination .page-numbers {
	display: none;
	text-decoration: none;
}

.comments-pagination .page-numbers:focus,
.comments-pagination .page-numbers:hover {
	text-decoration: underline;
}

.comments-pagination .prev,
.comments-pagination .next {
	display: block;
}

.comments-pagination .prev {
	right: 0;
}

.comments-pagination .next {
	left: 0;
	text-align: left;
}


/* Comment Respond ---------------------------- */

.comment-respond::after {
	clear: both;
	content: "";
	display: block;
}

.comment-respond .comment-notes,
.comment-respond .logged-in-as {
	color: #6d6d6d;
	font-size: 1.6rem;
	line-height: 1.4;
	margin: -3rem 0 4rem 0;
	text-align: center;
}

.comment-respond .comment-notes a,
.comment-respond .logged-in-as a {
	color: inherit;
	text-decoration: none;
}

.comment-respond .comment-notes a:focus,
.comment-respond .comment-notes a:hover,
.comment-respond .logged-in-as a:focus,
.comment-respond .logged-in-as a:hover {
	text-decoration: underline;
}

.comment-respond p {
	line-height: 1.1;
	margin-bottom: 2rem;
	margin-right: auto;
	margin-left: auto;
}

.comment-respond p:not(.comment-notes) {
	max-width: 58rem;
}

.comment-form-cookies-consent {
	align-items: baseline;
	display: flex;
}

.comment-respond > p:last-of-type {
	margin-bottom: 0;
}

.comment-respond label {
	display: block;
}

.comment-respond input[type="checkbox"] + label {
	font-size: 1.5rem;
	line-height: 1.25;
}

.comment-respond input[type="text"],
.comment-respond input[type="email"],
.comment-respond textarea {
	margin-bottom: 0;
}

.comment-respond textarea {
	height: 15rem;
}

.comment-respond #submit {
	display: block;
}

.comment-respond .comments-closed {
	text-align: center;
}


/* Reply Respond ---------------------------- */

.comments .comment-respond {
	padding: 3rem 0 0;
}

.comments .comment-respond .comment-reply-title,
.comments .comment-respond .comment-notes,
.comments .comment-respond .logged-in-as {
	text-align: right;
}

.comment-reply-title small {
	display: block;
	font-size: 1.6rem;
	font-weight: 600;
	letter-spacing: -0.0277em;
	margin: 0.5rem 0 0 0;
	white-space: nowrap;
}

.comment-reply-title small a {
	text-decoration: none;
}

.comment-reply-title small a:focus,
.comment-reply-title small a:hover {
	text-decoration: underline;
}


/* -------------------------------------------------------------------------- */

/*	13. Site Pagination
/* -------------------------------------------------------------------------- */


.pagination .nav-links {
	align-items: baseline;
	display: flex;
	flex-wrap: wrap;
	font-size: 1.8rem;
	font-weight: 600;
	margin: -1.5rem -2.5rem 0 0;
	width: calc(100% + 2.5rem);
}

.pagination-separator {
	margin: 5rem 0;
}

.nav-links > * {
	margin: 1.5rem 2.5rem 0 0;
}

.nav-links .placeholder {
	display: none;
	visibility: hidden;
}

.pagination a {
	text-decoration: none;
}

.pagination a:focus,
.pagination a:hover {
	text-decoration: underline;
}

.pagination .dots {
	transform: translateY(-0.3em);
	color: #6d6d6d;
}

.nav-short {
	display: none;
}

/* -------------------------------------------------------------------------- */

/*	14. Error 404
/* -------------------------------------------------------------------------- */


.error404 #site-content {
	padding-top: 4rem;
}

.error404-content {
	text-align: center;
}

.error404 #site-content .search-form {
	justify-content: center;
	margin-top: 3rem;
}


/* -------------------------------------------------------------------------- */

/*	15.	Widgets
/* -------------------------------------------------------------------------- */


/* Widget Base ------------------------------- */

.widget {
	margin-top: 3rem;
}

.widget:first-child {
	margin-top: 0;
}

.widget-content > div > *:first-child {
	margin-top: 0;
}

.widget-content > div > *:last-child {
	margin-bottom: 0;
}

.widget .widget-title {
	margin: 0 0 2rem;
}

.widget li {
	margin: 2rem 0 0 0;
}

.widget li:first-child,
.widget li > ul,
.widget li > ol {
	margin-top: 0;
}

.widget table,
.widget table * {
	border-color: #dedfdf;
}

.widget table caption {
	background-color: #dedfdf;
}

.widget .post-date,
.widget .rss-date {
	color: #6d6d6d;
	display: block;
	font-size: 0.85em;
	font-weight: 500;
	margin-top: 0.2rem;
}

.widget select {
	max-width: 100%;
}

/* Font Families ----------------------------- */

.widget_text p,
.widget_text ol,
.widget_text ul,
.widget_text dl,
.widget_text dt,
.widget-content .rssSummary {
	font-family: NonBreakingSpaceOverride, "Hoefler Text", Garamond, "Times New Roman", serif;
	letter-spacing: normal;
}

.widget-content cite,
.widget-content figcaption,
.widget-content .wp-caption-text {
	font-family: -apple-system, BlinkMacSystemFont, "Helvetica Neue", Helvetica, sans-serif;
}

@supports ( font-variation-settings: normal ) {

	.widget-content cite,
	.widget-content figcaption,
	.widget-content .wp-caption-text {
		font-family: "Inter var", -apple-system, BlinkMacSystemFont, "Helvetica Neue", Helvetica, sans-serif;
	}
}

/* Base List Widget -------------------------- */

.widget_archive ul,
.widget_categories ul,
.widget_pages ul,
.widget_meta ul,
.widget_nav_menu ul,
.widget_recent_comments ul,
.widget_recent_entries ul,
.widget_rss ul {
	list-style: none;
	margin: 0;
}

.widget_archive li,
.widget_categories li,
.widget_pages li,
.widget_meta li,
.widget_nav_menu li {
	color: #6d6d6d;
	margin: 0.3rem 0;
}

.widget_archive li li,
.widget_categories li li,
.widget_pages li li,
.widget_meta li li,
.widget_nav_menu li li {
	margin-right: 2rem;
}

.widget_archive a,
.widget_categories a,
.widget_pages a,
.widget_meta a,
.widget_nav_menu a {
	font-weight: 700;
	text-decoration: none;
}

.widget_archive a:focus,
.widget_archive a:hover,
.widget_categories a:focus,
.widget_categories a:hover,
.widget_pages a:focus,
.widget_pages a:hover,
.widget_meta a:focus,
.widget_meta a:hover,
.widget_nav_menu a:focus,
.widget_nav_menu a:hover {
	text-decoration: underline;
}

/* Widget: Calendar -------------------------- */

.calendar_wrap {
	font-size: 2.4rem;
}

.calendar_wrap th,
.calendar_wrap td,
.wp-calendar-nav span {
	display: table-cell;
	font-size: 1em;
	font-weight: 500;
	line-height: 1;
	padding: 2.5% 2.5% 1.75% 2.5%;
	text-align: center;
}

.wp-calendar-table {
	margin-bottom: 0;
}

.wp-calendar-nav {
	display: table;
	width: 100%;
	font-size: 1.8rem;
}

.calendar_wrap tfoot td {
	border-bottom: none;
}

.calendar_wrap tfoot a,
.calendar_wrap .wp-calendar-nav a {
	text-decoration: none;
}

.calendar_wrap tfoot #prev,
.calendar_wrap .wp-calendar-nav-prev {
	text-align: right;
}

.calendar_wrap tfoot #next,
.calendar_wrap .wp-calendar-nav-next {
	text-align: left;
}

/* Widget: Image ----------------------------- */

/* Widget: Gallery --------------------------- */

.widget_media_gallery .gallery {
	margin: 0 -0.4em -0.8em -0.4em;
	width: calc(100% + 0.8em);
}

.widget_media_gallery .gallery-item {
	margin: 0 0 0.8em 0;
	padding: 0 0.4em;
}

/* Widget: Nav Menu -------------------------- */

.widget_nav_menu .widget-content > div > ul {
	margin-right: 0;
}

/* Widget: Recent Comments ------------------- */

.widget_recent_comments li {
	font-weight: 700;
}

.widget_recent_comments a {
	text-decoration: none;
}

.widget_recent_comments a:focus,
.widget_recent_comments a:hover {
	text-decoration: underline;
}

/* Widget: Recent Entries -------------------- */

.widget_recent_entries a {
	font-weight: 700;
	text-decoration: none;
}

.widget_recent_entries a:focus,
.widget_recent_entries a:hover {
	text-decoration: underline;
}

/* Widget: RSS ------------------------------- */

.widget_rss .widget-title a.rsswidget:first-of-type {
	display: none;
}

.widget_rss .rsswidget {
	font-weight: 700;
}

.widget_rss a {
	text-decoration: none;
}

.widget_rss a:focus,
.widget_rss a:hover {
	text-decoration: underline;
}

.widget_rss .rssSummary {
	margin-top: 0.5rem;
}

.widget_rss cite::before {
	content: "— ";
}

/* Widget: Search ---------------------------- */

.widget_search .search-field {
	border-color: #dedfdf;
}

/* Widget: Tag Cloud ------------------------- */

.widget_tag_cloud a {
	font-weight: 700;
	margin-left: 0.5rem;
	text-decoration: none;
	white-space: nowrap;
}

.widget_tag_cloud a:focus,
.widget_tag_cloud a:hover {
	text-decoration: underline;
}

/* Widget: Text ------------------------------ */


/* -------------------------------------------------------------------------- */

/*	16. Site Footer
/* -------------------------------------------------------------------------- */


.footer-nav-widgets-wrapper,
#site-footer {
	background-color: #fff;
	border-color: #dedfdf;
	border-style: solid;
	border-width: 0;
}

.footer-top-visible .footer-nav-widgets-wrapper,
.footer-top-hidden #site-footer {
	margin-top: 5rem;
}

.reduced-spacing.footer-top-visible .footer-nav-widgets-wrapper,
.reduced-spacing.footer-top-hidden #site-footer {
	border-top-width: 0.1rem;
}

.footer-top,
.footer-widgets-outer-wrapper,
#site-footer {
	padding: 3rem 0;
}


/* Footer Top -------------------------------- */

.footer-top {
	display: flex;
	border-bottom: 0.1rem solid #dedfdf;
	justify-content: space-between;
}

/* FOOTER MENU */

.footer-menu {
	font-size: 1.8rem;
	font-weight: 700;
	letter-spacing: -0.0277em;
}

.footer-menu li {
	line-height: 1.25;
	margin: 0.25em 0 0 0;
}

.footer-menu a {
	text-decoration: none;
	word-break: normal;
	word-wrap: normal;
}

.footer-menu a:hover,
.footer-menu a:focus {
	text-decoration: underline;
}

/* FOOTER SOCIAL */

.footer-social-wrapper {
	margin: 0;
	width: 100%;
}

.has-footer-menu .footer-social-wrapper {
	flex-shrink: 0;
	margin-right: 1rem;
	width: 50%;
}

ul.footer-social {
	margin: -0.5rem -0.5rem 0 0;
}

.has-footer-menu .footer-social {
	justify-content: flex-end;
}

ul.footer-social li {
	margin: 0.5rem 0.5rem 0 0;
}

.footer-social a {
	background-color: #cd2653;
	height: 3.6rem;
	width: 3.6rem;
}

.footer-social a::before {
	font-size: 1.6rem;
}

/* Footer Widgets ---------------------------- */

.footer-widgets-outer-wrapper {
	border-bottom: 0.1rem solid #dedfdf;
}

.footer-widgets + .footer-widgets {
	margin-top: 3rem;
}

/* Footer Bottom ----------------------------- */

#site-footer {
	font-size: 1.6rem;
}

#site-footer .section-inner {
	align-items: baseline;
	display: flex;
	justify-content: space-between;
}

#site-footer a {
	text-decoration: none;
}

#site-footer a:focus,
#site-footer a:hover {
	text-decoration: underline;
}

.footer-copyright a,
.powered-by-wordpress a {
	color: inherit;
}

.powered-by-wordpress,
.to-the-top {
	color: #6d6d6d;
}

a.to-the-top > * {
	pointer-events: none;
}

.footer-copyright {
	font-weight: 600;
	margin: 0;
}

.powered-by-wordpress {
	display: none;
	margin: 0 2.4rem 0 0;
}

.to-the-top-long {
	display: none;
}


/* -------------------------------------------------------------------------- */

/*	17. Media Queries
/* -------------------------------------------------------------------------- */

@media ( max-width: 479px ) {

	/* Blocks -------------------------------- */

	.wp-block-pullquote.alignleft,
	.wp-block-pullquote.alignright {
		float: none;
	}

	/* Entry Content ------------------------- */

	/* LISTS */

	ul,
	ol {
		margin: 0 2rem 3rem 0;
	}

	li {
		margin: 0.5rem 1rem 0 0;
	}

	/* Post Footer --------------------------- */

	/* POST NAV LINKS */

	.post-nav-links {
		margin: 3em 0 0 0;
	}
}

@media ( min-width: 480px ) {

	/* Blocks -------------------------------- */

	/* BLOCK: BASE ALIGNMENT WIDTH */

	.wp-block-pullquote.alignleft,
	.wp-block-pullquote.alignright,
	.wp-block-cover-image.alignleft,
	.wp-block-cover-image.alignright,
	.wp-block-cover.alignleft,
	.wp-block-cover.alignright,
	.wp-block-embed.alignleft,
	.wp-block-embed.alignright,
	.wp-block-gallery.alignleft,
	.wp-block-gallery.alignright {
		max-width: 26rem;
	}

	/* BLOCK: TABLE WIDTH */
	.wp-block-table.alignleft,
	.wp-block-table.alignright {
		max-width: 100%;
	}

	/* Entry Content ------------------------- */

	/* ALIGNMENT CLASSES */

	.alignleft,
	.alignright {
		max-width: 26rem;
	}

	/* Post Footer --------------------------- */

	/* POST NAV LINKS */

	.post-nav-links {
		margin: 3em 0 0 0;
	}
}

@media ( max-width: 599px ) {

	/* Blocks -------------------------------- */

	/* BLOCK: COLUMNS */

	/* While columns are stacked */
	.wp-block-column:last-child {
		margin-bottom: 0;
	}

	.wp-block-columns + .wp-block-columns {
		margin-top: 0.2rem;
	}

	.wp-block-columns.alignwide 