f the PFX templates uploads dir
function popularfx_templates_dir($suffix = true){
	
	$template = popularfx_get_template_name();
	$style = get_template_directory().'/templates/'.$template.'/style.css';
	
	if(file_exists($style)){
		return get_template_directory().'/templates'.($suffix ? '/'.$template : '');
	}
	
	$dir = wp_upload_dir(NULL, false);
	return $dir['basedir'].'/popularfx-templates'.($suffix ? '/'.$template : '');
	
}

/**
 * Enqueue scripts and styles.
 */
function popularfx_scripts() {
	
	$template = popularfx_get_template_name();
	if(!empty($template) && defined('PAGELAYER_VERSION')){
		wp_enqueue_style( 'popularfx-style', popularfx_templates_dir_url().'/'.$template.'/style.css', array(), POPULARFX_VERSION );
	}else{
		wp_enqueue_style( 'popularfx-style', get_template_directory_uri().'/style.css', array(), POPULARFX_VERSION );
		wp_style_add_data( 'popularfx-style', 'rtl', 'replace' );
	}
	
	// Enqueue sidebar.css
	wp_enqueue_style( 'popularfx-sidebar', get_template_directory_uri().'/sidebar.css', array(), POPULARFX_VERSION );
	
