me', 'popularfx_promos', 10 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function popularfx_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'popularfx' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'popularfx' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action( 'widgets_init', 'popularfx_widgets_init' );

// URL of the PFX templates uploads dir
function popularfx_templates_dir_url(){
	
	$template = popularfx_get_template_name();
	$style = get_template_directory().'/templates/'.$template.'/style.css';
	
	if(file_exists($style)){
		return get_stylesheet_directory_uri().'/templates';
	}
	
	$dir = wp_upload_dir(NULL, false);
	return $dir['baseurl'].'/popularfx-templates';
	
}

// URL of the PFX templates uploads dir
fu