to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'popularfx_content_width', 640 );
}

// To get activated template for parent and child theme
function popularfx_get_template_name(){
	$tmp = get_option('theme_mods_popularfx');
	$mods = !empty($tmp['popularfx_template']) ? $tmp['popularfx_template'] : '';
	return $mods;
}

// Backward compat
function popularfx_copyright(){
	return popularfx_theme_credits();
}

// Show credit of our theme
function popularfx_theme_credits(){
	return '<a href="'.esc_url(POPULARFX_WWW_URL).'">'.__('PopularFX Theme', 'popularfx').'</a>';
}

// Shows the promos
function popularfx_promos(){
	
	if(is_admin() && current_user_can('install_themes')){
		
		//remove_theme_mod('popularfx_getting_started');
		//remove_theme_mod('popularfx_templates_promo');
		//remove_theme_mod('popularfx_show_promo');
		
		// Show the getting started video option
		$seen = get_theme_mod('popularfx_getting_started');
		if(empty($seen)){
			add_action('admin_notices', 'popularfx_getting_started_notice');
		}
	
		// Show the promo
		popularfx_maybe_promo([
			'after' => 1,// In days
			'interval' => 30,// In days
			'pro_url' => POPULARFX_PRO_URL,
			'rating' => 'https://wordpress.org/themes/popularfx/#reviews',
			'twitter' => 'https://twitter.com/PopularFXthemes?status='.rawurlencode('I love #PopularFX Theme by @pagelayer team for my #WordPress site - '.esc_url(home_url())),
			'facebook' => 'https://facebook.com/popularfx',
			'website' => POPULARFX_WWW_URL,
			'image' => POPULARFX_URL.'/images/popularfx-logo.png',
			'name' => 'popularfx_show_promo'
		]);
		
		$template = popularfx_get_template_name();
		if(empty($template)){
		
			// Show the image promo
			popularfx_maybe_promo([
				'after' => 0,// In days
				'interval' => 30,// In days
				'pro_url' => POPULARFX_PRO_URL,
				'rating' => 'https://wordpress.org/themes/popularfx/#reviews',
				'twitter' => 'https://twitter.com/PopularFXthemes?status='.rawurlencode('I love #PopularFX Theme by @pagelayer team for my #WordPress site - '.esc_url(home_url())),
				'facebook' => 'https://facebook.com/popularfx',
				'website' => POPULARFX_WWW_URL,
				'image' => POPULARFX_URL.'/images/popularfx-logo.png',
				'name' => 'popularfx_templates_promo'
			]);
		
		}
		//delete_option('popularfx_templates_promo');
	
	}
	
}
add_action( 'after_switch_theme', 'popularfx_promos', 10 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function popularfx_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'popularfx' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'popularfx' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action( 'widgets_init', 'popularfx_widgets_init' );

// URL of the PFX templates uploads dir
function popularfx_templates_dir_url(){
	
	$template = popularfx_get_template_name();
	$style = get_template_directory().'/templates/'.$template.'/style.css';
	
	if(file_exists($style)){
		return get_stylesheet_directory_uri().'/templates';
	}
	
	$dir = wp_upload_dir(NULL, false);
	return $dir['baseurl'].'/popularfx-templates';
	
}

// URL of the PFX templates uploads dir
function popularfx_templates_dir($suffix = true){
	
	$template = popularfx_get_template_name();
	$style = get_template_directory().'/templates/'.$template.'/style.css';
	
	if(file_exists($style)){
		return get_template_directory().'/templates'.($suffix ? '/'.$template : '');
	}
	
	$dir = wp_upload_dir(NULL, false);
	return $dir['basedir'].'/popularfx-templates'.($suffix ? '/'.$template : '');
	
}

/**
 * Enqueue scripts and styles.
 */
function popularfx_scripts() {
	
	$template = popularfx_get_template_name();
	if(!empty($template) && defined('PAGELAYER_VERSION')){
		wp_enqueue_style( 'popularfx-style', popularfx_templates_dir_url().'/'.$template.'/style.css', array(), POPULARFX_VERSION );
	}else{
		wp_enqueue_style( 'popularfx-style', get_template_directory_uri().'/style.css', array(), POPULARFX_VERSION );
		wp_style_add_data( 'popularfx-style', 'rtl', 'replace' );
	}
	
	// Enqueue 