ion_message_array()
	{
		$response = [];
		foreach (self::get_protective_files_array() as $file) {
			if ($file === '.htaccess' && self::get_uploads_root_response_code() === 403) {
				$response[] = '<span class="dashicons dashicons-yes"></span> ' . __('.htaccess file is present and access to uploads directory returns 403 code.', $this->plugin_name);
			}
			if ($file === 'index.php') {
				$response[] = '<span class="dashicons dashicons-yes"></span> ' . __('index.php file is present.', $this->plugin_name);
			}
			if ($file === 'index.html') {
				$response[] = '<span class="dashicons dashicons-yes"></span> ' . __('index.html file is present.', $this->plugin_name);
			}
		}
		if (self::check_protective_file('.htaccess') === true && self::get_uploads_root_response_code() === 200) {
			$response[] = '<span class="dashicons dashicons-search"></span> ' . __('.htaccess file is present but not protecting uploads directory.', $this->plugin_name);
		}
		if (self::check_protective_file('.htaccess') === false && self::get_uploads_root_response_code() === 403) {
			$response[] = '<span class="dashicons dashicons-yes"></span> ' . __('Access to uploads directory is protected (403) with a global .htaccess or another global declaration.', $this->plugin_name);
		}
		return $response;
	}

	public function check_apache()
	{

		if (!function_exists('apache_get_modules')) {
			self::register_message('The Protect Uploads plugin cannot work without Apache. Yourself or your web host has to activate this module.');
		}
	}


	public function register_message($message, $type = 'updated', $id = 0)
	{
		$this->messages['apache'][] = array(
			'message' => __($message, $this->plugin_name),
			'type' => $type,
			'id' => $id
		);
	}

	public function display_messages()
	{

		foreach ($this->messages as $name => $messages) {
			foreach ($messages as $message) {
				return '<div id="message" class="' . $message['type'] . '"><p>' . $message['message'] . '</p></div>';
			}
		}
	}
}
             plugins/protect-uploads/admin/index.php                                                             0000644                 00000000032 15122266562 0014264 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php // Silence is golden                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      plugins/protect-uploads/includes/class-protect-uploads-activator.php                                0000644                 00000000160 15122266562 0022117 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php
class Alti_ProtectUploads_Activator extends Alti_ProtectUploads
{

	public function run()
	{
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                plugins/protect-uploads/includes/class-protect-uploads-deactivator.php                              0000644                 00000000471 15122266562 0022435 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php 
class Alti_ProtectUploads_Deactivator extends Alti_ProtectUploads {

	public function run() {
		$plugin = new Alti_ProtectUploads_Admin($this->plugin_name, $this->version);
		$plugin->remove_index();
		$plugin->remove_htaccess();
		delete_option( $this->get_plugin_name().'-protection' );

	}

}                                                                                                                                                                                                       plugins/protect-uploads/includes/class-protect-uploads-i18n.php                                     0000644                 00000001254 15122266562 0020707 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php
class Alti_ProtectUploads_i18n {

	/**
	 * The domain specified for this plugin.
	 * @var      string    $domain    The domain identifier for this plugin.
	 */
	private $domain;

	/**
	 * Load the plugin text domain for translation.
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			$this->domain,
			false,
			dirname( dirname( plugin_basename