<?php

class Alti_ProtectUploads_Admin
{

	private $plugin_name;
	private $version;
	private $messages = array();

	public function __construct($plugin_name, $version)
	{
		$this->plugin_name = $plugin_name;
		$this->version = $version;
	}

	public function get_plugin_name()
	{
		return $this->plugin_name;
	}

	public function add_submenu_page()
	{
		add_submenu_page('upload.php', $this->plugin_name, 'Protect Uploads <span class="dashicons dashicons-shield-alt" style="font-size:15px;"></span>', 'manage_options', $this->plugin_name . '-settings-page', array($this, 'render_settings_page'));
	}

    public function verify_settings_page() {
        if(!isset($_POST['protect-uploads_nonce'])) {
            return;
        }
        if(!wp_verify_nonce($_POST['protect-uploads_nonce'], 'submit_form')) {
            return;
        }
        if(!current_user_can('manage_options')) {
            return;
        }
        if(!check_admin_referer('submit_form', 'protect-uploads_nonce')) {
            return;
        }
        if (isset($_POST['submit']) && isset($_POST['protection'])) {
            $this->save_form(sanitize_text_field($_POST['protection']));
        }
    }

	public funct