sOptions($key)) {
            return self::secureOptionWithOptions($key, $value, 'escape');
        } else {
            return \YoastSEO_Vendor\WordProof\SDK\Helpers\EscapeHelper::escape($value, $option['escape']);
        }
    }
    /**
     * Returns all site options as object.
     *
     * @return object
     */
    public static function all()
    {
        $optionKeys = \array_keys(\YoastSEO_Vendor\WordProof\SDK\Config\OptionsConfig::get());
        foreach ($optionKeys as $key) {
            $options[$key] = self::get($key);
        }
        return (object) $options;
    }
    /**
     * Deletes all site options.
     */
    public static function reset()
    {
        $optionKeys = \array_keys(\YoastSEO_Vendor\WordProof\SDK\Config\OptionsConfig::get());
        foreach ($optionKeys as $key) {
            self::delete($key);
        }
    }
    /**
     * Deletes authentication options.
     */
    public static function resetAuthentication()
    {
        $optionKeys = ['access_token', 'source_id'];
        foreach ($optionKeys as $key) {
            self::delete($key);
        }
    }
    /**
     * Retrieves the access token.
     *
     * @return string|null
     */
    public static function accessToken()
    {
        return self::get('access_token');
    }
    /**
     * Retrieves the source id.
     *
     * @return integer|null
     */
    public static function sourceId()
    {
        return self::get('source_id');
    }
    /**
     * Sets the access token.
     *
     * @param string|null $value The access token to be set.
     * @return bool
     */
    public static function setAccessToken($value)
    {
        return self::set('access_token', $value);
    }
    /**
     * Sets the source id.
     *
     * @param integer|null $value The source id to be set.
     * @return bool
     */
    public static function setSourceId($value)
    {
        return self::set('source_id', $value);
    }
    /**
     * Retrieves the option settings from the config.
     *
     * @param string $key The option key.
     * @return array|false|mixed
     */
    private static function getOptionFromConfig($key)
    {
        $option = \YoastSEO_Vendor\WordProof\SDK\Config\OptionsConfig::get($key);
        if ($option && \array_key_exists('escape', $option) && \array_key_exists('default', $option)) {
            return $option;
        }
        return \false;
    }
    /**
     * Returns if the given option key contains options itself.
     *
     * @param string $key The option key to be checked.
     * @return bool
     */
    private static function optionContainsOptions($key)
    {
        $option = \YoastSEO_Vendor\WordProof\SDK\Config\OptionsConfig::get($key);
        return $option && \array_key_exists('options', $option);
    }
    /**
     * Loops through an option that contains options to either sanitize or escape the result.
     *
     * @param $key
     * @param $value
     * @param string $method
     * @return array|object
     */
    private static function secureOptionWithOptions($key, $value, $method = 'sanitize')
    {
        $isObject = \is_object($value);
        if (\is_object($value)) {
            $value = (array) $value;
        }
        if (\is_array($value)) {
            $values = [];
            foreach ($value as $optionKey => $optionValue) {
                $optionConfig = self::getOptionFromConfig($key . '.options.' . $optionKey);
                if (!$optionConfig) {
                    continue;
                }
                if ($method === 'escape') {
                    $securedValue = \YoastSEO_Vendor\WordProof\SDK\Helpers\EscapeHelper::escape($optionValue, $optionConfig['escape']);
                } else {
                    $securedValue = \YoastSEO_Vendor\WordProof\SDK\Helpers\SanitizeHelper::sanitize($optionValue, $optionConfig['escape']);
                }
                $values[$optionKey] = $securedValue;
            }
            if ($isObject) {
                return (object) $values;
            }
            return $values;
        }
        return [];
    }
}
wordpress-seo-extended/vendor_prefixed/wordproof/wordpress-sdk/app/Helpers/PostEditorHelper.php     0000644                 00000007720 15122266561 0030736 0                                                                                                    ustar 00                                                                                plugins                                                                                                                                                                <?php

namespace YoastSEO_Vendor\WordProof\SDK\Helpers;

use YoastSEO_Vendor\WordProof\SDK\Translations\TranslationsInterface;
class PostEditorHelper
{
    /**
     * Returns the post editor that is in use.
     *
     * @return bool The post editor the user is using..
     */
    public static function getPostEditor()
    {
        if (!\function_exists('YoastSEO_Vendor\\get_current_screen')) {
            return null;
        }
        $screen = \get_current_screen();
        if (!self::isPostEdit($screen->base)) {
            return null;
        }
        // Start with Elementor, otherwise the block editor will be returned.
        $action = \filter_input(\INPUT_GET, 'action', \FILTER_SANITIZE_STRING);
        if ($action === 'elementor') {
            return 'elementor';
        }
        if (\method_exists($screen, 'is_block_editor') && $screen->is_block_editor()) {
            return 'block';
        }
        return 'classic';
    }
    /**
     * Returns if the page is a post edit page.
     *
     * @param string $page The page to check.
     * @return bool If the current page is a post edit page.
     */
    public static function isPostEdit($page)
    {
        return \in_array($page, self::getPostEditPages(), \true);
    }
    /**
     * Returns an array of edit page hooks.
     *
     * @return array Post edit page hooks.
     */
    public