-field>
        <custom-field action="copy_once">_yoast_wpseo_meta-robots-adv</custom-field>
        <custom-field action="ignore">_yoast_wpseo_canonical</custom-field>
        <custom-field action="ignore">_yoast_wpseo_redirect</custom-field>
        <custom-field action="translate">_yoast_wpseo_opengraph-description</custom-field>
    </custom-fields>
    <admin-texts>
        <key name="wpseo_titles">
            <key name="title-home-wpseo" />
            <key name="metadesc-home-wpseo" />
            <key name="title-post" />
            <key name="metadesc-post" />
            <key name="title-page" />
            <key name="metadesc-page" />
            <key name="title-attachment" />
            <key name="metadesc-attachment" />
            <key name="title-category" />
            <key name="metadesc-category" />
            <key name="title-tax-post_tag" />
            <key name="metadesc-tax-post_tag" />
            <key name="title-author-wpseo" />
            <key name="metadesc-author-wpseo" />
            <key name="title-archive-wpseo" />
            <key name="metadesc-archive-wpseo" />
            <key name="title-search-wpseo" />
            <key name="title-404-wpseo" />
            <key name="breadcrumbs-sep" />
            <key name="breadcrumbs-home" />
            <key name="breadcrumbs-prefix" />
            <key name="breadcrumbs-archiveprefix" />
            <key name="breadcrumbs-searchprefix" />
            <key name="breadcrumbs-404crumb" />
            <key name="rssbefore" />
            <key name="rssafter" />
        </key>
    </admin-texts>
</wpml-config>
                                                                                                                                                                                                                                                                                                                                                                                                                                             plugins/wordpress-seo-extended/wp-seo-main.php                                                      0000644                 00000041714 15122266561 0015521 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php
/**
 * WPSEO plugin file.
 *
 * @package WPSEO\Main
 */

if ( ! function_exists( 'add_filter' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit();
}

/**
 * {@internal Nobody should be able to overrule the real version number as this can cause
 *            serious issues with the options, so no if ( ! defined() ).}}
 */
define( 'WPSEO_VERSION', '22.5' );


if ( ! defined( 'WPSEO_PATH' ) ) {
	define( 'WPSEO_PATH', plugin_dir_path( WPSEO_FILE ) );
}

if ( ! defined( 'WPSEO_BASENAME' ) ) {
	define( 'WPSEO_BASENAME', plugin_basename( WPSEO_FILE ) );
}

/*
 * {@internal The prefix constants are used to build prefixed versions of dependencies.
 *            These should not be changed on run-time, thus missing the ! defined() check.}}
 */
define( 'YOAST_VENDOR_NS_PREFIX', 'YoastSEO_Vendor' );
define( 'YOAST_VENDOR_DEFINE_PREFIX', 'YOASTSEO_VENDOR__' );
define( 'YOAST_VENDOR_PREFIX_DIRECTORY', 'vendor_prefixed' );

define( 'YOAST_SEO_PHP_REQUIRED', '7.2.5' );
define( 'YOAST_SEO_WP_TESTED', '6.5.2' );
define( 'YOAST_SEO_WP_REQUIRED', '6.3' );

if ( ! defined( 'WPSEO_NAMESPACES' ) ) {
	define( 'WPSEO_NAMESPACES', true );
}


/* ***************************** CLASS AUTOLOADING *************************** */

/**
 * Autoload our class files.
 *
 * @param string $class_name Class name.
 *
 * @return void
 */
function wpseo_auto_load( $class_name ) {
	static $classes = null;

	if ( $classes === null ) {
		$classes = [
			'wp_list_table'   => ABSPATH . 'wp-admin/includes/class-wp-list-table.php',
			'walker_category' => ABSPATH . 'wp-includes/category-template.php',
		];
	}

	$cn = strtolower( $class_name );

	if ( ! class_exists( $class_name ) && isset( $classes[ $cn ] ) ) {
		require_once $classes[ $cn ];
	}
}

$yoast_autoload_file = WPSEO_PATH . 'vendor/autoload.php';

if ( is_readable( $yoast_autoload_file ) ) {
	$yoast_autoloader = require $yoast_autoload_file;
}
elseif ( ! class_exists( 'WPSEO_Options' ) ) { // Still checking since might be site-level autoload R.
	add_action( 'admin_init', 'yoast_wpseo_missing_autoload', 1 );

	return;
}

/**
 * Include the file from the `symfony/deprecation-contracts` dependency instead of autoloading it via composer.
 *
 * We need to do that because autoloading via composer prevents the vendor-prefixing of the dependency itself.
 * Note that we don't expect the function to be ever called since the OAuth2 library should not provide invalid input.
 */
$deprecation_contracts_file = WPSEO_PATH . 'vendor_prefixed/symfony/deprecation-contracts/functions.php';
if ( is_readable( $deprecation_contracts_file ) ) {
	include $deprecation_contracts_file;
}

if ( function_exists( 'spl_autoload_register' ) ) {
	spl_autoload_register( 'wpseo_auto_load' );
}
require_once WPSEO_PATH . 'src/functions.php';

/* ********************* DEFINES DEPENDING ON AUTOLOADED CODE ********************* */

/**
 * Defaults to production, for safety.
 */
if ( ! defined( 'YOAST_ENVIRONMENT' ) ) {
	define( 'YOAST_ENVIRONMENT', 'production' );
}

if ( YOAST_ENVIRONMENT === 'development' && isset( $yoast_autoloader ) ) {
	add_action(
		'plugins_loaded',
		/**
		 * Reregisters the autoloader so that Yoast SEO is at the front.
		 * This prevents conflicts with the development versions of our addons.
		 * An anonymous function is used so we can use the autoloader variable.
		 * As this is only loaded in development removing this action is not a concern.
		 *
		 * @return void
		 */
		static function () use ( $yoast_autoloader ) {
			$yoast_autoloader->unregister();
			$yoast_autoloader->register( true );
		},
		1
	);
}

/**
 * Only use minified assets when we are in a production environment.
 */
if ( ! defined( 'WPSEO_CSSJS_SUFFIX' ) ) {
	define( 'WPSEO_CSSJS_SUFFIX', ( YOAST_ENVIRONMENT !== 'development' ) ? '.min' : '' );
}

/* ***************************** PLUGIN (DE-)ACTIVATION *************************** */

/**
 * Run single site / network-wide activation of the plugin.
 *
 * @param bool $networkwide Whether the plugin is being activated network-wide.
 *
 * @return void
 */
function wpseo_activate( $networkwide = false ) {
	if ( ! is_multisite() || ! $networkwide ) {
		_wpseo_activate();
	}
	else {
		/* Multi-site network activation - activate the plugin for all blogs. */
		wpseo_network_activate_deactivate( true );
	}

	// This is done so that the 'uninstall_{$file}' is triggered.
	register_uninstall_hook( WPSEO_FILE, '__return_false' );
}

/**
 * Run single site / network-wide de-activation of the plugin.
 *
 * @param bool $networkwide Whether the plugin is being de-activated network-wide.
 *
 * @return void
 */
function wpseo_deactivate( $networkwide = false ) {
	if ( ! is_multisite() || ! $networkwide