    public function __construct(\YoastSEO_Vendor\WordProof\SDK\Config\AppConfigInterface $appConfig = null, \YoastSEO_Vendor\WordProof\SDK\Translations\TranslationsInterface $translations = null)
    {
        if (\defined('WORDPROOF_TIMESTAMP_SDK_VERSION')) {
            return;
        }
        $this->loader = new \YoastSEO_Vendor\WordProof\SDK\Support\Loader();
        $this->appConfig = $appConfig ?: new \YoastSEO_Vendor\WordProof\SDK\Config\DefaultAppConfig();
        $this->translations = $translations ?: new \YoastSEO_Vendor\WordProof\SDK\Translations\DefaultTranslations();
        $this->authentication();
        $this->api();
        $this->timestamp();
        $this->settings();
        $this->postEditorData();
        $this->notices();
        if (!\defined('WORDPROOF_TIMESTAMP_SDK_FILE')) {
            \define('WORDPROOF_TIMESTAMP_SDK_FILE', __FILE__);
        }
        if (!\defined('WORDPROOF_TIMESTAMP_SDK_VERSION')) {
            \define('WORDPROOF_TIMESTAMP_SDK_VERSION', $this->version);
        }
        return $this;
    }
    /**
     * Singleton implementation of WordPress SDK.
     *
     * @param AppConfigInterface|null $appConfig
     * @param TranslationsInterface|null $translations
     * @return WordPressSDK|null Returns the WordPress SDK instance.
     * @throws \Exception
     */
    public static function getInstance(\YoastSEO_Vendor\WordProof\SDK\Config\AppConfigInterface $appConfig = null, \YoastSEO_Vendor\WordProof\SDK\Translations\TranslationsInterface $translations = null)
    {
        if (self::$instance === null) {
            self::$instance = new \YoastSEO_Vendor\WordProof\SDK\WordPressSDK($appConfig, $translations);
        }
        return self::$instance;
    }
    /**
     * Runs the loader and initializes the class.
     *
     * @return $this
     */
    public function initialize()
    {
        $this->loader->run();
        return $this;
    }
    /**
     * Initializes the authentication feature.
     */
    private function authentication()
    {
        $class = new \YoastSEO_Vendor\WordProof\SDK\Controllers\AuthenticationController();
        $this->loader->addAction('wordproof_authenticate', $class, 'authenticate');
        $this->loader->addAction('admin_menu', $class, 'addRedirectPage');
        $this->loader->addAction('admin_menu', $class, 'addSelfDestructPage');
        $this->loader->addAction('load-admin_page_wordproof-redirect-authenticate', $