t_type;
        }
        if ($typenow) {
            return $typenow;
        }
        if ($current_screen && $current_screen->post_type) {
            return $current_screen->post_type;
        }
        // phpcs:disable WordPress.Security.NonceVerification
        if (isset($_REQUEST['post_type'])) {
            return \sanitize_key($_REQUEST['post_type']);
        }
        // phpcs:enable WordPress.Security.NonceVerification
        return null;
    }
}
                                                wordpress-seo-extended/vendor_prefixed/wordproof/wordpress-sdk/app/Helpers/PostMetaHelper.php       0000644                 00000003163 15122266561 0030373 0                                                                                                    ustar 00                                                                                plugins                                                                                                                                                                <?php

namespace YoastSEO_Vendor\WordProof\SDK\Helpers;

class PostMetaHelper
{
    /**
     * @param integer $postId The post id for which the meta should be set.
     * @param string $key The key for the post meta.
     * @param mixed $value The value for the post meta.
     * @return integer|boolean Returns the post meta id or false on failure.
     */
    public static function add($postId, $key, $value, $single = \false)
    {
        return \add_post_meta($postId, $key, $value, $single);
    }
    /**
     * @param integer $postId The post id for which the meta should be set.
     * @param string $key The key for the post meta.
     * @param mixed $value The value for the post meta.
     * @return integer|boolean Returns the post meta id or false on failure.
     */
    public static function update($postId, $key, $value)
    {
        return \update_post_meta($postId, $key, $value);
    }
    /**
     * @param integer $postId The post id for which the meta should be set.
     * @param string $key The key for the post meta.
     * @param bool $single If a single result should be returned.
     * @return mixed Returns the post meta data or false on failure.
     */
    public static function get($postId, $key, $single = \true)
    {
        return \get_post_meta($postId, $key, $single);
    }
    /**
     * @param integer $postId The post id for which the meta should be set.
     * @param string $key The key for the post meta.
     * @return boolean Returns if the post meta key exists for the post id.
     */
    public static function has($postId, $key)
    {
        return \boolval(self::get($postId, $key));
    }
}
                                                                                                                                                                                                                                                                                                                                                                                                             wordpress-seo-extended/vendor_prefixed/wordproof/wordpress-sdk/app/Helpers/PostTypeHelper.php       0000644                 00000001322 15122266561 0030421 0                                                                                                    ustar 00                                                                                plugins                                                                                                                                                                <?php

namespace YoastSEO_Vendor\WordProof\SDK\Helpers;

class PostTypeHelper
{
    /**
     * Returns public post types.
     *
     * @return array The public post types.
     */
    public static function getPublicPostTypes()
    {
        return \array_values(\get_post_types(['public' => \true]));
    }
    public static function getUnprotectedPosts($postType)
    {
        $query = ['post_type' => [$postType], 'fields' => 'ids', 'posts_per_page' => -1, 'post_status' => ['publish', 'inherit'], 'meta_query' => [['key' => '_wordproof_blockchain_transaction', 'compare' => 'NOT EXISTS']]];
        $query = new \WP_Query($query);
        return ['count' => $query->found_posts, 'postIds' => $query->posts];
    }
}
                                                                                                                                                                                                                                                                                                              wordpress-seo-extended/vendor_prefixed/wordproof/wordpress-sdk/app/Helpers/RedirectHelper.php       0000644                 00000000512 15122266561 0030373 0                                                                                                    ustar 00                                                                                plugins                                                                                                                                                                <?php

namespace YoastSEO_Vendor\WordProof\SDK\Helpers;

class RedirectHelper
{
    /**
     * Does a safe redirect to an admin page.
     *
     * @param string $url The url to be redirected to.
     */
    public static function safe($url)
    {
        nocache_headers();
        \wp_safe_redirect($url);
        exit;
    }
}
                                                                                                                                                                                      wordpress-seo-extended/vendor_prefixed/wordproof/wordpress-sdk/app/Helpers/ReflectionHelper.php     0000644                 00000001000 15122266561 0030715 0                                                                                                    ustar 00                                                                                plugins                                                                                                                                                                <?php

namespace YoastSEO_Vendor\WordProof\SDK\Helpers;

use YoastSEO_Vendor\WordProof\SDK\WordPressSDK;
class ReflectionHelper
{
    /**
     * @param class $instance The class from which to get the name.
     * @return false|string
     */
    public static function name($instance)
    {
        if ($instance instanceof \YoastSEO_Vendor\WordProof\SDK\WordPressSDK) {
            $reflector = new \ReflectionClass($instance);
            return $reflector->getName();
        }
        return \false;
    }
}
plugins/wordpress-seo-extended/vendor_prefixed/wordproof/wordpress-sdk/app/Helpers/RestApiHelper.php0000644                 00000002576 15122266561 0030274 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace YoastSEO_Vendor\WordProof\SDK\Helpers;

use YoastSEO_Vendor\WordProof\SDK\Config\RoutesConfig;
class RestApiHelper
{
    private static function buildPath($endpoint)
    {
        return 'wordproof/v1' . $endpoint;
    }
    public static function getNamespace()
    {
        return self::buildPath('');
    }
    public static function route($slug)
    {
        $routes = \YoastSEO_Vendor\WordProof\SDK\Config\RoutesConfig::get();
        if (isset($routes[$slug])) {
            return $routes[$slug];
        }
        throw new \Exception('Route slug does not exist.');
    }
    public static function endpoint($slug)
    {
        $route = self::route($slug);
        if (isset($route['endpoint'])) {
            return $route['endpoint'];
        }
        throw new \Exception('Endpoint for route does not exist.');
    }
    public static function getRestRoute($slug, $params = [])
    {
        $url = \get_rest_url(null, self::buildPath(self::endpoint($slug)));
        \preg_match_all("/\\(.+?\\)/", $url, $matches);
        if (!isset($matches) || !isset($matches[0])) {
            return $url;
        }
        if (!\is_array($params) || \count($params) !== \count($matches[0])) {
            return $url;
        }
        foreach ($matches[0] as $index => $match) {
            $url = \str_replace($match, $params[$index], $url);
        }
        return $url;
    }
}
                                                                                                                                  wordpress-seo-extended/vendor_prefixed/wordproof/wordpress-sdk/app/Helpers/SanitizeHelper.php       0000644                 00000004175 15122266561 0030431 0                                                                                                    ustar 00                                                                                plugins                                                                                                                                                                <?php

namespace YoastSEO_Vendor\WordProof\SDK\Helpers;

class SanitizeHelper
{
    /**
     * Returns the value sanitized according to the escape function set in the class.
     *
     * @param mixed $value The value to be sanitized.
     * @param string $sanitizeKey The sanitize function to be used.
     *
     * @return array|bool|int|string
     */
    public static function sanitize($value, $sanitizeKey)
    {
        if (\is_array($value)) {
            return self::sanitizeArray($value, $sanitizeKey);
        }
        if (\is_object($value)) {
            return (object) self::sanitizeArray((array) $value, $sanitizeKey);
        }
        return self::sanitizeSingleValue($value, $sanitizeKey);
    }
    /**
     * Loops through the array to sanitize the values inside.
     *
     * @param array $array The array with values to be escaped.
     * @param string $sanitizeKey The sanitize function to be used.
     * @return array Array with escapes values.
     */
    private static function sanitizeArray($array, $sanitizeKey)
    {
        $values = [];
        foreach ($array as $key => $value) {
            $values[$key] = self::sanitizeSingleValue($value, $sanitizeKey);
        }
        return $values;
    }
    /**
     * Sanitize a single value using an escape function set in the class.
     *
     * @param string $value The value to be sanitized.
     * @param string $sanitizeKey The sanitize function to be used.
     * @return bool|int|string The sanitized value.
     */
    private static function sanitizeSingleValue($value, $sanitizeKey)
    {
        switch ($sanitizeKey) {
            case 'integer':
                return \intval($value);
            case 'boolean':
                return \boolval($value);
            case 'html_class':
                return \sanitize_html_class($value);
            case 'email':
                return \sanitize_email($value);
            case 'url':
                return \esc_url_raw($value);
            case 'key':
                return \sanitize_key($value);
            case 'text_field':
            default:
                return \sanitize_text_field($value);
        }
    }
}
                                                                                                                                                                                                                                                                                                                                                                                                   plugins/wordpress-seo-extended/vendor_prefixed/wordproof/wordpress-sdk/app/Helpers/SchemaHelper.php 0000644                 00000003351 15122266561 0030115 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace YoastSEO_Vendor\WordProof\SDK\Helpers;

class SchemaHelper
{
    /**
     * Builds an blockchain transaction schema object as array.
     *
     * @param object $response The response by WordProof.
     * @return array The blockchain transaction in the correct schema format.
     */
    public static function getBlockchainTransaction($response)
    {
        $postId = $response->uid;
        $hashLink = \YoastSEO_Vendor\WordProof\SDK\Helpers\RestApiHelper::getRestRoute('hashInput', [$postId, $response->hash]);
        $identifier = null;
        if (isset($response->transaction)) {
            $transaction = $response->transaction;
            if (isset($transaction->transactionId)) {
                $identifier = $transaction->transactionId;
            }
            if (isset($transaction->tx)) {
                $identifier = $transaction->tx;
            }
        }
        return ['@type' => 'BlockchainTransaction', 'identifier' => $identifier, 'hash' => $response->hash, 'hashLink' => $hashLink, 'recordedIn' => ['@type' => 'Blockchain', 'name' => $response->transaction->blockchain]];
    }
    /**
     * Retrieves the schema as array for a post.
     *
     * @param integer $postId The post id for which the schema should be returned.
     * @return array The schema as array.
     */
    public static function getSchema($postId)
    {
        $transactions = \YoastSEO_Vendor\WordProof\SDK\Helpers\PostMetaHelper::get($postId, '_wordproof_blockchain_transaction', \false);
        $latest = \array_pop($transactions);
        if (\count($transactions) === 0) {
            return ['timestamp' => $latest];
        }
        return ['timestamp' => \array_merge($latest, ['revisions' => \array_reverse($transactions)])];
    }
}
                                                                                                                                                                                                                                                                                       wordpress-seo-extended/vendor_prefixed/wordproof/wordpress-sdk/app/Helpers/SettingsHelper.php       0000644                 00000002741 15122266561 0030440 0                                                                                                    ustar 00                                                                                plugins                                                                                                                                                                <?php

namespace YoastSEO_Vendor\WordProof\SDK\Helpers;

use YoastSEO_Vendor\WordProof\SDK\Config\OptionsConfig;
class SettingsHelper
{
    private static $key = 'settings';
    /**
     * Retrieving settings from the option.
     *
     * @param null $setting The key for the setting
     * @return array|bool|int|mixed|object|string|null
     */
    public static function get($setting = null)
    {
        $settings = \YoastSEO_Vendor\WordProof\SDK\Helpers\OptionsHelper::get(self::$key);
        if ($setting) {
            $option = \YoastSEO_Vendor\WordProof\SDK\Config\OptionsConfig::get('settings.options.' . $setting);
            if (isset($settings->{$setting}) && $option) {
                return $settings->{$setting};
            }
            return $option['default'];
        }
        return (object) $settings;
    }
    public static function showRevisions()
    {
        return self::get('show_revisions');
    }
    public static function certificateLinkText()
    {
        return self::get('certificate_link_text');
    }
    public static function hideCertificateLink()
    {
        return self::get('hide_certificate_link');
    }
    public static function selectedPostTypes()
    {
        return \apply_filters('wordproof_timestamp_post_types', self::get('selected_post_types'));
    }
    public static function postTypeIsInSelectedPostTypes($postType)
    {
        $postTypes = self::selectedPostTypes();
        return \in_array($postType, $postTypes, \true);
    }
}
                               plugins/wordpress-seo-extended/vendor_prefixed/wordproof/wordpress-sdk/app/Helpers/StringHelper.php 0000644                 00000001370 15122266561 0030162 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace YoastSEO_Vendor\WordProof\SDK\Helpers;

class StringHelper
{
    /**
     * Replace the last occurrence.
     *
     * @param string $search
     * @param string $replace
     * @param string $subject
     * @return string
     */
    public static function lastReplace($search, $replace, $subject)
    {
        $pos = \strrpos($subject, $search);
        if ($pos !== \false) {
            $subject = \substr_replace($subject, $replace, $pos, \strlen($search));
        }
        return $subject;
    }
    /**
     * PascalCase to snake_case
     *
     * @param $string
     * @return string
     */
    public static function toUnderscore($string)
    {
        return \strtolower(\preg_replace('/(?<!^)[A-Z]/', '_$0', $string));
    }
}
                                                                                                                                                                                                                                                                        wordpress-seo-extended/vendor_prefixed/wordproof/wordpress-sdk/app/Helpers/TimestampHelper.php      0000644                 00000006611 15122266561 0030603 0                                                                                                    ustar 00                                                                                plugins                                                                                                                                                                <?php

namespace YoastSEO_Vendor\WordProof\SDK\Helpers;

use YoastSEO_Vendor\WordProof\SDK\DataTransferObjects\TimestampData;
use YoastSEO_Vendor\WordProof\SDK\Support\Timestamp;
class TimestampHelper
{
    public static function debounce(\WP_Post $post)
    {
        $key = 'wordproof_timestamped_debounce_' . $post->id;
        $data = \YoastSEO_Vendor\WordProof\SDK\DataTransferObjects\TimestampData::fromPost($post);
        $transient = \YoastSEO_Vendor\WordProof\SDK\Helpers\TransientHelper::get($key);
        if ($transient) {
            return new \WP_REST_Response($transient, $transient->status);
        }
        $response = self::shouldBeTimestamped($post, $data);
        if (\is_bool($response) && $response === \false) {
            $response = (object) ['status' => 200, 'message' => 'Post should not be timestamped'];
            return new \WP_REST_Response($response, $response->status);
        }
        if (\is_array($response) && $response['timestamp'] === \false) {
            $response = (object) ['status' => 400, 'message' => 'Post should not be timestamped', 'error' => 'not_authenticated'];
            return new \WP_REST_Response($response, $response->status);
        }
        $response = \YoastSEO_Vendor\WordProof\SDK\Support\Timestamp::sendPostRequest($data);
        if ($response === \false) {
            $response = (object) ['status' => 400, 'message' => 'Something went wrong.', 'error' => 'timestamp_failed'];
            return new \WP_REST_Response($response, $response->status);
        }
        $response->status = 201;
        \YoastSEO_Vendor\WordProof\SDK\Helpers\TransientHelper::set($key, $response, 5);
        return new \WP_REST_Response($response, $response->status);
    }
    public static function shouldBeTimestamped(\WP_Post $post, $data)
    {
        if (!\YoastSEO_Vendor\WordProof\SDK\Helpers\AuthenticationHelper::isAuthenticated()) {
            if (self::hasPostMetaOverrideSetToTrue($post)) {
                return ['timestamp' => \false, 'notice' => 'not_authenticated'];
            }
            return \false;
        }
        if ($post->post_type !== 'attachment' && $post->post_content === '') {
            return \false;
        }
        if ($post->post_type === 'attachment' && \get_attached_file($post->ID) === \false) {
            return \false;
        }
        if (!\in_array($post->post_status, ['publish', 'inherit'], \true)) {
            return \false;
        }
        if (\YoastSEO_Vendor\WordProof\SDK\Helpers\SettingsHelper::postTypeIsInSelectedPostTypes($post->post_type)) {
            return \true;
        }
        if (self::hasPostMetaOverrideSetToTrue($post)) {
            return \true;
        }
        return \false;
    }
    private static function hasPostMetaOverrideSetToTrue(\WP_Post $post)
    {
        $timestampablePostMetaKeys = \apply_filters('wordproof_timestamp_post_meta_key_overrides', ['_wordproof_timestamp']);
        //Do not use PostMeta helper
        $meta = \get_post_meta($post->ID);
        foreach ($timestampablePostMetaKeys as $key) {
            if (!isset($meta[$key])) {
                continue;
            }
            if (\is_array($meta[$key])) {
                $value = \boolval($meta[$key][0]);
            } else {
                $value = \boolval($meta[$key]);
            }
            if (!$value) {
                continue;
            }
            return \true;
        }
        return \false;
    }
}
                                                                                                                       wordpress-seo-extended/vendor_prefixed/wordproof/wordpress-sdk/app/Helpers/TransientHelper.php      0000644                 00000002711 15122266561 0030604 0                                                                                                    ustar 00                                                                                plugins                                                                                                                                                                <?php

namespace YoastSEO_Vendor\WordProof\SDK\Helpers;

use YoastSEO_Vendor\WordProof\SDK\DataTransferObjects\TimestampData;
class TransientHelper
{
    /**
     * Set transient.
     *
     * @param $key
     * @param $value
     * @param int $expiration
     * @return bool
     */
    public static function set($key, $value, $expiration = 0)
    {
        return \set_transient($key, $value, $expiration);
    }
    /**
     * Returns and deletes site transient by key.
     *
     * @param $key
     * @return mixed
     */
    public static function getOnce($key)
    {
        $value = \get_transient($key);
        \delete_transient($key);
        return $value;
    }
    /**
     * Returns the transient by key.
     *
     * @param $key
     * @return mixed
     */
    public static function get($key)
    {
        return \get_transient($key);
    }
    /**
     * Debounce callback for post id.
     *
     * @param $postId
     * @param $action
     * @param $callback
     * @return mixed
     */
    public static function debounce($postId, $action, $callback)
    {
        $key = 'wordproof_debounce_' . $action . '_' . $postId;
        $transient = \YoastSEO_Vendor\WordProof\SDK\Helpers\TransientHelper::get($key);
        if ($transient) {
            return $transient;
        } else {
            \YoastSEO_Vendor\WordProof\SDK\Helpers\TransientHelper::set($key, \true, 4);
            $result = $callback();
            return $result;
        }
    }
}
                                                       plugins/wordpress-seo-extended/vendor_prefixed/wordproof/wordpress-sdk/app/Support/Api.php          0000644                 00000002405 15122266561 0026337 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace YoastSEO_Vendor\WordProof\SDK\Support;

use YoastSEO_Vendor\WordProof\SDK\Helpers\EnvironmentHelper;
use YoastSEO_Vendor\WordProof\SDK\Helpers\OptionsHelper;
class Api
{
    /**
     * @param string $endpoint
     * @param array $body
     * @return mixed
     */
    public static function post($endpoint, $body = [])
    {
        $location = \YoastSEO_Vendor\WordProof\SDK\He