      return \apply_filters('wordproof_timestamp_show_certificate', \YoastSEO_Vendor\WordProof\SDK\Helpers\PostMetaHelper::has($post->ID, '_wordproof_schema'), $post);
    }
}
                                                                                                                                                                                                                                                                                                                                                wordpress-seo-extended/vendor_prefixed/wordproof/wordpress-sdk/app/Helpers/ClassicNoticeHelper.php  0000644                 00000003154 15122266561 0031362 0                                                                                                    ustar 00                                                                                plugins                                                                                                                                                                <?php

namespace YoastSEO_Vendor\WordProof\SDK\Helpers;

class ClassicNoticeHelper
{
    /**
     * @var string The key used for the transient to save the single notice.
     */
    public static $transientKey = 'wordproof_notice';
    /**
     * Add a new transient with a notice key.
     *
     * @param string $noticeKey The noticeKey that should be displayed to the user.
     */
    public static function add($noticeKey)
    {
        \YoastSEO_Vendor\WordProof\SDK\Helpers\TransientHelper::set(self::$transientKey, $noticeKey);
    }
    /**
     * Add new notice depending on the timestamp response.
     *
     * @param \WP_REST_Response $response The timestamp response.
     */
    public static function addTimestampNotice($response)
    {
        $notice = self::getNoticeKeyForTimestampResponse($response->get_data());
        if ($notice) {
            self::add($notice);
        }
    }
    /**
     * Retrieve notice key for the timestamp response data.
     *
     * @param object $data The timestamp response data.
     * @return string The notice key for this response data.
     */
    private static function getNoticeKeyForTimestampResponse($data)
    {
        if (isset($data->error) && $data->error === 'not_authenticated') {
            return 'not_authenticated';
        }
        if (isset($data->balance) && $data->balance === 0) {
            return 'no_balance';
        }
        if (isset($data->hash)) {
            return 'timestamp_success';
        }
        if (isset($data->error) && $data->error === 'timestamp_failed') {
            return 'timestamp_failed';
        }
        return null;
    }
}
                                                                                                                                                                                                                                                                                                                                                                                                                    wordpress-seo-extended/vendor_prefixed/wordproof/wordpress-sdk/app/Helpers/EnvironmentHelper.php    0000644                 00000002653 15122266561 0031146 0                                                                                                    ustar 00                                                                                plugins                                                                                                                                                                <?php

namespace YoastSEO_Vendor\WordProof\SDK\Helpers;

use YoastSEO_Vendor\WordProof\SDK\Config\EnvironmentConfig;
class EnvironmentHelper
{
    public static function url()
    {
        $appConfig = \YoastSEO_Vendor\WordProof\SDK\Helpers\AppConfigHelper::getAppConfig();
        if ($appConfig->getWordProofUrl()) {
            return $appConfig->getWordProofUrl();
        }
        return self::get('url');
    }
    public static function client()
    {
        $appConfig = \YoastSEO_Vendor\WordProof\SDK\Helpers\AppConfigHelper::getAppConfig();
        if ($appConfig->getOauthClient()) {
            return $appConfig->getOauthClient();
        }
        return self::get('client');
    }
    public static function sslVerify()
    {
        return !\YoastSEO_Vendor\WordProof\SDK\Helpers\EnvironmentHelper::development();
    }
    public static function development()
    {
        return \YoastSEO_Vendor\WordProof\SDK\Helpers\AppConfigHelper::getEnvironment() === 'development';
    }
    public static function get($key)
    {
        $envConfig = self::environmentConfig();
        if ($envConfig && isset($envConfig[$key])) {
            return $envConfig[$key];
        }
        return null;
    }
    private static function environmentConfig()
    {
        $env = \YoastSEO_Vendor\WordProof\SDK\Helpers\AppConfigHelper::getEnvironment();
        return \YoastSEO_Vendor\WordProof\SDK\Config\EnvironmentConfig::get($env);
    }
}
                                                                                     plugins/wordpress-seo-extended/vendor_prefixed/wordproof/wordpress-sdk/app/Helpers/EscapeHelper.php 0000644                 00000004056 15122266561 0030120 0                                       