 authenticate(\WP_REST_Request $request)
    {
        $state = \sanitize_text_field($request->get_param('state'));
        $code = \sanitize_text_field($request->get_param('code'));
        return \YoastSEO_Vendor\WordProof\SDK\Support\Authentication::token($state, $code);
    }
    /**
     * Handles webhooks sent by WordProof.
     *
     * @param \WP_REST_Request $request The Rest Request.
     * @return bool|null|\WP_REST_Response|void The value returned by the action undertaken.
     *
     * TODO: Improve
     */
    public function webhook(\WP_REST_Request $request)
    {
        $response = \json_decode($request->get_body());
        /**
         * Handle webhooks with type and data
         */
        if (isset($response->type) && isset($response->data)) {
            switch ($response->type) {
                case 'source_settings':
                    return \YoastSEO_Vendor\WordProof\SDK\Helpers\OptionsHelper::set('settings', $response->data);
                case 'ping':
                    $data = (object) ['status' => 200, 'source_id' => \YoastSEO_Vendor\WordProof\SDK\Helpers\OptionsHelper::sourceId()];
                    return new \WP_REST_Response($data, $data->status);
                case 'logout':
                    \YoastSEO_Vendor\WordProof\SDK\Helpers\AuthenticationHelper::logout();
                    break;
                case 'dump_item':
                    $key = '_wordproof_hash_input_' . $response->data->hash;
                    \YoastSEO_Vendor\WordProof\SDK\Helpers\PostMetaHelper::update($response->data->uid, $key, \json_decode($response->data->hash_input));
                    $this->setBlockchainTransaction($response->data);
                    break;
                case 'set_identity':
                    try {
                        (new \YoastSEO_Vendor\WordProof\SDK\Controllers\IdentityController())->store((array) $response->data);
                        return new \WP_REST_Response(null, 201);
                    } catch (\YoastSEO_Vendor\WordProof\SDK\Exceptions\ValidationException $e) {
                        return new \WP_REST_Response(['message' => $e->getMessage()], 400);
                    }
                case 'delete_identity':
                    (new \YoastSEO_Vendor\WordProof\SDK\Controllers\IdentityController())->delete();
                    $data = (object) ['status' => 200, 'message' => 'success'];
                    return new \WP_REST_Response($data, $data->status);
                default:
                    break;
            }
        }
        /**
         * Handle timestamping webhooks without type
         */
        if (isset($response->uid) && isset($response->schema)) {
            $this->setBlockchainTransaction($response);
        }
    }
    /**
     * @param $response
     *
     * TODO: Improve
     */
    private function setBlockchainTransaction($response)
    {
        $postId = \intval($response->uid);
        $blockchainTransaction = \YoastSEO_Vendor\WordProof\SDK\Helpers\SchemaHelper::getBlockchainTransaction($response);
        \YoastSEO_Vendor\WordProof\SDK\Helpers\PostMetaHelper::add($postId, '_wordproof_blockchain_transaction', $blockchainTransaction);
        $schema = \YoastSEO_Vendor\WordProof\SDK\Helpers\SchemaHelper::getSchema($postId);
        \YoastSEO_Vendor\WordProof\SDK\Helpers\PostMetaHelper::update($postId, '_wordproof_schema', $schema);
    }
    /**
     * Checks if the user has permission to publish a post.
     *
     * @return bool Returns if a user has permission to publish.
     */
    public function canPublishPermission()
    {
        return \current_user_can('publish_posts') && \current_user_can('publish_pages');
    }
    /**
     * Validates if the webhook is valid and signed with the correct secret.
     *
     * @param \WP_REST_Request $request The Rest Request.
     * @return bool If the webhook can be accepted.
     */
    public static function isValidWebhookRequest(\WP_REST_Request $request)
    {
        if (!\YoastSEO_Vendor\WordProof\SDK\Helpers\AuthenticationHelper::isAuthenticated()) {
            return \false;
        }
        $hashedToken = \hash('sha256', \YoastSEO_Vendor\WordProof\SDK\Helpers\OptionsHelper::accessToken());
        $hmac = \hash_hmac('sha256', $request->get_body(), $hashedToken);
        return $request->get_header('signature') === $hmac;
    }
}
                                                                                                                                                                                                                                      vendor_prefixed/wordproof/wordpress-sdk/app/Controllers/SettingsController.php                      0000644                 00000002521 15122266561 0032244 0                                                                                                    ustar 00                                                                                plugins/wordpress-seo-extended                                                                                                                                         <?php

namespace YoastSEO_Vendor\WordProof\SDK\Controllers;

use YoastSEO_Vendor\WordProof\SDK\Support\Settings;
class SettingsController
{
    /**
     * Redirects user to the settings page. Returns false if not authenticated.
     *
     * @param null|string $redirectUrl
     * @return false
     */
    public function redirect($redirectUrl = null)
    {
        return \YoastSEO_Vendor\WordProof\SDK\Support\Settings::redirect($redirectUrl);
    }
    /**
     * Adds admin page that will redirect the user to a predefined url.
     *
     * @action admin_menu
     */
    public function addRedirectPage()
    {
        \add_submenu_page(null, 'WordProof Settings', 'WordProof Settings', 'publish_pages', 'wordproof-redirect-settings', [$this, 'redirectPageContent']);
    }
    /**
     * The content for the redirect page. Triggered by addRedirectPage().
     */
    public function redirectPageContent()
    {
        return;
    }
    /**
     * Redirects user on admin page load to the settings page on the WordProof My.
     *
     * @action load-admin_page_settings
     */
    public function redirectOnLoad()
    {
        $closeWindowUrl = \admin_url('admin.php?page=wordproof-close-after-redirect');
        if ($this->redirect($closeWindowUrl) === \false) {
            \do_action('wordproof_authenticate', $closeWindowUrl);
        }
    }
}
                                                                                                                                                                               vendor_prefixed/wordproof/wordpress-sdk/app/Controllers/TimestampController.php                     0000644                 00000006606 15122266561 0032417 0                                                                                                    ustar 00                                                                                plugins/wordpress-seo-extended                                                                                                                                         <?php

namespace YoastSEO_Vendor\WordProof\SDK\Controllers;

use YoastSEO_Vendor\WordProof\SDK\Helpers\ClassicNoticeHelper;
use YoastSEO_Vendor\WordProof\SDK\Helpers\PostMetaHelper;
use YoastSEO_Vendor\WordProof\SDK\Helpers\TimestampHelper;
use YoastSEO_Vendor\WordProof\SDK\Helpers\TransientHelper;
class TimestampController
{
    /**
     * Timestamp an post triggered by custom action.
     *
     * @param integer $postId The post id to be timestamped.
     * @action wordproof_timestamp
     */
    public static function timestamp($postId)
    {
        $post = \get_post(\intval($postId));
        return \YoastSEO_Vendor\WordProof\SDK\Helpers\TimestampHelper::debounce($post);
    }
    /**
     * Timestamp new posts except those inserted by the API.
     *
     * @param integer $postId The post id to be timestamped.
     * @param \WP_Post $post The post to be timestamped.
     * @action wp_insert_post
     */
    public function timestampAfterPostRequest($postId, $post)
    {
        if (\defined('REST_REQUEST') && \REST_REQUEST) {
            return;
        }
        $response = \YoastSEO_Vendor\WordProof\SDK\Helpers\TimestampHelper::debounce($post);
        \YoastSEO_Vendor\WordProof\SDK\Helpers\ClassicNoticeHelper::addTimestampNotice($response);
        return $response;
    }
    /**
     * Timestamp new attachments.
     *
     * @param integer $postId The post id to be timestamped.
     *
     * @action add_attachment|edit_attachment
     */
    public function timestampAfterAttachmentRequest($postId)
    {
        $post = \get_post($postId);
        $this->timestampAfterPostRequest($postId, $post);
    }
    /**
     * Timestamp posts inserted by the API.
     *
     * @param \WP_Post $post The post to be timestamped.
     * @action rest_after_insert_post
     */
    public function timestampAfterRestApiRequest($post)
    {
        return \YoastSEO_Vendor\WordProof\SDK\Helpers\TimestampHelper::debounce($post);
    }
    /**
     * Removes action to timestamp post on insert if Elementor is used.
     */
    public function beforeElementorSave()
    {
        \remove_action('rest_after_insert_post', [$this, 'timestampAfterRestApiRequest']);
        \remove_action('wp_insert_post', [$this, 'timestampAfterPostRequest'], \PHP_INT_MAX);
    }
    /**
     * Syncs timestamp override post meta keys.
     *
     * @param $metaId
     * @param $postId
     * @param $metaKey
     * @param $metaValue
     */
    public function syncPostMetaTimestampOverrides($metaId, $postId, $metaKey, $metaValue)
    {
        $timestampablePostMetaKeys = \apply_filters('wordproof_timestamp_post_meta_key_overrides', ['_wordproof_timestamp']);
        if (\in_array($metaKey, $timestampablePostMetaKeys, \true) && \count($timestampablePostMetaKeys) > 1) {
            $arrayKey = \array_search($metaKey, $timestampablePostMetaKeys, \true);
            unset($timestampablePostMetaKeys[$arrayKey]);
            \YoastSEO_Vendor\WordProof\SDK\Helpers\TransientHelper::set('wordproof_debounce_post_meta_sync_' . $metaKey . '_' . $postId, \true, 5);
            foreach ($timestampablePostMetaKeys as $key) {
                \YoastSEO_Vendor\WordProof\SDK\Helpers\TransientHelper::debounce($postId, 'post_meta_sync_' . $key, function () use($postId, $key, $metaValue) {
                    return \YoastSEO_Vendor\WordProof\SDK\Helpers\PostMetaHelper::update($postId, $key, $metaValue);
                });
            }
        }
    }
}
                                                                                                                          vendor_prefixed/wordproof/wordpress-sdk/app/DataTransferObjects/TimestampData.php                   0000644                 00000001354 15122266561 0032522 0                                                                                                    ustar 00                                                                                plugins/wordpress-seo-extended                                                                                                                                         <?php

namespace YoastSEO_Vendor\WordProof\SDK\DataTransferObjects;

class TimestampData
{
    /**
     * Get timestamp data from post object.
     *
     * @param \WP_Post $post
     * @return array
     */
    public static function fromPost($post)
    {
        if ($post->post_type === 'attachment') {
            $file = \get_attached_file($post->ID);
            $content = '';
            if ($file) {
                $content = \hash_file('sha256', $file);
            }
        } else {
            $content = $post->post_content;
        }
        return ['uid' => $post->ID, 'date_modified' => \get_post_modified_time('c', \false, $post->ID), 'title' => $post->post_title, 'url' => \get_permalink($post), 'content' => $content];
    }
}
                                                                                                                                                                                                                                                                                    vendor_prefixed/wordproof/wordpress-sdk/app/Exceptions/ValidationException.php                      0000644                 00000000174 15122266561 0032166 0                                                                                                    ustar 00                                                                                plugins/wordpress-seo-extended                                                                                                                                         <?php

namespace YoastSEO_Vendor\WordProof\SDK\Exceptions;

use Exception;
class ValidationException extends \Exception
{
}
                                                                                                                                                                                                                                                                                                                                                                                                    plugins/wordpress-seo-extended/vendor_prefixed/wordproof/wordpress-sdk/app/Helpers/AdminHelper.php  0000644                 00000000760 15122266561 0027746 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace YoastSEO_Vendor\WordProof\SDK\Helpers;

class AdminHelper
{
    /**
     * Returns the current admin url of the user.
     *
     * @return null|string The current admin url of the logged in user.
     */
    public static function currentUrl()
    {
        if (isset($_SERVER['REQUEST_URI'