<?php

namespace YoastSEO_Vendor\WordProof\SDK\Controllers;

use YoastSEO_Vendor\WordProof\SDK\Support\Authentication;
class AuthenticationController
{
    /**
     * Triggers the authentication flow.
     *
     * @param null $redirectUrl
     */
    public function authenticate($redirectUrl = null)
    {
        return \YoastSEO_Vendor\WordProof\SDK\Support\Authentication::authorize($redirectUrl);
    }
    /**
     * Adds admin page that redirects to the authentication flow.
     */
    public function addRedirectPage()
    {
        \add_submenu_page(null, 'WordProof Authenticate', 'WordProof Authenticate', 'publish_pages', 'wordproof-redirect-authenticate', [$this, 'redirectPageContent']);
    }
    /**
     * The content for the redirect page.
     */
    public function redirectPageContent()
    {
    }
    /**
     * Gets triggered by the 'load-admin_page_' hook of the redirect page
     */
    public function redirectOnLoad()
    {
        \do_action('wordproof_authenticate', \admin_url('admin.php?page=wordproof-close-after-redirect'));
    }
    /**
     * Adds self destruct admin page.
     */
    public function addSelfDestructPage()
    {
        \add_submenu_page(null, 'WordProof After Authenticate', 'WordProof After Authenticate', 'publish_pages', 'wordproof-close-after-redirect', [$this, 'closeOnLoadContent']);
    }
    /**
     * Adds a script to the loaded page to close on load.
     */
    public function closeOnLoadContent()
    {
        echo '<script type="text/javascript">';
        echo 'window.close();';
        echo '</script>';
    }
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                          vendor_prefixed/wordproof/wordpress-sdk/app/Controllers/CertificateController.php                   0000644                 00000007213 15122266561 0032671 0                                                                                                    ustar 00                                                                                plugins/wordpress-seo-extended                                                                                                                                         <?php

namespace YoastSEO_Vendor\WordProof\SDK\Controllers;

use YoastSEO_Vendor\WordProof\SDK\Helpers\AppConfigHelper;
use YoastSEO_Vendor\WordProof\SDK\Helpers\CertificateHelper;
use YoastSEO_Vendor\WordProof\SDK\Helpers\EnvironmentHelper;
use YoastSEO_Vendor\WordProof\SDK\Helpers\OptionsHelper;
use YoastSEO_Vendor\WordProof\SDK\Helpers\PostMetaHelper;
use YoastSEO_Vendor\WordProof\SDK\Helpers\SettingsHelper;
class CertificateController
{
    /**
     * Add scripts and schema to the head of the current page.
     *
     * @action wp_head
     */
    public function head()
    {
        if (!\YoastSEO_Vendor\WordProof\SDK\Helpers\CertificateHelper::show()) {
            return;
        }
        global $post;
        $schema = "\n";
        if (\YoastSEO_Vendor\WordProof\SDK\Helpers\AppConfigHelper::getLoadUikitFromCdn() === \true) {
            $schema .= '<script type="module" src="https://unpkg.com/@wordproof/uikit@1.0.*/dist/uikit/uikit.esm.js"></script>';
            $schema .= "\n";
            $schema .= '<script nomodule src="https://unpkg.com/@wordproof/uikit@1.0.*/dist/uikit/uikit.js"></script>';
            $schema .= "\n";
        }
        $schema .= '<script type="application/ld+json" class="' . \esc_attr('wordproof-schema-graph') . '">';
        $schema .= \json_encode(\YoastSEO_Vendor\WordProof\SDK\Helpers\PostMetaHelper::get($post->ID, '_wordproof_schema'), \JSON_UNESCAPED_SLASHES | \JSON_UNESCAPED_UNICODE);
        $schema .= "</script>";
        $schema .= "\n";
        // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
        echo $schema;
    }
    /**
     * Adds the certificate tag to the content before rendering it.
     *
     * @param $content
     * @return mixed|string Content string from 'the_content' filter
     * @filter the_content
     */
    public function certificateTag($content)
    {
        if (!\YoastSEO_Vendor\WordProof\SDK\Helpers\CertificateHelper::show()) {
            return $content;
        }
        if (\YoastSEO_Vendor\WordProof\SDK\Helpers\SettingsHelper::hideCertificateLink()) {
            return $content;
        }
        global $post;
        $identifier = $post->ID;
        $text = \YoastSEO_Vendor\WordProof\SDK\Helpers\SettingsHelper::certificateLinkText();
        $showRevisions = \YoastSEO_Vendor\WordProof\SDK\Helpers\SettingsHelper::showRevisions() ? 'true' : 'false';
        $debug = \YoastSEO_Vendor\WordProof\SDK\Helpers\EnvironmentHelper::development() ? 'true' : 'false';
        $lastModified = \get_the_modified_date('c', $post->ID);
        $identity = \YoastSEO_Vendor\WordProof\SDK\Helpers\OptionsHelper::get('identity');
        $identityProvider = isset($identity->provider) ? $identity->provider : '';
        $identityName = (isset($identity->first_name) ? $identity->first_name : '') . ' ' . (isset($identity->last_name) ? $identity->last_name : '');
        $identityProfilePicture = isset($identity->profile_picture) ? $identity->profile_picture : '';
        $identityProofUrl = isset($identity->proof_url) ? $identity->proof_url : '';
        $content .= "\n" . '<w-certificate identity-provider="' . $identityProvider . '" identity-name="' . $identityName . '" identity-profile-picture="' . $identityProfilePicture . '" identity-proof-url="' . $identityProofUrl . '" debug="' . $debug . '" shared-identifier="' . $identifier . '" render-without-button="true" show-revisions="' . $showRevisions . '" last-modified="' . $lastModified . '"></w-certificate>';
        $content .= "\n" . '<p><w-certificate-button shared-identifier="' . $identifier . '" icon="shield" shape="text" text="' . $text . '"></w-certificate-button></p>';
        $content .= "\n";
        return $content;
    }
}
                                                                                                                                                                                                                                                                                                                                                                                     vendor_prefixed/wordproof/wordpress-sdk/app/Controllers/IdentityController.php                      0000644                 00000004234 15122266561 0032240 0                                                                                                    ustar 00                                                                                plugins/wordpress-seo-extended                                                                                                                                         <?php

namespace YoastSEO_Vendor\WordProof\SDK\Controllers;

use YoastSEO_Vendor\WordProof\SDK\Exceptions\ValidationException;
use YoastSEO_Vendor\WordProof\SDK\Helpers\AppConfigHelper;
use YoastSEO_Vendor\WordProof\SDK\Helpers\EnvironmentHelper;
use YoastSEO_Vendor\WordProof\SDK\Helpers\OptionsHelper;
class IdentityController
{
    /**
     * Validate identity data
     *
     * @param array $data
     *
     * @return array
     * @throws ValidationException
     */
    public function validate($data)
    {
        if (!isset($data['first_name']) || !\is_string($data['first_name'])) {
            throw new \YoastSEO_Vendor\WordProof\SDK\Exceptions\ValidationException("Invalid field 'first_name'");
        }
        if (!isset($data['last_name']) || !\is_string($data['last_name'])) {
            throw new \YoastSEO_Vendor\WordProof\SDK\Exceptions\ValidationException("Invalid field 'last_name'");
        }
        if (!isset($data['provider']) || !\is_string($data['provider'])) {
            throw new \YoastSEO_Vendor\WordProof\SDK\Exceptions\ValidationException("Invalid field 'provider'");
        }
        if (isset($data['profile_picture']) && !\filter_var($data['profile_picture'], \FILTER_VALIDATE_URL)) {
            throw new \YoastSEO_Vendor\WordProof\SDK\Exceptions\ValidationException("Invalid field 'profile_picture'");
        }
        return ['first_name' => $data['first_name'], 'last_name' => $data['last_name'], 'provider' => $data['provider'], 'profile_picture' => $data['profile_picture'], 'proof_url' => \YoastSEO_Vendor\WordProof\SDK\Helpers\EnvironmentHelper::url() . '/identity/' . \YoastSEO_Vendor\WordProof\SDK\Helpers\OptionsHelper::sourceId()];
    }
    /**
     * Store identity data
     *
     * @param array $data
     *
     * @return bool
     * @throws ValidationException
     */
    public function store($data)
    {
        return \YoastSEO_Vendor\WordProof\SDK\Helpers\OptionsHelper::set('identity', $this->validate($data));
    }
    /**
     * Delete the stored identity data
     *
     * @return mixed
     */
    public function delete()
    {
        return \YoastSEO_Vendor\WordProof\SDK\Helpers\OptionsHelper::delete('identity');
    }
}
                                                                                                                                                                                                            