Value($value);
                $parameters[$key] = $this->unescapeValue($value);
            } catch (\YoastSEO_Vendor\Symfony\Component\DependencyInjection\Exception\ParameterNotFoundException $e) {
                $e->setSourceKey($key);
                throw $e;
            }
        }
        $this->parameters = $parameters;
        $this->resolved = \true;
    }
    /**
     * Replaces parameter placeholders (%name%) by their values.
     *
     * @param mixed $value     A value
     * @param array $resolving An array of keys that are being resolved (used internally to detect circular references)
     *
     * @return mixed The resolved value
     *
     * @throws ParameterNotFoundException          if a placeholder references a parameter that does not exist
     * @throws ParameterCircularReferenceException if a circular reference if detected
     * @throws RuntimeException                    when a given parameter has a type problem
     */
    public function resolveValue($value, array $resolving = [])
    {
        if (\is_array($value)) {
            $args = [];
            foreach ($value as $k => $v) {
                $args[\is_string($k) ? $this->resolveValue($k, $resolving) : $k] = $this->resolveValue($v, $resolving);
            }
            return $args;
        }
        if (!\is_string($value) || 2 > \strlen($value)) {
            return $value;
        }
        return $this->resolveString($value, $resolving);
    }
    /**
     * Resolves parameters inside a string.
     *
     * @param string $value     The string to resolve
     * @param array  $resolving An array of keys that are being resolved (used internally to detect circular references)
     *
     * @return mixed The resolved string
     *
     * @throws ParameterNotFoundException          if a placeholder references a parameter that does not exist
     * @throws ParameterCircularReferenceException if a circular reference if detected
     * @throws RuntimeException                    when a given parameter has a type problem
     */
    public function resolveString($value, array $resolving = [])
    {
        // we do this to deal with non string values (Boolean, integer, ...)
        // as the preg_replace_callback throw an exception when trying
        // a non-string in a parameter value
        if (\preg_match('/^%([^%\\s]+)%$/', $value, $match)) {
            $key = $match[1];
            $lcKey = \strtolower($key);
            // strtolower() to be removed in 4.0
            if (isset($resolving[$lcKey])) {
                throw new \YoastSEO_Vendor\Symfony\Component\DependencyInjection\Exception\ParameterCircularReferenceException(\array_keys($resolving));
            }
            $resolving[$lcKey] = \true;
            return $this->resolved ? $this->get($key) : $this->resolveValue($this->get($key), $resolving);
        }
        return \preg_replace_callback('/%%|%([^%\\s]+)%/', function ($match) use($resolving, $value) {
            // skip %%
            if (!isset($match[1])) {
                return '%%';
            }
            $key = $match[1];
            $lcKey = \strtolower($key);
            // strtolower() to be removed in 4.0
            if (isset($resolving[$lcKey])) {
                throw new \YoastSEO_Vendor\Symfony\Component\DependencyInjection\Exception\ParameterCircularReferenceException(\array_keys($resolving));
            }
            $resolved = $this->get($key);
            if (!\is_string($resolved) && !\is_numeric($resolved)) {
                throw new \YoastSEO_Vendor\Symfony\Component\DependencyInjection\Exception\RuntimeException(\sprintf('A string value must be composed of strings and/or numbers, but found parameter "%s" of type "%s" inside string value "%s".', $key, \gettype($resolved), $value));
            }
            $resolved = (string) $resolved;
            $resolving[$lcKey] = \true;
            return $this->isResolved() ? $resolved : $this->resolveString($resolved, $resolving);
        }, $value);
    }
    public function isResolved()
    {
        return $this->resolved;
    }
    /**
     * {@inheritdoc}
     */
    public function escapeValue($value)
    {
        if (\is_string($value)) {
            return \str_replace('%', '%%', $value);
        }
        if (\is_array($value)) {
            $result = [];
            foreach ($value as $k => $v) {
                $result[$k] = $this->escapeValue($v);
            }
            return $result;
        }
        return $value;
    }
    /**
     * {@inheritdoc}
     */
    public function unescapeValue($value)
    {
        if (\is_string($value)) {
            return \str_replace('%%', '%', $value);
        }
        if (\is_array($value)) {
            $result = [];
            foreach ($value as $k => $v) {
                $result[$k] = $this->unescapeValue($v);
            }
            return $result;
        }
        return $value;
    }
    private function normalizeName($name)
    {
        if (isset($this->normalizedNames[$normalizedName = \strtolower($name)])) {
            $normalizedName = $this->normalizedNames[$normalizedName];
            if ((string) $name !== $normalizedName) {
                @\trigger_error(\sprintf('Parameter names will be made case sensitive in Symfony 4.0. Using "%s" instead of "%s" is deprecated since Symfony 3.4.', $name, $normalizedName), \E_USER_DEPRECATED);
            }
        } else {
            $normalizedName = $this->normalizedNames[$normalizedName] = (string) $name;
        }
        return $normalizedName;
    }
}
                                                                       wordpress-seo-extended/vendor_prefixed/symfony/dependency-injection/ResettableContainerInterface.php0000644                 00000002015 15122266561 0032040 0                                                                                                    ustar 00                                                                                plugins                                                                                                                                                                <?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace YoastSEO_Vendor\Symfony\Component\DependencyInjection;

/**
 * ResettableContainerInterface defines additional resetting functionality
 * for containers, allowing to release shared services when the container is
 * not needed anymore.
 *
 * @author Christophe Coevoet <stof@notk.org>
 */
interface ResettableContainerInterface extends \YoastSEO_Vendor\Symfony\Component\DependencyInjection\ContainerInterface
{
    /**
     * Resets shared services from the container.
     *
     * The container is not intended to be used again after being reset in a normal workflow. This method is
     * meant as a way to release references for ref-counting.
     * A subsequent call to ContainerInterface::get will recreate a new instance of the shared service.
     */
    public function reset();
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   plugins/wordpress-seo-extended/vendor_prefixed/symfony/deprecation-contracts/function.php           0000644                 00000001760 15122266561 0026371 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

if (!function_exists('trigger_deprecation')) {
    /**
     * Triggers a silenced deprecation notice.
     *
     * @param string $package The name of the Composer package that is triggering the deprecation
     * @param string $version The version of the package that introduced the deprecation
     * @param string $message The message of the deprecation
     * @param mixed  ...$args Values to insert in the message using printf() formatting
     *
     * @author Nicolas Grekas <p@tchwork.com>
     */
    function trigger_deprecation(string $package, string $version, string $message, ...$args): void
    {
        @trigger_error(($package || $version ? "Since $package $version: " : '').($args ? vsprintf($message, $args) : $message), \E_USER_DEPRECATED);
    }
}
                wordpress-seo-extended/vendor_prefixed/wordproof/wordpress-sdk/app/Config/AppConfigInterface.php    0000644                 00000001676 15122266561 0031000 0                                                                                                    ustar 00                                                                                plugins                                                                                                                                                                <?php

namespace YoastSEO_Vendor\WordProof\SDK\Config;

interface AppConfigInterface
{
    /**
     * Your partner name.
     *
     * @default wordproof
     * @return string
     */
    public function getPartner();
    /**
     * The WordProof environment used. Either staging or production.
     *
     * @default production
     * @return string
     */
    public function getEnvironment();
    /**
     * The WordProof environment used. Either staging or production.
     *
     * @default true
     * @return boolean
     */
    public function getLoadUikitFromCdn();
    /**
     * Only used for local development.
     *
     * @return integer
     */
    public function getOauthClient();
    /**
     * Only used for local development.
     *
     * @return string
     */
    public function getWordProofUrl();
    /**
     * Only used for local development.
     *
     * @return string
     */
    public function getScriptsFileOverwrite();
}
                                                                  plugins/wordpress-seo-extended/vendor_prefixed/wordproof/wordpress-sdk/app/Config/Config.php        0000644                 00000001670 15122266561 0026567 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace YoastSEO_Vendor\WordProof\SDK\Config;

abstract class Config
{
    /**
     * Try to return config values using the dot syntax.
     *
     * @param string|null $key The key of the config using the dot syntax.
     * @return array|mixed Returns the entire config array if not found, otherwise the value itself.
     */
    public static function get($key = null)
    {
        if (!isset($key)) {
            return static::values();
        }
        $keys = \explode('.', $key);
        $value = static::values();
        foreach ($keys as $key) {
            if (isset($value[$key])) {
                $value = $value[$key];
            } else {
                return \false;
            }
        }
        return $value;
    }
    /**
     * Should return an array with the config.
     *
     * @return array An array containing the config values.
     */
    protected static function values()
    {
        return [];
    }
}
                                                                        wordpress-seo-extended/vendor_prefixed/wordproof/wordpress-sdk/app/Config/DefaultAppConfig.php      0000644                 00000001465 15122266561 0030460 0                                                                                                    ustar 00                                                                                plugins                                                                                                                                                                <?php

namespace YoastSEO_Vendor\WordProof\SDK\Config;

class DefaultAppConfig implements \YoastSEO_Vendor\WordProof\SDK\Config\AppConfigInterface
{
    /**
     * @return string
     */
    public function getPartner()
    {
        return 'wordproof';
    }
    /**
     * @return string
     */
    public function getEnvironment()
    {
        return 'production';
    }
    /**
     * @return boolean
     */
    public function getLoadUikitFromCdn()
    {
        return \true;
    }
    /**
     * @return null
     */
    public function getOauthClient()
    {
        return null;
    }
    /**
     * @return null
     */
    public function getWordProofUrl()
    {
        return null;
    }
    /**
     * @return null
     */
    public function getScriptsFileOverwrite()
    {
        return null;
    }
}
                                                                                                                                                                                                           wordpress-seo-extended/vendor_prefixed/wordproof/wordpress-sdk/app/Config/EnvironmentConfig.php     0000644                 00000000676 15122266561 0030742 0                                                                                                    ustar 00                                                                                plugins                                                                                                                                                                <?php

namespace YoastSEO_Vendor\WordProof\SDK\Config;

class EnvironmentConfig extends \YoastSEO_Vendor\WordProof\SDK\Config\Config
{
    /**
     * Returns an array with the environment config.
     *
     * @return array
     */
    protected static function values()
    {
        return ['staging' => ['url' => 'https://staging.wordproof.com', 'client' => 78], 'production' => ['url' => 'https://my.wordproof.com', 'client' => 79]];
    }
}
                                                                  plugins/wordpress-seo-extended/vendor_prefixed/wordproof/wordpress-sdk/app/Config/OptionsConfig.php 0000644                 00000002300 15122266561 0030132 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace YoastSEO_Vendor\WordProof\SDK\Config;

class OptionsConfig extends \YoastSEO_Vendor\WordProof\SDK\Config\Config
{
    /**
     * Returns an array with the settings config.
     *
     * @return array
     */
    protected static function values()
    {
        return ['source_id' => ['escape' => 'integer', 'default' => null], 'access_token' => ['escape' => 'text_field', 'default' => null], 'balance' => ['escape' => 'integer', 'default' => 0], 'settings' => ['cast' => 'object', 'options' => ['certificate_link_text' => ['escape' => 'text_field', 'default' => __('View this content\'s Timestamp certificate', 'wordproof')], 'hide_certificate_link' => ['escape' => 'boolean', 'default' => \false], 'selected_post_types' => ['escape' => 'text_field', 'default' => []], 'show_revisions' => ['escape' => 'boolean', 'default' => \true]]], 'identity' => ['cast' => 'object', 'options' => ['provider' => ['escape' => 'text_field', 'default' => null], 'first_name' => ['escape' => 'text_field', 'default' => null], 'last_name' => ['escape' => 'text_field', 'default' => null], 'profile_picture' => ['escape' => 'url', 'default' => null], 'proof_url' => ['escape' => 'url', 'default' => null]]]];
    }
}
                                                                                                                                                                                                                                                                                                                                plugins/wordpress-seo-extended/vendor_prefixed/wordproof/wordpress-sdk/app/Config/RoutesConfig.php  0000644                 00000002012 15122266561 0027760 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace YoastSEO_Vendor\WordProof\SDK\Config;

class RoutesConfig extends \YoastSEO_Vendor\WordProof\SDK\Config\Config
{
    /**
     * Returns an array with the environment config.
     *
     * @return array
     */
    protected static function values()
    {
        return ['hashInput' => ['endpoint' => '/posts/(?P<id>\\d+)/hashinput/(?P<hash>[a-fA-F0-9]{64})', 'method' => 'get'], 'authenticate' => ['endpoint' => '/oauth/authenticate', 'method' => 'post'], 'timestamp' => ['endpoint' => '/posts/(?P<id>\\d+)/timestamp', 'method' => 'post'], 'timestamp.transaction.latest' => ['endpoint' => '/posts/(?P<id>\\d+)/timestamp/transaction/latest', 'method' => 'get'], 'webhook' => ['endpoint' => '/webhook', 'method' => 'get'], 'settings' => ['endpoint' => '/settings', 'method' => 'get'], 'saveSettings' => ['endpoint' => '/settings', 'method' => 'POST'], 'authentication' => ['endpoint' => '/authentication', 'method' => 'post'], 'authentication.destroy' => ['endpoint' => '/oauth/destroy', 'method' => 'post']];
    }
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      plugins/wordpress-seo-extended/vendor_prefixed/wordproof/wordpress-sdk/app/Config/ScriptsConfig.php 0000644                 00000001651 15122266561 0030136 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace YoastSEO_Vendor\WordProof\SDK\Config;

class ScriptsConfig extends \YoastSEO_Vendor\WordProof\SDK\Config\Config
{
    /**
     * Returns an array with the environment config.
     *
     * @return array
     */
    protected static function values()
    {
        return ['data' => ['dependencies' => ['wp-data', 'lodash', 'wp-api-fetch'], 'type' => 'js'], 'wordproof-block-editor' => ['dependencies' => ['wp-i18n', 'wp-element', 'wp-components', 'wp-editor', 'wp-edit-post', 'wp-data', 'lodash', 'wordproof-data'],