er/db.json
     */
    public static function fromExtension(string $extension) : ?string
    {
        return self::MIME_TYPES[\strtolower($extension)] ?? null;
    }
}
                                                                                                                                                                                                                                                                                                                                                       plugins/wordpress-seo-extended/vendor_prefixed/guzzlehttp/psr7/src/MultipartStream.php              0000644                 00000012371 15122266561 0025604 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

declare (strict_types=1);
namespace YoastSEO_Vendor\GuzzleHttp\Psr7;

use YoastSEO_Vendor\Psr\Http\Message\StreamInterface;
/**
 * Stream that when read returns bytes for a streaming multipart or
 * multipart/form-data stream.
 */
final class MultipartStream implements \YoastSEO_Vendor\Psr\Http\Message\StreamInterface
{
    use StreamDecoratorTrait;
    /** @var string */
    private $boundary;
    /** @var StreamInterface */
    private $stream;
    /**
     * @param array  $elements Array of associative arrays, each containing a
     *                         required "name" key mapping to the form field,
     *                         name, a required "contents" key mapping to a
     *                         StreamInterface/resource/string, an optional
     *                         "headers" associative array of custom headers,
     *                         and an optional "filename" key mapping to a
     *                         string to send as the filename in the part.
     * @param string $boundary You can optionally provide a specific boundary
     *
     * @throws \InvalidArgumentException
     */
    public function __construct(array $elements = [], string $boundary = null)
    {
        $this->boundary = $boundary ?: \bin2hex(\random_bytes(20));
        $this->stream = $this->createStream($elements);
    }
    public function getBoundary() : string
    {
        return $this->boundary;
    }
    public function isWritable() : bool
    {
        return \false;
    }
    /**
     * Get the headers needed before transferring the content of a POST file
     *
     * @param string[] $headers
     */
    private function getHeaders(array $headers) : string
    {
        $str = '';
        foreach ($headers as $key => $value) {
            $str .= "{$key}: {$val