lidArgumentException('Invalid request string');
        }
        $parts = \explode(' ', $data['start-line'], 3);
        $version = isset($parts[2]) ? \explode('/', $parts[2])[1] : '1.1';
        $request = new \YoastSEO_Vendor\GuzzleHttp\Psr7\Request($parts[0], $matches[1] === '/' ? self::parseRequestUri($parts[1], $data['headers']) : $parts[1], $data['headers'], $data['body'], $version);
        return $matches[1] === '/' ? $request : $request->withRequestTarget($parts[1]);
    }
    /**
     * Parses a response message string into a response object.
     *
     * @param string $message Response message string.
     */
    public static function parseResponse(string $message) : \YoastSEO_Vendor\Psr\Http\Message\ResponseInterface
    {
        $data = self::parseMessage($message);
        // According to https://datatracker.ietf.org/doc/html/rfc7230#section-3.1.2
        // the space between status-code and reason-phrase is required. But
        // browsers accept responses without space and reason as well.
        if (!\preg_match('/^HTTP\\/.* [0-9]{3}( .*|$)/', $data['start-line'])) {
            throw new \InvalidArgumentException('Invalid response string: ' . $data['start-line']);
        }
        $parts = \explode(' ', $data['start-line'], 3);
        return new \YoastSEO_Vendor\GuzzleHttp\Psr7\Response((int) $parts[1], $data['headers'], $data['body'], \explode('/', $parts[0])[1], $parts[2] ?? null);
    }
}
                                                                                                plugins/wordpress-seo-extended/vendor_prefixed/guzzlehttp/psr7/src/MessageTrait.php                 0000644                 00000017343 15122266561 0025043 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

declare (strict_types=1);
namespace YoastSEO_Vendor\GuzzleHttp\Psr7;

use YoastSEO_Vendor\Psr\Http\Message\MessageInterface;
use YoastSEO_Vendor\Psr\Http\Message\StreamInterface;
/**
 * Trait implementing functionality common to requests and responses.
 */
trait MessageTrait
{
    /** @var string[][] Map of all registered headers, as original name => array of values */
    private $headers = [];
    /** @var string[] Map of lowercase header name => original name at registration */
    private $headerNames = [];
    /** @var string */
    private $protocol = '1.1';
    /** @var StreamInterface|null */
    private $stream;
    public function getProtocolVersion() : string
    {
        return $this->protocol;
    }
    public function withProtocolVersion($version) : \YoastSEO_Vendor\Psr\Http\Message\MessageInterface
    {
        if ($this->protocol === $version) {
            return $this;
        }
        $new = clone $this;
        $new->protocol = $version;
        return $new;
    }
    public function getHeaders() : array
    {
        return $this->headers;
    }
    public function hasHeader($header) : bool
    {
        return isset($this-