on isWritable() : bool
    {
        return \false;
    }
    public function isSeekable() : bool
    {
        return $this->seekable;
    }
    public function write($string) : int
    {
        throw new \RuntimeException('Cannot write to an AppendStream');
    }
    /**
     * @return mixed
     */
    public function getMetadata($key = null)
    {
        return $key ? null : [];
    }
}
                                                                                                                    plugins/wordpress-seo-extended/vendor_prefixed/guzzlehttp/psr7/src/BufferStream.php                 0000644                 00000006321 15122266561 0025032 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

declare (strict_types=1);
namespace YoastSEO_Vendor\GuzzleHttp\Psr7;

use YoastSEO_Vendor\Psr\Http\Message\StreamInterface;
/**
 * Provides a buffer stream that can be written to to fill a buffer, and read
 * from to remove bytes from the buffer.
 *
 * This stream returns a "hwm" metadata value that tells upstream consumers
 * what the configured high water mark of the stream is, or the maximum
 * preferred size of the buffer.
 */
final class BufferStream implements \YoastSEO_Vendor\Psr\Http\Message\StreamInterface
{
    /** @var int */
    private $hwm;
    /** @var string */
    private $buffer = '';
    /**
     * @param int $hwm High water mark, representing the preferred maximum
     *                 buffer size. If the size of the buffer exceeds the high
     *                 water mark, then calls to write will continue to succeed
     *                 but will return 0 to inform writers to slow down
     *                 until the buffer has been drained by reading from it.
     */
    public function __construct(int $hwm = 16384)
    {
        $this->hwm = $hwm;
    }
    public function __toString() : string
    {
        return $this->getContents();
    }
    public function getContents() : string
    {
        $buffer = $this->buffer;
        $this->buffer = '';
        return $buffer;
    }
    public function close() : void
    {
        $this->buffer = '';
    }
    public function detach()
    {
        $this->close();
        return null;
    }
    public function getSize() : ?int
    {
        return \strlen($this->buffer);
    }
    public function isReadable() : bool
    {
        return \true;
    }
    public function isWritable() : bool
    {
        return \true;
    }
    public function isSeekable() : bool
    {
        return \false;
    }
    public function rewind() : void
    {
        $this->seek(0);
    }
    public function seek($offset, $whence = \SEEK_SET) : void
    {
        throw new \RuntimeException('Cannot seek a BufferStream');
    }
    public function eof() : bool
    {
        return \strlen($this->buffer) === 0;
    }
    public function tell() : int
    {
        throw new \RuntimeException('Cannot determine the position of a BufferStream');
    }
    /**
     * Reads data from the buffer.
     */
    public function read($length) : string
    {
        $currentLength = \strlen($this->buffer);
        if ($length >= $currentLength) {
            // No need to slice the bu