ition. Only supports SEEK_SET.
     */
    public function seek($offset, $whence = \SEEK_SET) : void
    {
        if (!$this->seekable) {
            throw new \RuntimeException('This AppendStream is not seekable');
        } elseif ($whence !== \SEEK_SET) {
            throw new \RuntimeException('The AppendStream can only seek with SEEK_SET');
        }
        $this->pos = $this->current = 0;
        // Rewind each stream
        foreach ($this->streams as $i => $stream) {
            try {
                $stream->rewind();
            } catch (\Exception $e) {
                throw new \RuntimeException('Unable to seek stream ' . $i . ' of the AppendStream', 0, $e);
            }
        }
        // Seek to the actual position by reading from each stream
        while ($this->pos < $offset && !$this->eof()) {
            $result = $this->read(\min(8096, $offset - $this->pos));
            if ($result === '') {
                break;
            }
        }
    }
    /**
     * Reads from all of the appended streams until the length is met or EOF.
     */
    public function read($length) : string
    {
        $buffer = '';
        $total = \count($this->streams) - 1;
        $remaining = $length;
        $progressToNext = \false;
        while ($remaining > 0) {
            // Progress to the next stream if needed.
            if ($progressToNext || $this->streams[$this->current]->eof()) {
                $progressT