** @var int */
    private $pos = 0;
    /**
     * @param StreamInterface[] $streams Streams to decorate. Each stream must
     *                                   be readable.
     */
    public function __construct(array $streams = [])
    {
        foreach ($streams as $stream) {
            $this->addStream($stream);
        }
    }
    public function __toString() : string
    {
        try {
            $this->rewind();
            return $this->getContents();
        } catch (\Throwable $e) {
            if (\PHP_VERSION_ID >= 70400) {
                throw $e;
            }
            \trigger_error(\sprintf('%s::__toString exception: %s', self::class, (string) $e), \E_USER_ERROR);
            return '';
        }
    }
    /**
     * Add a stream to the AppendStream
     *
     * @param StreamInterface $stream Stream to append. Must be readable.
     *
     * @throws \InvalidArgumentException if the stream is not readable
     */
    public function addStream(\YoastSEO_Vendor\Psr\Http\Message\StreamInterface $stream) : void
    {
        if (!$stream->isReadable()) {
            throw new \InvalidArgumentException('Each stream must be readable');
        }
        // The stream is only seekable if all streams are seekable
        if (!$stream->isSeekable()) {
            $this->seekable = \false;
        }
        $this->streams[] = $stream;
    }
    public function getContents() : string
    {
        return \YoastSEO_Vendor\GuzzleHttp\Psr7\Utils::copyToString($this);
    }
    /**
     * Closes each attached stream.
     */
    public function close() : void
    {
        $this->pos = $this->current = 0;
        $this->seekable = \true;
        foreach ($this->streams as $stream) {
            $stream->close();
        }
        $this->streams = [];
    }
    /**
     * Detaches each attached stream.
     *
     * Returns null as it's not clear which underlying stream resource to return.
     */
    public function detach()
    {
        $this->pos = $this->current = 0;
        $this->seekable = \true;
        foreach ($this->streams as $stream) {
            $stream->detach();
        }
        $this->streams = [];
        return null;
    }
    public function tell() : int
    {
        return $this->pos;
    }
    /**
     * Tries to calculate the size by adding the size of each stream.
     *
     * If any of the streams do not return a valid number, then the size of the
     * append stream cannot be determined and nu