tSEO_Vendor\GuzzleHttp\Promise\Promise $aggregate) : void {
            $aggregate->reject($reason);
        })->then(function () use(&$results) {
            \ksort($results);
            return $results;
        });
        if (\true === $recursive) {
            $promise = $promise->then(function ($results) use($recursive, &$promises) {
                foreach ($promises as $promise) {
                    if (\YoastSEO_Vendor\GuzzleHttp\Promise\Is::pending($promise)) {
                        return self::all($promises, $recursive);
                    }
                }
                return $results;
            });
        }
        return $promise;
    }
    /**
     * Initiate a competitive race between multiple promises or values (values
     * will become immediately fulfilled promises).
     *
     * When count amount of promises have been fulfilled, the returned promise
     * is fulfilled with an array that contains the fulfillment values of the
     * winners in order of resolution.
     *
     * This promise is rejected with a {@see AggregateException} if the number
     * of fulfilled promises is less than the desired $count.
     *
     * @param int   $count    Total number of promises.
     * @param mixed $promises Promises or values.
     */
    public static function some(int $count, $promises) : \YoastSEO_Vendor\GuzzleHttp\Promise\PromiseInterface
    {
        $results = [];
        $rejections = [];
        return \YoastSEO_Vendor\GuzzleHttp\Promise\Each::of($promises, function ($value, $idx, \YoastSEO_Vendor\GuzzleHttp\Promise\PromiseInterface $p) use(&$results, $count) : void {
            if (\YoastSEO_Vendor\GuzzleHttp\Promise\Is::settled($p)) {
                return;
            }
            $results[$idx] = $value;
            if (\count($results) >= $count) {
                $p->resolve(null);
            }
        }, function ($reason) use(&$rejections) : void {
            $rejections[] = $reason;
        })->then(function () use(&$results, &$rejections, $count) {
            if (\count($results) !== $count) {
                throw new \YoastSEO_Vendor\GuzzleHttp\Promise\AggregateException('Not enough promises to fulfill count', $rejections);
            }
            \ksort($results);
            return \array_values($results);
       