plugins/wordpress-seo-extended/vendor_prefixed/guzzlehttp/promises/src/TaskQueue.php                0000644                 00000004027 15122266561 0025323 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

declare (strict_types=1);
namespace YoastSEO_Vendor\GuzzleHttp\Promise;

/**
 * A task queue that executes tasks in a FIFO order.
 *
 * This task queue class is used to settle promises asynchronously and
 * maintains a constant stack size. You can use the task queue asynchronously
 * by calling the `run()` function of the global task queue in an event loop.
 *
 *     GuzzleHttp\Promise\Utils::queue()->run();
 *
 * @final
 */
class TaskQueue implements \YoastSEO_Vendor\GuzzleHttp\Promise\TaskQueueInterface
{
    private $enableShutdown = \true;
    private $queue = [];
    public function __construct(bool $withShutdown = \true)
    {
        if ($withShutdown) {
            \register_shutdown_function(function () : void {
                if ($this->enableShutdown) {
                    // Only run the tasks if an E_ERROR didn't occur.
                    $err = \error_get_last();
                    if (!$err || $err['type'] ^ \E_ERROR) {
                        $this->run();
                    }
                }
            });
        }
    }
    public function isEmpty() : bool
    {
        return !$this->queue;
    }
    public function add(callable $task) : void
    {
        $this->queue[] = $task;
    }
    public function run() : void
    {
        while ($task = \array_shift($this->queue)) {
            /** @var callable $task */
            $task();
        }
    }
    /**
     * The task queue will be run and exhausted by default when the process
     * exits IFF the exit is not the result of a PHP E_ERROR error.
     *
     * You can disable running the automatic shutdown of the queue by calling
     * this function. If you disable the task queue shutdown process, then you
     * MUST either run the task queue (as a result of running your event loop
     * or manually using the run() method) or wait on each outstanding promise.
     *
     * Note: This shutdown will occur before any destructors are triggered.
     */
    public function disableShutdown() : void
    {
        $this->enableShutdown = \false;
    }
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         plugins/wordpress-seo-extended/vendor_prefixed/guzzlehttp/promises/src/Utils.php                    0000644                 00000021320 15122266561 0024507 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

declare (strict_types=1);
namespace YoastSEO_Vendor\GuzzleHttp\Promise;

final class Utils
{
    /**
     * Get the global task queue used for promise resolution.
     *
     * This task queue MUST be run in an event loop in order for promises to be
     * settled asynchronously. It will be automatically run when synchronously
     * waiting on a promise.
     *
     * <code>
     * while ($eventLoop->isRunning()) {
     *     GuzzleHttp\Promise\Utils::queue()->run();
     * }
     * </code>
     *
     * @param TaskQueueInterface|null $assign Optionally specify a new queue instance.
     */
    public static function queue(\YoastSEO_Vendor\GuzzleHttp\Promise\TaskQueueInterface $assign = null) : \YoastSEO_Vendor\GuzzleHttp\Promise\TaskQueueInterface
    {
        static $queue;
        if ($assign) {
            $queue = $assign;
        } elseif (!$queue) {
            $queue = new \YoastSEO_Vendor\GuzzleHttp\Promise\TaskQueue();
        }
        return $queue;
    }
    /**
     * Adds a function to run in the task queue when it is next `run()` and
     * returns a promise that is fulfilled or rejected with the result.
     *
     * @param callable $task Task function to run.
     */
    public static function task(callable $task) : \YoastSEO_Vendor\GuzzleHttp\Promise\PromiseInterface
    {
        $queue = self::queue();
        $promise = new \YoastSEO_Vendor\GuzzleHttp\Promise\Promise([$queue, 'run']);
        $queue->add(function () use($task, $promise) : void {
            try {
                if (\YoastSEO_Vendor\GuzzleHttp\Promise\Is::pending($promise)) {
                    $promise->resolve($task());
                }
            } catch (\Throwable $e) {
                $promise->reject($e);
            }
        });
        return $promise;
    }
    /**
     * Synchronously waits on a promise to resolve and returns an inspection
     * state array.
     *
     * Returns a state associative array containing a "state" key mapping to a
     * valid promise state. If the state of the promise is "fulfilled", the
     * array will contain a "value" key mapping to the fulfilled value of the
     * promise. If the promise is rejected, the array will contain a "reason"
     * key mapping to the rejection reason of the promise.
     *
     * @param PromiseInterface $promise Promise or value.
    