t rejected in a then callback.
        /** @psalm-suppress RedundantCondition */
        if ($this->state === self::PENDING) {
            $this->reject(new \YoastSEO_Vendor\GuzzleHttp\Promise\CancellationException('Promise has been cancelled'));
        }
    }
    public function resolve($value) : void
    {
        $this->settle(self::FULFILLED, $value);
    }
    public function reject($reason) : void
    {
        $this->settle(self::REJECTED, $reason);
    }
    private function settle(string $state, $value) : void
    {
        if ($this->state !== self::PENDING) {
            // Ignore calls with the same resolution.
            if ($state === $this->state && $value === $this->result) {
                return;
            }
            throw $this->state === $state ? new \LogicException("The promise is already {$state}.") : new \LogicException("Cannot change a {$this->state} promise to {$state}");
        }
        if ($value === $this) {
            throw new \LogicException('Cannot fulfill or reject a promise with itself');
        }
        // Clear out the state of the promise but stash the handlers.
        $this->state = $state;
        $this->result = $value;
        $handlers = $this->handlers;
        $this->handlers = null;
        $this->waitList = $this->waitFn = null;
        $this->cancelFn = null;
        if (!$handlers) {
            return;
        }
        // If the value was not a settled promise or a thenable, then resolve
        // it in the task queue using the correct ID.
        if (!\is_object($value) || !\method_exists($value, 'then')) {
            $id = $state === self::FULFILLED ? 1 : 2;
            // It's a success, so resolve the handlers in the queue.
            \YoastSEO_Vendor\GuzzleHttp\Promise\Utils::queue()->add(static function () use($id, $value, $handlers) : void {
                foreach ($handlers as $handler) {
                    self::callHandler($id, $value, $handler);
                }
            });
        } elseif ($value instanceof \YoastSEO_Vendor\GuzzleHttp\Promise\Promise && \YoastSEO_Vendor\GuzzleHttp\Promise\Is::pending($value)) {
            // We can just merge our handlers onto the next promise.
            $value->handlers = \array_merge($value->handlers, $handlers);
        } else {
            // Resolve the handlers when the forwarded promise is resolved.
            $value->then(static function ($value) use($handlers) : void {
                foreach ($handlers as $handler) {
                    self::callHandler(1, $value, $handler);
                }
            }, static function ($reason) use($handlers) : void {
                foreach ($handlers as $handler) {
                    self::callHandler(2, $reason, $handler);
                }
            });
        }
    }
    /**
     * Call a stack of handlers using a specific callback index and value.
     *
     * @param int   $index   1 (resolve) or 2 (reject).
     * @param mixed $value   Value to pass to the callback.
     * @param array $handler Array of handler data (promise and callbacks).
     */
    private static function callHandler(int $index, $value, array $handler) : void
    {
        /** @var PromiseInterface $promise */
        $promise = $handler[0];
        // The promise may have been cancelled or resolved before placing
        // this thunk in the queue.
        if (\YoastSEO_Vendor\GuzzleHttp\Promise\Is::settled($promise)) {
            return;
        }
        try {
            if (isset($handler[$index])) {
                /*
                 * If $f throws an exception, then $handler will be in the exception
                 * stack trace. Since $handler contains a reference to the callable
                 * itself we get a circular reference. We clear the $handler
                 * here to avoid that memory leak.
                 */
                $f = $handler[$index];
                unset($handler);
                $promise->resolve($f($value));
            } elseif ($index === 1) {
                // Forward resolution values as-is.
                $promise->resolve($value);
            } else {
                // Forward rejections down the chain.
                $promise->reject($value);
            }
        } catch (\Throwable $reason) {
            $promise->reject($reason);
        }
    }
    private function waitIfPending() : void
    {
        if ($this->state !== self::PENDING) {
            return;
        } elseif ($this->waitFn) {
            $this->invokeWaitFn();
        } elseif ($this->waitList) {
            $this->invokeWaitList();
        } else {
            // If there's no wait function, then reject the promise.
            $this->reject('Cannot wait on a promise that has ' . 'no internal wait function. You must provide a wait ' . 'function when constructing the promise to be able to ' . 'wait on a promise.');
        }
        \YoastSEO_Vendor\GuzzleHttp\Promise\Utils::queue()->run();
        /** @psalm-suppress RedundantCondition */
        if ($this->state === self::PENDING) {
            $this->reject('Invoking the wait callback did not resolve the promise');
        }
    }
    private function invokeWaitFn() : void
    {
        try {
            $wfn = $this->waitFn;
            $this->waitFn = null;
            $wfn(\true);
        } catch (\Throwable $reason) {
            if ($this->state === self::PENDING) {
                // The promise has not been resolved yet, so reject the promise
                // with the exception.
                $this->reject($reason);
            } else {
                // The promise was already resolved, so there's a problem in
                // the application.
                throw $reason;
            }
        }
    }
    private function invokeWaitList() : void
    {
        $waitList = $this->waitList;
        $this->waitList = null;
        foreach ($waitList as $result) {
            do {
                $result->waitIfPending();
                $result = $result->result;
            } while ($result instanceof \YoastSEO_Vendor\GuzzleHttp\Promise\Promise);
            if ($result instanceof \YoastSEO_Vendor\GuzzleHttp\Promise\PromiseInterface) {
                $result->wait(\false);
            }
        }
    }
}
                                                                                                                                                                                                                                                                                                                                                                                                 plugins/wordpress-seo-extended/vendor_prefixed/guzzlehttp/promises/src/PromisorInterface.php        0000644                 00000000456 15122266561 0027051 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

declare (strict_types=1);
namespace YoastSEO_Vendor\GuzzleHttp\Promise;

/**
 * Interface used with classes that return a promise.
 */
interface PromisorInterface
{
    /**
     * Returns a promise.
     */
    public function promise() : \YoastSEO_Vendor\GuzzleHttp\Promise\PromiseInterface;
}
                                                                                                                                                                                                                  plugins/wordpress-seo-extended/vendor_prefixed/guzzlehttp/promises/src/RejectedPromise.php          0000644                 00000004663 15122266561 0026506 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

declare (strict_types=1);
namespace YoastSEO_Vendor\GuzzleHttp\Promise;

/**
 * A promise that has been rejected.
 *
 * Thenning off of this promise will invoke the onRejected callback
 * immediately and ignore other callbacks.
 *
 * @final
 */
class RejectedPromise implements \YoastSEO_Vendor\GuzzleHttp\Promise\PromiseInterface
{
    private $reason;
    /**
     * @param mixed $reason
     */
    public function __construct($reason)
    {
        if (\is_object($reason) && \method_exists($reason, 'then')) {
            throw new \InvalidArgumentException('You cannot create a RejectedPromise with a promise.');
        }
        $this->reason = $reason;
    }
    public function then(callable $onFulfilled = null, callable $onRejected = null) : \YoastS