ing() : void
    {
        if (!$this->concurrency) {
            // Add all pending promises.
            while ($this->addPending() && $this->advanceIterator()) {
            }
            return;
        }
        // Add only up to N pending promises.
        $concurrency = \is_callable($this->concurrency) ? ($this->concurrency)(\count($this->pending)) : $this->concurrency;
        $concurrency = \max($concurrency - \count($this->pending), 0);
        // Concurrency may be set to 0 to disallow new promises.
        if (!$concurrency) {
            return;
        }
        // Add the first pending promise.
        $this->addPending();
        // Note this is special handling for concurrency=1 so that we do
        // not advance the iterator after adding the first promise. This
        // helps work around issues with generators that might not have the
        // next value to yield until promise callbacks are called.
        while (--$concurrency && $this->advanceIterator() && $this->addPending()) {
        }
    }
    private function addPending() : bool
    {
        if (!$this->iterable || !$this->iterable->valid()) {
            return \false;
        }
        $promise = \YoastSEO_Vendor\GuzzleHttp\Promise\Create::promiseFor($this->iterable->current());
        $key = $this->iterable->key();
        // Iterable keys may not be unique, so we use a counter to
        // guarantee uniqueness
        $idx = $this->nextPendingIndex++;
        $this->pending[$idx] = $promise->then(function ($value) use($idx, $key) : void {
            if ($this->onFulfilled) {
                ($this->onFulfilled)($value, $key, $this->aggregate);
            }
            $this->step($idx);
        }, function ($reason) use($idx, $key) : void {
            if ($this->onRejected) {
                ($this->onRejected)($reason, $key, $this->aggregate);
            }
            $this->step($idx);
        });
        return \true;
    }
    private function advanceIterator() : bool
    {
        // Place a lock on the iterator so that we ensure to not recurse,
        // preventing fatal generator errors.
        if ($this->mutex) {
            return \false;
        }
        $this->mutex = \true;
        try {
           