stSEO_Vendor\GuzzleHttp\Promise\PromiseInterface
    {
        return $this->result->otherwise($onRejected);
    }
    public function wait(bool $unwrap = \true)
    {
        return $this->result->wait($unwrap);
    }
    public function getState() : string
    {
        return $this->result->getState();
    }
    public function resolve($value) : void
    {
        $this->result->resolve($value);
    }
    public function reject($reason) : void
    {
        $this->result->reject($reason);
    }
    public function cancel() : void
    {
        $this->currentPromise->cancel();
        $this->result->cancel();
    }
    private function nextCoroutine($yielded) : void
    {
        $this->currentPromise = \YoastSEO_Vendor\GuzzleHttp\Promise\Create::promiseFor($yielded)->then([$this, '_handleSuccess'], [$this, '_handleFailure']);
    }
    /**
     * @internal
     */
    public function _handleSuccess($value) : void
    {
        unset($this->currentPromise);
        try {
            $next = $this->generator->send($value);
            if ($this->generator->valid()) {
                $this->nextCoroutine($next);
            } else {
                $this->result->resolve($value);
            }
        } catch (\Throwable $throwable) {
            $this->result->reject($throwable);
        }
    }
    /**
     * @internal
     */
    public function _handleFailure($reason) : void
    {
        unset($this->currentPromise);
        try {
            $nextYield = $this->generator->throw(\YoastSEO_Vendor\GuzzleHttp\Promise\Create::exceptionFor($reason));
            // The throw was caught, so keep iterating on the coroutine
            $this->nextCoroutine($nextYield);
        } catch (\Throwable $throwable) {
            $this->result->reject($throwable);
        }
    }
}
                                                                                                                                                                                                                                                      plugins/wordpress-seo-extended/vendor_prefixed/guzzlehttp/promises/src/Create.php                   0000644                 00000004412 15122266561 0024615 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

declare (strict_types=1);
namespace YoastSEO_Vendor\GuzzleHttp\Promise;

final class Create
{
    /**
     * Creates a promise for a value if the value is not a promise.
     *
     * @param mixed $value Promise or value.
     */
    public static function promiseFor($value) : \YoastSEO_Vendor\GuzzleHttp\Promise\PromiseInterface
    {
        if ($value instanceof \YoastSEO_Vendor\GuzzleHttp\Promise\PromiseInterface) {
            return $value;
        }
        // Return a Guzzle promise that shadows the given promise.
        if (\is_object($value) && \method_exists($value, 'then')) {
            $wfn = \method_exists($value, 'wait') ? [$value, 'wait'] : null;
            $cfn = \method_exists($value, 'cancel') ? [$value, 'cancel'] : null;
            $promise = new \YoastSEO_Vendor\GuzzleHttp\Promise\Promise($wfn, $cfn);
            $value->then([$promise, 'resolve'], [$promise, 'reject']);
            return $promise;
        }
        return new \YoastSEO_Vendor\GuzzleHttp\Promise\FulfilledPromise($value);
    }
    /**
     * Creates a rejected promise for a reason if the reason is not a promise.
     * If the provided reason is a promise, then it is returned as-is.
     *
     * @param mixed $reason Promise or reason.
     */
    public static function rejectionFor($reason) : \YoastSEO_Vendor\GuzzleHttp\Promise\PromiseInterface
    {
        if ($reason instanceof \YoastSEO_Vendor\GuzzleHttp\Promise\PromiseInterface) {
            return $reason;
        }
        return new \YoastSEO_Vendor\GuzzleHttp\Promise\RejectedPromise($reason);
    }
    /**
     * Create an exception for a rejected promise value.
     *
     * @param mixed $reason
     */
    public static function exceptionFor($reason) : \Throwable
    {
        if ($reason instanceof \Throwable) {
            return $reason;
        }
        return new \YoastSEO_Vendor\GuzzleHttp\Promise\RejectionException($reason);
    }
    /**
     * Returns an iterator for the given value.
     *
     * @param mixed $value
     */
    public static function iterFor($value) : \Iterator
    {
        if ($value instanceof \Iterator) {
            return $value;
        }
        if (\is_array($value)) {
            return new \ArrayIterator($value);
        }
        return new \ArrayIterator([$value]);
    }
}
                                                                                                                                                                                                                                                      plugins/wordpress-seo-extended/vendor_prefixed/guzzlehttp/promises/src/Each.php                     0000644                 00000005143 15122266561 0024254 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

declare (strict_types=1);
namespace YoastSEO_Vendor\GuzzleHttp\Promise;

final class Each
{
    /**
     * Given an iterator that yields promises or values, returns a promise that
     * is fulfilled with a null value when the iterator has been consumed or
     * the aggregate promise has been fulfilled or rejected.
     *
     * $onFulfilled is a function that accepts the fulfilled value, iterator
     * index, and the aggregate promise. The callback can invoke any necessary
     * side effects and choose to resolve or reject the aggregate if needed.
     *
     * $onRejected is a function that accepts the rejection reason, iterator
     * index, and the aggregate promise. The callback can invoke any necessary
     * side effects and choose to resolve or reject the aggregate if needed.
     *
     * @param mixed $iterable Iterator or array to iterate over.
     */
    public static function of($iterable, callable $onFulfilled = null, callable $onRejected = null) : \YoastSEO_Vendor\GuzzleHttp\Promise\PromiseInterface
    {
        return (new \YoastSEO_Vendor\GuzzleHttp\Promise\EachPromise($iterable, ['fulfilled' => $onFulfilled, 'rejected' => $onRejected]))->promise();
    }
    /**
     * Like of, but only allows a certain number of outstanding promises at any
     * given time.
     *
     * $concurrency may be an integer or a function that accepts the number of
     * pending promises and returns a numeric concurrency limit value to allow
     * for dynamic a concurrency size.
     *
     * @param mixed        $iterable
     * @param int|callable $concurrency
     */
    public static function ofLimit($iterable, $concurrency, callable $onFulfilled = null, callable $onRejected = null) : \YoastSEO_Vendor\GuzzleHttp\Promise\PromiseInterface
    {
        return (new \YoastSEO_Vendor\GuzzleHttp\Promise\EachPromise($iterable, ['fulfilled' => $onFulfilled, 'rejected' => $onRejected, 'concurrency' => $concurrency]))->promise();
    }
    /**
     * Like limit, but ensures that no promise in the given $iterable argument
     * is rejected. If any promise is rejected, then the aggregate promise is
     * rejected with the encountered rejection.
     *
     * @param mixed        $iterable
     * @param int|callable $concurrency
     */
    public static function ofLimitAll($iterable, $concurrency, callable $onFulfilled = null) : \YoastSEO_Vendor\GuzzleHttp\Promise\PromiseInterface
    {
        return self::ofLimit($iterable, $concurrency, $onFulfilled, function ($reason, $idx, \YoastSEO_Vendor\GuzzleHttp\Promise\PromiseInterface $aggregate) : void {
            $aggregate->reject($reason);
        });
    }
}
                                                                                                                                                                                                                                                                                                                                                                                                                             plugins/wordpress-seo-extended/vendor_prefixed/guzzlehttp/promises/src/EachPromise.php              0000644                 00000016566 15122266561 0025626 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

declare (strict_types=1);
namespace YoastSEO_Vendor\GuzzleHttp\Promise;

/**
 * Represents a promise that iterates over many promises and invokes
 * side-effect functions in the process.
 *
 * @final
 */
class EachPromise implements \YoastSEO_Vendor\GuzzleHttp\Promise\PromisorInterface
{
    private $pending = [];
    private $nextPendingIndex = 0;
    /** @var \Iterator|null */
    private $iterable;
    /** @var callable|int|null */
    private $concurrency;
    /** @var callable|null */
    private $onFulfilled;
    /** @var callable|null */
    private $onRejected;
    /** @var Promise|null */
    private $aggregate;
    /** @var bool|null */
    private $mutex;
    /**
     * Configuration hash can include the following key value pairs:
     *
     * - fulfilled: (callable) Invoked when a promise fulfills. The function
     *   is invoked with three arguments: the fulfillment value, the index
     *   position from the iterable list of the promise, and the aggregate
     *   promise that manages all of the promises. The aggregate promise may
     *   be resolved from within the callback to short-circuit the promise.
     * - rejected: (callable) Invoked when a promise is rejected. The
     *   function is invoked with three arguments: the rejection reason, the
     *   index position from the iterable list of the promise, and the
     *   aggregate promise that manages all of the promises. The aggregate
     *   promise may be resolved from within the callback to short-circuit
     *   the promise.
     * - concurrency: (integer) Pass this configuration option to limit the
     *   allowed number of outstanding concurrently executing promises,
     *   creating a capped pool of promises. There is no limit by default.
     *
     * @param mixed $iterable Promises or values to iterate.
     * @param array $config   Configuration options
     */
    public function __construct($iterable, array $config = [])
    {
        $this->iterable = \YoastSEO_Vendor\GuzzleHttp\Promise\Create::iterFor($iterable);
        if (isset($config['concurrency'])) {
            $this->concurrency = $config['concurrency'];
        }
        if (isset($config['fulfilled'])) {
            $this->onFulfilled = $config['fulfilled'];
        }
        if (isset($config['rejected'])) {
            $this->onRejected = $config['rejected'];
        }
    }
    /** @psalm-suppress InvalidNullableReturnType */
    public function promise() : \YoastSEO_Vendor\GuzzleHttp\Promise\PromiseInterface
    {
        if ($this->aggregate) {
            return $this->aggregate;
        }
        try {
            $this->createPromise();
            /** @psalm-assert Promise $this->aggregate */
            $this->iterable->rewind();
            $this->refillPending();
        } catch (\Throwable $e) {
            $this->aggregate->reject($e);
        }
        /**
         * @psalm-suppress NullableReturnStatement
         */
        return $this->aggregate;
    }
    private function createPromise() : void
    {
        $this->mutex = \false;
        $this->aggregate = new \YoastSEO_Vendor\GuzzleHttp\Promise\Promise(function () : void {
            if ($this->checkIfFinished()) {
                return;
            }
            \reset($this->pending);
            // Consume a potentially fluctuating list of promises while
            // ensuring that indexes are maintained (preclud