json);
    }
    /**
     * Load the contents of the client session into the data array
     */
    protected function load() : void
    {
        if (!isset($_SESSION[$this->sessionKey])) {
            return;
        }
        $data = \json_decode($_SESSION[$this->sessionKey], \true);
        if (\is_array($data)) {
            foreach ($data as $cookie) {
                $this->setCookie(new \YoastSEO_Vendor\GuzzleHttp\Cookie\SetCookie($cookie));
            }
        } elseif (\strlen($data)) {
            throw new \RuntimeException('Invalid cookie data');
        }
    }
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                      plugins/wordpress-seo-extended/vendor_prefixed/guzzlehttp/guzzle/src/Cookie/SetCookie.php           0000644                 00000033464 15122266561 0026200 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace YoastSEO_Vendor\GuzzleHttp\Cookie;

/**
 * Set-Cookie object
 */
class SetCookie
{
    /**
     * @var array
     */
    private static $defaults = ['Name' => null, 'Value' => null, 'Domain' => null, 'Path' => '/', 'Max-Age' => null, 'Expires' => null, 'Secure' => \false, 'Discard' => \false, 'HttpOnly' => \false];
    /**
     * @var array Cookie data
     */
    private $data;
    /**
     * Create a new SetCookie object from a string.
     *
     * @param string $cookie Set-Cookie header string
     */
    public static function fromString(string $cookie) : self
    {
        // Create the default return array
        $data = self::$defaults;
        // Explode the cookie string using a series of semicolons
        $pieces = \array_filter(\array_map('trim', \explode(';', $cookie)));
        // The name of the cookie (first kvp) must exist and include an equal sign.
        if (!isset($pieces[0]) || \strpos($pieces[0], '=') === \false) {
            return new self($data);
        }
        // Add the cookie pieces into the parsed data array
        foreach ($pieces as $part) {
            $cookieParts = \explode('=', $part, 2);
            $key = \trim($cookieParts[0]);
            $value = isset($cookieParts[1]) ? \trim($cookieParts[1], " \n\r\t\x00\v") : \true;
            // Only check for non-cookies when cookies have been found
            if (!isset($data['Name'])) {
                $data['Name'] = $key;
                $data['Value'] = $value;
            } else {
                foreach (\array_keys(self::$defaults) as $search) {
                    if (!\strcasecmp($search, $key)) {
                        if ($search === 'Max-Age') {
                            if (\is_numeric($value)) {
                                $data[$search] = (int) $value;
                            }
                        } else {
                            $data[$search] = $value;
                        }
                        continue 2;
                    }
                }
                $data[$key] = $value;
            }
        }
        return new self($data);
    }
    /**
     * @param array $data Array of cookie data provided by a Cookie parser
     */
    public function __construct(array $data = [])
    {
        $this->data = self::$defaults;
        if (isset($data['Name'])) {
            $this->setName($data['Name']);
        }
        if (isset($data['Value'])) {
            $this->setValue($data['Value']);
        }
        if (isset($data['Domain'])) {
            $this->setDomain($data['Domain']);
        }
        if (isset($data['Path'])) {
            $this->setPath($data['Path']);
        }
        if (isset($data['Max-Age'])) {
            $this->setMaxAge($data['Max-Age']);
        }
        if (isset($data['Expires'])) {
            $this->setExpires($data['Expires']);
        }
        if (isset($data['Secure'])) {
            $this->setSecure($data['Secure']);
        }
        if (isset($data['Discard'])) {
            $this->setDiscard($data['Discard']);
        }
        if (isset($data['HttpOnly'])) {
            $this->setHttpOnly($data['HttpOnly']);
        }
        // Set the remaining values that don't have extra validation logic
        foreach (\array_diff(\array_keys($data), \array_keys(self::$defaults)) as $key) {
            $this->data[$key] = $data[$key];
        }
        // Extract the Expires value and turn it into a UNIX timestamp if needed
        if (!$this->getExpires() && $this->getMaxAge()) {
            // Calculate the Expires date
            $this->setExpires(\time() + $this->getMaxAge());
        } elseif (null !== ($expires = $this->getExpires()) && !\is_numeric($expires)) {
            $this->setExpires($expires);
        }
    }
    public function __toString()
    {
        $str = $this->data['Name'] . '=' . ($this->data['Value'] ?? '') . '; ';
        foreach ($this->data as $k => $v) {
            if ($k !== 'Name' && $k !== 'Value' && $v !== null && $v !== \false) {
                if ($k === 'Expires') {
                    $str .= 'Expires=' . \gmdate('D, d M Y H:i:s \\G\\M\\T', $v) . '; ';
                } else {
                    $str .= ($v ===