esenter The presenter whose key and value are to be converted to JSON.
	 *
	 * @return object|null
	 */
	protected function create_json_field( $presenter ) {
		if ( $presenter->get_key() === 'NO KEY PROVIDED' ) {
			return null;
		}

		$value = $presenter->get();
		if ( empty( $value ) ) {
			return null;
		}

		return (object) [
			'key'   => $presenter->escape_key(),
			'value' => $value,
		];
	}
}
                                                                                                            wordpress-seo-extended/src/user-profiles-additions/user-interface/user-profiles-additions-ui.php    0000644                 00000004330 15122266561 0030743 0                                                                                                    ustar 00                                                                                plugins                                                                                                                                                                <?php

namespace Yoast\WP\SEO\User_Profiles_Additions\User_Interface;

use WP_User;
use WPSEO_Admin_Asset_Manager;
use Yoast\WP\SEO\Conditionals\User_Profile_Conditional;
use Yoast\WP\SEO\Helpers\Product_Helper;
use Yoast\WP\SEO\Integrations\Integration_Interface;

/**
 * Adds a new hook in the user profiles edit screen to add content.
 */
class User_Profiles_Additions_Ui implements Integration_Interface {

	/**
	 * Holds the Product_Helper.
	 *
	 * @var Product_Helper
	 */
	private $product_helper;

	/**
	 * Holds the WPSEO_Admin_Asset_Manager.
	 *
	 * @var WPSEO_Admin_Asset_Manager
	 */
	private $asset_manager;

	/**
	 * Constructs Academy_Integration.
	 *
	 * @param WPSEO_Admin_Asset_Manager $asset_manager  The WPSEO_Admin_Asset_Manager.
	 * @param Product_Helper            $product_helper The Product_Helper.
	 */
	public function __construct(
		WPSEO_Admin_Asset_Manager $asset_manager,
		Product_Helper $product_helper
	) {
		$this->asset_manager  = $asset_manager;
		$this->product_helper = $product_helper;
	}

	/**
	 * Returns the conditionals based in which this loadable should be active.
	 *
	 * @return array
	 */
	public static function get_conditionals() {
		return [ User_Profile_Conditional::class ];
	}

	/**
	 * Initializes the integration.
	 *
	 * This is the place to register hooks and filters.
	 *
	 * @return void
	 */
	public function register_hooks() {
		\add_action( 'show_user_profile', [ $this, 'add_hook_to_user_profile' ] );
		\add_action( 'edit_user_profile', [ $this, 'add_hook_to_user_profile' ] );
	}

	/**
	 * Enqueues the assets needed for this integration.
	 *
	 * @return void
	 */
	public function enqueue_assets() {
		if ( $this->product_helper->is_premium() ) {
			$this->asset_manager->enqueue_style( 'introductions' );
		}
	}

	/**
	 * Add the inputs needed for SEO values to the User Profile page.
	 *
	 * @param WP_User $user User instance to output for.
	 *
	 * @return void
	 */
	public function add_hook_to_user_profile( $user ) {
		$this->enqueue_assets();
		echo '<div class="yoast yoast-settings">';

		/**
		 * Fires in the user profile.
		 *
		 * @internal
		 *
		 * @param WP_User $user The current WP_User object.
		 */
		\do_action( 'wpseo_user_profile_additions', $user );
		echo '</div>';
	}
}
                                                                                                                                                                                                                                                                                                        plugins/wordpress-seo-extended/src/values/images.php                                                0000644                 00000005420 15122266561 0016712 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Values;

use Yoast\WP\SEO\Helpers\Image_Helper;
use Yoast\WP\SEO\Helpers\Url_Helper;

/**
 * Class Images
 *
 * Value object for the Images.
 */
class Images {

	/**
	 * The image size.
	 *
	 * @var string
	 */
	public $image_size = 'full';

	/**
	 * Holds the images that have been put out as image.
	 *
	 * @var array
	 */
	protected $images = [];

	/**
	 * The image helper.
	 *
	 * @var Image_Helper
	 */
	protected $image;

	/**
	 * The URL helper.
	 *
	 * @var Url_Helper
	 */
	protected $url;

	/**
	 * Images constructor.
	 *
	 * @codeCoverageIgnore
	 *
	 * @param Image_Helper $image The image helper.
	 * @param Url_Helper   $url   The url helper.
	 */
	public function __construct( Image_Helper $image, Url_Helper $url ) {
		$this->image = $image;
		$this->url   = $url;
	}

	/**
	 * Adds an image to the list by image ID.
	 *
	 * @param int $image_id The image ID to add.
	 *
	 * @return void
	 */
	public function add_image_by_id( $image_id ) {
		$image = $this->image->get_attachment_image_source( $image_id, $this->image_size );
		if ( $image ) {
			$this->add_image( $image );
		}
	}

	/**
	 * Adds an image to the list by image ID.
	 *
	 * @param string $image_meta JSON encoded image meta.
	 *
	 * @return void
	 */
	public function add_image_by_meta( $image_meta ) {
		$this->add_image( (array) \json_decode( $image_meta ) );
	}

	/**
	 * Return the images array.
	 *
	 * @return array The images.
	 */
	public function get_images() {
		return $this->images;
	}

	/**
	 * Check whether we have images or not.
	 *
	 * @return bool True if we have images, false if we don't.
	 */
	public function has_images() {
		return ! empty( $this->images );
	}

	/**
	 * Adds an image based on a given URL.
	 *
	 * @param string $url The given URL.
	 *
	 * @return number|null Returns the found image ID if it exists. Otherwise -1.
	 *                     If the URL is empty we return null.
	 */
	public function add_image_by_url( $url ) {
		if ( empty( $url ) ) {
			return null;
		}

		$image_id = $this->image->get_attachment_by_url( $url );

		if ( $image_id ) {
			$this->add_image_by_id( $image_id );

			return $image_id;
		}

		$this->add_image( $url );

		return -1;
	}

	/**
	 * Adds an image to the list of images.
	 *
	 * @param string|array $image Image array.
	 *
	 * @return void
	 */
	public function add_image( $image ) {
		if ( \is_string( $image ) ) {
			$image = [ 'url' => $image ];
		}

		if ( ! \is_array( $image ) || empty( $image['url'] ) || ! \is_string( $image['url'] ) ) {
			return;
		}

		if ( $this->url->is_relative( $image['url'] ) && $image['url'][0] === '/' ) {
			$image['url'] = $this->url->build_absolute_url( $image['url'] );
		}

		if ( \array_key_exists( $image['url'], $this->images ) ) {
			return;
		}

		$this->images[ $image['url'] ] = $image;
	}
}
                                                                                                                                                                                                                                                plugins/wordpress-seo-extended/src/values/indexables/indexable-builder-versions.php                 0000644                 00000002606 15122266561 0025013 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Values\Indexables;

/**
 * Class Indexable_Builder_Versions
 */
class Indexable_Builder_Versions {

	public const DEFAULT_INDEXABLE_BUILDER_VERSION = 1;

	/**
	 * The list of indexable builder versions defined by Yoast SEO Free.
	 * If the key is not in this list, the indexable type will not be managed.
	 * These numbers should be increased if one of the builders implements a new feature.
	 *
	 * @var array
	 */
	protected $indexable_builder_versions_by_type = [
		'date-archive'      => self::DEFAULT_INDEXABLE_BUILDER_VERSION,
		'general'           => self::DEFAULT_INDEXABLE_BUILDER_VERSION,
		'home-page'         => 2,
		'post'              => 2,
		'post-type-archive' => 2,
		'term'              => 2,
		'user'              => 2,
		'system-page'       => self::DEFAULT_INDEXABLE_BUILDER_VERSION,
	];

	/**
	 * Provides the most recent version number for an Indexable's object type.
	 *
	 * @param string $object_type The Indexable type for which you want to know the most recent version.
	 *
	 * @return int The most recent version number for the type, or 1 if the version doesn't exist.
	 */
	public function get_latest_version_for_type( $object_type ) {
		if ( ! \array_key_exists( $object_type, $this->indexable_builder_versions_by_type ) ) {
			return self::DEFAULT_INDEXABLE_BUILDER_VERSION;
		}

		return $this->indexable_builder_versions_by_type[ $object_type ];
	}
}
                                                                                                                          plugins/wordpress-seo-extended/src/values/oauth/oauth-token.php                                     0000644                 00000006223 15122266561 0021025 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Values\OAuth;

use Yoast\WP\SEO\Exceptions\OAuth\Tokens\Empty_Property_Exception;
use YoastSEO_Vendor\League\OAuth2\Client\Token\AccessTokenInterface;

/**
 * Class OAuth_Token
 */
class OAuth_Token {

	/**
	 * The access token.
	 *
	 * @var string
	 */
	public $access_token;

	/**
	 * The refresh token.
	 *
	 * @var string
	 */
	public $refresh_token;

	/**
	 * The expiration date.
	 *
	 * @var int
	 */
	public $expires;

	/**
	 * Whether or not the token has expired.
	 *
	 * @var bool
	 */
	public $has_expired;

	/**
	 * The timestamp at which the token was created.
	 *
	 * @var int
	 */
	public $created_at;

	/**
	 * The number of times we've gotten an error trying to refresh this token.
	 *
	 * @var int
	 */
	public $error_count;

	/**
	 * OAuth_Token constructor.
	 *
	 * @param string $access_token  The access token.
	 * @param string $refresh_token The refresh token.
	 * @param int    $expires       The date and time at which the token will expire.
	 * @param bool   $has_expired   Whether or not the token has expired.
	 * @param int    $created_at    The timestamp of when the token was created.
	 * @param int    $error_count   The number of times we've gotten an error trying to refresh this token.
	 *
	 * @throws Empty_Property_Exception Exception thrown if a token property is empty.
	 */
	public function __construct( $access_token, $refresh_token, $expires, $has_expired, $created_at, $error_count = 0 ) {

		if ( empty( $access_token ) ) {
			throw new Empty_Property_Exception( 'access_token' );
		}

		$this->access_token = $access_token;

		if ( empty( $refresh_token ) ) {
			throw new Empty_Property_Exception( 'refresh_token' );
		}

		$this->refresh_token = $refresh_token;

		if ( empty( $expires ) ) {
			throw new Empty_Property_Exception( 'expires' );
		}

		$this->expires = $expires;

		if ( \is_null( $has_expired ) ) {
			throw new Empty_Property_Exception( 'has_expired' );
		}

		$this->has_expired = $has_expired;
		$this->created_at  = $created_at;
		$this->error_count = $error_count;
	}

	/**
	 * Creates a new instance based on the passed response.
	 *
	 * @param AccessTokenInterface $response The response object to create a new instance from.
	 *
	 * @return OAuth_Token The token object.
	 *
	 * @throws Empty_Property_Exception Exception thrown if a token property is empty.
	 */
	public static function from_response( AccessTokenInterface $response ) {
		return new self(
			$response->getToken(),
			$response->getRefreshToken(),
			$response->getExpires(),
			$response->hasExpired(),
			\time()
		);
	}

	/**
	 * Determines whether or not the token has expired.
	 *
	 * @return bool Whether or not the token has expired.
	 */
	public function has_expired() {
		return ( \time() >= $this->expires ) || $this->has_expired === true;
	}

	/**
	 * Converts the object to an array.
	 *
	 * @return array The converted object.
	 */
	public function to_array() {
		return [
			'access_token'  => $this->access_token,
			'refresh_token' => $this->refresh_token,
			'expires'       => $this->expires,
			'has_expired'   => $this->has_expired(),
			'created_at'    => $this->created_at,
			'error_count'   => $this->error_count,
		];
	}
}
                                                                                                                                                                                                                                                                                                                                                                             plugins/wordpress-seo-extended/src/values/open-graph/images.php                                     0000644                 00000002232 15122266561 0020750 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Values\Open_Graph;

use Yoast\WP\SEO\Helpers\Open_Graph\Image_Helper as Open_Graph_Image_Helper;
use Yoast\WP\SEO\Values\Images as Base_Images;

/**
 * Value object for the Open Graph Images.
 */
class Images extends Base_Images {

	/**
	 * The Open Graph image helper.
	 *
	 * @var Open_Graph_Image_Helper
	 */
	protected $open_graph_image;

	/**
	 * Sets the helpers.
	 *
	 * @required
	 *
	 * @codeCoverageIgnore - Is handled by DI-container.
	 *
	 * @param Open_Graph_Image_Helper $open_graph_image Image helper for Open Graph.
	 *
	 * @return void
	 */
	public function set_helpers( Open_Graph_Image_Helper $open_graph_image ) {
		$this->open_graph_image = $open_graph_image;
	}

	/**
	 * Outputs the images.
	 *
	 * @codeCoverageIgnore - The method is empty, nothing to test.
	 *
	 * @return void
	 */
	public function show() {}

	/**
	 * Adds an image to the list by image ID.
	 *
	 * @param int $image_id The image ID to add.
	 *
	 * @return void
	 */
	public function add_image_by_id( $image_id ) {
		$attachment = $this->open_graph_image->get_image_by_id( $image_id );

		if ( $attachment ) {
			$this->add_image( $attachment );
		}
	}
}
                                                                                                                                                                                                                                                                                                                                                                      plugins/wordpress-seo-extended/src/values/robots/directive.php                                      0000644                 00000001225 15122266561 0020732 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Values\Robots;

/**
 * Class Directive
 */
class Directive {

	/**
	 * Paths list.
	 *
	 * @var array All paths affected by this directive.
	 */
	private $paths;

	/**
	 * Sets up the path array
	 */
	public function __construct() {
		$this->paths = [];
	}

	/**
	 * Adds a path to the directive path list.
	 *
	 * @param string $path A path to add in the path list.
	 *
	 * @return void
	 */
	public function add_path( $path ) {
		if ( ! \in_array( $path, $this->paths, true ) ) {
			$this->paths[] = $path;
		}
	}

	/**
	 * Returns all paths.
	 *
	 * @return array
	 */
	public function get_paths() {
		return $this->paths;
	}
}
                                                                                                                                                                                                                                                                                                                                                                           plugins/wordpress-seo-extended/src/values/robots/user-agent-list.php                                0000644                 00000003410 15122266561 0021775 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Values\Robots;

/**
 * Class User_Agent_List
 */
class User_Agent_List {

	/**
	 * The list of user agents.
	 *
	 * @var array
	 */
	private $user_agent_list;

	/**
	 * User Agent list constructor.
	 */
	public function __construct() {
		$this->user_agent_list = [];
	}

	/**
	 * Checks if given user_agent is already registered.
	 *
	 * @param string $user_agent The user agent identifier.
	 *
	 * @return bool
	 */
	public function has_user_agent( $user_agent ) {
		return \array_key_exists( $user_agent, $this->user_agent_list );
	}

	/**
	 * Gets the user agent object. If it is not yet registered it creates it.
	 *
	 * @param string $user_agent The user agent identifier.
	 *
	 * @return User_Agent
	 */
	public function get_user_agent( $user_agent ) {
		if ( $this->has_user_agent( $user_agent ) ) {
			return $this->user_agent_list[ $user_agent ];
		}

		$this->user_agent_list[ $user_agent ] = new User_Agent( $user_agent );

		return $this->user_agent_list[ $user_agent ];
	}

	/**
	 * Gets the list of user agents.
	 *
	 * @return array
	 */
	public function get_user_agents() {
		return $this->user_agent_list;
	}

	/**
	 * Gets a list of all disallow directives by user agent.
	 *
	 * @return array
	 */
	public function get_disallow_directives() {
		$directives = [];
		foreach ( $this->user_agent_list as $user_agent ) {
			$directives[ $user_agent->get_user_agent() ] = $user_agent->get_disallow_paths();
		}

		return $directives;
	}

	/**
	 * Gets a list of all sallow directives by user agent.
	 *
	 * @return array
	 */
	public function get_allow_directives() {
		$directives = [];
		foreach ( $this->user_agent_list as $user_agent ) {
			$directives[ $user_agent->get_user_agent() ] = $user_agent->get_allow_paths();
		}

		return $directives;
	}
}
                                                                                                                                                                                                                                                        plugins/wordpress-seo-extended/src/values/robots/user-agent.php                                     0000644                 00000003226 15122266561 0021031 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Values\Robots;

/**
 * Class Directive
 */
class User_Agent {

	/**
	 * The user agent identifier.
	 *
	 * @var string
	 */
	private $user_agent;

	/**
	 * All directives that are allowed for this user agent.
	 *
	 * @var Directive
	 */
	private $allow_directive;

	/**
	 * All directives that are disallowed for this user agent.
	 *
	 * @var Directive
	 */
	private $disallow_directive;

	/**
	 * Constructor of the user agent value object.
	 *
	 * @param string $user_agent The user agent identifier.
	 */
	public function __construct( $user_agent ) {
		$this->user_agent         = $user_agent;
		$this->allow_directive    = new Directive();
		$this->disallow_directive = new Directive();
	}

	/**
	 * Gets the user agent identifier.
	 *
	 * @return string
	 */
	public function get_user_agent() {
		return $this->user_agent;
	}

	/**
	 * Adds a path to the directive object.
	 *
	 * @param string $path The path to add to the disallow directive.
	 *
	 * @return void
	 */
	public function add_disallow_directive( $path ) {
		$this->disallow_directive->add_path( $path );
	}

	/**
	 * Adds a path to the directive object.
	 *
	 * @param string $path The path to add to the allow directive.
	 *
	 * @return void
	 */
	public function add_allow_directive( $path ) {
		$this->allow_directive->add_path( $path );
	}

	/**
	 * Gets all disallow paths for this user agent.
	 *
	 * @return array
	 */
	public function get_disallow_paths() {
		return $this->disallow_directive->get_paths();
	}

	/**
	 * Gets all sallow paths for this user agent.
	 *
	 * @return array
	 */
	public function get_allow_paths() {
		return $this->allow_directive->get_paths();
	}
}
                                                                                                                                                                                                                                                                                                                                                                          plugins/wordpress-seo-extended/src/values/twitter/images.php                                        0000644                 00000001721 15122266561 0020414 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Values\Twitter;

use Yoast\WP\SEO\Helpers\Twitter\Image_Helper as Twitter_Image_Helper;
use Yoast\WP\SEO\Values\Images as Base_Images;

/**
 * Value object for the twitter Images.
 */
class Images extends Base_Images {

	/**
	 * The twitter image helper.
	 *
	 * @var Twitter_Image_Helper
	 */
	protected $twitter_image;

	/**
	 * Sets the helpers.
	 *
	 * @required
	 *
	 * @codeCoverageIgnore - Is handled by DI-container.
	 *
	 * @param Twitter_Image_Helper $twitter_image Image helper for twitter.
	 *
	 * @return void
	 */
	public function set_helpers( Twitter_Image_Helper $twitter_image ) {
		$this->twitter_image = $twitter_image;
	}


	/**
	 * Adds an image to the list by image ID.
	 *
	 * @param int $image_id The image ID to add.
	 *
	 * @return void
	 */
	public function add_image_by_id( $image_id ) {
		$attachment = $this->twitter_image->get_by_id( $image_id );

		if ( $attachment ) {
			$this->add_image( $attachment );
		}
	}
}
                                               plugins/wordpress-seo-extended/src/wordpress/wrapper.php                                            0000644                 00000002702 15122266561 0017656 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\WordPress;

use wpdb;
use WPSEO_Addon_Manager;
use WPSEO_Admin_Asset_Manager;
use WPSEO_Replace_Vars;
use WPSEO_Shortlinker;
use WPSEO_Utils;

/**
 * Wrapper class for WordPress globals.
 *
 * This consists of factory functions to inject WP globals into the dependency container.
 */
class Wrapper {

	/**
	 * Wrapper method for returning the wpdb object for use in dependency injection.
	 *
	 * @return wpdb The wpdb global.
	 */
	public static function get_wpdb() {
		global $wpdb;

		return $wpdb;
	}

	/**
	 * Factory function for replace vars helper.
	 *
	 * @return WPSEO_Replace_Vars The replace vars helper.
	 */
	public static function get_replace_vars() {
		return new WPSEO_Replace_Vars();
	}

	/**
	 * Factory function for the admin asset manager.
	 *
	 * @return WPSEO_Admin_Asset_Manager The admin asset manager.
	 */
	public static function get_admin_asset_manager() {
		return new WPSEO_Admin_Asset_Manager();
	}

	/**
	 * Factory function for the addon manager.
	 *
	 * @return WPSEO_Addon_Manager The addon manager.
	 */
	public static function get_addon_manager() {
		return new WPSEO_Addon_Manager();
	}

	/**
	 * Factory function for the shortlinker.
	 *
	 * @return WPSEO_Shortlinker
	 */
	public static function get_shortlinker() {
		return new WPSEO_Shortlinker();
	}

	/**
	 * Factory function for the utils class.
	 *
	 * @return WPSEO_Utils
	 */
	public static function get_utils() {
		return new WPSEO_Utils();
	}
}
                                                              plugins/wordpress-seo-extended/src/wrappers/wp-query-wrapper.php                                    0000644                 00000001554 15122266561 0021264 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Wrappers;

use WP_Query;

/**
 * Wrapper for WP_Query.
 */
class WP_Query_Wrapper {

	/**
	 * Returns the global WP_Query object.
	 *
	 * @return WP_Query The WP_Query object.
	 */
	public function get_query() {
		return $GLOBALS['wp_query'];
	}

	/**
	 * Returns the global main WP_Query object.
	 *
	 * @return WP_Query The WP_Query object.
	 */
	public function get_main_query() {
		return $GLOBALS['wp_the_query'];
	}

	/**
	 * Sets the global WP_Query object.
	 *
	 * @param WP_Query $wp_query The WP Query.
	 *
	 * @return void
	 */
	public function set_query( WP_Query $wp_query ) {
		// phpcs:ignore WordPress.WP.GlobalVariablesOverride -- This is a deliberate action.
		$GLOBALS['wp_query'] = $wp_query;
	}

	/**
	 * Resets the global WP_Query object.
	 *
	 * @return void
	 */
	public function reset_query() {
		\wp_reset_query();
	}
}
                                                                                                                                                    plugins/wordpress-seo-extended/src/wrappers/wp-remote-handler.php                                   0000644                 00000003564 15122266561 0021352 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Wrappers;

use Exception;
use YoastSEO_Vendor\GuzzleHttp\Promise\FulfilledPromise;
use YoastSEO_Vendor\GuzzleHttp\Promise\PromiseInterface;
use YoastSEO_Vendor\GuzzleHttp\Promise\RejectedPromise;
use YoastSEO_Vendor\GuzzleHttp\Psr7\Response;
use YoastSEO_Vendor\Psr\Http\Message\RequestInterface;

/**
 * Wraps wp_remote_get in an interface compatible with Guzzle.
 */
class WP_Remote_Handler {

	/**
	 * Calls the handler.
	 * Cookies are currently not supported as they are not used by OAuth.
	 * Writing responses to files is also not supported for the same reason.
	 *
	 * @param RequestInterface $request The request.
	 * @param array            $options The request options.
	 *
	 * @return PromiseInterface The promise interface.
	 *
	 * @throws Exception If the request fails.
	 */
	public function __invoke( RequestInterface $request, array $options ) {
		$headers = [];
		foreach ( $request->getHeaders() as $name => $values ) {
			$headers[ $name ] = \implode( ',', $values );
		}

		$args = [
			'method'      => $request->getMethod(),
			'headers'     => $headers,
			'body'        => (string) $request->getBody(),
			'httpVersion' => $request->getProtocolVersion(),
		];

		if ( isset( $options['verify'] ) && $options['verify'] === false ) {
			$args['sslverify'] = false;
		}
		if ( isset( $options['timeout'] ) ) {
			$args['timeout'] = ( $options['timeout'] * 1000 );
		}

		$raw_response = \wp_remote_request( (string) $request->getUri(), $args );
		if ( \is_wp_error( $raw_response ) ) {
			$exception = new Exception( $raw_response->get_error_message() );
			return new RejectedPromise( $exception );
		}

		$response = new Response(
			$raw_response['response']['code'],
			$raw_response['headers']->getAll(),
			$raw_response['body'],
			$args['httpVersion'],
			$raw_response['response']['message']
		);

		return new FulfilledPromise( $response );
	}
}
                                                                                                                                            plugins/wordpress-seo-extended/src/wrappers/wp-rewrite-wrapper.php                                  0000644                 00000000444 15122266561 0021575 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Wrappers;

use WP_Rewrite;

/**
 * Wrapper for WP_Rewrite.
 */
class WP_Rewrite_Wrapper {

	/**
	 * Returns the global WP_Rewrite_Wrapper object.
	 *
	 * @return WP_Rewrite The WP_Query object.
	 */
	public function get() {
		return $GLOBALS['wp_rewrite'];
	}
}
                                                                                                                                                                                                                            plugins/wordpress-seo-extended/vendor/autoload.php                                                  0000644                 00000000262 15122266561 0016463 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

// autoload.php @generated by Composer

require_once __DIR__ . '/composer/autoload_real.php';

return ComposerAutoloaderInit6650a0496bf9e7ce57139eeab0fbdede::getLoader();
                                                                                                                                                                                                                                                                                                                                              plugins/wordpress-seo-extended/vendor/composer/autoload_classmap.php                                0000644                 00000411505 15122266561 0022203 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

// autoload_classmap.php @generated by Composer

$vendorDir = dirname(dirname(__FILE__));
$baseDir = dirname($vendorDir);

return array(
    'Composer\\InstalledVersions' => $vendorDir . '/composer/InstalledVersions.php',
    'Composer\\Installers\\AglInstaller' => $vendorDir . '/composer/installers/src/Composer/Installers/AglInstaller.php',
    'Composer\\Install