ties_bin ) ) {
			return true;
		}

		return isset( $this->context->presentation->{$name} );
	}

	/**
	 * Prevents setting dynamic properties and overwriting the value of declared properties
	 * from an inaccessible context.
	 *
	 * @param string $name  The property name.
	 * @param mixed  $value The property value.
	 *
	 * @return void
	 *
	 * @throws Forbidden_Property_Mutation_Exception Set is never meant to be called.
	 */
	public function __set( $name, $value ) { // @phpcs:ignore Generic.CodeAnalysis.UnusedFunctionParameter.FoundAfterLastUsed -- __set must have a name and value - PHPCS #3715.
		throw Forbidden_Property_Mutation_Exception::cannot_set_because_property_is_immutable( $name );
	}

	/**
	 * Prevents unsetting dynamic properties and unsetting declared properties
	 * from an inaccessible context.
	 *
	 * @param string $name The property name.
	 *
	 * @return void
	 *
	 * @throws Forbidden_Property_Mutation_Exception Unset is never meant to be called.
	 */
	public function __unset( $name ) {
		throw Forbidden_Property_Mutation_Exception::cannot_unset_because_property_is_immutable( $name );
	}

	/**
	 * Strips all nested dependencies from the debug info.
	 *
	 * @return array
	 */
	public function __debugInfo() {
		return [ 'context' => $this->context ];
	}

	/**
	 * Returns all presenters.
	 *
	 * @return Abstract_Indexable_Presenter[]
	 */
	protected function get_presenters() {
		$presenters = $this->front_end->get_presenters( $this->context->page_type, $this->context );

		if ( $this->context->page_type === 'Date_Archive' ) {
			/**
			 * Define a filter that removes objects of type Rel_Next_Presenter or Rel_Prev_Presenter from a list.
			 *
			 * @param object $presenter The presenter to verify.
			 *
			 * @return bool True if the presenter is not a Rel_Next or Rel_Prev presenter.
			 */
			$callback   = static function ( $presenter ) {
				return ! \is_a( $presenter, Rel_Next_Presenter::class )
					&& ! \is_a( $presenter, Rel_Prev_Presenter::cla