ld be found.
	 */
	public function for_posts( $ids ) {
		$indexables = $this->repository->find_by_multiple_ids_and_type( $ids, 'post' );

		if ( empty( $indexables ) ) {
			return false;
		}

		// Remove all false values.
		$indexables = \array_filter( $indexables );

		return \array_map(
			function ( $indexable ) {
				return $this->build_meta( $this->context_memoizer->get( $indexable, 'Post_Type' ) );
			},
			$indexables
		);
	}

	/**
	 * Returns the meta tags context for a term.
	 *
	 * @param int $id The ID of the term.
	 *
	 * @return Meta|false The meta values. False if none could be found.
	 */
	public function for_term( $id ) {
		$indexable = $this->repository->find_by_id_and_type( $id, 'term' );

		if ( ! $indexable ) {
			return false;
		}

		return $this->build_meta( $this->context_memoizer->get( $indexable, 'Term_Archive' ) );
	}

	/**
	 * Returns the meta tags context for an author.
	 *
	 * @param int $id The ID of the author.
	 *
	 * @return Meta|false The meta values. False if none could be found.
	 */
	public function for_author( $id ) {
		$indexable = $this->repository->find_by_id_and_type( $id, 'user' );

		if ( ! $indexable ) {
			return false;
		}

		return $this->build_meta( $this->context_memoizer->get( $indexable, 'Author_Archive' ) );
	}

	/**
	 * Returns the meta for an indexable.
	 *
	 * @param Indexable   $indexable The indexable.
	 * @param string|null $page_type Optional. The page type if already known.
	 *
	 * @return Meta|false The meta values. False if none could be found.
	 */
	public function for_indexable( $indexable, $page_type = null ) {

		if ( ! \is_a( $indexable, Indexable::class ) ) {
			return false;
		}
		if ( \is_null( $page_type ) ) {
			$page_type = $this->indexable_helper->get_page_type_for_indexable( $indexable );
		}

		return $this->build_meta( $this->context_memoizer->get( $indexable, $page_type ) );
	}

	/**
	 * Returns the meta for an indexable.
	 *
	 * @param Indexable[] $indexables The indexables.
	 * @param string|null $page_type  Optional. The page type if already known.
	 *
	 * @return Meta|false The meta values. False if none could be found.
	 */
	public function for_indexables( $indexables, $page_type = null ) {
		$closure = function ( $indexable ) use ( $page_type ) {
			$this_page_type = $page_type;
			if ( \is_null( $this_page_type ) ) {
				$this_page_type = $this->indexable_helper->get_page_type_for_indexable( $indexable );
			}

			return $this->build_meta( $this->context_memoizer->get( $indexable, $this_page_type ) );
		};

		return \array_map( $closure, $indexables );
	}

	/**
	 * Returns the meta tags context for a url.
	 *
	 * @param string $url The url of the page. Required to be relative to the site url.
	 *
	 * @return Meta|false The meta values. False if none could be found.
	 */
	public function for_url( $url ) {
		$url_parts  = \wp_parse_url( $url );
		$site_parts = \wp_parse_url( \site_url() );

		if ( ( ! \is_array( $url_parts ) || ! \is_array( $site_parts ) )
			|| ! isset( $url_parts['host'], $url_parts['path'], $site_parts['host'], $site_parts['scheme'] )
		) {
			return false;
		}

		if ( $url_parts['host'] !== $site_parts['host'] ) {
			return false;
		}
		// Ensure the scheme is consistent with values in the DB.
		$url = $site_parts['scheme'] . '://' . $url_parts['host'] . $url_parts['path'];

		if ( $this->is_date_archive_url( $url ) ) {
			$indexable = $this->repository->find_for_date_archive();
		}
		else {
			$indexable = $this->repository->find_by_permalink( $url );
		}

		// If we still don't have an indexable abort, the WP globals could be anything so we can't use the unknown indexable.
		if ( ! $indexable ) {
			return false;
		}
		$page_type = $this->indexable_helper->get_page_type_for_indexable( $indexable );

		if ( $page_type === false ) {
			return false;
		}

		return $this->build_meta( $this->context_memoizer->get( $indexable, $page_type ) );
	}

	/**
	 * Checks if a given URL is a date archive URL.
	 *
	 * @param string $url The url.
	 *
	 * @return bool
	 */
	protected function is_date_archive_url( $url ) {
		$path = \wp_parse_url( $url, \PHP_URL_PATH );
		if ( $path === null ) {
			return false;
		}

		$path         = \ltrim( $path, '/' );
		$wp_rewrite   = $this->wp_rewrite_wrapper->get();
		$date_rewrite = $wp_rewrite->generate_rewrite_rules( $wp_rewrite->get_date_permastruct(), \EP_DATE );
		$date_rewrite = \apply_filters( 'date_rewrite_rules', $date_rewrite );

		foreach ( (array) $date_rewrite as $match => $query ) {
			if ( \preg_match( "#^$match#", $path ) ) {
				return true;
			}
		}

		return false;
	}

	/**
	 * Creates a new meta value object
	 *
	 * @param Meta_Tags_Context $context The meta tags context.
	 *
	 * @return Meta The meta value
	 */
	protected function build_meta( Meta_Tags_Context $context ) {
		return new Meta( $context, $this->container );
	}
}
                                                                                                                                                                                                                                                               plugins/wordpress-seo-extended/src/surfaces/open-graph-helpers-surface.php                          0000644                 00000004757 15122266561 0023123 0                                                                                                    ustar 00                                                                                                                                                                                                                         