 $type );
			}
		);
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       plugins/wordpress-seo-extended/src/services/indexables/indexable-version-manager.php                0000644                 00000004440 15122266560 0025135 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Services\Indexables;

use Yoast\WP\SEO\Models\Indexable;
use Yoast\WP\SEO\Values\Indexables\Indexable_Builder_Versions;

/**
 * Handles version control for Indexables.
 */
class Indexable_Version_Manager {

	/**
	 * Stores the version of each Indexable type.
	 *
	 * @var Indexable_Builder_Versions The current versions of all indexable builders.
	 */
	protected $indexable_builder_versions;

	/**
	 * Indexable_Version_Manager constructor.
	 *
	 * @param Indexable_Builder_Versions $indexable_builder_versions The current versions of all indexable builders.
	 */
	public function __construct( Indexable_Builder_Versions $indexable_builder_versions ) {
		$this->indexable_builder_versions = $indexable_builder_versions;
	}

	/**
	 * Determines if an Indexable has a lower version than the builder for that Indexable's type.
	 *
	 * @param Indexable $indexable The Indexable to check.
	 *
	 * @return bool True if the given version is older than the current latest version.
	 */
	public function indexable_needs_upgrade( $indexable ) {
		if ( ( ! $indexable )
			|| ( ! \is_a( $indexable, Indexable::class ) )
		) {
			return false;
		}

		return $this->needs_upgrade( $indexable->object_type, $indexable->version );
	}

	/**
	 * Determines if an Indexable version for the type is lower than the current version for that Indexable type.
	 *
	 * @param string $object_type       The Indexable's object type.
	 * @param int    $indexable_version The Indexable's version.
	 *
	 * @return bool True if the given version is older than the current latest version.
	 */
	protected function needs_upgrade( $object_type, $indexable_version ) {
		$current_indexable_builder_version = $this->indexable_builder_versions->get_latest_version_for_type( $object_type );

		// If the Indexable's version is below the current version, that Indexable needs updating.
		return $indexable_version < $current_indexable_builder_version;
	}

	/**
	 * Sets an Indexable's version to the latest version.
	 *
	 * @param Indexable $indexable The Indexable to update.
	 *
	 * @return Indexable
	 */
	public function set_latest( $indexable ) {
		if ( ! $indexable ) {
			return $indexable;
		}

		$indexable->version = $this->indexable_builder_versions->get_latest_version_for_type( $indexable->object_type );

		return $indexable;
	}
}
                                                                                                                                                                                                                                plugins/wordpress-seo-extended/src/surfaces/classes-surface.php                                     0000644                 00000001456 15122266560 0021050 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Surfaces;

use YoastSEO_Vendor\Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Class Classes_Surface.
 *
 * Surface for the indexables.
 */
class Classes_Surface {

	/**
	 * The dependency injection container.
	 *
	 * @var ContainerInterface
	 */
	public $container;

	/**
	 * Loader constructor.
	 *
	 * @param ContainerInterface $container The dependency injection container.
	 */
	public function __construct( ContainerInterface $container ) {
		$this->container = $container;
	}

	/**
	 * Returns the instance of a class. Handy for unhooking things.
	 *
	 * @param string $class_name The class to get the instance of.
	 *
	 * @return mixed The instance of the class.
	 */
	public function get( $class_name ) {
		return $this->container->get( $class_name );
	}
}
                                                                                                                                                                                                                  plugins/wordpress-seo-extended/src/surfaces/helpers-surface.php                                     0000644                 00000013205 15122266560 0021050 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Surfaces;

use Yoast\WP\SEO\Exceptions\Forbidden_Property_Mutation_Exception;
use Yoast\WP\SEO\Helpers;
use YoastSEO_Vendor\Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Class Helpers_Surface.
 *
 * Surface for the indexables.
 *
 * @property Helpers\Asset_Helper                           $asset
 * @property Helpers\Author_Archive_Helper                  $author_archive
 * @property Helpers\Blocks_Helper                          $blocks
 * @property Helpers\Capability_Helper                      $capability
 * @property Helpers\Current_Page_Helper                    $current_page
 * @property Helpers\Date_Helper                            $date
 * @property Helpers\Environment_Helper                     $environment
 * @property Helpers\First_Time_Configuration_Notice_Helper $first_time_configuration_notice
 * @property Helpers\Home_Url_Helper                        $home_url
 * @property Helpers\Image_Helper                           $image
 * @property Helpers\Indexable_Helper                       $indexable
 * @property Helpers\Indexing_Helper                        $indexing
 * @property Helpers\Input_Helper                           $input
 * @property Helpers\Language_Helper                        $language
 * @property Helpers\Meta_Helper                            $meta
 * @property Helpers\Notification_Helper                    $notification
 * @property Helpers\Options_Helper                         $options
 * @property Helpers\Pagination_Helper                      $pagination
 * @property Helpers\Permalink_Helper                       $permalink
 * @property Helpers\Post_Helper                            $post
 * @property Helpers\Post_Type_Helper                       $post_type
 * @property Helpers\Primary_Term_Helper                    $primary_term
 * @property Helpers\Product_Helper                         $product
 * @property Helpers\Redirect_Helper                        $redirect
 * @property Helpers\Request_Helper                         $request
 * @property Helpers\Require_File_Helper                    $require_file
 * @property Helpers\Robots_Helper                          $robots
 * @property Helpers\Short_Link_Helper                      $short_link
 * @property Helpers\Site_Helper                            $site
 * @property Helpers\String_Helper                          $string
 * @property Helpers\Social