_source( \array_values( $attachments )[0]->ID, 'fullsize' );
		}

		return '';
	}

	/**
	 * Retrieves the url of the featured image.
	 *
	 * @param int $post_id The post id to extract the image from.
	 *
	 * @return string The url of the featured image.
	 */
	public function get_featured_image( $post_id ) {
		$feature_image_id = \get_post_thumbnail_id( $post_id );

		if ( $feature_image_id ) {
			return $this->image->get_attachment_image_source( $feature_image_id, 'fullsize' );
		}

		return '';
	}

	/**
	 * Retrieves the url of the first available image. Tries each image source to get one image.
	 *
	 * @param int $post_id The post id to extract the image from.
	 *
	 * @return string The url of the featured image.
	 */
	public function get_auto_image( $post_id ) {
		$image = $this->get_first_attached_image( $post_id );

		if ( ! $image ) {
			$image = $this->get_first_image_in_content( $post_id );
		}

		return $image;
	}
}
                                                                                     plugins/wordpress-seo-extended/src/services/importing/conflicting-plugins-service.php               0000644                 00000006224 15122266560 0025417 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Services\Importing;

use Yoast\WP\SEO\Config\Conflicting_Plugins;

/**
 * Detects plugin conflicts.
 */
class Conflicting_Plugins_Service {

	/**
	 * Detects the conflicting plugins.
	 *
	 * @return array A list of all active conflicting plugins.
	 */
	public function detect_conflicting_plugins() {
		$all_active_plugins = $this->get_active_plugins();

		// Search for active plugins.
		return $this->get_active_conflicting_plugins( $all_active_plugins );
	}

	/**
	 * Deactivates the specified plugin(s) if any, or the entire list of known conflicting plugins.
	 *
	 * @param string|array|false $plugins Optional. The plugin filename, or array of plugin filenames, to deactivate.
	 *
	 * @return void
	 */
	public function deactivate_conflicting_plugins( $plugins = false ) {
		// If no plugins are specified, deactivate any known conflicting plugins that are active.
		if ( ! $plugins ) {
			$plugins = $this->detect_conflicting_plugins();
		}

		// In case of a single plugin, wrap it in an array.
		if ( \is_string( $plugins ) ) {
			$plugins = [ $plugins ];
		}

		if ( ! \is_array( $plugins ) ) {
			return;
		}

		// Deactivate all specified plugins across the network, while retaining their deactivation hook.
		\deactivate_plugins( $plugins );
	}

	/**
	 * Loop through the list of known conflicting plugins to check if one of the plugins is active.
	 *
	 * @param array $all_active_plugins All plugins loaded by WordPress.
	 *
	 * @return array The array of activated conflicting plugins.
	 */
	protected function get_active_conflicting_plugins( $all_active_plugins ) {
		$active_conflicting_plugins = [];

		foreach ( Conflicting_Plugins::all_plugins() as $plugin ) {
			if ( \in_array( $plugin, $all_active_plugins, true ) ) {
				$active_conflicting_plugins[] = $plugin;
			}
		}

		return $active_conflicting_plugins;
	}

	/**
	 * Get a list of all plugins active in the current WordPress instance.
	 *
	 * @return false|array The names of all active plugins.
	 */
	protected function get_active_plugins() {
		// Request a list of active plugins from WordPress.
		$all_active_plugins = \get_option( 'active_plugins' );

		return $this->ignore_deactivating_plugin( $all_active_plugins );
	}

	/**
	 * While deactivating a plugin, we should ignore the plugin currently being deactivated.
	 *
	 * @param array $all_active_plugins All plugins currently loaded by WordPress.
	 *
	 * @return array The remaining active plugins.
	 */
	protected function ignore_deactivating_plugin( $all_active_plugins ) {
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Reason: We are strictly comparing only.
		if ( isset( $_GET['action'] ) && isset( $_GET['plugin'] ) && \is_string( $_GET['action'] ) && \is_string( $_GET['plugin'] ) && \wp_unslash( $_GET['action'] ) === 'deactivate' ) {
			$deactivated_plugin = \sanitize_text_field( \wp_unslash( $_GET['plugin'] ) );

			\check_admin_referer( 'deactivate-plugin_' . $deactivated_plugin );

			$key_to_remove = \array_search( $deactivated_plugin, $all_active_plugins, true );
			if ( $key_to_remove !== false ) {
				unset( $all_active_plugins[ $key_to_remove ] );
			}
		}

		return $all_active_plugins;
	}
}
                                                                                                                                                                                                                                                                                                                                                                            plugins/wordpress-seo-extended/src/services/importing/importable-detector-service.php               0000644                 00000005031 15122266560 0025401 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php

namespace Yoast\WP\SEO\Services\Importing;

use Yoast\WP\SEO\Actions\Importing\Importing_Action_Interface;

/**
 * Detects if any data from other SEO plugins is available for importing.
 */
class Importable_Detector_Service {

	/**
	 * All known import actions
	 *
	 * @var array|Importing_Action_Interface[]
	 */
	protected $importers;

	/**
	 * Importable_Detector_Service constructor.
	 *
	 * @param Importing_Action_Interface ...$importers All of the known importers.
	 */
	public function __construct( Importing_Action_Interface ...$importers ) {
		$this->importers = $importers;
	}

	/**
	 * Returns the detected importers that have data to work with.
	 *
	 * @param string|null $plugin The plugin name of the importer.
	 * @param string|null $type   The type of the importer.
	 *
	 * @return array The detected importers that have data to work with.
	 */
	public function detect_importers( $plugin = null, $type = null ) {
		$detectors = $this->filter_actions( $this->importers, $plugin, $type );

		$detected = [];
		foreach ( $detectors as $detector ) {
			if ( $detector->is_enabled() && $detector->get_type() !== 'cleanup' && ! $detector->get_completed() && $detector->get_limited_unindexed_count( 1 ) > 0 ) {
				$detected[ $detector->get_plugin() ][] = $detector->get_type();
			}
		}

		return $detected;
	}

	/**
	 * Returns the detected cleanups that have data to work with.
	 *
	 * @param string|null $plugin The plugin name of the cleanup.
	 *
	 * @return array The detected importers that have data to work with.
	 */
	public function detect